if (0) then begin
    nx = 1044
    ny = 1024
end

if (0) then begin

    dd = fltarr(nx, ny, 10)
    i0 = 41
    for i = i0,49,1 do begin
        dd[*,*,(i-i0)/1] = rdi('focus', i, /raw)
        plotsub,dd[*,*,(i-i0)/1], 243,774, 30,30, 5, /mag, $
          tit=string(i), windx=(i-i0)/1, zmax=30000.
    endfor

end


if (0) then begin

    dd = fltarr(nx, ny, 10)
    i0 = 52
    for i = i0,54,1 do begin
        dd[*,*,(i-i0)/1] = rdi('im', i, /raw)
        plotsub,dd[*,*,(i-i0)/1], 545,553, 30,30, 5, /mag, $
          tit=string(i), windx=(i-i0)/1, zmax=20000.
    endfor

end

if (0) then begin

    s = ''
    fns = file_search('../08JUL14UT/im*fit', count=count)
    files = strmid(fns,strlen('../08JUL14UT/'), 6)
    print, count
    for i = 1, count-1, 1 do begin
        file = files[i]
        window, 0, xs=596, ys=570, title=file
        d = rd(file, h)
        findstars, d, h, /plot
        read, string(i)+file+' Press return to continue', s
    end
end

if (0) then begin
    ; from ../20080715_frEFY/Reduction/Do_bias_flats_08JUL14UT
    ;	Script to produce bias-subtracted, flat-fielded images for the 
;	EL61 subframes taken on 13-JUL-08 UT (day 1 of the WIRO EL61 run).
;	EFY, 13-JUL-08.

;	STEP 1: Set up paths to bias, flats and image data. ***PLATFORM DEPENDENT***
	biasPath = '../08JUL14UT_AST/'
	domePath = '../08JUL14UT_AST/'
	imPath = '../08JUL14UT_EL61/'
	
;	And choose the file number ranges for the biases and the dome flats
	fbias4 = 457 & nbias4 = 5
	fbias8 = 462 & nbias8 = 5
	fbias16 = 467 & nbias16 = 5
	fbias30 = 472 & nbias30 = 5

	fdome4 = 400 & ndome4 = 20
	fdome8 = 420 & ndome8 = 20
	fdome16 = 440 & ndome16 = 5

	fim = 51 & nim = 232
	
	xs = 1044
	ys = 1024	; size of our subframe
	
	domeExp = [4., 8., 16.]	; exposure times for the dome flats
	
	gain = 1.5 ; WIROPrime gain in e-/DN
	
;	***END OF PLATFORM-DEPENDENT SECTION***


;	STEP 2: Load the bias frames, dome flats.
	bias4 = fltarr(xs, ys, nbias4)
	bias8 = fltarr(xs, ys, nbias8)
	bias16 = fltarr(xs, ys, nbias16)
	bias30 = fltarr(xs, ys, nbias30)

	dome4 = fltarr(xs, ys, ndome4)
	dome8 = fltarr(xs, ys, ndome8)
	dome16 = fltarr(xs, ys, ndome16)
	
	bias4FN = biasPath + 'bias' + strmid(strtrim(string(10000+fbias4+indgen(nbias4)),2),1,4) + '.fit'
	bias8FN = biasPath + 'bias' + strmid(strtrim(string(10000+fbias8+indgen(nbias8)),2),1,4) + '.fit'
	bias16FN = biasPath + 'bias' + strmid(strtrim(string(10000+fbias16+indgen(nbias16)),2),1,4) + '.fit'
	bias30FN = biasPath + 'bias' + strmid(strtrim(string(10000+fbias30+indgen(nbias30)),2),1,4) + '.fit'

	dome4FN = domePath + 'dome' + strmid(strtrim(string(10000+fdome4+indgen(ndome4)),2),1,4) + '.fit'
	dome8FN = domePath + 'dome' + strmid(strtrim(string(10000+fdome8+indgen(ndome8)),2),1,4) + '.fit'
	dome16FN = domePath + 'dome' + strmid(strtrim(string(10000+fdome16+indgen(ndome16)),2),1,4) + '.fit'
	imFN = imPath + 'im' + strmid(strtrim(string(10000+fim+indgen(nim)),2),1,4) + '.fit'

	for i=0, nbias4-1 do bias4[*,*,i] = WIRO_unsign(READFITS(bias4FN[i]))
	for i=0, nbias8-1 do bias8[*,*,i] = WIRO_unsign(READFITS(bias8FN[i]))
	for i=0, nbias16-1 do bias16[*,*,i] = WIRO_unsign(READFITS(bias16FN[i]))
	for i=0, nbias30-1 do bias30[*,*,i] = WIRO_unsign(READFITS(bias30FN[i]))

	for i=0, ndome4-1 do dome4[*,*,i] = WIRO_unsign(READFITS(dome4FN[i]))
	for i=0, ndome8-1 do dome8[*,*,i] = WIRO_unsign(READFITS(dome8FN[i]))
	for i=0, ndome16-1 do dome16[*,*,i] = WIRO_unsign(READFITS(dome16FN[i]))


;	STEP 3: Make a super bias frame
	biasNoise = stddev(bias4[*,*,0])
	sb4 = RoboStack(bias4, 5., gain, biasNoise)

	biasNoise = stddev(bias8[*,*,0])
	sb8 = RoboStack(bias8, 5., gain, biasNoise)

	biasNoise = stddev(bias16[*,*,0])
	sb16 = RoboStack(bias16, 5., gain, biasNoise)

	biasNoise = stddev(bias30[*,*,0])
	sb30 = RoboStack(bias30, 5., gain, biasNoise)
	
	
;	STEP 4: Make super dome flats with subtracted biases
	dNZ4 = stddev(dome4[*,*,0])
	dNZ8 = stddev(dome8[*,*,0])
	dNZ16 = stddev(dome16[*,*,0])
	
	sd4 = RoboStack(dome4, 5., gain, dNZ4) - sb4
	sd8 = RoboStack(dome8, 5., gain, dNZ8) - sb8
	sd16 = RoboStack(dome16, 5., gain, dNZ16) - sb16


;	STEP 5: Solve for the pixel-by-pixel slope and intercept for the flats.
	m = sd4 * 0.
	b = m	; Allocate space for the slope and intercept
	
	for i=0,xs-1 do for j=0,ys-1 do begin & res = LINFIT(domeEXP, [sd4[i,j], sd8[i,j], sd16[i,j]]) & $
		b[i,j] = res[0] & m[i,j] = res[1] & endfor
	
	sf = m/median(m)	; Use the slope array for the super flat.
	sf2 = sf
	bp = where((sf LT 0.5) OR (sf GT 2.0), cnt)
	if (cnt GT 0) then sf2[bp] = 1.0

;	STEP 6: Load the images, subtract bias, normalize by the superflat
;	im = fltarr(xs, ys, nim)
;	for i=0, nim-1 do im[*,*,i] = (WIRO_unsign(READFITS(imFN[i])) - sb30)/sf2
	
        writefits, 'superflat.fit', sf
        writefits, 'superbias30.fit', sb30
	

	
end

if (0) then begin

    s = ''
    fns = file_search('../08JUL14UT_EL61/im*fit', count=count)
    fns = fns[1:count-1]
    count = n_elements(fns)
    files = strmid(fns,strlen('../08JUL14UT_EL61/'), 6)
    nstar = 2
    xarr = fltarr(count, nstar)
    yarr = fltarr(count, nstar)
    farr = fltarr(count, nstar)
    ferrarr = fltarr(count, nstar)
    hrarr = fltarr(count)
    exptimearr = fltarr(count)
    dateobsarr = strarr(count)
    for i = 0, count - 1, 1 do begin
        file = files[i]
        d = rd(file, h, exptime, date_obs)
        findstars, d, h, xmax, ymax, xb, yb, hr
        photstars, d, h, xb, yb, hr, fb, ferrb 
        xarr[i,*] = xb
        yarr[i,*] = yb
        farr[i,*] = fb
        ferrarr[i,*] = ferrb
        hrarr[i] = hr
        exptimearr[i] = exptime
        dateobsarr[i] = date_obs
    end
    itarg = nstar-1
    istd = nstar-2
    ratio = farr[*,nstar-1] / farr[*,istd]
    ratioerr = ratio * sqrt( (ferrarr[*,nstar-1]/farr[*,nstar-1])^2 + $
                             (ferrarr[*,istd]/farr[*,istd])^2 )
    ratioerr2 = ratioerr 
    for i=2, count-3 do ratioerr2[i]=stddev(ratio[i-2:i+2])

    plot, hrarr, ratio, ps=3, yr=[0.13, 0.25], /xs
    oploterr, hrarr, ratio, ratioerr2, ps=3

; plot, hrarr, sqrt(60./exptimearr) * ratio/ratioerr

end

if (1) then begin
    midet = utc2et(dateobsarr) + exptimearr/2.
    jd = et2jd(midet)
    hjd = jd - 0.00069
    omega = 2*!pi/(3.915345/(24.d))
    t = hjd - 2454600.d

    rmag = 17.288943 $
      - 0.030194353*cos(omega*t) -0.011140734*sin(omega*t) $
      - 0.10043642*cos(2*omega*t) +  0.069297834*sin(2*omega*t) $
      + 0.00075353226 * cos(3*omega*t) -0.00053536864*sin(3*omega*t)  $
      -0.0031751431 * cos(4*omega*t) +  0.0073135269*sin(4*omega*t)

    rrel = 10^(-0.4 * (rmag - 17.288943) )
    
    save, dateobsarr, exptimearr, ratio, ratioerr, ratioerr2, rmag,$
      file='20080714_2003EL61_WIRO_v1.sav'

    forprint, dateobsarr, exptimearr, ratio, ratioerr, ratioerr2, rmag, $
      for='(A20, I3, 3F7.4, F8.4)', texto='20080714_2003EL61_WIRO_v1.txt'
    
    w = 1./(ratioerr2^2)
    fac = total(rrel^2 * w) / total( rrel*ratio * w)

    !p.color = 0 & !p.background = !d.n_colors-1
    plot, hrarr, ratio, ps=3, tit='20080714_2003EL61_WIRO_v1', $
      xs=3, xtit = 'UT hours past 2008 JUL 14 00:00', $
      ytit = 'Ratio of 2003 EL61 to 2UCAC38801214', yr=[0.15, .22]
    oploterr, hrarr, ratio, ratioerr2, ps=3
    oplot, hrarr, rrel / fac
    tv2ppm,'20080714_2003EL61_WIRO_v1_fig1.ppm'


    plot, hrarr, ratio/(rrel/fac), ps=3,  tit='20080714_2003EL61_WIRO_v1', $
      xs=3, xtit = 'UT hours past 2008 JUL 14 00:00', $
      ytit = '(2003 EL61/2UCAC38801214) / (scaled rotational lc)', yr=[0.8, 1.1]
    oploterr, hrarr, ratio/(rrel/fac), ratioerr2/(rrel/fac), ps=3
    for i=-2,2,2 do oplot, hrarr, 0*hrarr+1 + 0.01*i
    tv2ppm,'20080714_2003EL61_WIRO_v1_fig2.ppm'

    
    
endif

end

