; Frame im0064
; pixel scale ~0.52 arcsec/pix
; N down, E to the left.

pro findstars, d, h, xmax, ymax, xb, yb, hr, plot=plot

    findbright, d, h, xmax, ymax, plot=plot

    dateobs = sxpar(h, 'DATE-OBS')
    dateobs0 = '2008-07-14T04:22:43.000'

    hr  = (utc2et(dateobs)  - utc2et('2008-07-14 00:00:00'))/3600.d
    hr0 = (utc2et(dateobs0) - utc2et('2008-07-14 00:00:00'))/3600.d
    dhr = hr - hr0
    dra = 0.20 * dhr 
    ddec = -1.45 * dhr
    dx = dra / 0.52
    dy = -ddec /0.52

;    print, xmax, ymax

    xbi = xmax + [412,161,429,916,791,761,281,276,300+dx] - 412
    ybi = ymax + [109,166,199,522,939,891,777,440,483+dy] - 109
    xbi = xbi[7:8]
    ybi = ybi[7:8]

    n = n_elements(xbi)
    xb = fltarr(n)
    yb = fltarr(n)

    for i = 0, n_elements(xbi) - 1 do begin
        if xbi[i] gt 30 and xbi[i] lt (1044 - 30) and $
          ybi[i] gt 30 and ybi[i] lt (1024 - 30) then begin
            centrod, d, xbi[i], ybi[i], 5, 10, 20, skyback, x, y, fb
        endif else begin
            x = xbi[i]
            y = ybi[i]
        endelse
        xb[i] = x
        yb[i] = y
    endfor

    if keyword_set(plot) then begin
        plotsub, d
        for i = 0, n_elements(xbi) - 1 do begin
            plottick, xbi[i], ybi[i], [10,20], '0000ff'xl
            plottick, xb[i], yb[i], [0,10], 'ff0000'xl
            plotid, xb[i], yb[i], strtrim(string(i),2), 20,0,0,'ffffff'xl, chars=2
            print, xbi[i], ybi[i], x, y
        endfor
    endif

end
