function rd, fn, h, exptime, date_obs, raw=raw

    d = long(readfits('../08JUL14UT_EL61/'+fn+'.fit', h, /silent) )
;    d = long(readfits('../08JUL14UT/'+fn+'.fit', h, /silent) )
;    d = long(readfits('../08JUL14UT_EL61/'+fn+'.fit', h, /silent) )
    neg = where(d lt 0, nneg)
    if nneg gt 0 then d[neg] = (d[neg] + 2L * 32768L)

    exptime = sxpar(h, 'EXPTIME')
    date_obs = sxpar(h, 'DATE-OBS')

    if  keyword_set(raw) then return, d

    reddir = '../08JUL14UT-idl/'
    flat = readfits(reddir + 'superflat.fit', /sil)
    bd = where(flat lt 0.05 or flat gt 2.)
    flat[bd] = 1.
    
    case exptime of
        30: dark = readfits(reddir + 'superbias30.fit', /sil)
        else: dark = readfits(reddir + 'superbias30.fit', /sil)
    endcase

    return, (d - dark)/flat

end
