;+
; NAME: 
;  wiro_unsign.Pro
; PURPOSE: 
;  Returns unsigned pixel values for WIROPrime fits files.
; DESCRIPTION:
;	Adds 65536 to the negative pixels.
; CATEGORY:
; CALLING SEQUENCE:
;	u = WIRO_Unsign(d)
; INPUTS:
;	d	- The original WIROPrime fits file.
;
; OUTPUTS:
;	r	- the unsigned version of the file (float).
;
; KEYWORD OUTPUT PARAMETERS:
; COMMON BLOCKS:
; SIDE EFFECTS:
; RESTRICTIONS:
; PROCEDURE:
; MODIFICATION HISTORY:
; Jul 23, 2006; EFY, SwRI
;-
function wiro_unsign, d
	u = float(d)
	nP = where(d LT 0., cnt)
	if (cnt GT 0) then u[nP] = d[nP] + 65536l
	return, u
end