(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    104792,       2647]*)
(*NotebookOutlinePosition[    105851,       2681]*)
(*  CellTagsIndexPosition[    105807,       2677]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[" Below are the temperature profiles plotted in the \
paper:", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
{temperature[1], temperatureError[1],
\tbinnedAltitude[1]} =
{{63.8043193345393, 62.45837493942572, 61.41826760317194,
    60.49025806277634, 59.62388543790548, 58.803102755636,
    58.06467098059228, 57.47199719648736, 56.95413889653007,
    56.43143824277497, 55.9505168862919, 55.5180923172439,
    55.09964441293106, 54.70311030713972, 54.33762941302687,
    53.99452863724557, 53.68300496318078, 53.43092444583962,
    52.85746504960751, 52.35755813789142, 52.03797290741117,
    51.85601627555539, 51.650613498707, 51.44585032148317,
    51.29151764204489, 51.40042324271362, 51.60365377368662,
    51.76625818892904, 51.88263169672146, 51.86474704180572,
    51.90891539052855, 52.06887838182466, 52.14416985977975,
    52.11837369348197, 52.07492578916872, 51.96244181769283,
    51.83802749746205, 51.70450041828835, 51.63178924602916,
    51.64877075185172, 51.48706458982522, 51.35518534410002,
    51.40353898213044, 51.5570175876861, 51.79849705281175,
    51.40547924105413, 51.05255866297821, 50.74972874286184,
    50.45653310059351}, {2.120994036298424, 1.872009024940509,
    1.665629321956019, 1.496047707305931, 1.352743522896222,
    1.232338886308142, 1.128316674565614, 1.038550335742351,
    0.965350389440332, 0.903472860880768, 0.846243165471589,
    0.7983181325685318, 0.7563202846080951, 0.7186119849754127,
    0.6849410089733724, 0.6555730898319519, 0.6277314763479094,
    0.6021349395733835, 0.5638466093761052, 0.5286852879521655,
    0.4969571329652575, 0.4717242131853449, 0.453702318267479,
    0.4362592437263264, 0.4204037343476871, 0.400795368164192,
    0.3875162030443589, 0.3773005330874177, 0.3686511062495941,
    0.3593039496940196, 0.3472974202344251, 0.3386346502793425,
    0.3313114720439773, 0.3254661786014383, 0.3186361541915251,
    0.3109370133474438, 0.3033176989095924, 0.2962086197642569,
    0.2873682797605899, 0.2786240347025008, 0.271142863772504,
    0.2622281080648597, 0.2524266151126862, 0.2438713114357141,
    0.2354805061383991, 0.2173738530978896, 0.1983088445208596,
    0.1709093371709564, 0.13032203262185},
   {92.7214363333519, 88.8801477032835, 85.3838437852594,
    82.355216582765, 79.65305897728877, 77.26611447289566,
    75.03575439536258, 72.88077980258573, 70.9942798100783,
    69.34714278885577, 67.70636636093287, 66.24135829564603,
    64.89531498331326, 63.61882267222927, 62.40746106716051,
    61.29268392573091, 60.16689947912687, 59.04093692575134,
    57.30071705706474, 55.54534080450981, 53.72445125075592,
    52.04616469423786, 50.70532141320224, 49.37018419628885,
    48.06313121189601, 46.34986731411277, 44.90548605744584,
    43.65919742843971, 42.53601524423903, 41.21080314088159,
    39.70038931086378, 38.5732139915101, 37.36760227439118,
    36.34520710408355, 35.29179842881172, 34.06643477341436,
    32.90517612441772, 31.83415285060891, 30.64806948098135,
    29.45680403761935, 28.32751300510154, 27.24662293475922,
    26.10885730615837, 25.03413060505955, 23.94063456335948,
    22.8933778467308, 21.84328990225436, 20.77364541904922,
    20.12245643400502}};

{temperaturesFromFitResults[1],
   \ttemperatureErrorsFromFitResults[1],
\t  altitudesToPlotForFitResults[1]} =
{{65.65875474476476, 66.82544379000602, 68.0095705673855,
    69.21134675857881, 70.43098602399755, 71.66870401579241,
    72.92471839090576, 74.19924882417408, 75.49251702147977,
    76.80474673295282, 78.13616376622224, 79.48699599971718,
    80.8574733960181, 82.2478280152577, 83.6582940285718,
    85.0891077316003, 86.5405075580384, 88.0127340932377,
    89.5060300878572, 91.0206404715652, 92.5568123667913,
    94.1147951025279, 95.6948402281834, 97.2972015274849,
    98.9221350324316, 100.5698990372988},
   {2.087886374618002, 2.338990722324641, 2.598662668635752,
    2.866855171272348, 3.14358067179893, 3.428891952224216,
    3.722870148856606, 4.025617004489217, 4.337249718631666,
    4.657897439914906, 4.987698825050906, 5.326800307646463,
    5.675354849740476, 6.033521028345288, 6.401462358424802,
    6.779346785714744, 7.167346303114976, 7.56563665853807,
    7.974397130927441, 8.39381035805813, 8.82406220374081,
    9.26534165568142, 9.71784074699883, 10.18175449660029,
    10.65728086429088, 11.14462071787396},
   {97., 101., 105., 109., 113., 117., 121., 125., 129., 133., 137.,
    141., 145., 149., 153., 157., 161., 165., 169., 173., 177.,
    181., 185., 189., 193., 197.}};

{temperature[2], temperatureError[2],
\tbinnedAltitude[2]} =
{{61.09273050187188, 60.28763582151509, 59.6053846554485,
    59.01067608050885, 58.46852831171953, 57.88986308535906,
    57.28189897384289, 56.76965032196082, 56.36887290490679,
    55.97908347845282, 55.57449502776505, 55.2060525047666,
    54.88990585056514, 54.58993932838639, 54.28342342786378,
    53.97388358229448, 53.68376612623208, 53.43317665684902,
    53.22951779249211, 53.08750571337563, 52.78937233246259,
    52.48847078326554, 52.15488724003874, 51.88727226434302,
    51.67667346594602, 51.49986551340969, 51.35019797329639,
    51.19334694724258, 51.04265979255711, 50.93467202984117,
    50.857733107923, 50.81827905700754, 50.8375509460887,
    50.89095305008293, 50.99051384800445, 51.12814987738332,
    51.27828873199353, 51.40361430567288, 51.53538457558357,
    51.63027434611389, 51.71061979558097, 51.72623950471717,
    51.77648481764682, 51.884490663497, 51.9213702456929,
    51.97618446062988, 52.11069547369595, 52.29167388111334,
    52.35969348782536, 52.10128125123191, 51.90485239906798,
    52.02891720085196, 52.17775744861297, 51.99919133539812,
    51.98411520728594, 51.82102299884245},
   {1.966699207371581, 1.78369835605894, 1.622588359182075,
    1.48157362691066, 1.359021961366747, 1.253189549793848,
    1.158545845505267, 1.071373869383333, 0.997007684495033,
    0.934028965184145, 0.877629069718176, 0.824985992016723,
    0.778495900120054, 0.7378580209179067, 0.7015854940184668,
    0.6681797842091224, 0.6366549400729298, 0.6074569958740693,
    0.5805265738770246, 0.5552991275065683, 0.5137979707194508,
    0.4802149576461208, 0.4507848388055482, 0.4221567379239004,
    0.3986768774865843, 0.3774209418027241, 0.3588938663504444,
    0.3430152682609664, 0.3280662799364144, 0.3138676256540048,
    0.3014345049914066, 0.2897061916527984, 0.2786817344656817,
    0.2690104143068572, 0.2598511810579158, 0.2482016391805571,
    0.2380431444777401, 0.2292525411985599, 0.2209826412439525,
    0.2139691853535059, 0.2052447585684913, 0.1980487630256095,
    0.1903285990331653, 0.1831957584822106, 0.1764110934208511,
    0.1693966642452918, 0.1636757409136067, 0.1585172285699212,
    0.1531993622138841, 0.1474189910809489, 0.1404801919946917,
    0.1339745201222984, 0.1291739882167411, 0.1221545649446455,
    0.1157542056341389, 0.110237514442153},
   {90.9610848675766, 87.7092802536151, 84.7445140954396,
    82.01973725433, 79.54113804658323, 77.39319257465059,
    75.44392757142919, 73.46358666908691, 71.61415939441258,
    70.00043015763822, 68.52467183273734, 67.052182147949,
    65.66265115976035, 64.40239288949306, 63.25565855641503,
    62.17146378433882, 61.09364001101813, 60.02645558095333,
    58.96688386512733, 57.88101919173005, 56.0351133914453,
    54.47339859258978, 53.06884808375458, 51.55833890616668,
    50.21634246856525, 48.9124929015195, 47.69986775904476,
    46.62120607287352, 45.55803081427849, 44.46980227449922,
    43.44864072366091, 42.41584674324554, 41.35721212946919,
    40.35271946062063, 39.3275210353795, 37.94225778716714,
    36.64371359083748, 35.46314840988998, 34.30092010161002,
    33.27290748256223, 31.97662462986545, 30.87278687163166,
    29.66054325903519, 28.45136848872948, 27.25502323789578,
    26.00216715900797, 24.90474307731006, 23.83744876189371,
    22.72157215520724, 21.69224530411475, 20.5416699318248,
    19.28110555122066, 18.25131797170479, 17.20836624888102,
    16.19854144597934, 15.80690267847194}};

{temperaturesFromFitResults[2],
   \ttemperatureErrorsFromFitResults[2],
\t  altitudesToPlotForFitResults[2]} =
{{62.31749329531598, 63.23529654877765, 64.16403448424265,
    65.1038067781718, 66.05471373824612, 67.01685630561713,
    67.99033605715901, 68.97525520772259, 69.97171661239115,
    70.97982376873805, 71.99968081908613, 73.03139255276899,
    74.07506440839399, 75.13080247610719, 76.19871349985998,
    77.27890487967742, 78.37148467392868, 79.47656160159895,
    80.5942450445633, 81.7246450498622, 82.8678723319793,
    84.0240382751199, 85.1932549354926, 86.3756350435916,
    87.5712920064812, 88.7803399100824, 90.0028935214603},
   {1.726871632536746, 1.934480249813074, 2.148295282195533,
    2.368178651595084, 2.594057716272088, 2.82590326857851,
    3.063715891453377, 3.307517213570691, 3.55734413886162,
    3.813244939628681, 4.075276550487934, 4.343502655570921,
    4.61799231175467, 4.898818941353875, 5.1860595843367,
    5.479794335764929, 5.780105917505905, 6.087079348679853,
    6.400801689542893, 6.721361840768396, 7.04885038483433,
    7.383359459881462, 7.724982658711187, 8.07381494756991,
    8.4299526004377, 8.79349314575446, 9.16453532311841},
   {95., 99., 103., 107., 111., 115., 119., 123., 127., 131., 135.,
    139., 143., 147., 151., 155., 159., 163., 167., 171., 175.,
    179., 183., 187., 191., 195., 199.}};\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?temperature*\)\)], "Input"],

Cell["\<\
temperature
temperatureError
temperatureErrorsFromFitResults
temperaturesFromFitResults\
\>", "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?*Plot*\)\)], "Input"],

Cell["\<\
altitudesToPlotForFitResults Plot3D
ContourPlot                  Plot3Matrix
DensityPlot                  PlotDivision
ListContourPlot              PlotJoined
ListDensityPlot              PlotLabel
ListPlot                     PlotPoints
ListPlot3D                   PlotRange
ParametricPlot               PlotRegion
ParametricPlot3D             PlotStyle
Plot\
\>", "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[\ 
        Transpose[{temperaturesFromFitResults[1], \ 
            altitudesToPlotForFitResults[1]\ }\ ]];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.76737 0.0272801 -0.556231 0.00588604 [
[.14224 -0.00956 -6 -9 ]
[.14224 -0.00956 6 0 ]
[.27864 -0.00956 -6 -9 ]
[.27864 -0.00956 6 0 ]
[.41504 -0.00956 -6 -9 ]
[.41504 -0.00956 6 0 ]
[.55144 -0.00956 -6 -9 ]
[.55144 -0.00956 6 0 ]
[.68784 -0.00956 -6 -9 ]
[.68784 -0.00956 6 0 ]
[.82424 -0.00956 -6 -9 ]
[.82424 -0.00956 6 0 ]
[.96064 -0.00956 -9 -9 ]
[.96064 -0.00956 9 0 ]
[-0.00666 .03237 -18 -4.5 ]
[-0.00666 .03237 0 4.5 ]
[-0.00666 .15009 -18 -4.5 ]
[-0.00666 .15009 0 4.5 ]
[-0.00666 .26781 -18 -4.5 ]
[-0.00666 .26781 0 4.5 ]
[-0.00666 .38554 -18 -4.5 ]
[-0.00666 .38554 0 4.5 ]
[-0.00666 .50326 -18 -4.5 ]
[-0.00666 .50326 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.14224 .00294 m
.14224 .00919 L
s
[(70)] .14224 -0.00956 0 1 Mshowa
.27864 .00294 m
.27864 .00919 L
s
[(75)] .27864 -0.00956 0 1 Mshowa
.41504 .00294 m
.41504 .00919 L
s
[(80)] .41504 -0.00956 0 1 Mshowa
.55144 .00294 m
.55144 .00919 L
s
[(85)] .55144 -0.00956 0 1 Mshowa
.68784 .00294 m
.68784 .00919 L
s
[(90)] .68784 -0.00956 0 1 Mshowa
.82424 .00294 m
.82424 .00919 L
s
[(95)] .82424 -0.00956 0 1 Mshowa
.96064 .00294 m
.96064 .00919 L
s
[(100)] .96064 -0.00956 0 1 Mshowa
.125 Mabswid
.03312 .00294 m
.03312 .00669 L
s
.0604 .00294 m
.0604 .00669 L
s
.08768 .00294 m
.08768 .00669 L
s
.11496 .00294 m
.11496 .00669 L
s
.16952 .00294 m
.16952 .00669 L
s
.1968 .00294 m
.1968 .00669 L
s
.22408 .00294 m
.22408 .00669 L
s
.25136 .00294 m
.25136 .00669 L
s
.30592 .00294 m
.30592 .00669 L
s
.3332 .00294 m
.3332 .00669 L
s
.36048 .00294 m
.36048 .00669 L
s
.38776 .00294 m
.38776 .00669 L
s
.44232 .00294 m
.44232 .00669 L
s
.4696 .00294 m
.4696 .00669 L
s
.49688 .00294 m
.49688 .00669 L
s
.52416 .00294 m
.52416 .00669 L
s
.57872 .00294 m
.57872 .00669 L
s
.606 .00294 m
.606 .00669 L
s
.63328 .00294 m
.63328 .00669 L
s
.66056 .00294 m
.66056 .00669 L
s
.71512 .00294 m
.71512 .00669 L
s
.7424 .00294 m
.7424 .00669 L
s
.76968 .00294 m
.76968 .00669 L
s
.79696 .00294 m
.79696 .00669 L
s
.85152 .00294 m
.85152 .00669 L
s
.8788 .00294 m
.8788 .00669 L
s
.90608 .00294 m
.90608 .00669 L
s
.93336 .00294 m
.93336 .00669 L
s
.98792 .00294 m
.98792 .00669 L
s
.25 Mabswid
0 .00294 m
1 .00294 L
s
.00584 .03237 m
.01209 .03237 L
s
[(100)] -0.00666 .03237 1 0 Mshowa
.00584 .15009 m
.01209 .15009 L
s
[(120)] -0.00666 .15009 1 0 Mshowa
.00584 .26781 m
.01209 .26781 L
s
[(140)] -0.00666 .26781 1 0 Mshowa
.00584 .38554 m
.01209 .38554 L
s
[(160)] -0.00666 .38554 1 0 Mshowa
.00584 .50326 m
.01209 .50326 L
s
[(180)] -0.00666 .50326 1 0 Mshowa
.125 Mabswid
.00584 .0618 m
.00959 .0618 L
s
.00584 .09123 m
.00959 .09123 L
s
.00584 .12066 m
.00959 .12066 L
s
.00584 .17952 m
.00959 .17952 L
s
.00584 .20895 m
.00959 .20895 L
s
.00584 .23838 m
.00959 .23838 L
s
.00584 .29724 m
.00959 .29724 L
s
.00584 .32668 m
.00959 .32668 L
s
.00584 .35611 m
.00959 .35611 L
s
.00584 .41497 m
.00959 .41497 L
s
.00584 .4444 m
.00959 .4444 L
s
.00584 .47383 m
.00959 .47383 L
s
.00584 .53269 m
.00959 .53269 L
s
.00584 .56212 m
.00959 .56212 L
s
.00584 .59155 m
.00959 .59155 L
s
.25 Mabswid
.00584 0 m
.00584 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.05564 .03826 Mdot
.08794 .0618 Mdot
.12072 .08535 Mdot
.154 .10889 Mdot
.18776 .13244 Mdot
.22203 .15598 Mdot
.2568 .17952 Mdot
.29208 .20307 Mdot
.32787 .22661 Mdot
.3642 .25016 Mdot
.40105 .2737 Mdot
.43843 .29724 Mdot
.47636 .32079 Mdot
.51484 .34433 Mdot
.55387 .36788 Mdot
.59347 .39142 Mdot
.63363 .41497 Mdot
.67437 .43851 Mdot
.71569 .46205 Mdot
.75759 .4856 Mdot
.80009 .50914 Mdot
.8432 .53269 Mdot
.88691 .55623 Mdot
.93124 .57977 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00=@3oool00`000000oooo0?ooo`030?ooo`8000007@3oool00`000000oooo0?ooo`020?oo
o`<000006`3oool3000000@0oooo0P00000L0?ooo`<000000`3oool3000001/0oooo0P0000050?oo
o`800000703oool2000000@0oooo0`00000H0?ooo`<00000103oool2000000@0oooo0P0000050?oo
o`00=@3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000001`0oooo00D000000?oo
o`3oool0oooo000000030?ooo`030000003oool0oooo01L0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`040000003oool0oooo000001X0oooo00L000000?ooo`3oool0oooo0000003oool00000
00<0oooo00<000000?ooo`3oool06P3oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool06`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0
oooo000f0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool05`3oool01@000000oooo0?ooo`3oool00000
0080oooo00@000000?ooo`3oool000006P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<0
00000?ooo`3oool06`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo01`0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`00=P3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo01P0oooo0`0000030?ooo`040000003oool0oooo000001/0oooo0`000006
0?ooo`030000003oool0oooo01P0oooo100000020?ooo`040000003oool0oooo000001/0oooo1000
00050?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo000000@0oooo000g0?ooo`040000003oool0oooo00000080
oooo00<000000?ooo`3oool0703oool00`000000oooo00000003000001X0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`040000003oool0oooo000001X0oooo00H000000?ooo`3oool0oooo0000
003oool4000001X0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo0000
01X0oooo00H000000?ooo`3oool0oooo0000003oool4000001T0oooo00<000000?ooo`3oool00P3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo000c0?ooo`050000
003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`00000J0?ooo`070000003oool0oooo
0?ooo`000000oooo0000000M0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo
0?ooo`00000J0?ooo`070000003oool0oooo0?ooo`000000oooo0000000M0?ooo`050000003oool0
oooo0?ooo`0000000P3oool010000000oooo0?ooo`00000J0?ooo`070000003oool0oooo0?ooo`00
0000oooo0000000K0?ooo`800000103oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000000@0oooo000c0?ooo`D000000`3oool2000001/0oooo1@0000000`3oool0000000000003
000001X0oooo0`0000040?ooo`800000703oool300000080oooo1@00000J0?ooo`<00000103oool2
000001`0oooo0`0000020?ooo`D00000603oool00`000000oooo0?ooo`030?ooo`800000103oool2
000000D0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo000E0?ooo`030000003o
ool0oooo0?l0oooo2@3oool001<0ooooo`00000>000000005@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?oo
o`005@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool08@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3o
ool08P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00T0oooo000E0?ooo`040000
003oool0oooo0?ooo`800000o`3oool60?ooo`005@3oool010000000oooo0?ooo`3oool200000?l0
oooo1P3oool000040?ooo`0000000000000000@0oooo0P0000040?ooo`8000001@3oool00`000000
oooo0?ooo`3o0?ooo`T0oooo00020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0?l0oooo2@3oool00080
oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool0o`3oool90?ooo`000P3oool00`000000oooo0?ooo`020?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool300000?l0oooo2@3o
ool00080oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool02P3oool200000?`0oooo00000`3oool000000000
00040?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`0:0?ooo`800000o03oool00080oooo00<000000?ooo`3oool00`3oool2000000@0oooo
0P0000050?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3o
ool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo
0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool04P3oool200000?@0oooo000E0?ooo`800000
4`3oool200000?@0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<00000
0?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`03
0000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3o
ool00`000000oooo0?ooo`0K0?ooo`800000j`3oool001D0oooo00<000000?ooo`3oool06`3oool2
00000>/0oooo000E0?ooo`800000o`3oool:0?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0
oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3o
ool90?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`800000hP3oool001D0oooo00<000000?oo
o`3oool0903oool200000>80oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo
0P00003o0?ooo`X0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<00000
0?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`0]0?ooo`800000f@3oool001D0
oooo00<000000?ooo`3oool0;@3oool200000=T0oooo000E0?ooo`030000003oool0oooo0?l0oooo
2@3oool000040?ooo`000000000000000080oooo1@0000030?ooo`8000001@3oool00`000000oooo
0?ooo`3o0?ooo`T0oooo00020?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0?l0oooo2@3oool00080oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0
oooo0`00003o0?ooo`T0oooo00020?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0=P3oool200000=00
oooo00020?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0=P3oool200000=00oooo00000`3oool0
0000000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo0?l0oooo2@3oool00080oooo00<000000?ooo`3oool00P3oool30000
00@0oooo0P0000050?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3o
ool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003o
ool0oooo0?l0oooo2@3oool001D0oooo0P0000100?ooo`800000a`3oool001D0oooo00<000000?oo
o`3oool0?`3oool200000<L0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo
00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E
0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0B@3oool20000
0;d0oooo000E0?ooo`030000003oool0oooo04T0oooo0P00002m0?ooo`005@3oool200000?l0oooo
2P3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3o
ool0DP3oool200000;@0oooo000E0?ooo`030000003oool0oooo0580oooo0P00002d0?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool0
01D0oooo0P00003o0?ooo`X0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo
00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`1L0?ooo`800000ZP3o
ool001D0oooo00<000000?ooo`3oool0G03oool200000:X0oooo0000103oool00000000000000004
0?ooo`<000000`3oool2000000D0oooo00<000000?ooo`3oool0o`3oool90?ooo`000P3oool00`00
0000oooo0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0?l0oooo2@3oool00080oooo00@000000?ooo`3oool0oooo1@000002
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0o`3oool90?ooo`000P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo0080oooo0`00003o0?ooo`T0oooo00020?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`0000000`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo06H0oooo
0P00002P0?ooo`0000<0oooo0000000000001@3oool2000000<0oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`1V0?ooo`800000X03oool00080oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E
0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?oo
o`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0700oooo
0P00002F0?ooo`005@3oool200000740oooo0P00002F0?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3o
ool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003o
ool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0NP3oool2000008`0oooo000E0?oo
o`030000003oool0oooo07X0oooo0P00002<0?ooo`005@3oool200000?l0oooo2P3oool001D0oooo
00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E
0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0Q03oool20000
0880oooo000E0?ooo`030000003oool0oooo08@0oooo0P0000220?ooo`005@3oool00`000000oooo
0?ooo`3o0?ooo`T0oooo000E0?ooo`800000o`3oool:0?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3o
ool0S`3oool2000007L0oooo000E0?ooo`030000003oool0oooo08l0oooo0P00001g0?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`T0oooo0000103oool000000000000000030?ooo`<00000103o
ool2000000D0oooo00<000000?ooo`3oool0o`3oool90?ooo`000P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo0?l0oooo2@3oool00080oooo00D000000?ooo`3oool0oooo000000030?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool300000?l0oooo2@3oool00080oooo
00@000000?ooo`3oool0oooo100000030?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool0V@3oool2000006d0oooo00020?ooo`050000003oool0oooo0?ooo`0000001P3oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo09T0oooo0P00001]0?ooo`0000<0oooo0000
00000000103oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool0o`3oool90?ooo`000P3oool00`000000oooo0?ooo`030?ooo`800000103oool20000
00D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0
oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3o
ool90?ooo`005@3oool200000:D0oooo0P00001R0?ooo`005@3oool00`000000oooo0?ooo`2T0?oo
o`800000HP3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo
0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<00000
0?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`2_0?ooo`800000E`3oool001D0
oooo00<000000?ooo`3oool0[`3oool2000005L0oooo000E0?ooo`800000o`3oool:0?ooo`005@3o
ool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`2j0?ooo`80
0000C03oool001D0oooo00<000000?ooo`3oool0^P3oool2000004`0oooo000E0?ooo`030000003o
ool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool20000
0?l0oooo2P3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo
0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0<D0oooo0P0000110?ooo`005@3oool0
0`000000oooo0?ooo`350?ooo`800000@@3oool000040?ooo`0000000000000000<0oooo0`000004
0?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo00020?ooo`050000003oool0oooo
0?ooo`0000000`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0o`3oool90?ooo`000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0?l0oooo
2@3oool00080oooo00<000000?ooo`3oool00P3oool3000000<0oooo00@000000?ooo`3oool00000
103oool300000?l0oooo2@3oool00080oooo00D000000?ooo`3oool0oooo000000030?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3A0?ooo`80
0000=@3oool000030?ooo`000000000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0d@3oool2000003D0oooo00020?ooo`03
0000003oool0oooo0080oooo0`0000040?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`T0
oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3o
ool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo
0=`0oooo0P00000Z0?ooo`005@3oool200000=d0oooo0P00000Z0?ooo`005@3oool00`000000oooo
0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<00000
0?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`03
0000003oool0oooo0>P0oooo0P00000N0?ooo`005@3oool00`000000oooo0?ooo`3X0?ooo`800000
7P3oool001D0oooo0P00003o0?ooo`X0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool0
01D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0
oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0m03o
ool200000180oooo000E0?ooo`030000003oool0oooo0?@0oooo0P00000B0?ooo`005@3oool00`00
0000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`800000o`3oool:0?ooo`005@3oool00`000000oooo
0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool001D0oooo00<00000
0?ooo`3oool0o`3oool10?ooo`8000001P3oool001D0oooo00<000000?ooo`3oool0o`3oool10?oo
o`8000001P3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000oooo
0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0oooo0?l0oooo2@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {62.0725, 87.0793, 0.137179, \
0.635787}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[\ 
        Transpose[{temperaturesFromFitResults[2], \ 
            altitudesToPlotForFitResults[2]\ }\ ]];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.11992 0.0344001 -0.522952 0.00565965 [
[.28809 .00222 -6 -9 ]
[.28809 .00222 6 0 ]
[.46009 .00222 -6 -9 ]
[.46009 .00222 6 0 ]
[.63209 .00222 -6 -9 ]
[.63209 .00222 6 0 ]
[.80409 .00222 -6 -9 ]
[.80409 .00222 6 0 ]
[.97609 .00222 -6 -9 ]
[.97609 .00222 6 0 ]
[.10359 .04301 -18 -4.5 ]
[.10359 .04301 0 4.5 ]
[.10359 .15621 -18 -4.5 ]
[.10359 .15621 0 4.5 ]
[.10359 .2694 -18 -4.5 ]
[.10359 .2694 0 4.5 ]
[.10359 .38259 -18 -4.5 ]
[.10359 .38259 0 4.5 ]
[.10359 .49579 -18 -4.5 ]
[.10359 .49579 0 4.5 ]
[.10359 .60898 -18 -4.5 ]
[.10359 .60898 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.28809 .01472 m
.28809 .02097 L
s
[(70)] .28809 .00222 0 1 Mshowa
.46009 .01472 m
.46009 .02097 L
s
[(75)] .46009 .00222 0 1 Mshowa
.63209 .01472 m
.63209 .02097 L
s
[(80)] .63209 .00222 0 1 Mshowa
.80409 .01472 m
.80409 .02097 L
s
[(85)] .80409 .00222 0 1 Mshowa
.97609 .01472 m
.97609 .02097 L
s
[(90)] .97609 .00222 0 1 Mshowa
.125 Mabswid
.15049 .01472 m
.15049 .01847 L
s
.18489 .01472 m
.18489 .01847 L
s
.21929 .01472 m
.21929 .01847 L
s
.25369 .01472 m
.25369 .01847 L
s
.32249 .01472 m
.32249 .01847 L
s
.35689 .01472 m
.35689 .01847 L
s
.39129 .01472 m
.39129 .01847 L
s
.42569 .01472 m
.42569 .01847 L
s
.49449 .01472 m
.49449 .01847 L
s
.52889 .01472 m
.52889 .01847 L
s
.56329 .01472 m
.56329 .01847 L
s
.59769 .01472 m
.59769 .01847 L
s
.66649 .01472 m
.66649 .01847 L
s
.70089 .01472 m
.70089 .01847 L
s
.73529 .01472 m
.73529 .01847 L
s
.76969 .01472 m
.76969 .01847 L
s
.83849 .01472 m
.83849 .01847 L
s
.87289 .01472 m
.87289 .01847 L
s
.90729 .01472 m
.90729 .01847 L
s
.94169 .01472 m
.94169 .01847 L
s
.08169 .01472 m
.08169 .01847 L
s
.04729 .01472 m
.04729 .01847 L
s
.01289 .01472 m
.01289 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.11609 .04301 m
.12234 .04301 L
s
[(100)] .10359 .04301 1 0 Mshowa
.11609 .15621 m
.12234 .15621 L
s
[(120)] .10359 .15621 1 0 Mshowa
.11609 .2694 m
.12234 .2694 L
s
[(140)] .10359 .2694 1 0 Mshowa
.11609 .38259 m
.12234 .38259 L
s
[(160)] .10359 .38259 1 0 Mshowa
.11609 .49579 m
.12234 .49579 L
s
[(180)] .10359 .49579 1 0 Mshowa
.11609 .60898 m
.12234 .60898 L
s
[(200)] .10359 .60898 1 0 Mshowa
.125 Mabswid
.11609 .07131 m
.11984 .07131 L
s
.11609 .09961 m
.11984 .09961 L
s
.11609 .12791 m
.11984 .12791 L
s
.11609 .1845 m
.11984 .1845 L
s
.11609 .2128 m
.11984 .2128 L
s
.11609 .2411 m
.11984 .2411 L
s
.11609 .2977 m
.11984 .2977 L
s
.11609 .326 m
.11984 .326 L
s
.11609 .35429 m
.11984 .35429 L
s
.11609 .41089 m
.11984 .41089 L
s
.11609 .43919 m
.11984 .43919 L
s
.11609 .46749 m
.11984 .46749 L
s
.11609 .52408 m
.11984 .52408 L
s
.11609 .55238 m
.11984 .55238 L
s
.11609 .58068 m
.11984 .58068 L
s
.25 Mabswid
.11609 0 m
.11609 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.05538 .03735 Mdot
.08733 .05999 Mdot
.11966 .08263 Mdot
.15237 .10527 Mdot
.18547 .12791 Mdot
.21896 .15055 Mdot
.25284 .17319 Mdot
.28712 .19582 Mdot
.32179 .21846 Mdot
.35688 .2411 Mdot
.39237 .26374 Mdot
.42827 .28638 Mdot
.46459 .30902 Mdot
.50133 .33166 Mdot
.53848 .35429 Mdot
.57607 .37693 Mdot
.61408 .39957 Mdot
.65253 .42221 Mdot
.69142 .44485 Mdot
.73074 .46749 Mdot
.77052 .49013 Mdot
.81074 .51276 Mdot
.85141 .5354 Mdot
.89254 .55804 Mdot
.93413 .58068 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00DP3oool00`000000oooo0?ooo`030?ooo`8000009P3oool00`000000oooo0?ooo`020?oo
o`<000009P3oool3000000@0oooo0P00000U0?ooo`<000000`3oool3000002D0oooo0P0000050?oo
o`8000003@3oool00580oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00000U0?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0R0?ooo`050000003oool0
oooo0?ooo`0000000P3oool010000000oooo0?ooo`00000S0?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`030000003oool0oooo02@0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo00X0oooo001C0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool08P3oool0
1@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000008`3oool01@000000oooo
0?ooo`3oool0000000D0oooo00<000000?ooo`3oool09@3oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo00X0oooo001C0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool08`3oool30000
00<0oooo00@000000?ooo`3oool00000903oool3000000H0oooo00<000000?ooo`3oool08P3oool4
00000080oooo00@000000?ooo`3oool00000303oool005@0oooo00@000000?ooo`3oool000000P3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0000000<000009@3oool01@000000oooo0?oo
o`3oool000000080oooo00@000000?ooo`3oool000008`3oool01P000000oooo0?ooo`3oool00000
0?ooo`@00000903oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool00000
303oool00500oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo000002<0
oooo00L000000?ooo`3oool0oooo0000003oool0000002P0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`040000003oool0oooo000002<0oooo00L000000?ooo`3oool0oooo0000003oool00000
02L0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo000000`0oooo001@
0?ooo`D000000`3oool2000002@0oooo1@0000000`3oool0000000000003000002D0oooo0`000004
0?ooo`8000009@3oool300000080oooo1@00000T0?ooo`<00000103oool2000000d0oooo000X0?oo
o`030000003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000
003oool0oooo0?D0oooo000>0?ooo`800000603oool00`000000oooo0?ooo`3e0?ooo`00203ooooo
0000010000002@3oool000`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0>0?oo
o`00:03oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3o
ool0;03oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3o
ool03P3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3oool0m@3o
ool001<0oooo0`0000040?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool0m@3oool0
01@0oooo00<000000?ooo`3oool00`0000020?ooo`040000003oool0oooo00000080oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`3e0?ooo`00503oool00`000000oooo0?ooo`030000
0080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0?D0oooo000D0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000050?ooo`800000mP3oool001@0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
m@3oool001<0oooo0P0000040?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`3e0?ooo`00503oool00`000000oooo0?ooo`030?ooo`800000
103oool2000000H0oooo00<000000?ooo`3oool0m@3oool001l0oooo0P0000070?ooo`030000003o
ool0oooo0?D0oooo000O0?ooo`8000001`3oool00`000000oooo0?ooo`3e0?ooo`00:03oool00`00
0000oooo0?ooo`3e0?ooo`00:03oool200000?H0oooo000X0?ooo`030000003oool0oooo0?D0oooo
000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`800000mP3oool002P0oooo0P00003f0?oo
o`00:03oool00`000000oooo0?ooo`3e0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00:03o
ool00`000000oooo0?ooo`3e0?ooo`00:03oool200000?H0oooo000X0?ooo`030000003oool0oooo
00H0oooo0P00003]0?ooo`00:03oool00`000000oooo0?ooo`060?ooo`800000k@3oool002P0oooo
00<000000?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo00<00000
0?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo0P00000@0?ooo`80
0000i03oool002P0oooo00<000000?ooo`3oool03`3oool200000>@0oooo000X0?ooo`030000003o
ool0oooo0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo
0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000C0?ooo`<000000P3oool5000000<0oooo
0P0000060?ooo`030000003oool0oooo01P0oooo0P00003K0?ooo`00503oool00`000000oooo0?oo
o`020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool00`000000
oooo0?ooo`0H0?ooo`800000f`3oool001@0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`020?ooo`040000003oool0oooo000000D0oooo0P00003f0?ooo`00503oool00`000000oooo
0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0?D0oooo000D0?ooo`050000003oool0oooo0?ooo`0000000`3oool010000000
oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0m@3oool001<0
oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo0?D0oooo000D0?ooo`030000003oool0oooo0080oooo0`0000040?oo
o`8000001P3oool00`000000oooo0?ooo`0Q0?ooo`800000dP3oool002P0oooo00<000000?ooo`3o
ool08@3oool200000=80oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000003o
ool0oooo0?D0oooo000X0?ooo`800000mP3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0
oooo00<000000?ooo`3oool0:P3oool200000<T0oooo000X0?ooo`030000003oool0oooo02X0oooo
0P0000390?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00:03oool00`000000oooo0?ooo`3e
0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00:03oool200000?H0oooo000X0?ooo`030000
003oool0oooo03<0oooo0P0000300?ooo`00:03oool00`000000oooo0?ooo`0c0?ooo`800000`03o
ool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0
oooo00<000000?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo00<0
00000?ooo`3oool0?@3oool200000;H0oooo000X0?ooo`800000?P3oool200000;H0oooo000X0?oo
o`030000003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000
003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000C0?ooo`<00000103oool3
000000<0oooo0P0000060?ooo`030000003oool0oooo0?D0oooo000D0?ooo`030000003oool0oooo
00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0AP3oool200000:d0oooo000D0?ooo`040000003oool0oooo0?ooo`D000000P3oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0oooo04H0oooo0P00002]0?ooo`00503oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo00<0oooo0P00003f0?ooo`00503oool00`000000oooo0?ooo`020?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`3e0?ooo`004`3o
ool2000000D0oooo0P0000030?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0
m@3oool001@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`8000001P3o
ool00`000000oooo0?ooo`3e0?ooo`00:03oool00`000000oooo0?ooo`1@0?ooo`800000X`3oool0
02P0oooo00<000000?ooo`3oool0D03oool200000:<0oooo000X0?ooo`030000003oool0oooo0?D0
oooo000X0?ooo`800000mP3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo00<00000
0?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3oool0FP3oool2000009T0oooo000X0?ooo`03
0000003oool0oooo05X0oooo0P00002I0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00:03o
ool00`000000oooo0?ooo`3e0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00:03oool20000
0?H0oooo000X0?ooo`030000003oool0oooo06@0oooo0P00002?0?ooo`00:03oool00`000000oooo
0?ooo`1T0?ooo`800000S`3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo00<00000
0?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3o
ool0m@3oool002P0oooo0P00001_0?ooo`800000Q@3oool002P0oooo00<000000?ooo`3oool0KP3o
ool2000008D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo
0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo
000C0?ooo`<000000`3oool3000000@0oooo0P0000060?ooo`030000003oool0oooo07P0oooo0P00
001k0?ooo`00503oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo07P0oooo0P00001k0?ooo`00503o
ool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`030?ooo`800000mP3oool001@0oooo00@000000?ooo`3oool0oooo100000030?ooo`04
0000003oool0oooo000000D0oooo00<000000?ooo`3oool0m@3oool001@0oooo00D000000?ooo`3o
ool0oooo000000060?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0m@3oool0
01<0oooo0P0000040?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001@3oool0
0`000000oooo0?ooo`3e0?ooo`00503oool00`000000oooo0?ooo`030?ooo`800000103oool20000
00H0oooo00<000000?ooo`3oool0PP3oool200000740oooo000X0?ooo`030000003oool0oooo0880
oooo0P00001a0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00:03oool00`000000oooo0?oo
o`3e0?ooo`00:03oool200000?H0oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`03
0000003oool0oooo08d0oooo0P00001V0?ooo`00:03oool00`000000oooo0?ooo`2=0?ooo`800000
IP3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3oool0m@3oool0
02P0oooo00<000000?ooo`3oool0m@3oool002P0oooo0P00003f0?ooo`00:03oool00`000000oooo
0?ooo`2G0?ooo`800000G03oool002P0oooo00<000000?ooo`3oool0U`3oool2000005`0oooo000X
0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`03
0000003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000003o
ool0oooo0:80oooo0P00001A0?ooo`00:03oool200000:<0oooo0P00001A0?ooo`00:03oool00`00
0000oooo0?ooo`3e0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00:03oool00`000000oooo
0?ooo`3e0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`004`3oool3000000<0oooo0`000004
0?ooo`8000001P3oool00`000000oooo0?ooo`3e0?ooo`00503oool01@000000oooo0?ooo`3oool0
000000<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0:`0oooo0P0000170?ooo`00503oool01@000000oooo0?ooo`3oool0000000<0oooo00@0
00000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0:`0oooo
0P0000170?ooo`00503oool00`000000oooo0?ooo`020?ooo`<000000`3oool010000000oooo0?oo
o`0000050?ooo`800000mP3oool001@0oooo00D000000?ooo`3oool0oooo000000030?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3e0?ooo`00
4`3oool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo0000
00D0oooo00<000000?ooo`3oool0m@3oool001@0oooo00<000000?ooo`3oool00P3oool3000000@0
oooo0P0000060?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo0;L0oooo
0P00000l0?ooo`00:03oool00`000000oooo0?ooo`2g0?ooo`800000?03oool002P0oooo00<00000
0?ooo`3oool0m@3oool002P0oooo0P00003f0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00
:03oool00`000000oooo0?ooo`3e0?ooo`00:03oool00`000000oooo0?ooo`320?ooo`800000<@3o
ool002P0oooo00<000000?ooo`3oool0`P3oool200000340oooo000X0?ooo`030000003oool0oooo
0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo000X0?ooo`030000003oool0oooo0?D0oooo
000X0?ooo`800000mP3oool002P0oooo00<000000?ooo`3oool0c@3oool2000002H0oooo000X0?oo
o`030000003oool0oooo0<d0oooo0P00000V0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00
:03oool00`000000oooo0?ooo`3e0?ooo`00:03oool00`000000oooo0?ooo`3e0?ooo`00:03oool0
0`000000oooo0?ooo`3e0?ooo`00:03oool200000=T0oooo0P00000K0?ooo`00:03oool00`000000
oooo0?ooo`3H0?ooo`8000006`3oool002P0oooo00<000000?ooo`3oool0m@3oool002P0oooo00<0
00000?ooo`3oool0m@3oool002P0oooo00<000000?ooo`3oool0m@3oool00180oooo1@0000030?oo
o`800000103oool2000000H0oooo00<000000?ooo`3oool0m@3oool001<0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`3oool0i03oool2000000l0oooo000D0?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0>@0oooo
0P00000?0?ooo`005@3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`030?ooo`800000mP3oool00180oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool0
0`000000oooo0?ooo`3e0?ooo`004P3oool01@000000oooo0?ooo`3oool000000080oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0?D0oooo
000C0?ooo`<00000103oool2000000@0oooo0P00003n0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {60.6734, 86.8881, 0.107922, \
0.655964}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[\ 
        Transpose[{temperature[1], \ binnedAltitude[1]\ }\ ]];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-3.57633 0.0713512 -0.14843 0.0081076 [
[.27664 .00122 -6 -9 ]
[.27664 .00122 6 0 ]
[.41934 .00122 -6 -9 ]
[.41934 .00122 6 0 ]
[.56205 .00122 -6 -9 ]
[.56205 .00122 6 0 ]
[.70475 .00122 -6 -9 ]
[.70475 .00122 6 0 ]
[.84745 .00122 -6 -9 ]
[.84745 .00122 6 0 ]
[.99015 .00122 -6 -9 ]
[.99015 .00122 6 0 ]
[.12144 .0948 -12 -4.5 ]
[.12144 .0948 0 4.5 ]
[.12144 .17587 -12 -4.5 ]
[.12144 .17587 0 4.5 ]
[.12144 .25695 -12 -4.5 ]
[.12144 .25695 0 4.5 ]
[.12144 .33803 -12 -4.5 ]
[.12144 .33803 0 4.5 ]
[.12144 .4191 -12 -4.5 ]
[.12144 .4191 0 4.5 ]
[.12144 .50018 -12 -4.5 ]
[.12144 .50018 0 4.5 ]
[.12144 .58125 -12 -4.5 ]
[.12144 .58125 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.27664 .01372 m
.27664 .01997 L
s
[(54)] .27664 .00122 0 1 Mshowa
.41934 .01372 m
.41934 .01997 L
s
[(56)] .41934 .00122 0 1 Mshowa
.56205 .01372 m
.56205 .01997 L
s
[(58)] .56205 .00122 0 1 Mshowa
.70475 .01372 m
.70475 .01997 L
s
[(60)] .70475 .00122 0 1 Mshowa
.84745 .01372 m
.84745 .01997 L
s
[(62)] .84745 .00122 0 1 Mshowa
.99015 .01372 m
.99015 .01997 L
s
[(64)] .99015 .00122 0 1 Mshowa
.125 Mabswid
.16961 .01372 m
.16961 .01747 L
s
.20529 .01372 m
.20529 .01747 L
s
.24096 .01372 m
.24096 .01747 L
s
.31232 .01372 m
.31232 .01747 L
s
.34799 .01372 m
.34799 .01747 L
s
.38367 .01372 m
.38367 .01747 L
s
.45502 .01372 m
.45502 .01747 L
s
.49069 .01372 m
.49069 .01747 L
s
.52637 .01372 m
.52637 .01747 L
s
.59772 .01372 m
.59772 .01747 L
s
.6334 .01372 m
.6334 .01747 L
s
.66907 .01372 m
.66907 .01747 L
s
.74042 .01372 m
.74042 .01747 L
s
.7761 .01372 m
.7761 .01747 L
s
.81177 .01372 m
.81177 .01747 L
s
.88313 .01372 m
.88313 .01747 L
s
.9188 .01372 m
.9188 .01747 L
s
.95448 .01372 m
.95448 .01747 L
s
.09826 .01372 m
.09826 .01747 L
s
.06259 .01372 m
.06259 .01747 L
s
.02691 .01372 m
.02691 .01747 L
s
.25 Mabswid
0 .01372 m
1 .01372 L
s
.13394 .0948 m
.14019 .0948 L
s
[(30)] .12144 .0948 1 0 Mshowa
.13394 .17587 m
.14019 .17587 L
s
[(40)] .12144 .17587 1 0 Mshowa
.13394 .25695 m
.14019 .25695 L
s
[(50)] .12144 .25695 1 0 Mshowa
.13394 .33803 m
.14019 .33803 L
s
[(60)] .12144 .33803 1 0 Mshowa
.13394 .4191 m
.14019 .4191 L
s
[(70)] .12144 .4191 1 0 Mshowa
.13394 .50018 m
.14019 .50018 L
s
[(80)] .12144 .50018 1 0 Mshowa
.13394 .58125 m
.14019 .58125 L
s
[(90)] .12144 .58125 1 0 Mshowa
.125 Mabswid
.13394 .02994 m
.13769 .02994 L
s
.13394 .04615 m
.13769 .04615 L
s
.13394 .06237 m
.13769 .06237 L
s
.13394 .07858 m
.13769 .07858 L
s
.13394 .11101 m
.13769 .11101 L
s
.13394 .12723 m
.13769 .12723 L
s
.13394 .14344 m
.13769 .14344 L
s
.13394 .15966 m
.13769 .15966 L
s
.13394 .19209 m
.13769 .19209 L
s
.13394 .2083 m
.13769 .2083 L
s
.13394 .22452 m
.13769 .22452 L
s
.13394 .24074 m
.13769 .24074 L
s
.13394 .27317 m
.13769 .27317 L
s
.13394 .28938 m
.13769 .28938 L
s
.13394 .3056 m
.13769 .3056 L
s
.13394 .32181 m
.13769 .32181 L
s
.13394 .35424 m
.13769 .35424 L
s
.13394 .37046 m
.13769 .37046 L
s
.13394 .38667 m
.13769 .38667 L
s
.13394 .40289 m
.13769 .40289 L
s
.13394 .43532 m
.13769 .43532 L
s
.13394 .45153 m
.13769 .45153 L
s
.13394 .46775 m
.13769 .46775 L
s
.13394 .48396 m
.13769 .48396 L
s
.13394 .51639 m
.13769 .51639 L
s
.13394 .53261 m
.13769 .53261 L
s
.13394 .54882 m
.13769 .54882 L
s
.13394 .56504 m
.13769 .56504 L
s
.13394 .59747 m
.13769 .59747 L
s
.13394 .61368 m
.13769 .61368 L
s
.25 Mabswid
.13394 0 m
.13394 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.97619 .60332 Mdot
.88016 .57218 Mdot
.80594 .54383 Mdot
.73973 .51927 Mdot
.67791 .49737 Mdot
.61935 .47801 Mdot
.56666 .45993 Mdot
.52437 .44246 Mdot
.48742 .42716 Mdot
.45013 .41381 Mdot
.41581 .40051 Mdot
.38496 .38863 Mdot
.3551 .37772 Mdot
.32681 .36737 Mdot
.30073 .35755 Mdot
.27625 .34851 Mdot
.25402 .33938 Mdot
.23604 .33025 Mdot
.19512 .31614 Mdot
.15945 .30191 Mdot
.13665 .28715 Mdot
.12366 .27354 Mdot
.10901 .26267 Mdot
.0944 .25184 Mdot
.08339 .24125 Mdot
.09116 .22736 Mdot
.10566 .21565 Mdot
.11726 .20554 Mdot
.12556 .19644 Mdot
.12429 .18569 Mdot
.12744 .17345 Mdot
.13885 .16431 Mdot
.14422 .15453 Mdot
.14238 .14624 Mdot
.13928 .1377 Mdot
.13126 .12777 Mdot
.12238 .11835 Mdot
.11285 .10967 Mdot
.10767 .10005 Mdot
.10888 .09039 Mdot
.09734 .08124 Mdot
.08793 .07248 Mdot
.09138 .06325 Mdot
.10233 .05454 Mdot
.11956 .04567 Mdot
.09152 .03718 Mdot
.06634 .02867 Mdot
.04473 .01999 Mdot
.02381 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00C03oool3000000@0oooo0`00000L0?ooo`<000000`3oool3000001h0oooo0`0000030?oo
o`<000007P3oool3000000@0oooo0P00000N0?ooo`<000000P3oool5000001d0oooo0`0000040?oo
o`<00000203oool004/0oooo00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo
01X0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`3oool06P3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0?ooo`0J0?ooo`05
0000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`00000L0?ooo`050000003oool0
oooo0?ooo`0000000P3oool010000000oooo0?ooo`00000L0?ooo`050000003oool0oooo0?ooo`00
0000103oool00`000000oooo0?ooo`070?ooo`00C`3oool00`000000oooo00000004000001l0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0000000<0oooo
00<000000?ooo`3oool06P3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3o
ool00000703oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0703oool0
1P000000oooo0?ooo`3oool000000?ooo`D00000203oool004l0oooo00<000000?ooo`0000000P3o
ool00`000000oooo0?ooo`0N0?ooo`030000003oool0000000<000008@3oool00`000000oooo0?oo
o`03000001d0oooo100000030?ooo`040000003oool0oooo000001`0oooo100000050?ooo`030000
003oool0oooo01/0oooo100000020?ooo`040000003oool0oooo000000T0oooo001;0?ooo`@00000
0`3oool00`000000oooo0000000L0?ooo`@000000P3oool00`000000oooo0?ooo`0N0?ooo`@00000
0P3oool01@000000oooo0?ooo`3oool0000001`0oooo00<000000?ooo`3oool0103oool010000000
oooo0?ooo`00000L0?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000L
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000002@3oool004/0oooo00<000000?oo
o`3oool01@3oool2000001`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo0000000M0?ooo`030000003oool0
oooo00<0oooo00@000000?ooo`3oool000007@3oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000007@3oool00`000000oooo0?ooo`040?ooo`8000002@3oool004/0oooo1@00
00040?ooo`030000003oool0oooo01X0oooo1@0000030?ooo`8000007@3oool500000080oooo0`00
000O0?ooo`800000103oool2000001l0oooo0P0000030?ooo`<000007`3oool2000000D0oooo00<0
00000?ooo`3oool01`3oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo00<000000?oo
o`3oool0l`3oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0
l`3oool000D0ooooo`00000B000000X0oooo000;0?ooo`<000000`3oool2000000<0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00X0oooo000A0?oo
o`8000005`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02@0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`0:0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00
5`3oool200000140oooo0P00003d0?ooo`005`3oool200000140oooo00<000000?ooo`3oool0l`3o
ool001h0oooo0P00000:0?ooo`030000003oool0oooo0?<0oooo000N0?ooo`8000002P3oool00`00
0000oooo0?ooo`3c0?ooo`009@3oool2000000<0oooo00<000000?ooo`3oool0l`3oool002D0oooo
0P0000030?ooo`800000m03oool002X0oooo00<000000?ooo`3oool0l`3oool00240oooo0P000007
0?ooo`030000003oool0oooo0?<0oooo000Q0?ooo`8000001`3oool00`000000oooo0?ooo`3c0?oo
o`007P3oool2000000X0oooo0P00003d0?ooo`007P3oool2000000X0oooo00<000000?ooo`3oool0
l`3oool002X0oooo00<000000?ooo`3oool0l`3oool001d0oooo0P00000;0?ooo`030000003oool0
oooo0?<0oooo000M0?ooo`8000002`3oool00`000000oooo0?ooo`3c0?ooo`007`3oool2000000T0
oooo0P00003d0?ooo`007`3oool2000000T0oooo00<000000?ooo`3oool0l`3oool001/0oooo0`00
00040?ooo`8000001P3oool00`000000oooo0?ooo`3c0?ooo`006P3oool01@000000oooo0?ooo`3o
ool000000080oooo100000050?ooo`030000003oool0oooo0?<0oooo000N0?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool00`3oool200000?@0oooo000L0?ooo`8000000`3oool4
000000D0oooo00<000000?ooo`3oool0l`3oool001h0oooo00<000000?ooo`3oool0100000050?oo
o`030000003oool0oooo0?<0oooo000J0?ooo`050000003oool0oooo0?ooo`0000000P3oool01000
0000oooo0?ooo`0000050?ooo`030000003oool0oooo0?<0oooo000K0?ooo`<00000103oool30000
00D0oooo0P00003d0?ooo`008`3oool2000000D0oooo00<000000?ooo`3oool0l`3oool002H0oooo
0P0000020?ooo`030000003oool0oooo0?<0oooo000V0?ooo`8000000P3oool00`000000oooo0?oo
o`3c0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:03oool400000?@0oooo000X0?ooo`<0
0000m@3oool002X0oooo0`00003c0?ooo`00:P3oool300000?<0oooo000Z0?ooo`800000m03oool0
02X0oooo0`00003c0?ooo`00:P3oool300000?<0oooo000Z0?ooo`040000003oool0000000000?80
oooo000Z0?ooo`040000003oool0000000000?80oooo000Z0?ooo`800000m03oool002X0oooo0P00
003d0?ooo`00703oool3000000<0oooo0P0000060?ooo`800000m03oool001d0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo0080000000<0oooo0000003oool0m03oool0
01X0oooo1@0000020?ooo`040000003oool0oooo00000080oooo0P0000000`3oool000000000003d
0?ooo`006P3oool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`3oool0l`3oool001/0oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`00
0000oooo008000000P3oool00`000000oooo0?ooo`3c0?ooo`00703oool2000000<0oooo00D00000
0?ooo`3oool000000?ooo`0200000080oooo00<000000?ooo`3oool0l`3oool001d0oooo00<00000
0?ooo`3oool00P3oool2000000H0oooo00<000000?ooo`3oool0l`3oool002L0oooo0P0000000`3o
ool000000000003d0?ooo`009`3oool2000000030?ooo`000000oooo0?@0oooo000Z0?ooo`030000
003oool0oooo0?<0oooo000U0?ooo`8000000`3oool00`000000oooo0?ooo`3c0?ooo`009@3oool2
000000<0oooo0P00003d0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`008@3oool2000000L0
oooo00<000000?ooo`3oool0l`3oool00240oooo0P0000070?ooo`030000003oool0oooo0?<0oooo
000Z0?ooo`800000m03oool001d0oooo0P00000;0?ooo`030000003oool0oooo0?<0oooo000M0?oo
o`8000002`3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00
6`3oool2000000d0oooo00<000000?ooo`3oool0l`3oool001/0oooo0P00000=0?ooo`800000m03o
ool002X0oooo00<000000?ooo`3oool0l`3oool001/0oooo1@0000020?ooo`8000001P3oool00`00
0000oooo0?ooo`3c0?ooo`006P3oool010000000oooo0?ooo`3oool2000000050?ooo`000000oooo
0?ooo`0000001@3oool00`000000oooo0?ooo`3c0?ooo`007P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00<0oooo0P00003d0?ooo`007P3oool00`000000oooo0?ooo`040000
00D0oooo00<000000?ooo`3oool0l`3oool001X0oooo100000030?ooo`@000001@3oool00`000000
oooo0?ooo`3c0?ooo`006P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000D0
oooo00<000000?ooo`3oool0l`3oool001X0oooo1@0000030?ooo`8000000P3oool200000080oooo
00<000000?ooo`3oool0l`3oool002H0oooo0P0000020?ooo`800000m03oool002X0oooo00<00000
0?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0l`3oool002X0oooo0P00003d0?ooo`00
:P3oool200000?@0oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0
oooo0?<0oooo000Z0?ooo`030000003oool0oooo00<0oooo0P00003^0?ooo`00:P3oool2000000@0
oooo0P00003^0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?oo
o`3c0?ooo`00:P3oool00`000000oooo0?ooo`0=0?ooo`800000i03oool002X0oooo00<000000?oo
o`3oool03@3oool200000>@0oooo000Z0?ooo`800000m03oool002X0oooo00<000000?ooo`3oool0
l`3oool001/0oooo0`0000040?ooo`8000001P3oool00`000000oooo0?ooo`0H0?ooo`800000f@3o
ool001X0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo000000D0oooo
00<000000?ooo`3oool0603oool200000=T0oooo000J0?ooo`050000003oool0oooo0?ooo`000000
0P3oool010000000oooo0?ooo`0000050?ooo`8000007P3oool200000=@0oooo000J0?ooo`@00000
0`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo01d0oooo0P00003D0?ooo`00
6P3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3o
ool0l`3oool001/0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000050?ooo`03
0000003oool0oooo02<0oooo0P00003>0?ooo`00703oool2000000@0oooo0P0000060?ooo`030000
003oool0oooo02<0oooo0P00003>0?ooo`00:P3oool2000002/0oooo0P0000370?ooo`00:P3oool0
0`000000oooo0?ooo`0Z0?ooo`800000a`3oool002X0oooo00<000000?ooo`3oool0l`3oool002X0
oooo00<000000?ooo`3oool0<@3oool200000<00oooo000Z0?ooo`800000<P3oool200000<00oooo
000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo03P0oooo0P00002i
0?ooo`00:P3oool00`000000oooo0?ooo`0h0?ooo`800000^@3oool002X0oooo00<000000?ooo`3o
ool0l`3oool002X0oooo0P0000110?ooo`800000/@3oool002X0oooo00<000000?ooo`3oool0@03o
ool200000;40oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo
04T0oooo0P00002X0?ooo`00:P3oool2000004X0oooo0P00002X0?ooo`00:P3oool00`000000oooo
0?ooo`3c0?ooo`00703oool00`000000oooo0?ooo`030?ooo`8000001P3oool00`000000oooo0?oo
o`1B0?ooo`800000W`3oool001`0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`00
00050?ooo`030000003oool0oooo0580oooo0P00002O0?ooo`007@3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool00`3oool200000?@0oooo000M0?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?<0oooo000N
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`1L0?ooo`800000U@3oool001X0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003o
ool0oooo000000D0oooo00<000000?ooo`3oool0G03oool2000009D0oooo000J0?ooo`D000000`3o
ool2000000H0oooo00<000000?ooo`3oool0l`3oool002X0oooo0P00003d0?ooo`00:P3oool00`00
0000oooo0?ooo`1V0?ooo`800000R`3oool002X0oooo00<000000?ooo`3oool0IP3oool2000008/0
oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`800000m03oool002X0oooo00<00000
0?ooo`3oool0l`3oool002X0oooo00<000000?ooo`3oool0LP3oool2000007l0oooo000Z0?ooo`03
0000003oool0oooo0780oooo0P00001o0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3o
ool200000?@0oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo
0800oooo0P00001a0?ooo`00:P3oool00`000000oooo0?ooo`200?ooo`800000L@3oool002X0oooo
0P00003d0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`006`3oool3000000@0oooo0P000006
0?ooo`030000003oool0oooo0?<0oooo000J0?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0oooo0900oooo0P00001Q0?ooo`006P3oool0
1@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000001@3oool200000940oooo
0P00001Q0?ooo`006`3oool3000000<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo
0?ooo`3c0?ooo`006P3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`3c0?ooo`006P3oool01@000000oooo0?ooo`3oool000000080
oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`3c0?ooo`006`3oool3000000@0
oooo0P0000060?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`800000XP3oool200000500oooo
000Z0?ooo`030000003oool0oooo0:40oooo0P00001@0?ooo`00:P3oool00`000000oooo0?ooo`3c
0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool200000?@0oooo000Z0?ooo`030000
003oool0oooo0?<0oooo000Z0?ooo`030000003oool0oooo0?<0oooo000Z0?ooo`030000003oool0
oooo0;<0oooo0P00000n0?ooo`00:P3oool00`000000oooo0?ooo`2c0?ooo`800000?P3oool002X0
oooo0P00003d0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool00`000000oooo0?oo
o`3c0?ooo`00:P3oool00`000000oooo0?ooo`3c0?ooo`00:P3oool200000?@0oooo000Z0?ooo`03
0000003oool0oooo0?<0oooo000K0?ooo`8000001@3oool2000000H0oooo00<000000?ooo`3oool0
a`3oool2000002X0oooo000M0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0<L0oooo0P00000Z0?ooo`007P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00<0oooo0P00003d0?ooo`006`3oool400000080oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`3c0?ooo`006P3oool01@000000oooo0?oo
o`3oool000000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`3c0?ooo`00
6P3oool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000001@3oool00`00
0000oooo0?ooo`3c0?ooo`006`3oool3000000@0oooo0P0000060?ooo`030000003oool0oooo0?<0
oooo000Z0?ooo`800000m03oool002X0oooo00<000000?ooo`3oool0h@3oool200000100oooo000Z
0?ooo`030000003oool0oooo0>40oooo0P00000@0?ooo`00:P3oool00`000000oooo0?ooo`3c0?oo
o`00:P3oool200000?@0oooo000Z0?ooo`030000003oool0oooo0?<0oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {49.8291, 14.3804, 0.0514762, \
0.453018}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[\ 
        Transpose[{temperature[2], \ binnedAltitude[2]\ }\ ]];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-4.68674 0.0926941 -0.109084 0.00783195 [
[.31874 .03506 -6 -9 ]
[.31874 .03506 6 0 ]
[.50412 .03506 -6 -9 ]
[.50412 .03506 6 0 ]
[.68951 .03506 -6 -9 ]
[.68951 .03506 6 0 ]
[.8749 .03506 -6 -9 ]
[.8749 .03506 6 0 ]
[.12085 .12587 -12 -4.5 ]
[.12085 .12587 0 4.5 ]
[.12085 .20419 -12 -4.5 ]
[.12085 .20419 0 4.5 ]
[.12085 .28251 -12 -4.5 ]
[.12085 .28251 0 4.5 ]
[.12085 .36083 -12 -4.5 ]
[.12085 .36083 0 4.5 ]
[.12085 .43915 -12 -4.5 ]
[.12085 .43915 0 4.5 ]
[.12085 .51747 -12 -4.5 ]
[.12085 .51747 0 4.5 ]
[.12085 .59579 -12 -4.5 ]
[.12085 .59579 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.31874 .04756 m
.31874 .05381 L
s
[(54)] .31874 .03506 0 1 Mshowa
.50412 .04756 m
.50412 .05381 L
s
[(56)] .50412 .03506 0 1 Mshowa
.68951 .04756 m
.68951 .05381 L
s
[(58)] .68951 .03506 0 1 Mshowa
.8749 .04756 m
.8749 .05381 L
s
[(60)] .8749 .03506 0 1 Mshowa
.125 Mabswid
.1797 .04756 m
.1797 .05131 L
s
.22604 .04756 m
.22604 .05131 L
s
.27239 .04756 m
.27239 .05131 L
s
.36508 .04756 m
.36508 .05131 L
s
.41143 .04756 m
.41143 .05131 L
s
.45778 .04756 m
.45778 .05131 L
s
.55047 .04756 m
.55047 .05131 L
s
.59682 .04756 m
.59682 .05131 L
s
.64317 .04756 m
.64317 .05131 L
s
.73586 .04756 m
.73586 .05131 L
s
.78221 .04756 m
.78221 .05131 L
s
.82855 .04756 m
.82855 .05131 L
s
.087 .04756 m
.087 .05131 L
s
.04065 .04756 m
.04065 .05131 L
s
.92125 .04756 m
.92125 .05131 L
s
.96759 .04756 m
.96759 .05131 L
s
.25 Mabswid
0 .04756 m
1 .04756 L
s
.13335 .12587 m
.1396 .12587 L
s
[(30)] .12085 .12587 1 0 Mshowa
.13335 .20419 m
.1396 .20419 L
s
[(40)] .12085 .20419 1 0 Mshowa
.13335 .28251 m
.1396 .28251 L
s
[(50)] .12085 .28251 1 0 Mshowa
.13335 .36083 m
.1396 .36083 L
s
[(60)] .12085 .36083 1 0 Mshowa
.13335 .43915 m
.1396 .43915 L
s
[(70)] .12085 .43915 1 0 Mshowa
.13335 .51747 m
.1396 .51747 L
s
[(80)] .12085 .51747 1 0 Mshowa
.13335 .59579 m
.1396 .59579 L
s
[(90)] .12085 .59579 1 0 Mshowa
.125 Mabswid
.13335 .06322 m
.1371 .06322 L
s
.13335 .07888 m
.1371 .07888 L
s
.13335 .09455 m
.1371 .09455 L
s
.13335 .11021 m
.1371 .11021 L
s
.13335 .14154 m
.1371 .14154 L
s
.13335 .1572 m
.1371 .1572 L
s
.13335 .17287 m
.1371 .17287 L
s
.13335 .18853 m
.1371 .18853 L
s
.13335 .21986 m
.1371 .21986 L
s
.13335 .23552 m
.1371 .23552 L
s
.13335 .25119 m
.1371 .25119 L
s
.13335 .26685 m
.1371 .26685 L
s
.13335 .29818 m
.1371 .29818 L
s
.13335 .31384 m
.1371 .31384 L
s
.13335 .32951 m
.1371 .32951 L
s
.13335 .34517 m
.1371 .34517 L
s
.13335 .3765 m
.1371 .3765 L
s
.13335 .39216 m
.1371 .39216 L
s
.13335 .40782 m
.1371 .40782 L
s
.13335 .42349 m
.1371 .42349 L
s
.13335 .45482 m
.1371 .45482 L
s
.13335 .47048 m
.1371 .47048 L
s
.13335 .48614 m
.1371 .48614 L
s
.13335 .50181 m
.1371 .50181 L
s
.13335 .53314 m
.1371 .53314 L
s
.13335 .5488 m
.1371 .5488 L
s
.13335 .56446 m
.1371 .56446 L
s
.13335 .58013 m
.1371 .58013 L
s
.13335 .03189 m
.1371 .03189 L
s
.13335 .01623 m
.1371 .01623 L
s
.13335 .00056 m
.1371 .00056 L
s
.13335 .61146 m
.1371 .61146 L
s
.25 Mabswid
.13335 0 m
.13335 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.97619 .60332 Mdot
.90156 .57785 Mdot
.83832 .55463 Mdot
.7832 .53329 Mdot
.73294 .51388 Mdot
.6793 .49706 Mdot
.62295 .48179 Mdot
.57547 .46628 Mdot
.53832 .45179 Mdot
.50219 .43916 Mdot
.46468 .4276 Mdot
.43053 .41607 Mdot
.40123 .40518 Mdot
.37342 .39531 Mdot
.34501 .38633 Mdot
.31632 .37784 Mdot
.28942 .3694 Mdot
.2662 .36104 Mdot
.24732 .35274 Mdot
.23415 .34424 Mdot
.20652 .32978 Mdot
.17863 .31755 Mdot
.14771 .30655 Mdot
.1229 .29472 Mdot
.10338 .28421 Mdot
.08699 .274 Mdot
.07312 .2645 Mdot
.05858 .25605 Mdot
.04461 .24772 Mdot
.0346 .2392 Mdot
.02747 .2312 Mdot
.02381 .22312 Mdot
.0256 .21482 Mdot
.03055 .20696 Mdot
.03977 .19893 Mdot
.05253 .18808 Mdot
.06645 .17791 Mdot
.07807 .16866 Mdot
.09028 .15956 Mdot
.09908 .15151 Mdot
.10652 .14136 Mdot
.10797 .13271 Mdot
.11263 .12322 Mdot
.12264 .11375 Mdot
.12606 .10438 Mdot
.13114 .09456 Mdot
.14361 .08597 Mdot
.16038 .07761 Mdot
.16669 .06887 Mdot
.14274 .06081 Mdot
.12453 .0518 Mdot
.13603 .04192 Mdot
.14983 .03386 Mdot
.13327 .02569 Mdot
.13188 .01778 Mdot
.11676 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003o9P3oool2
00000?P0oooo000V0?ooo`030000003oool0oooo0?L0oooo000V0?ooo`030000003oool0oooo02d0
oooo0`0000040?ooo`<00000:`3oool3000000<0oooo0`00000/0?ooo`<000000`3oool3000002`0
oooo0`0000040?ooo`8000008P3oool00240oooo0P0000030?ooo`030000003oool0oooo02`0oooo
00D000000?ooo`3oool0oooo000000040?ooo`030000003oool0oooo02T0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00<000000?ooo`3oool0:03oool01`000000oooo0?ooo`3o
ool000000?ooo`0000000`3oool00`000000oooo0?ooo`0X0?ooo`050000003oool0oooo0?ooo`00
00000P3oool010000000oooo0?ooo`00000Q0?ooo`008@3oool200000080oooo0`00000a0?ooo`03
0000003oool0000000@00000;P3oool00`000000oooo000000030?ooo`030000003oool0oooo02`0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`0X0?ooo`050000003oool0oooo0?oo
o`0000000P3oool010000000oooo0?ooo`00000Q0?ooo`009@3oool200000380oooo00<000000?oo
o`0000000P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0000000<00000;`3oool00`00
0000oooo0?ooo`03000002/0oooo100000030?ooo`040000003oool0oooo00000240oooo000V0?oo
o`030000003oool0oooo02`0oooo100000030?ooo`030000003oool0000002/0oooo100000020?oo
o`030000003oool0oooo02`0oooo100000020?ooo`050000003oool0oooo0?ooo`000000:P3oool0
0`000000oooo0?ooo`040?ooo`040000003oool0oooo00000240oooo000U0?ooo`800000;P3oool0
0`000000oooo0?ooo`050?ooo`800000:`3oool00`000000oooo0?ooo`040?ooo`030000003oool0
oooo02/0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000002/0oooo00<0
00000?ooo`3oool00`3oool010000000oooo0?ooo`00000Q0?ooo`009@3oool2000002h0oooo1@00
00040?ooo`030000003oool0oooo02T0oooo1@0000030?ooo`800000:`3oool500000080oooo0`00
000]0?ooo`800000103oool200000280oooo000V0?ooo`8000000P3oool200000?@0oooo000V0?oo
o`040000003oool0oooo0?ooo`800000m03oool002H0oooo0P00003h0?ooo`009P3oool200000?P0
oooo003o0000020000000@3oool000/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`070?ooo`80000000<0oooo0000003oool02`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0203oool002<0oooo0P0000000`3oool000000?ooo`0c
0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0b
0?ooo`030000003oool0oooo02<0oooo000V0?ooo`030000003oool0oooo0?L0oooo000V0?ooo`04
0000003oool0000000000?H0oooo000V0?ooo`@00000mP3oool002H0oooo00<000000?ooo`3oool0
1P3oool200000>l0oooo000V0?ooo`030000003oool0oooo00H0oooo0P00003_0?ooo`009P3oool0
0`000000oooo0?ooo`040?ooo`800000l@3oool002H0oooo0P0000050?ooo`800000l@3oool002H0
oooo00<000000?ooo`3oool0m`3oool002H0oooo00@000000?ooo`0000000000mP3oool002H0oooo
00@000000?ooo`0000000000mP3oool002D0oooo0P00003i0?ooo`009@3oool300000?P0oooo000V
0?ooo`030000003oool0oooo0?L0oooo000S0?ooo`80000000<0oooo0000003oool0n03oool002<0
oooo0P0000000`3oool000000?ooo`3h0?ooo`009P3oool200000?P0oooo000R0?ooo`8000000P3o
ool00`000000oooo0?ooo`3g0?ooo`005`3oool3000000@0oooo0P0000020?ooo`8000000P3oool0
0`000000oooo0?ooo`3g0?ooo`005P3oool01@000000oooo0?ooo`3oool000000080oooo00@00000
0?ooo`00000000001@3oool00`000000oooo0?ooo`3g0?ooo`006P3oool01@000000oooo0?ooo`00
0000oooo008000001@3oool00`000000oooo0?ooo`3g0?ooo`00603oool2000000<0oooo00@00000
0?ooo`3oool000001@3oool300000?L0oooo000J0?ooo`030000003oool0oooo00@000001@3oool0
0`000000oooo0?ooo`3g0?ooo`005P3oool01@000000oooo0?ooo`3oool000000080oooo10000005
0?ooo`030000003oool0oooo0?L0oooo000G0?ooo`<00000103oool2000000H0oooo00<000000?oo
o`3oool0m`3oool001h0oooo0P0000060?ooo`800000n03oool001h0oooo0P0000060?ooo`030000
003oool0oooo0?L0oooo000V0?ooo`030000003oool0oooo0?L0oooo000L0?ooo`800000203oool0
0`000000oooo0?ooo`3g0?ooo`00703oool2000000P0oooo00<000000?ooo`3oool0m`3oool001T0
oooo0P00000;0?ooo`800000n03oool001T0oooo0P00000;0?ooo`030000003oool0oooo0?L0oooo
000F0?ooo`8000003P3oool00`000000oooo0?ooo`3g0?ooo`005P3oool2000000h0oooo00<00000
0?ooo`3oool0m`3oool002H0oooo0P00003h0?ooo`004P3oool200000180oooo00<000000?ooo`3o
ool0m`3oool00180oooo0P00000B0?ooo`030000003oool0oooo0?L0oooo000V0?ooo`030000003o
ool0oooo0?L0oooo000>0?ooo`8000005P3oool00`000000oooo0?ooo`3g0?ooo`003P3oool20000
01H0oooo0P00003h0?ooo`009P3oool00`000000oooo0?ooo`3g0?ooo`002`3oool2000000/0oooo
0`0000030?ooo`8000001P3oool00`000000oooo0?ooo`3g0?ooo`002`3oool2000000`0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
m`3oool000P0oooo0P00000<0?ooo`D000000P3oool010000000oooo0?ooo`0000050?ooo`<00000
m`3oool000P0oooo0P00000<0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`3g0?ooo`005`3oool00`000000oooo000000030?ooo`040000
003oool0oooo000000D0oooo00<000000?ooo`3oool0m`3oool000L0oooo0P00000?0?ooo`800000
0`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0?L0oooo00070?ooo`800000
403oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`000000oooo0?ooo`3g0?ooo`001P3o
ool2000001h0oooo0P00003h0?ooo`001P3oool2000001h0oooo00<000000?ooo`3oool0m`3oool0
00L0oooo0P00000M0?ooo`030000003oool0oooo0?L0oooo00070?ooo`8000007@3oool00`000000
oooo0?ooo`3g0?ooo`009P3oool200000?P0oooo00090?ooo`8000006`3oool00`000000oooo0?oo
o`3g0?ooo`002@3oool2000001/0oooo00<000000?ooo`3oool0m`3oool000`0oooo0P00000H0?oo
o`030000003oool0oooo0?L0oooo000<0?ooo`800000603oool200000?P0oooo000@0?ooo`800000
503oool00`000000oooo0?ooo`3g0?ooo`00403oool2000001@0oooo00<000000?ooo`3oool0m`3o
ool002H0oooo00<000000?ooo`3oool0m`3oool001@0oooo0P00000@0?ooo`030000003oool0oooo
0?L0oooo000D0?ooo`800000403oool200000?P0oooo000V0?ooo`030000003oool0oooo0?L0oooo
000G0?ooo`<00000103oool2000000H0oooo00<000000?ooo`3oool0m`3oool001H0oooo00<00000
0?ooo`0000000P0000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0m`3o
ool001X0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030?ooo`<00000m`3o
ool001X0oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`040?ooo`030000003oool0
oooo0?L0oooo000F0?ooo`@000000`3oool2000000030?ooo`000000oooo00@0oooo00<000000?oo
o`3oool0m`3oool001H0oooo00<000000?ooo`3oool0103oool010000000oooo0?ooo`0000050?oo
o`030000003oool0oooo0?L0oooo000F0?ooo`D000000`3oool200000080oooo0P0000020?ooo`03
0000003oool0oooo0?L0oooo000R0?ooo`8000000P3oool200000?P0oooo000V0?ooo`030000003o
ool0oooo0?L0oooo000V0?ooo`040000003oool0oooo0?ooo`800000m03oool002H0oooo00@00000
0?ooo`3oool0oooo0P00003d0?ooo`009P3oool200000?P0oooo000V0?ooo`030000003oool0oooo
00T0oooo0P00003/0?ooo`009P3oool00`000000oooo0?ooo`090?ooo`800000k03oool002H0oooo
00<000000?ooo`3oool0m`3oool002H0oooo00<000000?ooo`3oool0m`3oool002H0oooo0P00000B
0?ooo`800000i03oool002H0oooo00<000000?ooo`3oool04@3oool200000>@0oooo000V0?ooo`03
0000003oool0oooo0?L0oooo000V0?ooo`030000003oool0oooo0?L0oooo000V0?ooo`8000006P3o
ool200000=`0oooo000V0?ooo`030000003oool0oooo01T0oooo0P00003L0?ooo`005`3oool30000
00@0oooo0P0000060?ooo`030000003oool0oooo01d0oooo0P00003H0?ooo`005P3oool01@000000
oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`0M
0?ooo`800000f03oool001H0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0
oooo000000D0oooo00<000000?ooo`3oool0m`3oool001H0oooo100000030?ooo`040000003oool0
oooo000000D0oooo0`00000R0?ooo`800000d`3oool001H0oooo00<000000?ooo`3oool0103oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0oooo0280oooo0P00003C0?ooo`005`3oool0
0`000000oooo0?ooo`030?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0:@3o
ool200000<`0oooo000H0?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool0:@3oool2
00000<`0oooo000V0?ooo`800000<P3oool200000<@0oooo000V0?ooo`030000003oool0oooo0340
oooo0P0000340?ooo`009P3oool00`000000oooo0?ooo`3g0?ooo`009P3oool00`000000oooo0?oo
o`0i0?ooo`800000_03oool002H0oooo00<000000?ooo`3oool0>@3oool200000;`0oooo000V0?oo
o`800000@P3oool200000;@0oooo000V0?ooo`030000003oool0oooo0440oooo0P00002d0?ooo`00
9P3oool00`000000oooo0?ooo`3g0?ooo`009P3oool00`000000oooo0?ooo`190?ooo`800000[03o
ool002H0oooo0P00001:0?ooo`800000[03oool002H0oooo00<000000?ooo`3oool0m`3oool002H0
oooo00<000000?ooo`3oool0D@3oool200000:@0oooo000V0?ooo`030000003oool0oooo0540oooo
0P00002T0?ooo`009P3oool00`000000oooo0?ooo`3g0?ooo`009P3oool200000?P0oooo000V0?oo
o`030000003oool0oooo05/0oooo0P00002J0?ooo`00603oool00`000000oooo0?ooo`030?ooo`80
00001P3oool00`000000oooo0?ooo`1K0?ooo`800000VP3oool001P0oooo00<000000?ooo`3oool0
0P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0?L0oooo000I0?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`<00000IP3oool2000008l0
oooo000I0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo06H0oooo0P00002?0?ooo`006P3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0m`3oool001H0oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0m`3oool001H0
oooo1@0000030?ooo`8000001P3oool00`000000oooo0?ooo`1`0?ooo`800000Q@3oool002H0oooo
0P00001a0?ooo`800000Q@3oool002H0oooo00<000000?ooo`3oool0m`3oool002H0oooo00<00000
0?ooo`3oool0m`3oool002H0oooo00<000000?ooo`3oool0N`3oool2000007X0oooo000V0?ooo`80
0000O03oool2000007X0oooo000V0?ooo`030000003oool0oooo0?L0oooo000V0?ooo`030000003o
ool0oooo0?L0oooo000V0?ooo`030000003oool0oooo08T0oooo0P00001/0?ooo`009P3oool00`00
0000oooo0?ooo`290?ooo`800000K03oool002H0oooo0P00003h0?ooo`009P3oool00`000000oooo
0?ooo`3g0?ooo`009P3oool00`000000oooo0?ooo`2I0?ooo`800000G03oool002H0oooo00<00000
0?ooo`3oool0V@3oool2000005`0oooo000V0?ooo`800000n03oool002H0oooo00<000000?ooo`3o
ool0m`3oool001L0oooo0`0000040?ooo`8000001P3oool00`000000oooo0?ooo`3g0?ooo`005P3o
ool01@000000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000001@3oool00`000000
oooo0?ooo`2X0?ooo`800000C@3oool001H0oooo00D000000?ooo`3oool0oooo000000020?ooo`04
0000003oool0oooo000000D0oooo00<000000?ooo`3oool0Z03oool2000004d0oooo000G0?ooo`<0
00000`3oool010000000oooo0?ooo`0000050?ooo`<00000m`3oool001H0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0m`3oool0
01H0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`3oool0m`3oool001L0oooo0`0000040?ooo`8000001P3oool00`000000oooo0?ooo`3g
0?ooo`009P3oool200000;L0oooo0P00000o0?ooo`009P3oool00`000000oooo0?ooo`2f0?ooo`80
0000?`3oool002H0oooo00<000000?ooo`3oool0m`3oool002H0oooo00<000000?ooo`3oool0m`3o
ool002H0oooo00<000000?ooo`3oool0m`3oool002H0oooo0P00003h0?ooo`009P3oool00`000000
oooo0?ooo`360?ooo`800000;`3oool002H0oooo00<000000?ooo`3oool0aP3oool2000002l0oooo
000V0?ooo`030000003oool0oooo0?L0oooo000V0?ooo`800000n03oool002H0oooo00<000000?oo
o`3oool0m`3oool002H0oooo00<000000?ooo`3oool0m`3oool002H0oooo00<000000?ooo`3oool0
m`3oool002H0oooo00<000000?ooo`3oool0f03oool2000001d0oooo000V0?ooo`800000f@3oool2
000001d0oooo000V0?ooo`030000003oool0oooo0?L0oooo000G0?ooo`8000001@3oool2000000H0
oooo00<000000?ooo`3oool0m`3oool001T0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0m`3oool001X0oooo00@000000?ooo`3oool0
00000P3oool00`000000oooo0?ooo`030?ooo`<00000m`3oool001L0oooo100000020?ooo`040000
003oool0oooo000000D0oooo00<000000?ooo`3oool0m`3oool001H0oooo00D000000?ooo`3oool0
oooo000000020?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0kP3oool20000
00L0oooo000F0?ooo`050000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo0>h0oooo0P0000070?ooo`005`3oool3000000@0oooo0P0000060?oo
o`030000003oool0oooo0?L0oooo000V0?ooo`800000n03oool002H0oooo00<000000?ooo`3oool0
m`3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {50.548, 13.9277, 0.0376827, \
0.445989}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(?? ListPlot\)], "Input"],

Cell["\<\
ListPlot[{y1, y2, ... }] plots a list of values. The x
   coordinates for each point are taken to be 1, 2, ... .
   ListPlot[{{x1, y1}, {x2, y2}, ... }] plots a list of
   values with specified x and y coordinates.
Attributes[ListPlot] = {Protected}
 
Options[ListPlot] = {AspectRatio -> GoldenRatio^(-1), 
    Axes -> Automatic, AxesLabel -> None, 
    AxesOrigin -> Automatic, AxesStyle -> Automatic, 
    Background -> Automatic, ColorOutput -> Automatic, 
    DefaultColor -> Automatic, Epilog -> {}, Frame -> False, 
    FrameLabel -> None, FrameStyle -> Automatic, 
    FrameTicks -> Automatic, GridLines -> None, 
    ImageSize -> Automatic, PlotJoined -> False, 
    PlotLabel -> None, PlotRange -> Automatic, 
    PlotRegion -> Automatic, PlotStyle -> Automatic, 
    Prolog -> {}, RotateLabel -> True, Ticks -> Automatic, 
    DefaultFont :> $DefaultFont, DisplayFunction :> 
     $DisplayFunction, FormatType :> $FormatType, 
    TextStyle :> $TextStyle}\
\>", "Print"]
}, Open  ]],

Cell["\<\
Below are listings of temperature, pressure, and density; the 
temperatures should agree, of course.
\
\>", "Section"],

Cell[BoxData[
    \(\(foo = {{1444.721436333352, 63.8043193345393, 0.2972688769806175, 
            0.3374617644768466}, {1440.880147703284, 62.45837493942572, 
            0.3419507213225639, 0.3965500913184902}, {1437.383843785259, 
            61.41826760317194, 0.3896692160529069, 
            0.4595404507949086}, {1434.355216582765, 60.49025806277634, 
            0.4373917115964897, 0.5237334617995256}, {1431.653058977289, 
            59.62388543790548, 0.48585524391742, 
            0.5902171588754123}, {1429.266114472896, 58.803102755636, 
            0.5340132305982517, 0.657774427575688}, {1427.035754395363, 
            58.06467098059228, 0.5841948178863361, 
            0.7287372027148706}, {1424.880779802585, 57.47199719648736, 
            0.6379826941757364, 0.804040304331769}, {1422.994279810078, 
            56.95413889653007, 0.6897892118310168, 
            0.877235742049186}, {1421.347142788856, 56.43143824277497, 
            0.7390465620181949, 0.948584212752204}, {1419.706366360933, 
            55.9505168862919, 0.7922406814727554, 
            1.025600554728719}, {1418.241358295646, 55.5180923172439, 
            0.843509341828779, 1.100475992233534}, {1416.895314983313, 
            55.09964441293106, 0.894039807463147, 
            1.175258147703396}, {1415.618822672229, 54.70311030713972, 
            0.945243963809165, 1.251575643934082}, {1414.407461067161, 
            54.33762941302687, 0.997011227536201, 
            1.328998748439025}, {1413.292683925731, 53.99452863724557, 
            1.047576445747359, 1.405274550372824}, {1412.166899479127, 
            53.68300496318078, 1.101673544660491, 
            1.486419222600475}, {1411.040936925751, 53.43092444583962, 
            1.158977955321846, 1.571113996494222}, {1409.300717057065, 
            52.85746504960751, 1.254301412426308, 
            1.718781974740138}, {1407.54534080451, 52.35755813789142, 
            1.359818598544604, 1.881164626501035}, {1405.724451250756, 
            52.03797290741117, 1.479987899551377, 
            2.05998000242061}, {1404.046164694238, 51.85601627555539, 
            1.601045505679315, 2.236298313634801}, {1402.705321413202, 
            51.650613498707, 1.70547033462552, 
            2.391629467053602}, {1401.370184196289, 51.44585032148317, 
            1.816921951913518, 2.558062391030725}, {1400.063131211896, 
            51.29151764204489, 1.933740389464033, 
            2.730724138788597}, {1398.349867314113, 51.40042324271362, 
            2.09883322776743, 2.957579630676192}, {1396.905486057446, 
            51.60365377368662, 2.248746704939537, 
            3.156351036757447}, {1395.65919742844, 51.76625818892904, 
            2.386451209405156, 3.339112075078662}, {1394.536015244239, 
            51.88263169672146, 2.517639046886157, 
            3.514768122760988}, {1393.210803140882, 51.86474704180572, 
            2.681772287122279, 3.745198536151052}, {1391.700389310864, 
            51.90891539052855, 2.882371289741309, 
            4.021917697271701}, {1390.57321399151, 52.06887838182466, 
            3.041857846223304, 4.231417738822199}, {1389.367602274391, 
            52.14416985977975, 3.222013178264623, 
            4.475553624105038}, {1388.345207104084, 52.11837369348197, 
            3.383331172852024, 4.701959295955104}, {1387.291798428812, 
            52.07492578916872, 3.558412908943235, 
            4.949403850189596}, {1386.066434773414, 51.96244181769283, 
            3.774125688669762, 5.260802749469442}, {1384.905176124418, 
            51.83802749746205, 3.991528528109011, 
            5.577196939116557}, {1383.834152850609, 51.70450041828835, 
            4.204034086747164, 5.889292069141919}, {1382.648069480981, 
            51.63178924602916, 4.453573995817394, 
            6.247650226092235}, {1381.456804037619, 51.64877075185172, 
            4.71973989567377, 6.618861387115201}, {1380.327513005101, 
            51.48706458982522, 4.98738670853916, 
            7.016170297421691}, {1379.246622934759, 51.35518534410002, 
            5.25917732639738, 7.417519964591462}, {1378.108857306158, 
            51.40353898213044, 5.562165853037511, 
            7.837474216303021}, {1377.03413060506, 51.5570175876861, 
            5.864240763697816, 8.23852029979499}, {1375.94063456336, 
            51.79849705281175, 6.187698409305632, 
            8.65241197260242}, {1374.893377846731, 51.40547924105413, 
            6.514495463870654, 9.17902566486683}, {1373.843289902255, 
            51.05255866297821, 6.863265969034158, 
            9.7372994648274}, {1372.773645419049, 50.74972874286184, 
            7.240740925386524, 10.33414364199459}, {1372.122456434005, 
            50.45653310059351, 7.483847463826039, 
            10.74317699937529}};\)\)], "Input"],

Cell[BoxData[
    \(\({r[1], t[1], p[1], n[1]} = Transpose[foo];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(t[1]\)], "Input"],

Cell[OutputFormData["\<\
{63.8043193345393, 62.45837493942572, \
61.41826760317194, 
 60.49025806277634, 59.62388543790548, 58.803102755636, 
 58.06467098059228, 57.47199719648736, 56.95413889653007, 
 56.43143824277497, 55.9505168862919, 55.5180923172439, 
 55.09964441293106, 54.70311030713972, 54.33762941302687, 
 53.99452863724557, 53.68300496318078, 53.43092444583962, 
 52.85746504960751, 52.35755813789142, 52.03797290741117, 
 51.85601627555539, 51.650613498707, 51.44585032148317, 
 51.29151764204489, 51.40042324271362, 51.60365377368662, 
 51.76625818892904, 51.88263169672146, 51.86474704180572, 
 51.90891539052855, 52.06887838182466, 52.14416985977975, 
 52.11837369348197, 52.07492578916872, 51.96244181769283, 
 51.83802749746205, 51.70450041828835, 51.63178924602916, 
 51.64877075185172, 51.48706458982522, 51.35518534410002, 
 51.40353898213044, 51.5570175876861, 51.79849705281175, 
 51.40547924105413, 51.05255866297821, 50.74972874286184, 
 50.45653310059351}\
\>", "\<\
{63.8043, 62.4584, 61.4183, 60.4903, 59.6239, \
58.8031, 
 
  58.0647, 57.472, 56.9541, 56.4314, 55.9505, 55.5181, 
 
  55.0996, 54.7031, 54.3376, 53.9945, 53.683, 53.4309, 
 
  52.8575, 52.3576, 52.038, 51.856, 51.6506, 51.4459, 
 
  51.2915, 51.4004, 51.6037, 51.7663, 51.8826, 51.8647, 
 
  51.9089, 52.0689, 52.1442, 52.1184, 52.0749, 51.9624, 
 
  51.838, 51.7045, 51.6318, 51.6488, 51.4871, 51.3552, 
 
  51.4035, 51.557, 51.7985, 51.4055, 51.0526, 50.7497, 
 
  50.4565}\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(temperatureError[1]\)], "Input"],

Cell[OutputFormData["\<\
{2.120994036298424, 1.872009024940509, \
1.665629321956019, 
 1.496047707305931, 1.352743522896222, 1.232338886308142, 
 1.128316674565614, 1.038550335742351, 0.965350389440332, 
 0.903472860880768, 0.846243165471589, 0.7983181325685318, 
 0.7563202846080951, 0.7186119849754127, 0.6849410089733724, 
 0.655573089831952, 0.6277314763479094, 0.6021349395733835, 
 0.5638466093761052, 0.5286852879521655, 0.4969571329652575, 
 0.4717242131853449, 0.453702318267479, 0.4362592437263264, 
 0.4204037343476871, 0.400795368164192, 0.3875162030443589, 
 0.3773005330874177, 0.3686511062495941, 0.3593039496940196, 
 0.3472974202344251, 0.3386346502793425, 0.3313114720439773, 
 0.3254661786014383, 0.3186361541915251, 0.3109370133474438, 
 0.3033176989095924, 0.2962086197642569, 0.2873682797605899, 
 0.2786240347025008, 0.271142863772504, 0.2622281080648597, 
 0.2524266151126862, 0.2438713114357141, 0.2354805061383991, 
 0.2173738530978896, 0.1983088445208596, 0.1709093371709564, 
 0.13032203262185}\
\>", "\<\
{2.12099, 1.87201, 1.66563, 1.49605, 1.35274, \
1.23234, 
 
  1.12832, 1.03855, 0.96535, 0.903473, 0.846243, 0.798318, 
 
  0.75632, 0.718612, 0.684941, 0.655573, 0.627731, 0.602135, 
 
  0.563847, 0.528685, 0.496957, 0.471724, 0.453702, 
 
  0.436259, 0.420404, 0.400795, 0.387516, 0.377301, 
 
  0.368651, 0.359304, 0.347297, 0.338635, 0.331311, 
 
  0.325466, 0.318636, 0.310937, 0.303318, 0.296209, 
 
  0.287368, 0.278624, 0.271143, 0.262228, 0.252427, 
 
  0.243871, 0.235481, 0.217374, 0.198309, 0.170909, 0.130322}\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[foo, \ TableSpacing \[Rule] {0, 4}] // Print\)], "Input"],

Cell["\<\
1444.72    63.8043    0.297269    0.337462
1440.88    62.4584    0.341951    0.39655
1437.38    61.4183    0.389669    0.45954
1434.36    60.4903    0.437392    0.523733
1431.65    59.6239    0.485855    0.590217
1429.27    58.8031    0.534013    0.657774
1427.04    58.0647    0.584195    0.728737
1424.88    57.472     0.637983    0.80404
1422.99    56.9541    0.689789    0.877236
1421.35    56.4314    0.739047    0.948584
1419.71    55.9505    0.792241    1.0256
1418.24    55.5181    0.843509    1.10048
1416.9     55.0996    0.89404     1.17526
1415.62    54.7031    0.945244    1.25158
1414.41    54.3376    0.997011    1.329
1413.29    53.9945    1.04758     1.40527
1412.17    53.683     1.10167     1.48642
1411.04    53.4309    1.15898     1.57111
1409.3     52.8575    1.2543      1.71878
1407.55    52.3576    1.35982     1.88116
1405.72    52.038     1.47999     2.05998
1404.05    51.856     1.60105     2.2363
1402.71    51.6506    1.70547     2.39163
1401.37    51.4459    1.81692     2.55806
1400.06    51.2915    1.93374     2.73072
1398.35    51.4004    2.09883     2.95758
1396.91    51.6037    2.24875     3.15635
1395.66    51.7663    2.38645     3.33911
1394.54    51.8826    2.51764     3.51477
1393.21    51.8647    2.68177     3.7452
1391.7     51.9089    2.88237     4.02192
1390.57    52.0689    3.04186     4.23142
1389.37    52.1442    3.22201     4.47555
1388.35    52.1184    3.38333     4.70196
1387.29    52.0749    3.55841     4.9494
1386.07    51.9624    3.77413     5.2608
1384.91    51.838     3.99153     5.5772
1383.83    51.7045    4.20403     5.88929
1382.65    51.6318    4.45357     6.24765
1381.46    51.6488    4.71974     6.61886
1380.33    51.4871    4.98739     7.01617
1379.25    51.3552    5.25918     7.41752
1378.11    51.4035    5.56217     7.83747
1377.03    51.557     5.86424     8.23852
1375.94    51.7985    6.1877      8.65241
1374.89    51.4055    6.5145      9.17903
1373.84    51.0526    6.86327     9.7373
1372.77    50.7497    7.24074     10.3341
1372.12    50.4565    7.48385     10.7432\
\>", "Print"]
}, Closed]],

Cell[BoxData[
    \(\(foo = {{1442.961084867576, 61.09273050187188, 0.2646097664730354, 
            0.3137195214732649}, {1439.709280253615, 60.28763582151509, 
            0.2994393298584341, 0.3597541390487218}, {1436.74451409544, 
            59.6053846554485, 0.3358191053006436, 
            0.4080798169594485}, {1434.01973725433, 59.01067608050885, 
            0.3737330639062618, 0.4587289420325537}, {1431.541138046583, 
            58.46852831171953, 0.4124716414592584, 
            0.5109720475616204}, {1429.393192574651, 57.88986308535906, 
            0.4497750667202859, 0.5627533185460174}, {1427.443927571429, 
            57.28189897384289, 0.4870561242393222, 
            0.6158668271286813}, {1425.463586669087, 56.76965032196082, 
            0.5286545607199585, 0.6744984788156783}, {1423.614159394412, 
            56.36887290490679, 0.571178813200139, 
            0.7339355916917543}, {1422.000430157638, 55.97908347845282, 
            0.6114607816940325, 0.791166762578003}, {1420.524671832737, 
            55.57449502776505, 0.6511648414238972, 
            0.848673475187918}, {1419.052182147949, 55.2060525047666, 
            0.6937547507733888, 0.910216044278379}, {1417.66265115976, 
            54.88990585056514, 0.7368625144483046, 
            0.972342320100345}, {1416.402392889493, 54.58993932838639, 
            0.7785929813774941, 1.033054141921622}, {1415.255658556415, 
            54.28342342786378, 0.818916159053737, 
            1.092691141630598}, {1414.171463784339, 53.97388358229448, 
            0.859261423707276, 1.153099694840835}, {1413.093640011018, 
            53.68376612623208, 0.901650456464668, 
            1.216523328891762}, {1412.026455580953, 53.43317665684902, 
            0.945980290850231, 1.282319670817101}, {1410.966883865127, 
            53.22951779249211, 0.992425291694462, 
            1.350425102225482}, {1409.88101919173, 53.08750571337563, 
            1.042637726505428, 1.422546020281131}, {1408.035113391445, 
            52.78937233246259, 1.134390036973071, 
            1.556471295407575}, {1406.47339859259, 52.48847078326554, 
            1.219000051857212, 1.682151140988619}, {1405.068848083755, 
            52.15488724003874, 1.301178732391238, 
            1.807037461087626}, {1403.558338906167, 51.88727226434302, 
            1.396552326214177, 1.949492563035661}, {1402.216342468565, 
            51.67667346594602, 1.48775313940091, 
            2.08526635637203}, {1400.912492901519, 51.49986551340969, 
            1.582625856657221, 2.225857577829755}, {1399.699867759045, 
            51.35019797329639, 1.676767699815286, 
            2.365135286628633}, {1398.621206072873, 51.19334694724258, 
            1.765629493498943, 2.498108293640384}, {1397.558030814278, 
            51.04265979255711, 1.858263980466725, 
            2.636934378563978}, {1396.469802274499, 50.93467202984117, 
            1.958544443735973, 2.785127795244915}, {1395.448640723661, 
            50.857733107923, 2.05789945573942, 
            2.930841715932429}, {1394.415846743245, 50.81827905700754, 
            2.163805806014211, 3.084065112323957}, {1393.357212129469, 
            50.8375509460887, 2.278226368692894, 
            3.245917400207182}, {1392.35271946062, 50.89095305008293, 
            2.392473399504481, 3.405114689310043}, {1391.327521035379, 
            50.99051384800445, 2.51498673443278, 
            3.572494103308919}, {1389.942257787167, 51.12814987738332, 
            2.690372078271936, 3.811338131437544}, {1388.643713590838, 
            51.27828873199353, 2.865713832030266, 
            4.047850898355177}, {1387.46314840989, 51.40361430567288, 
            3.034874144499169, 4.276340122102984}, {1386.30092010161, 
            51.53538457558357, 3.211028714190478, 
            4.512984879300548}, {1385.272907482562, 51.63027434611389, 
            3.375240899132299, 4.73506072114758}, {1383.976624629865, 
            51.71061979558097, 3.594270492660569, 
            5.034498604654155}, {1382.872786871632, 51.72623950471717, 
            3.792118257168088, 5.310020239840991}, {1381.660543259035, 
            51.77648481764682, 4.022260833376682, 
            5.626818132891974}, {1380.451368488729, 51.884490663497, 
            4.265798759709673, 5.955085707514099}, {1379.255023237896, 
            51.9213702456929, 4.521266191042607, 
            6.307236882082861}, {1378.002167159008, 51.97618446062988, 
            4.805536100137292, 6.696727998675983}, {1376.90474307731, 
            52.11069547369595, 5.069240593899938, 
            7.045977388421883}, {1375.837448761894, 52.29167388111334, 
            5.339178295533987, 7.395492318337807}, {1374.721572155207, 
            52.35969348782536, 5.6363851582259, 
            7.79702232243043}, {1373.692245304115, 52.10128125123191, 
            5.926012972386329, 8.23833418383441}, {1372.541669931825, 
            51.90485239906798, 6.269846248123736, 
            8.74931678209281}, {1371.281105551221, 52.02891720085196, 
            6.670722809176447, 9.28652682223187}, {1370.251317971705, 
            52.17775744861297, 7.016651142346459, 
            9.74024061481078}, {1369.208366248881, 51.99919133539812, 
            7.385595199931596, 10.28760121956538}, {1368.198541445979, 
            51.98411520728594, 7.763112952862095, 
            10.81659226543324}, {1367.806902678472, 51.82102299884245, 
            7.916229978850253, 11.06464873187697}};\)\)], "Input"],

Cell[BoxData[
    \(\({r[2], t[2], p[2], n[2]} = Transpose[foo];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[foo, \ TableSpacing \[Rule] {0, 4}] // Print\)], "Input"],

Cell["\<\
1442.96    61.0927    0.26461     0.31372
1439.71    60.2876    0.299439    0.359754
1436.74    59.6054    0.335819    0.40808
1434.02    59.0107    0.373733    0.458729
1431.54    58.4685    0.412472    0.510972
1429.39    57.8899    0.449775    0.562753
1427.44    57.2819    0.487056    0.615867
1425.46    56.7697    0.528655    0.674498
1423.61    56.3689    0.571179    0.733936
1422.      55.9791    0.611461    0.791167
1420.52    55.5745    0.651165    0.848673
1419.05    55.2061    0.693755    0.910216
1417.66    54.8899    0.736863    0.972342
1416.4     54.5899    0.778593    1.03305
1415.26    54.2834    0.818916    1.09269
1414.17    53.9739    0.859261    1.1531
1413.09    53.6838    0.90165     1.21652
1412.03    53.4332    0.94598     1.28232
1410.97    53.2295    0.992425    1.35043
1409.88    53.0875    1.04264     1.42255
1408.04    52.7894    1.13439     1.55647
1406.47    52.4885    1.219       1.68215
1405.07    52.1549    1.30118     1.80704
1403.56    51.8873    1.39655     1.94949
1402.22    51.6767    1.48775     2.08527
1400.91    51.4999    1.58263     2.22586
1399.7     51.3502    1.67677     2.36514
1398.62    51.1933    1.76563     2.49811
1397.56    51.0427    1.85826     2.63693
1396.47    50.9347    1.95854     2.78513
1395.45    50.8577    2.0579      2.93084
1394.42    50.8183    2.16381     3.08407
1393.36    50.8376    2.27823     3.24592
1392.35    50.891     2.39247     3.40511
1391.33    50.9905    2.51499     3.57249
1389.94    51.1281    2.69037     3.81134
1388.64    51.2783    2.86571     4.04785
1387.46    51.4036    3.03487     4.27634
1386.3     51.5354    3.21103     4.51298
1385.27    51.6303    3.37524     4.73506
1383.98    51.7106    3.59427     5.0345
1382.87    51.7262    3.79212     5.31002
1381.66    51.7765    4.02226     5.62682
1380.45    51.8845    4.2658      5.95509
1379.26    51.9214    4.52127     6.30724
1378.      51.9762    4.80554     6.69673
1376.9     52.1107    5.06924     7.04598
1375.84    52.2917    5.33918     7.39549
1374.72    52.3597    5.63639     7.79702
1373.69    52.1013    5.92601     8.23833
1372.54    51.9049    6.26985     8.74932
1371.28    52.0289    6.67072     9.28653
1370.25    52.1778    7.01665     9.74024
1369.21    51.9992    7.3856      10.2876
1368.2     51.9841    7.76311     10.8166
1367.81    51.821     7.91623     11.0646\
\>", "Print"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(i = 2;\)\), "\[IndentingNewLine]", 
    \(TableForm[\ 
        Transpose[{r[i], \ t[i], \ temperatureError[i], \ p[i], \ n[i]}], \ 
        TableSpacing \[Rule] {0, 4}] // Print\)}], "Input"],

Cell["\<\
1442.96    61.0927    1.9667      0.26461     0.31372
1439.71    60.2876    1.7837      0.299439    0.359754
1436.74    59.6054    1.62259     0.335819    0.40808
1434.02    59.0107    1.48157     0.373733    0.458729
1431.54    58.4685    1.35902     0.412472    0.510972
1429.39    57.8899    1.25319     0.449775    0.562753
1427.44    57.2819    1.15855     0.487056    0.615867
1425.46    56.7697    1.07137     0.528655    0.674498
1423.61    56.3689    0.997008    0.571179    0.733936
1422.      55.9791    0.934029    0.611461    0.791167
1420.52    55.5745    0.877629    0.651165    0.848673
1419.05    55.2061    0.824986    0.693755    0.910216
1417.66    54.8899    0.778496    0.736863    0.972342
1416.4     54.5899    0.737858    0.778593    1.03305
1415.26    54.2834    0.701585    0.818916    1.09269
1414.17    53.9739    0.66818     0.859261    1.1531
1413.09    53.6838    0.636655    0.90165     1.21652
1412.03    53.4332    0.607457    0.94598     1.28232
1410.97    53.2295    0.580527    0.992425    1.35043
1409.88    53.0875    0.555299    1.04264     1.42255
1408.04    52.7894    0.513798    1.13439     1.55647
1406.47    52.4885    0.480215    1.219       1.68215
1405.07    52.1549    0.450785    1.30118     1.80704
1403.56    51.8873    0.422157    1.39655     1.94949
1402.22    51.6767    0.398677    1.48775     2.08527
1400.91    51.4999    0.377421    1.58263     2.22586
1399.7     51.3502    0.358894    1.67677     2.36514
1398.62    51.1933    0.343015    1.76563     2.49811
1397.56    51.0427    0.328066    1.85826     2.63693
1396.47    50.9347    0.313868    1.95854     2.78513
1395.45    50.8577    0.301435    2.0579      2.93084
1394.42    50.8183    0.289706    2.16381     3.08407
1393.36    50.8376    0.278682    2.27823     3.24592
1392.35    50.891     0.26901     2.39247     3.40511
1391.33    50.9905    0.259851    2.51499     3.57249
1389.94    51.1281    0.248202    2.69037     3.81134
1388.64    51.2783    0.238043    2.86571     4.04785
1387.46    51.4036    0.229253    3.03487     4.27634
1386.3     51.5354    0.220983    3.21103     4.51298
1385.27    51.6303    0.213969    3.37524     4.73506
1383.98    51.7106    0.205245    3.59427     5.0345
1382.87    51.7262    0.198049    3.79212     5.31002
1381.66    51.7765    0.190329    4.02226     5.62682
1380.45    51.8845    0.183196    4.2658      5.95509
1379.26    51.9214    0.176411    4.52127     6.30724
1378.      51.9762    0.169397    4.80554     6.69673
1376.9     52.1107    0.163676    5.06924     7.04598
1375.84    52.2917    0.158517    5.33918     7.39549
1374.72    52.3597    0.153199    5.63639     7.79702
1373.69    52.1013    0.147419    5.92601     8.23833
1372.54    51.9049    0.14048     6.26985     8.74932
1371.28    52.0289    0.133975    6.67072     9.28653
1370.25    52.1778    0.129174    7.01665     9.74024
1369.21    51.9992    0.122155    7.3856      10.2876
1368.2     51.9841    0.115754    7.76311     10.8166
1367.81    51.821     0.110238    7.91623     11.0646\
\>", "Print"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(i = 2;\)\), "\[IndentingNewLine]", 
    \(TableForm[\ 
        Reverse@Transpose[{\[IndentingNewLine]altitudesToPlotForFitResults[
                  i] + 1350. , temperaturesFromFitResults[i], 
              temperatureErrorsFromFitResults[i]}], \ 
        TableSpacing \[Rule] {0, 4}] // Print\)}], "Input"],

Cell["\<\
1549.    90.0029    9.16454
1545.    88.7803    8.79349
1541.    87.5713    8.42995
1537.    86.3756    8.07381
1533.    85.1933    7.72498
1529.    84.024     7.38336
1525.    82.8679    7.04885
1521.    81.7246    6.72136
1517.    80.5942    6.4008
1513.    79.4766    6.08708
1509.    78.3715    5.78011
1505.    77.2789    5.47979
1501.    76.1987    5.18606
1497.    75.1308    4.89882
1493.    74.0751    4.61799
1489.    73.0314    4.3435
1485.    71.9997    4.07528
1481.    70.9798    3.81324
1477.    69.9717    3.55734
1473.    68.9753    3.30752
1469.    67.9903    3.06372
1465.    67.0169    2.8259
1461.    66.0547    2.59406
1457.    65.1038    2.36818
1453.    64.164     2.1483
1449.    63.2353    1.93448
1445.    62.3175    1.72687\
\>", "Print"]
}, Closed]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 1280}, {0, 1004}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 740},
WindowMargins->{{17, Automatic}, {Automatic, 41}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 111, 2, 50, "Section"],
Cell[1853, 55, 9321, 164, 2714, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11211, 224, 50, 1, 26, "Input"],
Cell[11264, 227, 112, 5, 64, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11413, 237, 44, 1, 26, "Input"],
Cell[11460, 240, 385, 11, 148, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11882, 256, 153, 3, 56, "Input"],
Cell[12038, 261, 18282, 459, 186, 4125, 280, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False]
}, Closed]],

Cell[CellGroupData[{
Cell[30357, 725, 153, 3, 53, "Input"],
Cell[30513, 730, 16471, 418, 186, 3772, 257, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False]
}, Closed]],

Cell[CellGroupData[{
Cell[47021, 1153, 111, 2, 23, "Input"],
Cell[47135, 1157, 17055, 485, 186, 4845, 330, "GraphicsData", "PostScript", \
"Graphics",
  ImageCacheValid->False]
}, Closed]],

Cell[CellGroupData[{
Cell[64227, 1647, 111, 2, 23, "Input"],
Cell[64341, 1651, 16363, 466, 186, 4611, 316, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[80741, 2122, 44, 1, 26, "Input"],
Cell[80788, 2125, 990, 21, 288, "Print"]
}, Open  ]],
Cell[81793, 2149, 128, 4, 104, "Section"],
Cell[81924, 2155, 4806, 74, 1466, "Input"],
Cell[86733, 2231, 79, 1, 26, "Input"],

Cell[CellGroupData[{
Cell[86837, 2236, 37, 1, 26, "Input"],
Cell[86877, 2239, 1488, 38, 155, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88402, 2282, 52, 1, 26, "Input"],
Cell[88457, 2285, 1573, 38, 155, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[90067, 2328, 87, 1, 26, "Input"],
Cell[90157, 2331, 2080, 50, 694, "Print"]
}, Closed]],
Cell[92252, 2384, 5484, 84, 1688, "Input"],
Cell[97739, 2470, 79, 1, 26, "Input"],

Cell[CellGroupData[{
Cell[97843, 2475, 87, 1, 26, "Input"],
Cell[97933, 2478, 2385, 57, 792, "Print"]
}, Closed]],

Cell[CellGroupData[{
Cell[100355, 2540, 214, 4, 68, "Input"],
Cell[100572, 2546, 3057, 57, 792, "Print"]
}, Closed]],

Cell[CellGroupData[{
Cell[103666, 2608, 331, 6, 98, "Input"],
Cell[104000, 2616, 776, 28, 386, "Print"]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

