; Make T, P, r for Pluto based on Stansberry model
; Leslie Young, SwRI, July 13 2000

;----------
; Constants
;----------
grav = 6.67259e-8 ; Gravitational Constant, dyn cm^2 g^-2 
k = 1.380658e-16  ; Boltzmann constant, erg/K
mamu = 1.66054e-24 ; mass of an AMU, g
km=1e5
mpluto = 1.24e25  ; g

;--------------
; Bates portion
;--------------
; Read in flux.bates.stans1, just as a nice way to get good r's
fn=":Source:flux.bates.stans1"
rdfloat, fn, indx,time,rho,flux,r,theta,dtheta,nu,p,h,hn,dhn,t,dt,ddt, skip=1
delvar, indx,time,rho,flux,theta,dtheta,nu,p,h,hn,dhn,t,dt,ddt
r = r + 9.5 ; adjust the r's to end at 1206
r3=1206.2
z=r3^2*(1/r3-1/r)
t=106.*(1-0.5*exp(-0.565*z))
; integrate the Bates part upward
p=0*r
p(224)= 2.8 ; 2.8 microbar at r=1206, T=50 K
for i=223,0,-1 do begin &$
  g = grav * mpluto/( ( 0.5*(r(i)+r(i+1))*km)^2 ) &$
  h = k * 0.5*(t(i)+t(i+1)) / (28. * mamu * g) &$
  p(i) = p(i+1) * exp( -(r(i)-r(i+1))*km/h) &$
end


;--------------------
; Dry adiabat portion
;--------------------
; From p=2.8 microbar, r=1206 km, T=50 K to surface at T=40 K
; Eqn 5.14 of Young 1994

ttop = 35.0444  ; vapor-pressure temperature at 2.8 microbar
tbot = 40.      ; Tryka et al
ptop=2.8
rtop=1206.
t2 = findgen(31) * (tbot-ttop)/30. + ttop
r2=rtop/(1+0.370541*alog(t2/ttop))
p2=0*r2
p2(0)= 2.8 ; 2.8 microbar at r=1206
for i=0,29 do begin &$
  g = grav * mpluto/( ( 0.5*(r2(i)+r2(i+1))*km)^2 ) &$
  h = k * 0.5*(t2(i)+t2(i+1)) / (28. * mamu * g) &$
  p2(i+1) = p2(i) * exp( (r2(i)-r2(i+1))*km/h) &$
end
p3=fltarr(31)
for i=0,30 do p3(i)=n2vp(t2(i))


;restore,'justright_pluto.dat'

;-------
; splice
; ------

r[224] = 0.5*(r[224]+r[223])
t[224] = 0.5*(t[224]+t[223])
p[224] = sqrt(p[224]*p[223])
rpluto=[r,r2]
ppluto=[p,p2]
tpluto=[t,t2]
npluto=ppluto/(k*tpluto)

;-------
; save!
; ------

save, rpluto,tpluto,ppluto,npluto,filen='nominal_pluto.sav'


; Pluto upper limits !
physconstants

;  Some preliminary system stuff
cd , current=pwd
if strmid(pwd,0,6) eq 'Oseola' then pref='Oseola' else pref='Projects'

; constants and units
km=1e5
mpluto = 1.24e25  ; g
mtriton= 2.147e25 ; g
nz=50
dz=20.*km
r0p=1150.*km
r0t=1350.*km

fn=pref+':References:HITRAN_CDROM:HITRAN96:BY_MOLEC:05_HIT96.PAR'
lna = rd_band(fn, 5, 1, 3, 1)
lnb = lna(65:67)
lnc = lnb
bouanich83, lnc  ; change widths
wtarg=0.040

piso=58.
tiso=100.
isoatm, nz, dz*tiso/100., r0p, mpluto, 28., piso, tiso, riso,  piso, tiso, niso 
coln2_iso = calc_coltot(riso,niso) 
nco_iso = col_of_eqwp(riso, piso, tiso, niso, wtarg, lnc, f_iso) 
print, f_iso
;      0.18586539

piso=58.
tiso=40.
isoatm, nz, dz*tiso/100., r0p, mpluto, 28., piso, tiso, riso,  piso, tiso, niso 
coln2_iso = calc_coltot(riso,niso) 
nco_iso = col_of_eqwp(riso, piso, tiso, niso, wtarg, lnc, f_iso) 
print, f_iso
;     0.071915108

coln2_nom = calc_coltot(rpluto*km,npluto) 
nco_nom = col_of_eqwp(rpluto*km, ppluto, tpluto, npluto, wtarg, lnc, f_nom) 
print, coln2_nom, nco_nom, f_nom
;  2.05716e+22   1.4182273e+21     0.068940906
