; jun04.cmd
; numbers for table or figure showing N_co as fnc of P0, t0
; Leslie Young SwRI June 04 2000

physconstants

;  Some preliminary system stuff
cd , current=pwd
if strmid(pwd,0,6) eq 'Oseola' then pref='Oseola' else pref='Projects'

; constants and units
km=1e5
mpluto = 1.24e25  ; g
mtriton= 2.147e25 ; g
nz=50
dz=20.*km
r0p=1150.*km
r0t=1350.*km

fn=pref+':References:HITRAN_CDROM:HITRAN96:BY_MOLEC:05_HIT96.PAR'
lna = rd_band(fn, 5, 1, 3, 1)
lnb = lna(65:67)
lnc = lnb
bouanich83, lnc  ; change widths

;====================================================
; PLUTO
;====================================================
;----------------------------------------------------
; Pressure dependence of nco
np=7
p0a = [2,5,10.,20.,50.,100.,200.]
nt=8
t0a = findgen(nt)*10+40.
coln2a = fltarr(np,nt)
ncoa = fltarr(np,nt)
fa = fltarr(np,nt)
wtarg=0.040
for ip=0,np-1 do begin &$
 for it=0,nt-1 do begin &$
  isoatm, nz, dz*t0a(it)/100., r0p, mpluto, 28., p0a(ip), t0a(it), r,  p, t, n &$
  coln2a(ip,it) = calc_coltot(r,n) &$
  ncoa(ip,it) = col_of_eqwp(r, p, t, n, wtarg, lnc, f) &$
  fa(ip,it) = f &$
 end &$
end

save, filen='jun03.sav'

; find the analytical expression for the upper limit
; f = a (t)^g, or lnf - g ln(t) = lna

aa=fltarr(np) & ga=fltarr(np)
for ip=0,np-1 do begin &$
  x = alog(t0a) &$
  y = reform(alog(fa(ip,*))) &$
  res=linfit(x,y) &$
  aa(ip)=exp(res(0)) & ga(ip)=res(1) &$
end
g = mean(ga)
; Now, fit the exponent at g
for ip=0,np-1 do begin &$
  x = g * alog(t0a) &$
  y = reform(alog(fa(ip,*))) &$
  res= mean(y-x) &$
  aa(ip)=exp(res) &$
end

; now, ga = a p^-2
; ln ga + 2 ln p= ln a
x = -2*alog(p0a)
y = alog(aa)
res=mean(y-x)
a=exp(res)
;print, a, g
;      4.75665      1.05497

fa_model = fltarr(np,nt)
for ip=0,np-1 do begin &$
 for it=0,nt-1 do begin &$
   fa_model(ip,it)=a * p0a(ip)^(-2) * t0a(it)^g&$
 end &$
end

;====================================================
; TRITON
;====================================================

;23.6ubar, w/o trop, from Jason's workshop presentation

adop=[ 0.00245234,  0.00245439,  0.00245640]
aL  =[3.04433e-06, 2.97302e-06, 2.91507e-06]
S   =[9.39434e-21, 9.03895e-21, 7.30294e-21]

changept_specline_array, lnc, 23.6/2., 50.
print, adop, lnc.dopw
;   0.00245234   0.00245439   0.00245640
;   0.00245508   0.00245713   0.00245913
print, aL, lnc.gamma_air
;  3.04433e-06  2.97302e-06  2.91507e-06
;  3.25551e-06  3.14469e-06  3.06355e-06
print, s, lnc.s
;  9.39434e-21  9.03895e-21  7.30294e-21
;  9.39446e-21  9.03917e-21  7.30323e-21


print, widthv(lnc(1).dopw, lnc(1).gamma_air, lnc(1).s, 1.48e21, dop, voig, lor) 
ln=lnc(1)
nu_wgt_leg, ln, nu, nuwgt
xsec = xsec_specline(ln, nu)
tauup = 2 * 1.48e21*xsec
print, eqw_ppavg(tauup, nuwgt)

isoatm, nz,10.*km, r0t, mtriton, 28., 23.6, 50., r,  p, t, n &$
extcoef = excoef_specline(ln, nu, p, t, n)
tauup=2*tau_los(r, extcoef, 1.)
coln2 = calc_coltot(r,n)
fco=1.48e21/coln2
print, eqw_ppavg(tauup*fco, nuwgt)
mu_wgt_triton_leg, mu, muwgt, 5
taua = 2*tau_los_array(r, extcoef(*,*), mu)
print, eqw_avg(taua(*,*)*fco, nuwgt, muwgt)


print, col_of_eqwt(r, p, t, n, wtarg, lnc, f)

; now, a moment of truth
extcoef = excoef_specline(ln, nu, p, t, n)
colco = 10^(0.25*findgen(24)+16.) ; array of column densities, cm^-2
fco = colco/coln2
tauup=2*tau_los(r, extcoef, 1.)
w=fltarr(24)
for i=0,23 do w(i) = eqw_ppavg(tauup*fco(i), nuwgt)
plot, fco, w, xr=[0,.21], yr=[0,.040], /xs, /ys



;----------------------------------------------------
; Pressure dependence of nco
np=7
p0a = [2,5,10.,20.,50.,100.,200.]
nt=8
t0a = findgen(nt)*10+40.
coln2at = fltarr(np,nt)
ncoat = fltarr(np,nt)
fat = fltarr(np,nt)
wtarg=0.028
for ip=0,np-1 do begin &$
 for it=0,nt-1 do begin &$
  isoatm, nz, dz*t0a(it)/100., r0t, mtriton, 28., p0a(ip), t0a(it), r,  p, t, n &$
  coln2at(ip,it) = calc_coltot(r,n) &$
  ncoat(ip,it) = col_of_eqwt(r, p, t, n, wtarg, lnc, f) &$
  fat(ip,it) = f &$
 end &$
end

save, filen='jun03t.sav'

; --------- what IS the functional form of the upper limit, f(T)?

ip=2


; find the analytical expression for the upper limit
; f = a (t)^g, or lnf - g ln(t) = lna

aa=fltarr(np) & ga=fltarr(np)
for ip=0,np-1 do begin &$
  x = alog(t0a) &$
  y = reform(alog(fat(ip,*))) &$
  res=linfit(x,y) &$
  aa(ip)=exp(res(0)) & ga(ip)=res(1) &$
end
g = mean(ga)
; Now, fit the exponent at g
for ip=0,np-1 do begin &$
  x = g * alog(t0a) &$
  y = reform(alog(fat(ip,*))) &$
  res= mean(y-x) &$
  aa(ip)=exp(res) &$
end

; now, ga = a p^-2
; ln ga + 2 ln p= ln a
x = -2*alog(p0a)
y = alog(aa)
res=mean(y-x)
a=exp(res)
print, a, g
;   0.00679516      1.48799

fat_model = fltarr(np,nt)
for ip=0,np-1 do begin &$
 for it=0,nt-1 do begin &$
   fat_model(ip,it)=a * p0a(ip)^(-2) * t0a(it)^g&$
 end &$
end

