function n2vp, t

; Return N2 vapor pressure, in microbar, as a function of temperature
a_liq  =[1.51050147e1, -6.15496072e2, -2.31314834e3, -5.89850934e4, 0.]
a_beta= [1.64302619e1, -6.50497257e2, -8.52432256e3,  1.55914234e5, -1.06368300e6]
a_alpha=[1.88550118e1, -8.57102332e2, -1.01891053e3,  1.28466570e4, -4.82177497e4]
a=a_beta
if t lt 35.62 then a=a_alpha
if t gt 63.152 then a=a_gamma
p = exp( total((t^(-findgen(5))) * a))* 1.33322e3
return, p
end
