pro atm2line, root

  fnatm = root+'.atm'
  fnline = root+'.line'

; read the atmospheric file
  rdatm, fnatm, rarr, parr, tarr, narr, nabsarr
  nr = n_elements(rarr)

; Read the co lines
  speclines = rdcolines()
  nl = n_elements(speclines)
  
; make room for the strengths
  smat = fltarr(nr, nl)
  admat = fltarr(nr, nl)
  almat = fltarr(nr, nl)

; loop through the atmospheric levels
  for ir = 0, nr-1 do begin 
    t = tarr[ir]
    p = parr[ir]
    changept_specline_array, speclines, p, t
    smat[ir,*] = speclines.s
    admat[ir,*] = speclines.dopw
    almat[ir,*] = speclines.gamma_air
  end

  wrline, rarr,parr,tarr,narr,nabsarr, smat, admat, almat, fnline

end