; isoatm - generate an isothermal atmosphere (t, p, n), given
;          isothermal temperature, surface pressure, etc
; Inputs
;    nz  number of altitudes
;    dz  spacing between altitudes (cm)
;    r0  surface radius (cm)
;    p0  surface pressure (microbar)
;    m   mass of object (gm)
;    t0  surface temperature
; Outputs
;    r   radii (cm)
;    p   pressures (cm)
;    t   temperatures (K)
;    n   number density (cm^-3)

pro isoatm, nz, dz, r0, m, mu, p0, t0, r,  p, t, n

grav = 6.67259e-8 ; Gravitational Constant, dyn cm^2 g^-2 
k = 1.380658e-16  ; Boltzmann constant, erg/K
mamu = 1.66054e-24 ; mass of an AMU, g

  r = r0 + dz*findgen(nz)
  t = t0 + 0*r

  H0 = k*t0*r0^2/(mu*mamu*grav*m)
  lam0 = r0/h0
  p = p0 * exp(lam0 * ((r0/r)-1)) ; pressure
  n = p / (k*t) ; number density

end 