; Make three isothermal atmospheres
;
; Leslie Young SwRI Nov 2000

@constants
  fco = 0.1

  nz = 150*5
  dz = 1*1e5
  r0 = 1071 * 1e5
  m = mpluto
  mu = 28.01
  p0 = 58.
  T0 = 102.
  fn = 'DATA/p1.atm'
  isoatm, nz, dz, r0, m, mu, p0, t0, r,  p, t, n
  wratm, r,p,t,n,n*fco, fn



  ; read in Stansberry model
  restore, '_pluto/nominal_pluto.sav'
  tpluto = tpluto * (102./106)
  rpluto = rpluto+5
  r=reverse(rpluto[0:224])
  p=reverse(ppluto[0:224])
  t = reverse(tpluto[0:224])
  n= p/(!phys.k * t)
  fn = 'DATA/p2.atm'
  wratm, r*1e5,p,t,n,n*fco, fn

  r=reverse(rpluto)
  p=reverse(ppluto)
  t = reverse(tpluto)
  n= p/(!phys.k * t)
  fn = 'DATA/p3.atm'
  wratm, r*1e5,p,t,n,n*fco, fn


