@constants
  fco = 0.1

  ; read in Yelle model
  readcol, '_from.roger/yelle.dat', r, t, p, skip=1, /SILENT
  r = r + 1352e5
  n= p/(!phys.k * t)
  fn = 'DATA/t1.atm'
  wratm, r,p,t,n,n*fco, fn
  delvar, r,p,t,n, fn



; read in Elliot model (emersion, fit)
  readcol, '_from.jim/e00-emfit.txt', rfit, tfit, /skip
  nr = n_elements(rfit)
  logr = alog(rfit/1500.)
  logt = alog(tfit)
  res = poly_fit(logr, logt, 1, yfit)
  b = res[1] ; exponent for temperature

; read in Elliot model (emersion, inversion)
  readcol, '_from.jim/e00-eminv.txt', r, t, terr, p, n, /skip

; splice on fit portion, making sure it's smooth
  tfit2 = t[0] * (rfit/r[0])^b
  lam0 = !phys.g * mtriton * 28.01 * !phys.m_u / (!phys.k * t[0] * r[0]*1e5)
  lam = lam0 * (rfit/r[0])^(-(1+b))
  pfit = p[0] * exp( (lam-lam0) / (1+b))

; splice on the lower portion
  rlow = 1352 + reverse(findgen(16))
  r0 = r[55]
  t0 = t[55]
  p0 = p[55]
  lam0 = !phys.g * mtriton * 28.01 * !phys.m_u / (!phys.k * t0 * r0*1e5)
  h0 = r0/lam0
  plow = p[55] * exp( -(rlow-r0) / h0)
  tlow = t0 * (rlow/r0)^(-2)

  rarr = reverse([rfit,r, rlow])
  parr = reverse([pfit,p, plow])
  tarr = reverse([tfit2,t, tlow])
  narr= parr/(!phys.k * tarr)
  fn = 'DATA/t2.atm'
  wratm, rarr*1e5,parr,tarr,narr,narr*fco, fn

