(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e0,  12, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e0,  12, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e0,  12, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M18, N4, bold, e0,  12, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M18, N4, bold, e0,  12, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, N4, bold, e0,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, whiteDot, M42, N23, L-5, e0,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5, e0,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  10, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  10, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; preserveAspect; startGroup]
Obs. Plan
A notebook to accompany the observing plan.
:[font = section; inactive; preserveAspect; startGroup]
Load our packages
:[font = input; preserveAspect; startGroup]
<<jle-grp.startup.m
<<jle-grp.master.m
:[font = print; inactive; preserveAspect]
cubicInterpolationLINKfile = cubicInterpolationLINK1.3
ellipticalLorentzStarLINKfile = lorentzLINK
ellipticalLorentzStarMeshLINKfile = lorentzLINK
ellipticalGaussianStarLINKfile = gaussianLINK
ellipticalGaussianStarMeshLINKfile = gaussianLINK
grabBagPackage = grabBag1.5.3.m
fitsAidePackage = fitsAide4.9.18.m
leastSquaresPackage = leastSquares3.2.2.m
tableProcessingPackage  = tableProcessing1.21.m
starPackage = star2.1.0.m
timeAndCoordsPackage = timeAndCoords3.2.0.m
imageProcessingPackage = imageProcessing2.3.6.m
occultationLightCurvePackage = occLightCurves1.4.1.m
remoteObservingPackage = remoteObserving1.2.m
colorTablesPackage = colorTables1.1.m
shadowMapPackage = shadowMap2.0.m
plateReductionPackage = plateReduction1.3.m
:[font = message; inactive; preserveAspect]
Get::noopen: Can't open asbCurrentMathLinkVersions.m.
:[font = message; inactive; preserveAspect]
Get::noopen: Can't open asbCurrentPackageVersions.m.
:[font = output; output; inactive; preserveAspect]
$Failed
;[o]
$Failed
:[font = message; inactive; preserveAspect; endGroup]
DeclarePackage::aldec: 
   Symbol lightCurve10 in DeclarePackage[occLightCurves`, <<1>>]
     has already been declared.
:[font = input; preserveAspect; endGroup]
Get[ timeAndCoordsPackage ];
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Phase, separation, position angle
:[font = input; preserveAspect]
distL = {29.756827916, 29.740223253, 29.723637346, 29.707075434,
        29.690542841, 29.674044951, 29.657587187, 29.641174969,
        29.624813694, 29.608508703, 29.592265269, 29.576088583,
        29.559983753, 29.543955803, 29.528009675, 29.512150234};
:[font = input; preserveAspect]
JDL = 2449770.5 + Range[0,15] + (14+40/60)/24//N;
:[font = input; preserveAspect]
u0 = 259.76;
JD0 = 2446600.5;
period = 6.387246;
:[font = input; preserveAspect; startGroup]
(JDL - (distL/173) - JD0)/period
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{496.3702832684805843, 496.526860294120581, 496.6834373027867027, 
  496.8400142897378193, 496.9965912501556956, 497.1531681791679871, 
  497.3097450718669294, 497.4663219233475702, 497.6228987287256397, 
  497.7794754831676667, 497.9360521819016933, 498.092628820229948, 
  498.2492053935297358, 498.4057818972544703, 498.5623583269317159, 
  498.718934678158738}
;[o]
{496.37, 496.527, 496.683, 496.84, 496.997, 497.153, 497.31, 
  497.466, 497.623, 497.779, 497.936, 498.093, 498.249, 498.406, 
  498.562, 498.719}
:[font = input; preserveAspect; startGroup]
??Mod
:[font = print; inactive; preserveAspect; endGroup]
Mod[m, n] gives the remainder on division of m by n. The result has
   the same sign as n.

Attributes[Mod] = {Listable, Protected}
:[font = input; preserveAspect; startGroup]
Mod[(JDL - (distL/173) - JD0),period]/period
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{0.370283268480584331, 0.5268602941205810705, 0.6834373027867026963, 
  0.8400142897378193123, 0.9965912501556955875, 
  0.1531681791679870822, 0.3097450718669293646, 
  0.4663219233475701566, 0.622898728725639694, 0.779475483167666669, 
  0.9360521819016932507, 0.0926288202299480042, 
  0.2492053935297358295, 0.4057818972544703249, 
  0.5623583269317158804, 0.7189346781587379206}
;[o]
{0.370283, 0.52686, 0.683437, 0.840014, 0.996591, 0.153168, 
  0.309745, 0.466322, 0.622899, 0.779475, 0.936052, 0.0926288, 
  0.249205, 0.405782, 0.562358, 0.718935}
:[font = input; preserveAspect; startGroup]
uL = Mod[360 * (JDL - (distL/173) - JD0)/period + u0, 360];
Print[NumberForm[#,{6,3}]]& /@ uL;
:[font = print; inactive; preserveAspect; endGroup]
33.062
89.43
145.797
202.165
258.533
314.901
11.268
67.636
124.004
180.371
236.739
293.106
349.474
45.841
102.209
158.576
:[font = input; preserveAspect; startGroup]
??NumberForm
:[font = print; inactive; preserveAspect; endGroup]
NumberForm[expr, n] prints with approximate real numbers in expr
   given to n-digit precision.

Attributes[NumberForm] = {Protected}
 
Options[NumberForm] = 
  {DigitBlock -> DirectedInfinity[1], NumberPoint -> ".", 
   SignPadding -> False, NumberSigns -> {"-", ""}, 
   ExponentStep -> 1, NumberFormat -> Automatic, 
   NumberPadding -> {"", ""}, NumberSeparator -> ",", 
   ExponentFunction -> Automatic}
:[font = input; preserveAspect; startGroup]
phaseL = Mod[(uL-u0)/360 + 0.46111,1];
Print[NumberForm[phaseL,{7,5}, NumberPadding->{"","0"}] ];
:[font = print; inactive; preserveAspect; endGroup]
{0.83139, 0.98797, 0.14455, 0.30112, 0.45770, 0.61428, 0.77086, 
  0.92743, 0.08401, 0.24059, 0.39716, 0.55374, 0.71032, 0.86689, 
  0.02347, 0.18004}
:[font = input; preserveAspect]
{raL,decL} = Transpose[{
{(16+05/60+15.435063/3600)*15, -(06+56/60+37.42596/3600)},
{(16+05/60+16.952256/3600)*15, -(06+56/60+17.76108/3600)},
{(16+05/60+18.332659/3600)*15, -(06+55/60+57.69344/3600)},
{(16+05/60+19.575997/3600)*15, -(06+55/60+37.23166/3600)},
{(16+05/60+20.682066/3600)*15, -(06+55/60+16.38465/3600)},
{(16+05/60+21.650742/3600)*15, -(06+54/60+55.16164/3600)},
{(16+05/60+22.481991/3600)*15, -(06+54/60+33.57209/3600)},
{(16+05/60+23.175869/3600)*15, -(06+54/60+11.62572/3600)},
{(16+05/60+23.732524/3600)*15, -(06+53/60+49.33242/3600)},
{(16+05/60+24.152186/3600)*15, -(06+53/60+26.70221/3600)},
{(16+05/60+24.435163/3600)*15, -(06+53/60+03.74521/3600)},
{(16+05/60+24.581827/3600)*15, -(06+52/60+40.47159/3600)},
{(16+05/60+24.592611/3600)*15, -(06+52/60+16.89157/3600)},
{(16+05/60+24.468000/3600)*15, -(06+51/60+53.01541/3600)},
{(16+05/60+24.208526/3600)*15, -(06+51/60+28.85337/3600)},
{(16+05/60+23.814767/3600)*15, -(06+51/60+04.41576/3600)} }];
:[font = input; preserveAspect; startGroup]
decL
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{-6.943729433333333333, -6.938266966666666667, 
  -6.932692622222222222, -6.927008794444444444, 
  -6.921217958333333333, -6.915322677777777778, 
  -6.909325580555555556, -6.903229366666666667, 
  -6.897036783333333333, -6.890750613888888889, 
  -6.884373669444444445, -6.877908775, -6.871358769444444444, 
  -6.864726502777777778, -6.858014825, -6.8512266}
;[o]
{-6.94373, -6.93827, -6.93269, -6.92701, -6.92122, -6.91532, 
  -6.90933, -6.90323, -6.89704, -6.89075, -6.88437, -6.87791, 
  -6.87136, -6.86473, -6.85801, -6.85123}
:[font = input; preserveAspect]
cos[x_] = Cos[N[x Degree]]; sin[x_] = Sin[N[x Degree]];
:[font = input; preserveAspect]
omega = 223.015; i = 99.1;
:[font = input; preserveAspect; startGroup]
a = 19640; au = 1.496 10^8;
aa = a/(distL * au) * 206265
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{0.9100155167792461947, 0.9105235997499873769, 
  0.9110316755137629976, 0.9115395823412995335, 
  0.9120471551734617062, 0.9125542263754401082, 
  0.9130606263735314151, 0.9135661849440985827, 
  0.9140707318329655509, 0.9145740977810921386, 
  0.9150761149082155308, 0.9155766171614268854, 
  0.9160754403642597826, 0.9165724222664902005, 
  0.917067402501446775, 0.917560222450100976}
;[o]
{0.910016, 0.910524, 0.911032, 0.91154, 0.912047, 0.912554, 
  0.913061, 0.913566, 0.914071, 0.914574, 0.915076, 0.915577, 
  0.916075, 0.916572, 0.917067, 0.91756}
:[font = input; preserveAspect; startGroup]
xiL = aa * (
	-sin[raL - omega] * cos[uL] + 
	cos[raL-omega]*cos[i] * sin[uL])
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{-0.3140105591449830319, -0.1395588485054102502, 0.159834230857959, 
  0.3169323033302416838, 0.1911991117238317453, 
  -0.1054803331239001249, -0.3083791530897433748, 
  -0.2361660206539732478, 0.04703286430846223149, 
  0.2885927853376972006, 0.2727651399343788336, 
  0.01338294456726967319, -0.2582355963279010952, 
  -0.2996015009161068893, -0.07355285533979479843, 
  0.2183694451454821675}
;[o]
{-0.314011, -0.139559, 0.159834, 0.316932, 0.191199, -0.10548, 
  -0.308379, -0.236166, 0.0470329, 0.288593, 0.272765, 0.0133829, 
  -0.258236, -0.299602, -0.0735529, 0.218369}
:[font = input; preserveAspect; startGroup]
etaL = aa * (
	-cos[raL - omega] * sin[decL] * cos[uL] + 
	(-sin[raL-omega] * sin[decL] * cos[i] + cos[decL] * sin[i])
	* sin[uL])
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{0.5711702876521435978, 0.8880112331856763208, 
  0.4125539715500476502, -0.4316881576670850586, 
  -0.8915472930132754134, -0.5561192190589747824, 
  0.2760791849677812488, 0.8627789233111903586, 
  0.6800180647560086487, -0.1099269842432693266, 
  -0.8026295102179041491, -0.7796821840787098151, 
  -0.06077804288882898453, 0.7131663287129634746, 
  0.8514044283252653453, 0.229854614604876915}
;[o]
{0.57117, 0.888011, 0.412554, -0.431688, -0.891547, -0.556119, 
  0.276079, 0.862779, 0.680018, -0.109927, -0.80263, -0.779682, 
  -0.060778, 0.713166, 0.851404, 0.229855}
:[font = input; preserveAspect; startGroup]
ListPlot[ Transpose[{xiL, etaL}], PlotRange->All;
AspectRatio->Automatic, Prolog->{PointSize[0.05]} ];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 116; pictureHeight = 327; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: 2.82047 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.497795 1.50946 1.41291 1.50946 [
[(-0.3)] .04496 1.41291 0 2 Msboxa
[(-0.2)] .1959 1.41291 0 2 Msboxa
[(-0.1)] .34685 1.41291 0 2 Msboxa
[(0.1)] .64874 1.41291 0 2 Msboxa
[(0.2)] .79969 1.41291 0 2 Msboxa
[(0.3)] .95063 1.41291 0 2 Msboxa
[(-0.75)] .48529 .28081 1 0 Msboxa
[(-0.5)] .48529 .65818 1 0 Msboxa
[(-0.25)] .48529 1.03554 1 0 Msboxa
[(0.25)] .48529 1.79027 1 0 Msboxa
[(0.5)] .48529 2.16763 1 0 Msboxa
[(0.75)] .48529 2.545 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 2.82147 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.04496 1.41291 m
.04496 1.41916 L
s
P
[(-0.3)] .04496 1.41291 0 2 Mshowa
p
.002 w
.1959 1.41291 m
.1959 1.41916 L
s
P
[(-0.2)] .1959 1.41291 0 2 Mshowa
p
.002 w
.34685 1.41291 m
.34685 1.41916 L
s
P
[(-0.1)] .34685 1.41291 0 2 Mshowa
p
.002 w
.64874 1.41291 m
.64874 1.41916 L
s
P
[(0.1)] .64874 1.41291 0 2 Mshowa
p
.002 w
.79969 1.41291 m
.79969 1.41916 L
s
P
[(0.2)] .79969 1.41291 0 2 Mshowa
p
.002 w
.95063 1.41291 m
.95063 1.41916 L
s
P
[(0.3)] .95063 1.41291 0 2 Mshowa
p
.001 w
.07515 1.41291 m
.07515 1.41666 L
s
P
p
.001 w
.10534 1.41291 m
.10534 1.41666 L
s
P
p
.001 w
.13553 1.41291 m
.13553 1.41666 L
s
P
p
.001 w
.16571 1.41291 m
.16571 1.41666 L
s
P
p
.001 w
.22609 1.41291 m
.22609 1.41666 L
s
P
p
.001 w
.25628 1.41291 m
.25628 1.41666 L
s
P
p
.001 w
.28647 1.41291 m
.28647 1.41666 L
s
P
p
.001 w
.31666 1.41291 m
.31666 1.41666 L
s
P
p
.001 w
.37704 1.41291 m
.37704 1.41666 L
s
P
p
.001 w
.40723 1.41291 m
.40723 1.41666 L
s
P
p
.001 w
.43742 1.41291 m
.43742 1.41666 L
s
P
p
.001 w
.46761 1.41291 m
.46761 1.41666 L
s
P
p
.001 w
.52798 1.41291 m
.52798 1.41666 L
s
P
p
.001 w
.55817 1.41291 m
.55817 1.41666 L
s
P
p
.001 w
.58836 1.41291 m
.58836 1.41666 L
s
P
p
.001 w
.61855 1.41291 m
.61855 1.41666 L
s
P
p
.001 w
.67893 1.41291 m
.67893 1.41666 L
s
P
p
.001 w
.70912 1.41291 m
.70912 1.41666 L
s
P
p
.001 w
.73931 1.41291 m
.73931 1.41666 L
s
P
p
.001 w
.7695 1.41291 m
.7695 1.41666 L
s
P
p
.001 w
.82988 1.41291 m
.82988 1.41666 L
s
P
p
.001 w
.86006 1.41291 m
.86006 1.41666 L
s
P
p
.001 w
.89025 1.41291 m
.89025 1.41666 L
s
P
p
.001 w
.92044 1.41291 m
.92044 1.41666 L
s
P
p
.001 w
.01477 1.41291 m
.01477 1.41666 L
s
P
p
.001 w
.98082 1.41291 m
.98082 1.41666 L
s
P
p
.002 w
0 1.41291 m
1 1.41291 L
s
P
p
.002 w
.49779 .28081 m
.50404 .28081 L
s
P
[(-0.75)] .48529 .28081 1 0 Mshowa
p
.002 w
.49779 .65818 m
.50404 .65818 L
s
P
[(-0.5)] .48529 .65818 1 0 Mshowa
p
.002 w
.49779 1.03554 m
.50404 1.03554 L
s
P
[(-0.25)] .48529 1.03554 1 0 Mshowa
p
.002 w
.49779 1.79027 m
.50404 1.79027 L
s
P
[(0.25)] .48529 1.79027 1 0 Mshowa
p
.002 w
.49779 2.16763 m
.50404 2.16763 L
s
P
[(0.5)] .48529 2.16763 1 0 Mshowa
p
.002 w
.49779 2.545 m
.50404 2.545 L
s
P
[(0.75)] .48529 2.545 1 0 Mshowa
p
.001 w
.49779 .35629 m
.50154 .35629 L
s
P
p
.001 w
.49779 .43176 m
.50154 .43176 L
s
P
p
.001 w
.49779 .50723 m
.50154 .50723 L
s
P
p
.001 w
.49779 .58271 m
.50154 .58271 L
s
P
p
.001 w
.49779 .73365 m
.50154 .73365 L
s
P
p
.001 w
.49779 .80912 m
.50154 .80912 L
s
P
p
.001 w
.49779 .8846 m
.50154 .8846 L
s
P
p
.001 w
.49779 .96007 m
.50154 .96007 L
s
P
p
.001 w
.49779 1.11101 m
.50154 1.11101 L
s
P
p
.001 w
.49779 1.18649 m
.50154 1.18649 L
s
P
p
.001 w
.49779 1.26196 m
.50154 1.26196 L
s
P
p
.001 w
.49779 1.33743 m
.50154 1.33743 L
s
P
p
.001 w
.49779 1.48838 m
.50154 1.48838 L
s
P
p
.001 w
.49779 1.56385 m
.50154 1.56385 L
s
P
p
.001 w
.49779 1.63932 m
.50154 1.63932 L
s
P
p
.001 w
.49779 1.7148 m
.50154 1.7148 L
s
P
p
.001 w
.49779 1.86574 m
.50154 1.86574 L
s
P
p
.001 w
.49779 1.94122 m
.50154 1.94122 L
s
P
p
.001 w
.49779 2.01669 m
.50154 2.01669 L
s
P
p
.001 w
.49779 2.09216 m
.50154 2.09216 L
s
P
p
.001 w
.49779 2.24311 m
.50154 2.24311 L
s
P
p
.001 w
.49779 2.31858 m
.50154 2.31858 L
s
P
p
.001 w
.49779 2.39405 m
.50154 2.39405 L
s
P
p
.001 w
.49779 2.46953 m
.50154 2.46953 L
s
P
p
.001 w
.49779 .20534 m
.50154 .20534 L
s
P
p
.001 w
.49779 .12987 m
.50154 .12987 L
s
P
p
.001 w
.49779 .0544 m
.50154 .0544 L
s
P
p
.001 w
.49779 2.62047 m
.50154 2.62047 L
s
P
p
.001 w
.49779 2.69594 m
.50154 2.69594 L
s
P
p
.001 w
.49779 2.77142 m
.50154 2.77142 L
s
P
p
.002 w
.49779 0 m
.49779 2.82047 L
s
P
P
0 0 m
1 0 L
1 2.82047 L
0 2.82047 L
closepath
clip
newpath
p
.05 w
.02381 2.27506 Mdot
.28714 2.75332 Mdot
.73906 2.03564 Mdot
.97619 .76129 Mdot
.7864 .06715 Mdot
.33858 .57347 Mdot
.03231 1.82964 Mdot
.14131 2.71523 Mdot
.56879 2.43936 Mdot
.93341 1.24698 Mdot
.90952 .20137 Mdot
.518 .23601 Mdot
.108 1.32116 Mdot
.04556 2.4894 Mdot
.38677 2.69806 Mdot
.82741 1.75986 Mdot
P
% End of Graphics
MathPictureEnd

:[font = input; preserveAspect; startGroup]
sepL = Sqrt[xiL^2 + etaL^2];
Print[ NumberForm[sepL, {4,2}, NumberPadding->{"","0"}] ]
:[font = print; inactive; preserveAspect; endGroup]
{0.65, 0.90, 0.44, 0.54, 0.91, 0.57, 0.41, 0.89, 0.68, 0.31, 0.85, 0.78, 0.27, 0.77, 0.85, 0.32}
:[font = input; preserveAspect; startGroup]
paL = Mod[ArcTan[ etaL, xiL ] / Degree//N, 360];
Print[ NumberForm[paL, {6,2}, NumberPadding->{"","0"}] ]
:[font = print; inactive; preserveAspect; endGroup]
{331.20, 351.07, 21.18, 143.72, 167.90, 190.74, 311.84, 344.69, 3.96, 110.85, 161.23, 179.02, 256.76, 337.21, 355.06, 43.53}
:[font = input; preserveAspect; startGroup]
ra=234.25; dec = -4; 
Plot[ aa[[1]] * Sqrt[
(-sin[ra-omega] * cos[u] + 
  cos[ra-omega]*cos[i] * sin[u])^2 + 
(-cos[ra-omega] * sin[-dec] * cos[u] + 
	(-sin[ra-omega] * sin[-dec] * cos[i] + cos[-dec] * sin[i])
	* sin[u])^2], {u, 0, 360}];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0026455 -0.135163 0.811506 [
[(50)] .15608 .02714 0 2 Msboxa
[(100)] .28836 .02714 0 2 Msboxa
[(150)] .42063 .02714 0 2 Msboxa
[(200)] .55291 .02714 0 2 Msboxa
[(250)] .68519 .02714 0 2 Msboxa
[(300)] .81746 .02714 0 2 Msboxa
[(350)] .94974 .02714 0 2 Msboxa
[(0.3)] .01131 .10829 1 0 Msboxa
[(0.4)] .01131 .18944 1 0 Msboxa
[(0.5)] .01131 .27059 1 0 Msboxa
[(0.6)] .01131 .35174 1 0 Msboxa
[(0.7)] .01131 .43289 1 0 Msboxa
[(0.8)] .01131 .51404 1 0 Msboxa
[(0.9)] .01131 .59519 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.15608 .02714 m
.15608 .03339 L
s
P
[(50)] .15608 .02714 0 2 Mshowa
p
.002 w
.28836 .02714 m
.28836 .03339 L
s
P
[(100)] .28836 .02714 0 2 Mshowa
p
.002 w
.42063 .02714 m
.42063 .03339 L
s
P
[(150)] .42063 .02714 0 2 Mshowa
p
.002 w
.55291 .02714 m
.55291 .03339 L
s
P
[(200)] .55291 .02714 0 2 Mshowa
p
.002 w
.68519 .02714 m
.68519 .03339 L
s
P
[(250)] .68519 .02714 0 2 Mshowa
p
.002 w
.81746 .02714 m
.81746 .03339 L
s
P
[(300)] .81746 .02714 0 2 Mshowa
p
.002 w
.94974 .02714 m
.94974 .03339 L
s
P
[(350)] .94974 .02714 0 2 Mshowa
p
.001 w
.05026 .02714 m
.05026 .03089 L
s
P
p
.001 w
.07672 .02714 m
.07672 .03089 L
s
P
p
.001 w
.10317 .02714 m
.10317 .03089 L
s
P
p
.001 w
.12963 .02714 m
.12963 .03089 L
s
P
p
.001 w
.18254 .02714 m
.18254 .03089 L
s
P
p
.001 w
.20899 .02714 m
.20899 .03089 L
s
P
p
.001 w
.23545 .02714 m
.23545 .03089 L
s
P
p
.001 w
.2619 .02714 m
.2619 .03089 L
s
P
p
.001 w
.31481 .02714 m
.31481 .03089 L
s
P
p
.001 w
.34127 .02714 m
.34127 .03089 L
s
P
p
.001 w
.36772 .02714 m
.36772 .03089 L
s
P
p
.001 w
.39418 .02714 m
.39418 .03089 L
s
P
p
.001 w
.44709 .02714 m
.44709 .03089 L
s
P
p
.001 w
.47354 .02714 m
.47354 .03089 L
s
P
p
.001 w
.5 .02714 m
.5 .03089 L
s
P
p
.001 w
.52646 .02714 m
.52646 .03089 L
s
P
p
.001 w
.57937 .02714 m
.57937 .03089 L
s
P
p
.001 w
.60582 .02714 m
.60582 .03089 L
s
P
p
.001 w
.63228 .02714 m
.63228 .03089 L
s
P
p
.001 w
.65873 .02714 m
.65873 .03089 L
s
P
p
.001 w
.71164 .02714 m
.71164 .03089 L
s
P
p
.001 w
.7381 .02714 m
.7381 .03089 L
s
P
p
.001 w
.76455 .02714 m
.76455 .03089 L
s
P
p
.001 w
.79101 .02714 m
.79101 .03089 L
s
P
p
.001 w
.84392 .02714 m
.84392 .03089 L
s
P
p
.001 w
.87037 .02714 m
.87037 .03089 L
s
P
p
.001 w
.89683 .02714 m
.89683 .03089 L
s
P
p
.001 w
.92328 .02714 m
.92328 .03089 L
s
P
p
.001 w
.97619 .02714 m
.97619 .03089 L
s
P
p
.002 w
0 .02714 m
1 .02714 L
s
P
p
.002 w
.02381 .10829 m
.03006 .10829 L
s
P
[(0.3)] .01131 .10829 1 0 Mshowa
p
.002 w
.02381 .18944 m
.03006 .18944 L
s
P
[(0.4)] .01131 .18944 1 0 Mshowa
p
.002 w
.02381 .27059 m
.03006 .27059 L
s
P
[(0.5)] .01131 .27059 1 0 Mshowa
p
.002 w
.02381 .35174 m
.03006 .35174 L
s
P
[(0.6)] .01131 .35174 1 0 Mshowa
p
.002 w
.02381 .43289 m
.03006 .43289 L
s
P
[(0.7)] .01131 .43289 1 0 Mshowa
p
.002 w
.02381 .51404 m
.03006 .51404 L
s
P
[(0.8)] .01131 .51404 1 0 Mshowa
p
.002 w
.02381 .59519 m
.03006 .59519 L
s
P
[(0.9)] .01131 .59519 1 0 Mshowa
p
.001 w
.02381 .04337 m
.02756 .04337 L
s
P
p
.001 w
.02381 .0596 m
.02756 .0596 L
s
P
p
.001 w
.02381 .07583 m
.02756 .07583 L
s
P
p
.001 w
.02381 .09206 m
.02756 .09206 L
s
P
p
.001 w
.02381 .12452 m
.02756 .12452 L
s
P
p
.001 w
.02381 .14075 m
.02756 .14075 L
s
P
p
.001 w
.02381 .15698 m
.02756 .15698 L
s
P
p
.001 w
.02381 .17321 m
.02756 .17321 L
s
P
p
.001 w
.02381 .20567 m
.02756 .20567 L
s
P
p
.001 w
.02381 .2219 m
.02756 .2219 L
s
P
p
.001 w
.02381 .23813 m
.02756 .23813 L
s
P
p
.001 w
.02381 .25436 m
.02756 .25436 L
s
P
p
.001 w
.02381 .28682 m
.02756 .28682 L
s
P
p
.001 w
.02381 .30305 m
.02756 .30305 L
s
P
p
.001 w
.02381 .31928 m
.02756 .31928 L
s
P
p
.001 w
.02381 .33551 m
.02756 .33551 L
s
P
p
.001 w
.02381 .36797 m
.02756 .36797 L
s
P
p
.001 w
.02381 .3842 m
.02756 .3842 L
s
P
p
.001 w
.02381 .40043 m
.02756 .40043 L
s
P
p
.001 w
.02381 .41666 m
.02756 .41666 L
s
P
p
.001 w
.02381 .44912 m
.02756 .44912 L
s
P
p
.001 w
.02381 .46535 m
.02756 .46535 L
s
P
p
.001 w
.02381 .48158 m
.02756 .48158 L
s
P
p
.001 w
.02381 .49781 m
.02756 .49781 L
s
P
p
.001 w
.02381 .53027 m
.02756 .53027 L
s
P
p
.001 w
.02381 .5465 m
.02756 .5465 L
s
P
p
.001 w
.02381 .56273 m
.02756 .56273 L
s
P
p
.001 w
.02381 .57896 m
.02756 .57896 L
s
P
p
.001 w
.02381 .01091 m
.02756 .01091 L
s
P
p
.001 w
.02381 .61142 m
.02756 .61142 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
.02381 .01733 m
.02505 .01635 L
.02629 .0156 L
.02753 .01507 L
.02877 .01478 L
.03001 .01472 L
.03125 .01489 L
.03249 .01529 L
.03373 .01593 L
.03497 .01679 L
.03621 .01788 L
.03869 .0207 L
.04117 .02434 L
.04365 .02875 L
.05357 .05274 L
.06349 .08393 L
.10317 .23356 L
.14286 .37822 L
.1627 .44078 L
.18254 .49461 L
.20238 .53851 L
.2123 .55644 L
.22222 .57157 L
.23214 .58382 L
.2371 .58885 L
.24206 .59313 L
.24702 .59667 L
.25198 .59946 L
.25446 .60058 L
.25694 .6015 L
.25942 .60224 L
.26066 .60253 L
.2619 .60278 L
.26314 .60298 L
.26438 .60314 L
.26563 .60325 L
.26687 .60331 L
.26811 .60332 L
.26935 .60328 L
.27059 .6032 L
.27183 .60307 L
.27307 .60289 L
.27431 .60267 L
.27679 .60208 L
.27927 .6013 L
.28175 .60033 L
.28671 .59783 L
.29167 .59457 L
.30159 .58582 L
.31151 .57413 L
Mistroke
.32143 .55954 L
.34127 .522 L
.38095 .41644 L
.42063 .27861 L
.46032 .12628 L
.47024 .09041 L
.48016 .05824 L
.48512 .04437 L
.49008 .03259 L
.49256 .02764 L
.49504 .02341 L
.49752 .01995 L
.49876 .01853 L
.5 .01733 L
.50124 .01635 L
.50248 .0156 L
.50372 .01507 L
.50496 .01478 L
.5062 .01472 L
.50744 .01489 L
.50868 .01529 L
.50992 .01593 L
.51116 .01679 L
.5124 .01788 L
.51488 .0207 L
.51736 .02434 L
.51984 .02875 L
.52976 .05274 L
.53968 .08393 L
.57937 .23356 L
.61905 .37822 L
.63889 .44078 L
.65873 .49461 L
.67857 .53851 L
.68849 .55644 L
.69841 .57157 L
.70833 .58382 L
.71329 .58885 L
.71825 .59313 L
.72321 .59667 L
.72817 .59946 L
.73065 .60058 L
.73313 .6015 L
.73562 .60224 L
.73686 .60253 L
.7381 .60278 L
.73934 .60298 L
.74058 .60314 L
.74182 .60325 L
.74306 .60331 L
Mistroke
.7443 .60332 L
.74554 .60328 L
.74678 .6032 L
.74802 .60307 L
.74926 .60289 L
.7505 .60267 L
.75298 .60208 L
.75546 .6013 L
.75794 .60033 L
.7629 .59783 L
.76786 .59457 L
.77778 .58582 L
.7877 .57413 L
.79762 .55954 L
.81746 .522 L
.85714 .41644 L
.89683 .27861 L
.93651 .12628 L
.97619 .01733 L
Mfstroke
P
P
% End of Graphics
MathPictureEnd

:[font = input; preserveAspect; startGroup]
ra=241.24; dec = -6; 
Plot[ aa[[1]] * Sqrt[
(-sin[ra-omega] * cos[u] + 
  cos[ra-omega]*cos[i] * sin[u])^2 + 
(-cos[ra-omega] * sin[-dec] * cos[u] + 
	(-sin[ra-omega] * sin[-dec] * cos[i] + cos[-dec] * sin[i])
	* sin[u])^2], {u, 0, 360}];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0026455 -0.266951 0.956324 [
[(50)] .15608 .01995 0 2 Msboxa
[(100)] .28836 .01995 0 2 Msboxa
[(150)] .42063 .01995 0 2 Msboxa
[(200)] .55291 .01995 0 2 Msboxa
[(250)] .68519 .01995 0 2 Msboxa
[(300)] .81746 .01995 0 2 Msboxa
[(350)] .94974 .01995 0 2 Msboxa
[(0.4)] .01131 .11558 1 0 Msboxa
[(0.5)] .01131 .21121 1 0 Msboxa
[(0.6)] .01131 .30684 1 0 Msboxa
[(0.7)] .01131 .40248 1 0 Msboxa
[(0.8)] .01131 .49811 1 0 Msboxa
[(0.9)] .01131 .59374 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.15608 .01995 m
.15608 .0262 L
s
P
[(50)] .15608 .01995 0 2 Mshowa
p
.002 w
.28836 .01995 m
.28836 .0262 L
s
P
[(100)] .28836 .01995 0 2 Mshowa
p
.002 w
.42063 .01995 m
.42063 .0262 L
s
P
[(150)] .42063 .01995 0 2 Mshowa
p
.002 w
.55291 .01995 m
.55291 .0262 L
s
P
[(200)] .55291 .01995 0 2 Mshowa
p
.002 w
.68519 .01995 m
.68519 .0262 L
s
P
[(250)] .68519 .01995 0 2 Mshowa
p
.002 w
.81746 .01995 m
.81746 .0262 L
s
P
[(300)] .81746 .01995 0 2 Mshowa
p
.002 w
.94974 .01995 m
.94974 .0262 L
s
P
[(350)] .94974 .01995 0 2 Mshowa
p
.001 w
.05026 .01995 m
.05026 .0237 L
s
P
p
.001 w
.07672 .01995 m
.07672 .0237 L
s
P
p
.001 w
.10317 .01995 m
.10317 .0237 L
s
P
p
.001 w
.12963 .01995 m
.12963 .0237 L
s
P
p
.001 w
.18254 .01995 m
.18254 .0237 L
s
P
p
.001 w
.20899 .01995 m
.20899 .0237 L
s
P
p
.001 w
.23545 .01995 m
.23545 .0237 L
s
P
p
.001 w
.2619 .01995 m
.2619 .0237 L
s
P
p
.001 w
.31481 .01995 m
.31481 .0237 L
s
P
p
.001 w
.34127 .01995 m
.34127 .0237 L
s
P
p
.001 w
.36772 .01995 m
.36772 .0237 L
s
P
p
.001 w
.39418 .01995 m
.39418 .0237 L
s
P
p
.001 w
.44709 .01995 m
.44709 .0237 L
s
P
p
.001 w
.47354 .01995 m
.47354 .0237 L
s
P
p
.001 w
.5 .01995 m
.5 .0237 L
s
P
p
.001 w
.52646 .01995 m
.52646 .0237 L
s
P
p
.001 w
.57937 .01995 m
.57937 .0237 L
s
P
p
.001 w
.60582 .01995 m
.60582 .0237 L
s
P
p
.001 w
.63228 .01995 m
.63228 .0237 L
s
P
p
.001 w
.65873 .01995 m
.65873 .0237 L
s
P
p
.001 w
.71164 .01995 m
.71164 .0237 L
s
P
p
.001 w
.7381 .01995 m
.7381 .0237 L
s
P
p
.001 w
.76455 .01995 m
.76455 .0237 L
s
P
p
.001 w
.79101 .01995 m
.79101 .0237 L
s
P
p
.001 w
.84392 .01995 m
.84392 .0237 L
s
P
p
.001 w
.87037 .01995 m
.87037 .0237 L
s
P
p
.001 w
.89683 .01995 m
.89683 .0237 L
s
P
p
.001 w
.92328 .01995 m
.92328 .0237 L
s
P
p
.001 w
.97619 .01995 m
.97619 .0237 L
s
P
p
.002 w
0 .01995 m
1 .01995 L
s
P
p
.002 w
.02381 .11558 m
.03006 .11558 L
s
P
[(0.4)] .01131 .11558 1 0 Mshowa
p
.002 w
.02381 .21121 m
.03006 .21121 L
s
P
[(0.5)] .01131 .21121 1 0 Mshowa
p
.002 w
.02381 .30684 m
.03006 .30684 L
s
P
[(0.6)] .01131 .30684 1 0 Mshowa
p
.002 w
.02381 .40248 m
.03006 .40248 L
s
P
[(0.7)] .01131 .40248 1 0 Mshowa
p
.002 w
.02381 .49811 m
.03006 .49811 L
s
P
[(0.8)] .01131 .49811 1 0 Mshowa
p
.002 w
.02381 .59374 m
.03006 .59374 L
s
P
[(0.9)] .01131 .59374 1 0 Mshowa
p
.001 w
.02381 .03907 m
.02756 .03907 L
s
P
p
.001 w
.02381 .0582 m
.02756 .0582 L
s
P
p
.001 w
.02381 .07733 m
.02756 .07733 L
s
P
p
.001 w
.02381 .09645 m
.02756 .09645 L
s
P
p
.001 w
.02381 .13471 m
.02756 .13471 L
s
P
p
.001 w
.02381 .15383 m
.02756 .15383 L
s
P
p
.001 w
.02381 .17296 m
.02756 .17296 L
s
P
p
.001 w
.02381 .19208 m
.02756 .19208 L
s
P
p
.001 w
.02381 .23034 m
.02756 .23034 L
s
P
p
.001 w
.02381 .24946 m
.02756 .24946 L
s
P
p
.001 w
.02381 .26859 m
.02756 .26859 L
s
P
p
.001 w
.02381 .28772 m
.02756 .28772 L
s
P
p
.001 w
.02381 .32597 m
.02756 .32597 L
s
P
p
.001 w
.02381 .3451 m
.02756 .3451 L
s
P
p
.001 w
.02381 .36422 m
.02756 .36422 L
s
P
p
.001 w
.02381 .38335 m
.02756 .38335 L
s
P
p
.001 w
.02381 .4216 m
.02756 .4216 L
s
P
p
.001 w
.02381 .44073 m
.02756 .44073 L
s
P
p
.001 w
.02381 .45986 m
.02756 .45986 L
s
P
p
.001 w
.02381 .47898 m
.02756 .47898 L
s
P
p
.001 w
.02381 .51723 m
.02756 .51723 L
s
P
p
.001 w
.02381 .53636 m
.02756 .53636 L
s
P
p
.001 w
.02381 .55549 m
.02756 .55549 L
s
P
p
.001 w
.02381 .57461 m
.02756 .57461 L
s
P
p
.001 w
.02381 .00082 m
.02756 .00082 L
s
P
p
.001 w
.02381 .61287 m
.02756 .61287 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
.02381 .01861 m
.02505 .01758 L
.02629 .01671 L
.02753 .01599 L
.02877 .01543 L
.03001 .01503 L
.03125 .01479 L
.03249 .01472 L
.03373 .0148 L
.03497 .01504 L
.03621 .01545 L
.03745 .01601 L
.03869 .01673 L
.04117 .01865 L
.04365 .02118 L
.04861 .028 L
.05357 .03701 L
.06349 .06069 L
.08333 .12403 L
.10317 .19832 L
.14286 .34925 L
.1627 .4173 L
.18254 .47688 L
.20238 .52626 L
.2123 .5467 L
.22222 .56414 L
.23214 .57847 L
.24206 .5896 L
.24702 .59395 L
.25198 .59748 L
.25446 .59893 L
.25694 .60018 L
.25942 .60122 L
.2619 .60205 L
.26314 .60239 L
.26438 .60267 L
.26563 .60291 L
.26687 .60309 L
.26811 .60322 L
.26935 .60329 L
.27059 .60332 L
.27183 .60329 L
.27307 .60321 L
.27431 .60308 L
.27555 .6029 L
.27679 .60266 L
.27927 .60204 L
.28175 .6012 L
.28671 .59891 L
.29167 .59578 L
Mistroke
.30159 .58707 L
.31151 .57512 L
.32143 .55999 L
.34127 .52059 L
.38095 .40907 L
.42063 .26542 L
.44048 .1886 L
.46032 .11514 L
.47024 .0823 L
.48016 .05402 L
.48512 .04217 L
.49008 .03217 L
.49504 .02424 L
.49752 .02113 L
.5 .01861 L
.50124 .01758 L
.50248 .01671 L
.50372 .01599 L
.50496 .01543 L
.5062 .01503 L
.50744 .01479 L
.50868 .01472 L
.50992 .0148 L
.51116 .01504 L
.5124 .01545 L
.51364 .01601 L
.51488 .01673 L
.51736 .01865 L
.51984 .02118 L
.5248 .028 L
.52976 .03701 L
.53968 .06069 L
.55952 .12403 L
.57937 .19832 L
.61905 .34925 L
.63889 .4173 L
.65873 .47688 L
.67857 .52626 L
.68849 .5467 L
.69841 .56414 L
.70833 .57847 L
.71825 .5896 L
.72321 .59395 L
.72817 .59748 L
.73065 .59893 L
.73313 .60018 L
.73562 .60122 L
.7381 .60205 L
.73934 .60239 L
.74058 .60267 L
Mistroke
.74182 .60291 L
.74306 .60309 L
.7443 .60322 L
.74554 .60329 L
.74678 .60332 L
.74802 .60329 L
.74926 .60321 L
.7505 .60308 L
.75174 .6029 L
.75298 .60266 L
.75546 .60204 L
.75794 .6012 L
.7629 .59891 L
.76786 .59578 L
.77778 .58707 L
.7877 .57512 L
.79762 .55999 L
.81746 .52059 L
.85714 .40907 L
.89683 .26542 L
.91667 .1886 L
.93651 .11514 L
.94643 .0823 L
.95635 .05402 L
.96131 .04217 L
.96627 .03217 L
.97123 .02424 L
.97619 .01861 L
Mfstroke
P
P
% End of Graphics
MathPictureEnd

:[font = input; preserveAspect; startGroup]
Show[%74, %76];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0026455 -0.135163 0.811505 [
[(50)] .15608 .02714 0 2 Msboxa
[(100)] .28836 .02714 0 2 Msboxa
[(150)] .42063 .02714 0 2 Msboxa
[(200)] .55291 .02714 0 2 Msboxa
[(250)] .68519 .02714 0 2 Msboxa
[(300)] .81746 .02714 0 2 Msboxa
[(350)] .94974 .02714 0 2 Msboxa
[(0.3)] .01131 .10829 1 0 Msboxa
[(0.4)] .01131 .18944 1 0 Msboxa
[(0.5)] .01131 .27059 1 0 Msboxa
[(0.6)] .01131 .35174 1 0 Msboxa
[(0.7)] .01131 .43289 1 0 Msboxa
[(0.8)] .01131 .51404 1 0 Msboxa
[(0.9)] .01131 .59519 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.15608 .02714 m
.15608 .03339 L
s
P
[(50)] .15608 .02714 0 2 Mshowa
p
.002 w
.28836 .02714 m
.28836 .03339 L
s
P
[(100)] .28836 .02714 0 2 Mshowa
p
.002 w
.42063 .02714 m
.42063 .03339 L
s
P
[(150)] .42063 .02714 0 2 Mshowa
p
.002 w
.55291 .02714 m
.55291 .03339 L
s
P
[(200)] .55291 .02714 0 2 Mshowa
p
.002 w
.68519 .02714 m
.68519 .03339 L
s
P
[(250)] .68519 .02714 0 2 Mshowa
p
.002 w
.81746 .02714 m
.81746 .03339 L
s
P
[(300)] .81746 .02714 0 2 Mshowa
p
.002 w
.94974 .02714 m
.94974 .03339 L
s
P
[(350)] .94974 .02714 0 2 Mshowa
p
.001 w
.05026 .02714 m
.05026 .03089 L
s
P
p
.001 w
.07672 .02714 m
.07672 .03089 L
s
P
p
.001 w
.10317 .02714 m
.10317 .03089 L
s
P
p
.001 w
.12963 .02714 m
.12963 .03089 L
s
P
p
.001 w
.18254 .02714 m
.18254 .03089 L
s
P
p
.001 w
.20899 .02714 m
.20899 .03089 L
s
P
p
.001 w
.23545 .02714 m
.23545 .03089 L
s
P
p
.001 w
.2619 .02714 m
.2619 .03089 L
s
P
p
.001 w
.31481 .02714 m
.31481 .03089 L
s
P
p
.001 w
.34127 .02714 m
.34127 .03089 L
s
P
p
.001 w
.36772 .02714 m
.36772 .03089 L
s
P
p
.001 w
.39418 .02714 m
.39418 .03089 L
s
P
p
.001 w
.44709 .02714 m
.44709 .03089 L
s
P
p
.001 w
.47354 .02714 m
.47354 .03089 L
s
P
p
.001 w
.5 .02714 m
.5 .03089 L
s
P
p
.001 w
.52646 .02714 m
.52646 .03089 L
s
P
p
.001 w
.57937 .02714 m
.57937 .03089 L
s
P
p
.001 w
.60582 .02714 m
.60582 .03089 L
s
P
p
.001 w
.63228 .02714 m
.63228 .03089 L
s
P
p
.001 w
.65873 .02714 m
.65873 .03089 L
s
P
p
.001 w
.71164 .02714 m
.71164 .03089 L
s
P
p
.001 w
.7381 .02714 m
.7381 .03089 L
s
P
p
.001 w
.76455 .02714 m
.76455 .03089 L
s
P
p
.001 w
.79101 .02714 m
.79101 .03089 L
s
P
p
.001 w
.84392 .02714 m
.84392 .03089 L
s
P
p
.001 w
.87037 .02714 m
.87037 .03089 L
s
P
p
.001 w
.89683 .02714 m
.89683 .03089 L
s
P
p
.001 w
.92328 .02714 m
.92328 .03089 L
s
P
p
.001 w
.97619 .02714 m
.97619 .03089 L
s
P
p
.002 w
0 .02714 m
1 .02714 L
s
P
p
.002 w
.02381 .10829 m
.03006 .10829 L
s
P
[(0.3)] .01131 .10829 1 0 Mshowa
p
.002 w
.02381 .18944 m
.03006 .18944 L
s
P
[(0.4)] .01131 .18944 1 0 Mshowa
p
.002 w
.02381 .27059 m
.03006 .27059 L
s
P
[(0.5)] .01131 .27059 1 0 Mshowa
p
.002 w
.02381 .35174 m
.03006 .35174 L
s
P
[(0.6)] .01131 .35174 1 0 Mshowa
p
.002 w
.02381 .43289 m
.03006 .43289 L
s
P
[(0.7)] .01131 .43289 1 0 Mshowa
p
.002 w
.02381 .51404 m
.03006 .51404 L
s
P
[(0.8)] .01131 .51404 1 0 Mshowa
p
.002 w
.02381 .59519 m
.03006 .59519 L
s
P
[(0.9)] .01131 .59519 1 0 Mshowa
p
.001 w
.02381 .04337 m
.02756 .04337 L
s
P
p
.001 w
.02381 .0596 m
.02756 .0596 L
s
P
p
.001 w
.02381 .07583 m
.02756 .07583 L
s
P
p
.001 w
.02381 .09206 m
.02756 .09206 L
s
P
p
.001 w
.02381 .12452 m
.02756 .12452 L
s
P
p
.001 w
.02381 .14075 m
.02756 .14075 L
s
P
p
.001 w
.02381 .15698 m
.02756 .15698 L
s
P
p
.001 w
.02381 .17321 m
.02756 .17321 L
s
P
p
.001 w
.02381 .20567 m
.02756 .20567 L
s
P
p
.001 w
.02381 .2219 m
.02756 .2219 L
s
P
p
.001 w
.02381 .23813 m
.02756 .23813 L
s
P
p
.001 w
.02381 .25436 m
.02756 .25436 L
s
P
p
.001 w
.02381 .28682 m
.02756 .28682 L
s
P
p
.001 w
.02381 .30305 m
.02756 .30305 L
s
P
p
.001 w
.02381 .31928 m
.02756 .31928 L
s
P
p
.001 w
.02381 .33551 m
.02756 .33551 L
s
P
p
.001 w
.02381 .36797 m
.02756 .36797 L
s
P
p
.001 w
.02381 .3842 m
.02756 .3842 L
s
P
p
.001 w
.02381 .40043 m
.02756 .40043 L
s
P
p
.001 w
.02381 .41666 m
.02756 .41666 L
s
P
p
.001 w
.02381 .44912 m
.02756 .44912 L
s
P
p
.001 w
.02381 .46535 m
.02756 .46535 L
s
P
p
.001 w
.02381 .48158 m
.02756 .48158 L
s
P
p
.001 w
.02381 .49781 m
.02756 .49781 L
s
P
p
.001 w
.02381 .53027 m
.02756 .53027 L
s
P
p
.001 w
.02381 .5465 m
.02756 .5465 L
s
P
p
.001 w
.02381 .56273 m
.02756 .56273 L
s
P
p
.001 w
.02381 .57896 m
.02756 .57896 L
s
P
p
.001 w
.02381 .01091 m
.02756 .01091 L
s
P
p
.001 w
.02381 .61142 m
.02756 .61142 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.004 w
.02381 .01733 m
.02505 .01635 L
.02629 .0156 L
.02753 .01507 L
.02877 .01478 L
.03001 .01472 L
.03125 .01489 L
.03249 .01529 L
.03373 .01593 L
.03497 .01679 L
.03621 .01788 L
.03869 .0207 L
.04117 .02434 L
.04365 .02875 L
.05357 .05274 L
.06349 .08393 L
.10317 .23356 L
.14286 .37822 L
.1627 .44078 L
.18254 .49461 L
.20238 .5385 L
.2123 .55644 L
.22222 .57157 L
.23214 .58382 L
.2371 .58885 L
.24206 .59313 L
.24702 .59667 L
.25198 .59946 L
.25446 .60058 L
.25694 .6015 L
.25942 .60224 L
.26066 .60253 L
.2619 .60278 L
.26314 .60298 L
.26438 .60314 L
.26563 .60325 L
.26687 .60331 L
.26811 .60332 L
.26935 .60328 L
.27059 .6032 L
.27183 .60307 L
.27307 .60289 L
.27431 .60267 L
.27679 .60208 L
.27927 .6013 L
.28175 .60033 L
.28671 .59782 L
.29167 .59457 L
.30159 .58582 L
.31151 .57412 L
Mistroke
.32143 .55954 L
.34127 .522 L
.38095 .41643 L
.42063 .27861 L
.46032 .12628 L
.47024 .09041 L
.48016 .05824 L
.48512 .04437 L
.49008 .03259 L
.49256 .02764 L
.49504 .02341 L
.49752 .01995 L
.49876 .01853 L
.5 .01733 L
.50124 .01635 L
.50248 .0156 L
.50372 .01507 L
.50496 .01478 L
.5062 .01472 L
.50744 .01489 L
.50868 .01529 L
.50992 .01593 L
.51116 .01679 L
.5124 .01788 L
.51488 .0207 L
.51736 .02434 L
.51984 .02875 L
.52976 .05274 L
.53968 .08393 L
.57937 .23356 L
.61905 .37822 L
.63889 .44078 L
.65873 .49461 L
.67857 .5385 L
.68849 .55644 L
.69841 .57157 L
.70833 .58382 L
.71329 .58885 L
.71825 .59313 L
.72321 .59667 L
.72817 .59946 L
.73065 .60058 L
.73313 .6015 L
.73562 .60224 L
.73686 .60253 L
.7381 .60278 L
.73934 .60298 L
.74058 .60314 L
.74182 .60325 L
.74306 .60331 L
Mistroke
.7443 .60332 L
.74554 .60328 L
.74678 .6032 L
.74802 .60307 L
.74926 .60289 L
.7505 .60267 L
.75298 .60208 L
.75546 .6013 L
.75794 .60033 L
.7629 .59782 L
.76786 .59457 L
.77778 .58582 L
.7877 .57412 L
.79762 .55954 L
.81746 .522 L
.85714 .41643 L
.89683 .27861 L
.93651 .12628 L
.97619 .01733 L
Mfstroke
P
P
p
p
.004 w
.02381 .10716 m
.02505 .10628 L
.02629 .10554 L
.02753 .10493 L
.02877 .10446 L
.03001 .10412 L
.03125 .10392 L
.03249 .10385 L
.03373 .10392 L
.03497 .10413 L
.03621 .10447 L
.03745 .10495 L
.03869 .10556 L
.04117 .10719 L
.04365 .10934 L
.04861 .11512 L
.05357 .12277 L
.06349 .14286 L
.08333 .19661 L
.10317 .25965 L
.14286 .38773 L
.1627 .44547 L
.18254 .49603 L
.20238 .53793 L
.2123 .55528 L
.22222 .57007 L
.23214 .58223 L
.24206 .59168 L
.24702 .59537 L
.25198 .59836 L
.25446 .59959 L
.25694 .60065 L
.25942 .60153 L
.2619 .60224 L
.26314 .60253 L
.26438 .60277 L
.26563 .60297 L
.26687 .60312 L
.26811 .60323 L
.26935 .6033 L
.27059 .60332 L
.27183 .6033 L
.27307 .60323 L
.27431 .60312 L
.27555 .60296 L
.27679 .60276 L
.27927 .60223 L
.28175 .60152 L
.28671 .59957 L
.29167 .59692 L
Mistroke
.30159 .58953 L
.31151 .57939 L
.32143 .56656 L
.34127 .53312 L
.38095 .43848 L
.42063 .31659 L
.44048 .2514 L
.46032 .18907 L
.47024 .1612 L
.48016 .13721 L
.48512 .12715 L
.49008 .11866 L
.49504 .11194 L
.49752 .10929 L
.5 .10716 L
.50124 .10628 L
.50248 .10554 L
.50372 .10493 L
.50496 .10446 L
.5062 .10412 L
.50744 .10392 L
.50868 .10385 L
.50992 .10392 L
.51116 .10413 L
.5124 .10447 L
.51364 .10495 L
.51488 .10556 L
.51736 .10719 L
.51984 .10934 L
.5248 .11512 L
.52976 .12277 L
.53968 .14286 L
.55952 .19661 L
.57937 .25965 L
.61905 .38773 L
.63889 .44547 L
.65873 .49603 L
.67857 .53793 L
.68849 .55528 L
.69841 .57007 L
.70833 .58223 L
.71825 .59168 L
.72321 .59537 L
.72817 .59836 L
.73065 .59959 L
.73313 .60065 L
.73562 .60153 L
.7381 .60224 L
.73934 .60253 L
.74058 .60277 L
Mistroke
.74182 .60297 L
.74306 .60312 L
.7443 .60323 L
.74554 .6033 L
.74678 .60332 L
.74802 .6033 L
.74926 .60323 L
.7505 .60312 L
.75174 .60296 L
.75298 .60276 L
.75546 .60223 L
.75794 .60152 L
.7629 .59957 L
.76786 .59692 L
.77778 .58953 L
.7877 .57939 L
.79762 .56656 L
.81746 .53312 L
.85714 .43848 L
.89683 .31659 L
.91667 .2514 L
.93651 .18907 L
.94643 .1612 L
.95635 .13721 L
.96131 .12715 L
.96627 .11866 L
.97123 .11194 L
.97619 .10716 L
Mfstroke
P
P
P
% End of Graphics
MathPictureEnd

:[font = input; preserveAspect; startGroup]
{a, i, omega, u0}
:[font = output; output; inactive; preserveAspect; endGroup]
{19640, 99.1, 223.015, 259.76}
;[o]
{19640, 99.1, 223.015, 259.76}
:[font = input; preserveAspect]
(* clean up *)
Remove[a, aa, au, cos, dec, decL, distL, etaL, i,
JDL, JD0, omega, paL, period, phaseL, ra, raL, sepL,
sin, u, uL, u0, x, xiL]
:[font = input; preserveAspect; startGroup]
?Global`*
:[font = print; inactive; preserveAspect; endGroup]
colorTablesPackage
cubicInterpolationLINKfile
ellipticalGaussianStarLINKfile
ellipticalGaussianStarMeshLINKfile
ellipticalLorentzStarLINKfile
ellipticalLorentzStarMeshLINKfile
fitsAidePackage
grabBagPackage
imageProcessingPackage
leastSquaresPackage
occultationLightCurvePackage
ourLinkPaths
ourMathematicaPaths
plateReductionPackage
remoteObservingPackage
shadowMapPackage
starPackage
tableProcessingPackage
timeAndCoordsPackage
:[font = input; preserveAspect; startGroup]
??Global`a
:[font = message; inactive; preserveAspect; endGroup; endGroup]
Information::notfound: Symbol Global`a not found.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
converting starlists from B1950 to J2000 - NOPE!!! It's not B1950!!
:[font = input; preserveAspect; startGroup]
dir = "Internal HD:Mass Ratio 95:Observing:starlists:"
:[font = output; output; inactive; preserveAspect; endGroup]
"Internal HD:Mass Ratio 95:Observing:starlists:"
;[o]
Internal HD:Mass Ratio 95:Observing:starlists:
:[font = input; preserveAspect; startGroup]
SetDirectory[dir<>"B1950"]
:[font = output; output; inactive; preserveAspect; endGroup]
"Internal HD:Mass Ratio 95:Observing:starlists:B1950"
;[o]
Internal HD:Mass Ratio 95:Observing:starlists:B1950
:[font = input; preserveAspect; startGroup]
FileType[ fn = "Plu45,46,47.lin.ra_select.kg" ]
:[font = output; output; inactive; preserveAspect; endGroup]
File
;[o]
File
:[font = input; preserveAspect]
SetOptions[ ReadList, WordSeparators -> {"\t"}, RecordLists -> True];
:[font = input; preserveAspect]
fp = OpenRead[ fn ];
:[font = input; preserveAspect; startGroup]
headL = ReadList[fp, Word, 5]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{{"star number", "ra", "dec", "mag", "strip"}}
;[o]
{{star number, ra, dec, mag, strip}}
:[font = input; preserveAspect]
tempL = ReadList[fp, Word];
:[font = input; preserveAspect; startGroup]
Close[fp]
:[font = output; output; inactive; preserveAspect; endGroup]
"Plu45,46,47.lin.ra_select.kg"
;[o]
Plu45,46,47.lin.ra_select.kg
:[font = input; preserveAspect; startGroup]
tempL[[1]]
:[font = output; output; inactive; preserveAspect; endGroup]
{"20638", "16:01:34.060", "-6:40:30.383", "15.24600", "45"}
;[o]
{20638, 16:01:34.060, -6:40:30.383, 15.24600, 45}
:[font = input; preserveAspect; startGroup]
tempL[[-1]]
:[font = output; output; inactive; preserveAspect; endGroup]
{"21241", "16:03:01.232", "-6:47:59.719", "15.68700", "47"}
;[o]
{21241, 16:03:01.232, -6:47:59.719, 15.68700, 47}
:[font = input; preserveAspect; startGroup]
tcRadiansToDecString::usage
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
"tcRadiansToDecString[radians_ opts___] converts radians to a Dec\
  string. The option \"numberOfDecimals->n\" can be used, in which\
  case it is passed to a lower level function that produces \"n\"\
  digits to the right of the seconds decimal point."
;[o]
tcRadiansToDecString[radians_ opts___] converts radians to a Dec\
  string. The option "numberOfDecimals->n" can be used, in which\
  case it is passed to a lower level function that produces "n"\
  digits to the right of the seconds decimal point.
:[font = input; preserveAspect; startGroup]
tcRadiansToRAstring::usage
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
"tcRadiansToRAstring[radians_ opts___] converts radians into an RA\
  string The option \"numberOfDecimals->n\" can be used, in which\
  case it is passed to a lower level function that produces \"n\"\
  digits to the right of the seconds decimal point."
;[o]
tcRadiansToRAstring[radians_ opts___] converts radians into an RA\
  string The option "numberOfDecimals->n" can be used, in which case\
  it is passed to a lower level function that produces "n" digits to\
  the right of the seconds decimal point.
:[font = input; preserveAspect; startGroup]
tcFK4B1950ToFK5J2000::usage
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
"tcFK4B1950ToFK5J2000[coordinate_List, opts___] performs the\
  conversion from B1950, FK4, to J2000, FK5, including precession,\
  proper  motion, removal of E-terms, and the small rotation for the\
  FK4->FK5 conversion.  The method on p. B42 of the 1991 AA is used.\
   The coordinate list should be in the following order: {ra\
  (radians), dec (radians), raProperMotion (arcSeconds per tropical\
  century),  decProperMotion  (arcSeconds per tropical century),\
  parallax  (arcSeconds), radialVelocity (kilometers per second)}. \
  One can  use a list of 2, 4, 5, or 6 elements, and the returned\
  list will  be of the same length.  Unspecified elements will be\
  set to 0.0  for the transformation."
;[o]
tcFK4B1950ToFK5J2000[coordinate_List, opts___] performs the\
  conversion from B1950, FK4, to J2000, FK5, including precession,\
  proper  motion, removal of E-terms, and the small rotation for the\
  FK4->FK5 conversion.  The method on p. B42 of the 1991 AA is used.\
   The coordinate list should be in the following order: {ra\
  (radians), dec (radians), raProperMotion (arcSeconds per tropical\
  century),  decProperMotion  (arcSeconds per tropical century),\
  parallax  (arcSeconds), radialVelocity (kilometers per second)}. \
  One can  use a list of 2, 4, 5, or 6 elements, and the returned\
  list will  be of the same length.  Unspecified elements will be\
  set to 0.0  for the transformation.
:[font = input; preserveAspect; startGroup]
StringReplace::usage
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
"StringReplace[\"string\", \"s1\" -> \"sp1\"] or\
  StringReplace[\"string\", {\"s1\" -> \"sp1\", \"s2\" -> \"sp2\",\
  ...}] replaces the \"si\" by \"spi\" whenever they appear as\
  substrings of \"string\"."
;[o]
StringReplace["string", "s1" -> "sp1"] or StringReplace["string",\
  {"s1" -> "sp1", "s2" -> "sp2", ...}] replaces the "si" by "spi"\
  whenever they appear as substrings of "string".
:[font = input; preserveAspect]
prec[{sn_,raS_,decS_,dS_,stripS_}] := Module[
{ra1950, dec1950,ra2000,dec2000},
	ra1950 = tcHMSstringToRadians[raS];
	dec1950 = tcDecStringToRadians[decS];
	{ra2000,dec2000} = tcFK4B1950ToFK5J2000[{ra1950, dec1950}];
	ra2000S = StringReplace[
		tcRadiansToRAstring[ra2000, numberOfDecimals->3],
		{"  "->":0"," "->":"}];
	dec2000S = StringReplace[
		tcRadiansToDecString[dec2000, numberOfDecimals->3],
		{"- "->"-0", "  "->":0", " "->":"}];
{sn, ra2000S, dec2000S, dS, stripS}]
:[font = input; preserveAspect; startGroup]
tempL[[1]]
prec[tempL[[1]]]
:[font = output; output; inactive; preserveAspect]
{"20638", "16:01:34.060", "-6:40:30.383", "15.24600", "45"}
;[o]
{20638, 16:01:34.060, -6:40:30.383, 15.24600, 45}
:[font = output; output; inactive; preserveAspect; endGroup]
{"20638", "16:04:14.736", "-06:48:40.359", "15.24600", "45"}
;[o]
{20638, 16:04:14.736, -06:48:40.359, 15.24600, 45}
:[font = input; preserveAspect; startGroup]
tempL[[-1]]
prec[tempL[[-1]]]
:[font = output; output; inactive; preserveAspect]
{"21241", "16:03:01.232", "-6:47:59.719", "15.68700", "47"}
;[o]
{21241, 16:03:01.232, -6:47:59.719, 15.68700, 47}
:[font = output; output; inactive; preserveAspect; endGroup]
{"21241", "16:05:42.061", "-06:56:04.139", "15.68700", "47"}
;[o]
{21241, 16:05:42.061, -06:56:04.139, 15.68700, 47}
:[font = input; preserveAspect; startGroup]
SetDirectory[dir<>"J2000"]
:[font = output; output; inactive; preserveAspect; endGroup]
"Internal HD:Mass Ratio 95:Observing:starlists:J2000"
;[o]
Internal HD:Mass Ratio 95:Observing:starlists:J2000
:[font = input; preserveAspect; startGroup]
fn = "Plu45,46,47.lin.2000.kg"
:[font = output; output; inactive; preserveAspect; endGroup]
"Plu45,46,47.lin.2000.kg"
;[o]
Plu45,46,47.lin.2000.kg
:[font = input; preserveAspect]
t[a_] := StringJoin[Drop[
	Flatten[Transpose[{ToString/@a,Table["\t", {Length[a]}]}]],
	-1] ]
:[font = input; preserveAspect; startGroup]
Options[ OpenWrite ]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{PageWidth -> 78, PageHeight -> 22, 
  TotalWidth -> DirectedInfinity[1], FormatType -> InputForm, 
  TotalHeight -> DirectedInfinity[1], 
  StringConversion :> $StringConversion}
;[o]
{PageWidth -> 78, PageHeight -> 22, TotalWidth -> Infinity, 
  FormatType -> InputForm, TotalHeight -> Infinity, 
  StringConversion :> $StringConversion}
:[font = input; preserveAspect; startGroup]
fp = OpenWrite[ fn, PageWidth->Infinity, FormatType->OutputForm]
:[font = output; output; inactive; preserveAspect; endGroup]
OutputStream["Plu45,46,47.lin.2000.kg", 10]
;[o]
OutputStream[Plu45,46,47.lin.2000.kg, 10]
:[font = input; preserveAspect]
Write[fp, t[headL[[1]]] ]
:[font = input; preserveAspect]
Do[
   Write[fp, t[ prec[ tempL[[i]] ] ] ],
   {i, 1, Length[tempL]}]
:[font = input; preserveAspect; startGroup]
Close[fp]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
"Plu45,46,47.lin.2000.kg"
;[o]
Plu45,46,47.lin.2000.kg
:[font = section; inactive; preserveAspect; startGroup]
converting starlists from J1990.5 to J2000
:[font = input; preserveAspect; startGroup]
dir = "Internal HD:Projects:massratio95:Observing:starlists:"
:[font = output; output; inactive; preserveAspect; endGroup]
"Internal HD:Projects:massratio95:Observing:starlists:"
;[o]
Internal HD:Projects:massratio95:Observing:starlists:
:[font = input; preserveAspect; startGroup]
SetDirectory[dir<>"J1990.5"]
:[font = output; output; inactive; preserveAspect; endGroup]
"Internal HD:Projects:massratio95:Observing:starlists:J1990.5"
;[o]
Internal HD:Projects:massratio95:Observing:starlists:J1990.5
:[font = input; preserveAspect; startGroup]
FileType[ fn = "Plu45-52.lin.ra_select" ]
:[font = output; output; inactive; preserveAspect; endGroup]
File
;[o]
File
:[font = input; preserveAspect]
SetOptions[ ReadList, WordSeparators -> {" ","\t"}, RecordLists -> True];
:[font = input; preserveAspect]
fp = OpenRead[ fn ];
:[font = input; preserveAspect]
headL = {"star number", "ra", "dec", "mag", "strip"};
:[font = input; preserveAspect]
tempL = ReadList[fp, Word];
:[font = input; preserveAspect; startGroup]
Close[fp]
:[font = output; output; inactive; preserveAspect; endGroup]
"Plu45-52.lin.ra_select"
;[o]
Plu45-52.lin.ra_select
:[font = input; preserveAspect; startGroup]
tempL[[1]]
:[font = output; output; inactive; preserveAspect; endGroup]
{"20816", "16:3:1.320", "-6:31:6.156", "45"}
;[o]
{20816, 16:3:1.320, -6:31:6.156, 45}
:[font = input; preserveAspect; startGroup]
tempL[[-1]]
:[font = output; output; inactive; preserveAspect; endGroup]
{"20857", "16:5:59.435", "-7:36:56.331", "52"}
;[o]
{20857, 16:5:59.435, -7:36:56.331, 52}
:[font = input; preserveAspect; startGroup]
tcRadiansToDecString::usage
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
"tcRadiansToDecString[radians_ opts___] converts radians to a Dec string. The\
  option \"numberOfDecimals->n\" can be used, in which case it is passed to a\
  lower level function that produces \"n\" digits to the right of the seconds\
  decimal point."
;[o]
tcRadiansToDecString[radians_ opts___] converts radians to a Dec string. The\
  option "numberOfDecimals->n" can be used, in which case it is passed to a\
  lower level function that produces "n" digits to the right of the seconds\
  decimal point.
:[font = input; preserveAspect; startGroup]
tcRadiansToRAstring::usage
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
"tcRadiansToRAstring[radians_ opts___] converts radians into an RA string The\
  option \"numberOfDecimals->n\" can be used, in which case it is passed to a\
  lower level function that produces \"n\" digits to the right of the seconds\
  decimal point."
;[o]
tcRadiansToRAstring[radians_ opts___] converts radians into an RA string The\
  option "numberOfDecimals->n" can be used, in which case it is passed to a\
  lower level function that produces "n" digits to the right of the seconds\
  decimal point.
:[font = input; preserveAspect; startGroup]
tcFK4B1950ToFK5J2000::usage
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
"tcFK4B1950ToFK5J2000[coordinate_List, opts___] performs the conversion from\
  B1950, FK4, to J2000, FK5, including precession, proper  motion, removal of\
  E-terms, and the small rotation for the FK4->FK5 conversion.  The method on\
  p. B42 of the 1991 AA is used.  The coordinate list should be in the\
  following order: {ra (radians), dec (radians), raProperMotion (arcSeconds\
  per tropical century),  decProperMotion  (arcSeconds per tropical century),\
  parallax  (arcSeconds), radialVelocity (kilometers per second)}.  One can \
  use a list of 2, 4, 5, or 6 elements, and the returned list will  be of the\
  same length.  Unspecified elements will be set to 0.0  for the\
  transformation."
;[o]
tcFK4B1950ToFK5J2000[coordinate_List, opts___] performs the conversion from\
  B1950, FK4, to J2000, FK5, including precession, proper  motion, removal of\
  E-terms, and the small rotation for the FK4->FK5 conversion.  The method on\
  p. B42 of the 1991 AA is used.  The coordinate list should be in the\
  following order: {ra (radians), dec (radians), raProperMotion (arcSeconds\
  per tropical century),  decProperMotion  (arcSeconds per tropical century),\
  parallax  (arcSeconds), radialVelocity (kilometers per second)}.  One can \
  use a list of 2, 4, 5, or 6 elements, and the returned list will  be of the\
  same length.  Unspecified elements will be set to 0.0  for the\
  transformation.
:[font = input; preserveAspect; startGroup]
?tc*
:[font = print; inactive; preserveAspect; endGroup]
tcAzimuthAndAltitude             tcNutateToTrue
tcBesselianEpochToJD             tcObliquityOfEcliptic
tcBesselianEpochToMJD            tcPolarMotion
tcDateTimeStringToJD             tcPolePositionAngle
tcDateTimeStringToMJD            tcPrecess
tcDecStringToRadians             tcPrecessFromFK5J2000
tcDeltaRAandDec                  tcPrecessToFK5J2000
tcEarthCoordinatesToFK4B1950     tcRadiansToDecString
tcEarthCoordinatesToFK5J2000     tcRadiansToHAstring
tcEarthVelocityApproximateJ2000  tcRadiansToRAstring
tcEpochToMJD                     tcRAfk4ToRAfk5
tcEquationOfEquinoxes            tcRAfk5ToRAfk4
tcFK4B1950ToFK5J2000             tcRectangularFK4B1950ToFK5J2000
tcFK4ToFK5                       tcRectangularFK5J2000ToFK4B1950
tcFK5J2000ToFK4B1950             tcRectangularPrecess
tcFK5ToFK4                       tcRectangularPrecessFromFK5J2000
tcGeodeticToGeocentric           tcRectangularPrecessToFK5J2000
tcGMST                           tcRectangularToSpherical
tcHMSstringToRadians             tcRefractionVector
tcHourAngle                      tcRotationMatrixFGtoUV
tcHSTclockToMJD                  tcRotationMatrixUVWtoXYZ
tcInertialFK4B1950ToFK5J2000     tcRotationMatrixXYZtoFGH
tcInertialFK5J2000ToFK4B1950     tcSiderealToSolar
tcJDtoBesselianEpoch             tcSolarToSidereal
tcJDtoDateTimeString             tcSphericalToRectangular
tcJDtoJulianEpoch                tcSubEarthLatitude
tcJDtoMJD                        tcSubEarthOrbitalLongitude
tcJulianEpochToJD                tcSubOccultationLatitude
tcJulianEpochToMJD               tcTDTminusUT
tcLeapSeconds                    tcTDTminusUTcurrent
tcLongitudeObliquityNutation     tcTopocentricToGeocentric
tcMJDtoBesselianEpoch            tcTrakDateTimeToMJD
tcMJDtoDateTimeString            tcTrakLatitudeStringToRadians
tcMJDtoHSTclock                  tcTrakLongitudeStringToRadians
tcMJDtoJD                        tcVMSstringToMJD
tcMJDtoJulianEpoch               tcYeomansFK4B1950ToFK5J2000
tcMJDtoVMSstring                 tcYeomansFK5J2000ToFK4B1950
tcNutate                         tcZenithDistance
tcNutateToMean
:[font = input; preserveAspect; startGroup]
?tcPrecessToFK5J2000
:[font = print; inactive; preserveAspect; endGroup]
tcPrecessToFK5J2000[sphCoor_List, mjd] precesses from the mean equator and
   equinox indicated by the given Modified Julian Date, to the mean equator
   and equinox of J2000.0, in the FK5 system.  The input coordinates are 
   equatorial spherical coordinates, {right ascension (radians), declination 
   (radians), range to object (km)}.
:[font = input; preserveAspect; startGroup]
StringReplace::usage
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
"StringReplace[\"string\", \"s1\" -> \"sp1\"] or StringReplace[\"string\",\
  {\"s1\" -> \"sp1\", \"s2\" -> \"sp2\", ...}] replaces the \"si\" by \"spi\"\
  whenever they appear as substrings of \"string\"."
;[o]
StringReplace["string", "s1" -> "sp1"] or StringReplace["string", {"s1" ->\
  "sp1", "s2" -> "sp2", ...}] replaces the "si" by "spi" whenever they appear\
  as substrings of "string".
:[font = input; preserveAspect]
prec[{sn_,raS_,decS_,stripS_}] := Module[
{ra1990, dec1990,ra2000,dec2000, d2000},
	ra1990 = tcHMSstringToRadians[raS];
	dec1990 = tcDecStringToRadians[decS];
	{ra2000,dec2000, d2000} = tcPrecessToFK5J2000[{ra1990, dec1990, 1},
		tcJulianEpochToMJD[1990.5] ];
	ra2000S = StringReplace[
		tcRadiansToRAstring[ra2000, numberOfDecimals->3],
		{"  "->":0"," "->":"}];
	dec2000S = StringReplace[
		tcRadiansToDecString[dec2000, numberOfDecimals->3],
		{"- "->"-0", "  "->":0", " "->":"}];
{sn, ra2000S, dec2000S, stripS}]
:[font = input; preserveAspect; startGroup]
tempL[[1]]
prec[tempL[[1]]]
:[font = output; output; inactive; preserveAspect]
{"20816", "16:3:1.320", "-6:31:6.156", "45"}
;[o]
{20816, 16:3:1.320, -6:31:6.156, 45}
:[font = output; output; inactive; preserveAspect; endGroup]
{"20816", "16:03:31.800", "-06:32:38.996", "45"}
;[o]
{20816, 16:03:31.800, -06:32:38.996, 45}
:[font = input; preserveAspect; startGroup]
tempL[[-1]]
prec[tempL[[-1]]]
:[font = output; output; inactive; preserveAspect]
{"20857", "16:5:59.435", "-7:36:56.331", "52"}
;[o]
{20857, 16:5:59.435, -7:36:56.331, 52}
:[font = output; output; inactive; preserveAspect; endGroup]
{"20857", "16:06:30.141", "-07:38:27.008", "52"}
;[o]
{20857, 16:06:30.141, -07:38:27.008, 52}
:[font = input; preserveAspect; startGroup]
SetDirectory[dir<>"J2000"]
:[font = output; output; inactive; preserveAspect; endGroup]
"Internal HD:Projects:massratio95:Observing:starlists:J2000"
;[o]
Internal HD:Projects:massratio95:Observing:starlists:J2000
:[font = input; preserveAspect; startGroup]
fn = "Plu45-52.lin.2000"
:[font = output; output; inactive; preserveAspect; endGroup]
"Plu45-52.lin.2000"
;[o]
Plu45-52.lin.2000
:[font = input; preserveAspect]
t[a_] := StringJoin[Drop[
	Flatten[Transpose[{ToString/@a,Table["\t", {Length[a]}]}]],
	-1] ]
:[font = input; preserveAspect; startGroup]
Options[ OpenWrite ]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{PageWidth -> 78, PageHeight -> 22, TotalWidth -> DirectedInfinity[1], 
  FormatType -> InputForm, TotalHeight -> DirectedInfinity[1], 
  StringConversion :> $StringConversion}
;[o]
{PageWidth -> 78, PageHeight -> 22, TotalWidth -> Infinity, 
  FormatType -> InputForm, TotalHeight -> Infinity, 
  StringConversion :> $StringConversion}
:[font = input; preserveAspect; startGroup]
fp = OpenWrite[ fn, PageWidth->Infinity, FormatType->OutputForm]
:[font = output; output; inactive; preserveAspect; endGroup]
OutputStream["Plu45-52.lin.2000", 12]
;[o]
OutputStream[Plu45-52.lin.2000, 12]
:[font = input; preserveAspect]
Write[fp, t[headL] ]
:[font = input; preserveAspect]
Do[
   Write[fp, t[ prec[ tempL[[i]] ] ] ],
   {i, 1, Length[tempL]}]
:[font = input; preserveAspect; startGroup]
Close[fp]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
"Plu45-52.lin.2000"
;[o]
Plu45-52.lin.2000
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
row, column 
:[font = subsection; inactive; preserveAspect; startGroup]
make xiL, etaL
:[font = input; preserveAspect; startGroup]
SetDirectory[dir = "Internal HD:Mass Ratio 95:Observing:"]
:[font = output; output; inactive; preserveAspect; endGroup]
"Internal HD:Mass Ratio 95:Observing"
;[o]
Internal HD:Mass Ratio 95:Observing
:[font = input; preserveAspect; startGroup]
FileType[ fn = "20min.eph" ]
:[font = output; output; inactive; preserveAspect; endGroup]
File
;[o]
File
:[font = input; preserveAspect; startGroup]
fp = OpenRead[ fn ]
:[font = output; output; inactive; preserveAspect; endGroup]
InputStream["20min.eph", 3]
;[o]
InputStream[20min.eph, 3]
:[font = input; preserveAspect]
s = "";
While[ (s=Read[ fp, String ]) != "END", ];
While[ (s=Read[ fp, String ]) != "END", ];
:[font = input; preserveAspect]
s = ReadList[ fp, 
{Table[Word,{6}], Table[Word,{3}], Table[Word,{3}], Word}];
:[font = input; preserveAspect]
Close[fp];
:[font = input; preserveAspect; startGroup]
s[[1]]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{{"1995", "02", "22", "14", "00", "00.000"}, 
  {"16", "05", "15.390969"}, {"-06", "56", "37.96638"}, "29.757289\
   374"}
;[o]
{{1995, 02, 22, 14, 00, 00.000}, {16, 05, 15.390969}, 
  {-06, 56, 37.96638}, 29.757289374}
:[font = input; preserveAspect]
aC = tcHMSstringToRadians["16 02 38.93587"];
dC = tcDecStringToRadians["-05 08 15.99185"];
:[font = input; preserveAspect]
ra2rad[{h_,m_,s_}] := tcHMSstringToRadians[h<>" "<>m<>" "<>s];
dec2rad[{d_,m_,s_}] := tcDecStringToRadians[d<>" "<>m<>" "<>s];
:[font = input; preserveAspect]
aL = Map[ ra2rad[ #[[2]] ]&, s];
dL = Map[ dec2rad[ #[[3]] ]&, s];
:[font = input; preserveAspect; startGroup]
xiL = 206265 * Cos[dL]*Sin[aL-aC] /
(Sin[dC] Sin[dL] + Cos[dC] Cos[dL] Cos[aL-aC] )
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{2330.871660861202057, 2331.200614773069741, 2331.529181474467684, 
  2331.857346055754045, 2332.18512343648311, 2353.553568815262877, 
  2353.854255713883432, 2354.154570280636975, 
  2354.454467827303496, 2354.753993041805537, 
  2374.198357342241693, 2374.470716720663319, 2374.7427037668742, 
  2375.014273771464398, 2375.285471443543751, 
  2392.801818959290566, 2393.045820110037511, 2393.28941910765989, 
  2393.532615951996045, 2393.775425553150903, 
  2409.360832160966888, 2409.576414538043102, 
  2409.791609650464294, 2410.006387698168743, 
  2410.220793380850912, 2423.873450972203816, 
  2424.060598712974275, 2424.247359166994748, 
  2424.433717455206626, 2424.619688466955038, 
  2436.339039289699805, 2436.497751407625509, 
  2436.656091138049813, 2436.814013779987603, 
  2436.971549133824469, 2446.758330696484522, 
  2446.888650905787788, 2447.018568915130981, 
  2447.148099624783398, 2447.27722812343532, 2455.133428717575786, 
  2455.235370923490031, 2455.336925807282666, 
  2455.438078468191781, 2455.538843817390765, 
  2461.467658075432328, 2461.541280856871489, 
  2461.614516304230281, 2461.687364417343407, 
  2461.759810295288148, 2465.765490338620115, 
  2465.810867182099897, 2465.855856679492532, 
  2465.900443929719504, 2465.944643833523247, 
  2468.032365370496344, 2468.049584661602124, 
  2468.066416594584033, 2468.082846257408571, 
  2468.098888572570668, 2468.274676576698869, 
  2468.263811799713408, 2468.252574542966398, 
  2468.240935014652022, 2468.228908105022375, 
  2466.499517711690338, 2466.460687044983447, 
  2466.421483886620106, 2466.381878444481036, 
  2466.341900521146009, 2462.714742637667275, 
  2462.648064284570054, 2462.580998515643046, 
  2462.513560253793181, 2462.445719685030169, 
  2456.928846249044891, 2456.834438385051262, 
  2456.739658005679601, 2456.644475307419273, 2456.54892010419838}
;[o]
{2330.87, 2331.2, 2331.53, 2331.86, 2332.19, 2353.55, 2353.85, 
  2354.15, 2354.45, 2354.75, 2374.2, 2374.47, 2374.74, 2375.01, 
  2375.29, 2392.8, 2393.05, 2393.29, 2393.53, 2393.78, 2409.36, 
  2409.58, 2409.79, 2410.01, 2410.22, 2423.87, 2424.06, 2424.25, 
  2424.43, 2424.62, 2436.34, 2436.5, 2436.66, 2436.81, 2436.97, 
  2446.76, 2446.89, 2447.02, 2447.15, 2447.28, 2455.13, 2455.24, 
  2455.34, 2455.44, 2455.54, 2461.47, 2461.54, 2461.61, 2461.69, 
  2461.76, 2465.77, 2465.81, 2465.86, 2465.9, 2465.94, 2468.03, 
  2468.05, 2468.07, 2468.08, 2468.1, 2468.27, 2468.26, 2468.25, 
  2468.24, 2468.23, 2466.5, 2466.46, 2466.42, 2466.38, 2466.34, 
  2462.71, 2462.65, 2462.58, 2462.51, 2462.45, 2456.93, 2456.83, 
  2456.74, 2456.64, 2456.55}
:[font = input; preserveAspect; startGroup]
etaL = 206265 * (Cos[dC] Sin[dL] - Sin[dC] Cos[dL] Cos[aL-aC]) /
(Sin[dC] Sin[dL] + Cos[dC] Cos[dL] Cos[aL-aC] )
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup; endGroup]
{-6505.739004278695871, -6505.46900062393803, 
  -6505.198916427713662, -6504.928761679899535, 
  -6504.658516379637422, -6486.096000976062491, 
  -6485.820297418064493, -6485.544523336347609, 
  -6485.268668658120995, -6484.99274345582364, 
  -6466.047093406267267, -6465.765819075755639, 
  -6465.484464199158297, -6465.203038724238726, 
  -6464.921532702924864, -6445.600842155925379, 
  -6445.31410630995918, -6445.027299875990968, 
  -6444.740422853880439, -6444.453465254058507, 
  -6424.766097241162163, -6424.474029221890087, 
  -6424.181890626559353, -6423.889681412793883, 
  -6423.597401643868291, -6403.552028310435012, 
  -6403.254757629277009, -6402.957426374821933, 
  -6402.660014505083764, -6402.36253205153343, 
  -6381.968074808402732, -6381.665741114802659, 
  -6381.363336852831784, -6381.060861958432251, 
  -6380.758316474186299, -6360.023926044565916, 
  -6359.716659148003563, -6359.409321635753654, 
  -6359.101913529162502, -6358.794444816983248, 
  -6337.729461110867245, -6337.417390883958958, 
  -6337.10526006979375, -6336.793068646883144, 
  -6336.480806626501506, -6315.094678549207563, 
  -6314.777955053905321, -6314.461170969626572, 
  -6314.144326296357245, -6313.827421012594095, 
  -6292.129716191470508, -6291.80847960464923, 
  -6291.487182428575854, -6291.165824641750274, 
  -6290.844406265685269, -6268.844760715163315, 
  -6268.519151337357563, -6268.193481371450899, 
  -6267.867760805913073, -6267.541969642377209, 
  -6245.25004750752384, -6244.92020571821545, 
  -6244.590313374731491, -6244.260360424262415, 
  -6243.93035689821915, -6221.355870178413576, 
  -6221.021946529940642, -6220.687972331126746, 
  -6220.353937529325394, -6220.019842167501405, 
  -6197.172550471270021, -6196.834675592684731, 
  -6196.496760157278932, -6196.158784167054695, 
  -6195.820757589041566, -6172.710417914910912, 
  -6172.368752558712102, -6172.027036663847075, 
  -6171.685270187768365, -6171.343443163562769}
;[o]
{-6505.74, -6505.47, -6505.2, -6504.93, -6504.66, -6486.1, 
  -6485.82, -6485.54, -6485.27, -6484.99, -6466.05, -6465.77, 
  -6465.48, -6465.2, -6464.92, -6445.6, -6445.31, -6445.03, 
  -6444.74, -6444.45, -6424.77, -6424.47, -6424.18, -6423.89, 
  -6423.6, -6403.55, -6403.25, -6402.96, -6402.66, -6402.36, 
  -6381.97, -6381.67, -6381.36, -6381.06, -6380.76, -6360.02, 
  -6359.72, -6359.41, -6359.1, -6358.79, -6337.73, -6337.42, 
  -6337.11, -6336.79, -6336.48, -6315.09, -6314.78, -6314.46, 
  -6314.14, -6313.83, -6292.13, -6291.81, -6291.49, -6291.17, 
  -6290.84, -6268.84, -6268.52, -6268.19, -6267.87, -6267.54, 
  -6245.25, -6244.92, -6244.59, -6244.26, -6243.93, -6221.36, 
  -6221.02, -6220.69, -6220.35, -6220.02, -6197.17, -6196.83, 
  -6196.5, -6196.16, -6195.82, -6172.71, -6172.37, -6172.03, 
  -6171.69, -6171.34}
:[font = subsection; inactive; preserveAspect; startGroup]
(* FIRST ORDER *)
:[font = subsubsection; inactive; preserveAspect; startGroup]
Q&D xL, yL
:[font = input; preserveAspect; endGroup]
xL = xiL / 67.21385;
yL = etaL / 67.22424;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
turn xL, yL to colL, rowL
:[font = input; preserveAspect]
xC = 1.7536856856692 10^5;
yC = 1.7968494035345 10^5;
:[font = input; preserveAspect]
px = 25.28445;
py = 25.28445;
:[font = input; preserveAspect]
cnpix1 = 4982;
cnpix2 = 2833;
:[font = input; preserveAspect]
colL = (xC - 1000 xL)/px - cnpix1 + 1;
rowL = (yC + 1000 yL)/py - cnpix2 + 1;
:[font = input; preserveAspect; startGroup]
ListPlot[ Transpose[{colL, rowL}],
PlotRange->{{1,1059},{1,1059}}, 
AspectRatio->1, Frame->True];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00094518 0.00094518 -0.00094518 0.00094518 [
[(200)] .18809 0 0 2 Msboxa
[(400)] .37713 0 0 2 Msboxa
[(600)] .56616 0 0 2 Msboxa
[(800)] .7552 0 0 2 Msboxa
[(1000)] .94423 0 0 2 Msboxa
[(200)] -0.0125 .18809 1 0 Msboxa
[(400)] -0.0125 .37713 1 0 Msboxa
[(600)] -0.0125 .56616 1 0 Msboxa
[(800)] -0.0125 .7552 1 0 Msboxa
[(1000)] -0.0125 .94423 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.18809 0 m
.18809 .00625 L
s
P
[(200)] .18809 0 0 2 Mshowa
p
.002 w
.37713 0 m
.37713 .00625 L
s
P
[(400)] .37713 0 0 2 Mshowa
p
.002 w
.56616 0 m
.56616 .00625 L
s
P
[(600)] .56616 0 0 2 Mshowa
p
.002 w
.7552 0 m
.7552 .00625 L
s
P
[(800)] .7552 0 0 2 Mshowa
p
.002 w
.94423 0 m
.94423 .00625 L
s
P
[(1000)] .94423 0 0 2 Mshowa
p
.001 w
.03686 0 m
.03686 .00375 L
s
P
p
.001 w
.07467 0 m
.07467 .00375 L
s
P
p
.001 w
.11248 0 m
.11248 .00375 L
s
P
p
.001 w
.15028 0 m
.15028 .00375 L
s
P
p
.001 w
.2259 0 m
.2259 .00375 L
s
P
p
.001 w
.26371 0 m
.26371 .00375 L
s
P
p
.001 w
.30151 0 m
.30151 .00375 L
s
P
p
.001 w
.33932 0 m
.33932 .00375 L
s
P
p
.001 w
.41493 0 m
.41493 .00375 L
s
P
p
.001 w
.45274 0 m
.45274 .00375 L
s
P
p
.001 w
.49055 0 m
.49055 .00375 L
s
P
p
.001 w
.52836 0 m
.52836 .00375 L
s
P
p
.001 w
.60397 0 m
.60397 .00375 L
s
P
p
.001 w
.64178 0 m
.64178 .00375 L
s
P
p
.001 w
.67958 0 m
.67958 .00375 L
s
P
p
.001 w
.71739 0 m
.71739 .00375 L
s
P
p
.001 w
.79301 0 m
.79301 .00375 L
s
P
p
.001 w
.83081 0 m
.83081 .00375 L
s
P
p
.001 w
.86862 0 m
.86862 .00375 L
s
P
p
.001 w
.90643 0 m
.90643 .00375 L
s
P
p
.001 w
.98204 0 m
.98204 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .18809 m
.00625 .18809 L
s
P
[(200)] -0.0125 .18809 1 0 Mshowa
p
.002 w
0 .37713 m
.00625 .37713 L
s
P
[(400)] -0.0125 .37713 1 0 Mshowa
p
.002 w
0 .56616 m
.00625 .56616 L
s
P
[(600)] -0.0125 .56616 1 0 Mshowa
p
.002 w
0 .7552 m
.00625 .7552 L
s
P
[(800)] -0.0125 .7552 1 0 Mshowa
p
.002 w
0 .94423 m
.00625 .94423 L
s
P
[(1000)] -0.0125 .94423 1 0 Mshowa
p
.001 w
0 .03686 m
.00375 .03686 L
s
P
p
.001 w
0 .07467 m
.00375 .07467 L
s
P
p
.001 w
0 .11248 m
.00375 .11248 L
s
P
p
.001 w
0 .15028 m
.00375 .15028 L
s
P
p
.001 w
0 .2259 m
.00375 .2259 L
s
P
p
.001 w
0 .26371 m
.00375 .26371 L
s
P
p
.001 w
0 .30151 m
.00375 .30151 L
s
P
p
.001 w
0 .33932 m
.00375 .33932 L
s
P
p
.001 w
0 .41493 m
.00375 .41493 L
s
P
p
.001 w
0 .45274 m
.00375 .45274 L
s
P
p
.001 w
0 .49055 m
.00375 .49055 L
s
P
p
.001 w
0 .52836 m
.00375 .52836 L
s
P
p
.001 w
0 .60397 m
.00375 .60397 L
s
P
p
.001 w
0 .64178 m
.00375 .64178 L
s
P
p
.001 w
0 .67958 m
.00375 .67958 L
s
P
p
.001 w
0 .71739 m
.00375 .71739 L
s
P
p
.001 w
0 .79301 m
.00375 .79301 L
s
P
p
.001 w
0 .83081 m
.00375 .83081 L
s
P
p
.001 w
0 .86862 m
.00375 .86862 L
s
P
p
.001 w
0 .90643 m
.00375 .90643 L
s
P
p
.001 w
0 .98204 m
.00375 .98204 L
s
P
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.18809 .99375 m
.18809 1 L
s
P
p
.002 w
.37713 .99375 m
.37713 1 L
s
P
p
.002 w
.56616 .99375 m
.56616 1 L
s
P
p
.002 w
.7552 .99375 m
.7552 1 L
s
P
p
.002 w
.94423 .99375 m
.94423 1 L
s
P
p
.001 w
.03686 .99625 m
.03686 1 L
s
P
p
.001 w
.07467 .99625 m
.07467 1 L
s
P
p
.001 w
.11248 .99625 m
.11248 1 L
s
P
p
.001 w
.15028 .99625 m
.15028 1 L
s
P
p
.001 w
.2259 .99625 m
.2259 1 L
s
P
p
.001 w
.26371 .99625 m
.26371 1 L
s
P
p
.001 w
.30151 .99625 m
.30151 1 L
s
P
p
.001 w
.33932 .99625 m
.33932 1 L
s
P
p
.001 w
.41493 .99625 m
.41493 1 L
s
P
p
.001 w
.45274 .99625 m
.45274 1 L
s
P
p
.001 w
.49055 .99625 m
.49055 1 L
s
P
p
.001 w
.52836 .99625 m
.52836 1 L
s
P
p
.001 w
.60397 .99625 m
.60397 1 L
s
P
p
.001 w
.64178 .99625 m
.64178 1 L
s
P
p
.001 w
.67958 .99625 m
.67958 1 L
s
P
p
.001 w
.71739 .99625 m
.71739 1 L
s
P
p
.001 w
.79301 .99625 m
.79301 1 L
s
P
p
.001 w
.83081 .99625 m
.83081 1 L
s
P
p
.001 w
.86862 .99625 m
.86862 1 L
s
P
p
.001 w
.90643 .99625 m
.90643 1 L
s
P
p
.001 w
.98204 .99625 m
.98204 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .18809 m
1 .18809 L
s
P
p
.002 w
.99375 .37713 m
1 .37713 L
s
P
p
.002 w
.99375 .56616 m
1 .56616 L
s
P
p
.002 w
.99375 .7552 m
1 .7552 L
s
P
p
.002 w
.99375 .94423 m
1 .94423 L
s
P
p
.001 w
.99625 .03686 m
1 .03686 L
s
P
p
.001 w
.99625 .07467 m
1 .07467 L
s
P
p
.001 w
.99625 .11248 m
1 .11248 L
s
P
p
.001 w
.99625 .15028 m
1 .15028 L
s
P
p
.001 w
.99625 .2259 m
1 .2259 L
s
P
p
.001 w
.99625 .26371 m
1 .26371 L
s
P
p
.001 w
.99625 .30151 m
1 .30151 L
s
P
p
.001 w
.99625 .33932 m
1 .33932 L
s
P
p
.001 w
.99625 .41493 m
1 .41493 L
s
P
p
.001 w
.99625 .45274 m
1 .45274 L
s
P
p
.001 w
.99625 .49055 m
1 .49055 L
s
P
p
.001 w
.99625 .52836 m
1 .52836 L
s
P
p
.001 w
.99625 .60397 m
1 .60397 L
s
P
p
.001 w
.99625 .64178 m
1 .64178 L
s
P
p
.001 w
.99625 .67958 m
1 .67958 L
s
P
p
.001 w
.99625 .71739 m
1 .71739 L
s
P
p
.001 w
.99625 .79301 m
1 .79301 L
s
P
p
.001 w
.99625 .83081 m
1 .83081 L
s
P
p
.001 w
.99625 .86862 m
1 .86862 L
s
P
p
.001 w
.99625 .90643 m
1 .90643 L
s
P
p
.001 w
.99625 .98204 m
1 .98204 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
.008 w
.55037 .42157 Mdot
.55019 .42172 Mdot
.55001 .42187 Mdot
.54982 .42202 Mdot
.54964 .42217 Mdot
.53776 .43249 Mdot
.53759 .43265 Mdot
.53742 .4328 Mdot
.53726 .43295 Mdot
.53709 .43311 Mdot
.52628 .44364 Mdot
.52612 .4438 Mdot
.52597 .44396 Mdot
.52582 .44411 Mdot
.52567 .44427 Mdot
.51593 .45501 Mdot
.51579 .45517 Mdot
.51566 .45533 Mdot
.51552 .45549 Mdot
.51539 .45565 Mdot
.50672 .4666 Mdot
.5066 .46676 Mdot
.50648 .46692 Mdot
.50636 .46709 Mdot
.50624 .46725 Mdot
.49865 .47839 Mdot
.49854 .47856 Mdot
.49844 .47872 Mdot
.49834 .47889 Mdot
.49823 .47906 Mdot
.49172 .4904 Mdot
.49163 .49056 Mdot
.49154 .49073 Mdot
.49145 .4909 Mdot
.49136 .49107 Mdot
.48592 .5026 Mdot
.48585 .50277 Mdot
.48578 .50294 Mdot
.4857 .50311 Mdot
.48563 .50328 Mdot
.48126 .515 Mdot
.48121 .51517 Mdot
.48115 .51534 Mdot
.48109 .51552 Mdot
.48104 .51569 Mdot
.47774 .52758 Mdot
.4777 .52776 Mdot
.47766 .52794 Mdot
.47762 .52811 Mdot
.47758 .52829 Mdot
.47535 .54035 Mdot
.47532 .54053 Mdot
.4753 .54071 Mdot
.47527 .54089 Mdot
.47525 .54107 Mdot
.47409 .5533 Mdot
.47408 .55348 Mdot
.47407 .55366 Mdot
.47406 .55385 Mdot
.47405 .55403 Mdot
.47395 .56642 Mdot
.47396 .56661 Mdot
.47397 .56679 Mdot
.47397 .56697 Mdot
.47398 .56716 Mdot
.47494 .57971 Mdot
.47496 .5799 Mdot
.47499 .58008 Mdot
.47501 .58027 Mdot
.47503 .58045 Mdot
.47705 .59316 Mdot
.47708 .59335 Mdot
.47712 .59353 Mdot
.47716 .59372 Mdot
.4772 .59391 Mdot
.48026 .60676 Mdot
.48032 .60695 Mdot
.48037 .60714 Mdot
.48042 .60733 Mdot
.48048 .60752 Mdot
P
% End of Graphics
MathPictureEnd

:[font = input; preserveAspect; startGroup]
TableForm[ Transpose[{colL, rowL}] ]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
TableForm[{{583.2944831271140549, 447.0215630622899015}, 
   {583.1009199366869002, 447.1804141638028261}, 
   {582.9075845887969089, 447.3393126502323989}, 
   {582.7144858565814078, 447.4982526442399213}, 
   {582.5216149610703864, 447.6572459129193006}, 
   {569.947985912242729, 458.5781203779449709}, 
   {569.7710556088874929, 458.7403249003922456}, 
   {569.5943443931961396, 458.9025709140202156}, 
   {569.4178785606286959, 459.0648643449483708}, 
   {569.2416318159001727, 459.2271992672642276}, 
   {557.8001713132684753, 470.3734831275682744}, 
   {557.6399095005095745, 470.5389650995406743}, 
   {557.4798667756168173, 470.704494459147325}, 
   {557.3200694465188136, 470.870065353826015}, 
   {557.160491205463539, 471.0356836363205017}, 
   {546.8535150989064024, 482.4026148659508093}, 
   {546.709939845648818, 482.5713100083029454}, 
   {546.5666012274912369, 482.7400466796554337}, 
   {546.4234992445287817, 482.9088248800908183}, 
   {546.2806251233516366, 483.077650486766778}, 
   {537.1098540266189057, 494.6603088679792533}, 
   {536.9830009593614885, 494.832141084916014}, 
   {536.8563757665249585, 495.0040148238264974}, 
   {536.7299959830733767, 495.1759301096418007}, 
   {536.6038353067949141, 495.3478869051356039}, 
   {528.5703331478215192, 507.1411703594263847}, 
   {528.4602116004622196, 507.3160634555653914}, 
   {528.3503179405249357, 507.4909921887589068}, 
   {528.2406609231511951, 507.6659683502975302}, 
   {528.1312317871466723, 507.8409860383714949}, 
   {521.2353267586695606, 519.8396458370143811}, 
   {521.1419373117080451, 520.0175176524752345}, 
   {521.048766985146822, 520.1954309853868201}, 
   {520.9558420819571643, 520.373385873436261}, 
   {520.8631450669844405, 520.5513822915711713}, 
   {515.1044032039476837, 532.7500347946206518}, 
   {515.0277201350440337, 532.9308089586635942}, 
   {514.9512737287993551, 533.111624667995107}, 
   {514.8750552175913162, 533.2924819100565274}, 
   {514.799073375538657, 533.4733748081702205}, 
   {510.1763247266361283, 545.866525071522966}, 
   {510.1163398536674181, 546.0501251762631421}, 
   {510.0565828889341091, 546.2337609262708171}, 
   {509.9970626003483933, 546.4174323341882937}, 
   {509.9377702138717527, 546.6011452766770253}, 
   {506.449134992235805, 559.1832342310709891}, 
   {506.4058138461744161, 559.3695719906428296}, 
   {506.3627206153852058, 559.5559453964938521}, 
   {506.3198552999654374, 559.7423544486323353}, 
   {506.2772266679219286, 559.9287991597092708}, 
   {503.9202028386093555, 572.6941978882155133}, 
   {503.8935021784907637, 572.883190832435393}, 
   {503.8670294407093828, 573.0722194230965929}, 
   {503.8407933933637049, 573.2612836728482588}, 
   {503.8147852685529955, 573.4503835690337894}, 
   {502.5863273392168624, 586.3934229205885002}, 
   {502.5761951571600963, 586.5849885065201839}, 
   {502.5662909045231954, 586.7765897382159112}, 
   {502.5566233558507867, 586.9682207391647746}, 
   {502.5471837304425247, 587.159893274994946}, 
   {502.4437464837939342, 600.274887548452921}, 
   {502.4501395401483794, 600.4689431867131664}, 
   {502.4567517711908704, 600.6630285674836842}, 
   {502.4636007070275232, 600.8571496051283798}, 
   {502.4706775859303338, 601.0513003978727864}, 
   {503.4882861625447608, 614.3325357379876441}, 
   {503.5111349187474911, 614.5289928542022899}, 
   {503.5342028566374699, 614.7254797106711961}, 
   {503.557507506505261, 614.9220022216623381}, 
   {503.5810313319051321, 615.1185603618982474}, 
   {505.7153250027812854, 628.5602949035602607}, 
   {505.7545599055816443, 628.7590766448109709}, 
   {505.794022771757207, 628.957882246833556}, 
   {505.8337048203651962, 629.1567234750391251}, 
   {505.8736235945655264, 629.3555944655306742}, 
   {509.1198644353847711, 642.9520878791698943}, 
   {509.1754159479120645, 643.153099670027554}, 
   {509.2311866560848678, 643.3541411942708768}, 
   {509.2871940968966529, 643.5552124769317912}, 
   {509.3434207272240983, 643.7563193818388522}}]
;[o]
583.294   447.022

583.101   447.18

582.908   447.339

582.714   447.498

582.522   447.657

569.948   458.578

569.771   458.74

569.594   458.903

569.418   459.065

569.242   459.227

557.8     470.373

557.64    470.539

557.48    470.704

557.32    470.87

557.16    471.036

546.854   482.403

546.71    482.571

546.567   482.74

546.423   482.909

546.281   483.078

537.11    494.66

536.983   494.832

536.856   495.004

536.73    495.176

536.604   495.348

528.57    507.141

528.46    507.316

528.35    507.491

528.241   507.666

528.131   507.841

521.235   519.84

521.142   520.018

521.049   520.195

520.956   520.373

520.863   520.551

515.104   532.75

515.028   532.931

514.951   533.112

514.875   533.292

514.799   533.473

510.176   545.867

510.116   546.05

510.057   546.234

509.997   546.417

509.938   546.601

506.449   559.183

506.406   559.37

506.363   559.556

506.32    559.742

506.277   559.929

503.92    572.694

503.894   572.883

503.867   573.072

503.841   573.261

503.815   573.45

502.586   586.393

502.576   586.585

502.566   586.777

502.557   586.968

502.547   587.16

502.444   600.275

502.45    600.469

502.457   600.663

502.464   600.857

502.471   601.051

503.488   614.333

503.511   614.529

503.534   614.725

503.558   614.922

503.581   615.119

505.715   628.56

505.755   628.759

505.794   628.958

505.834   629.157

505.874   629.356

509.12    642.952

509.175   643.153

509.231   643.354

509.287   643.555

509.343   643.756
:[font = subsection; inactive; preserveAspect; startGroup]
full solution
:[font = subsubsection; inactive; preserveAspect; startGroup]
real xL, yL
:[font = input; preserveAspect]
a1 =  6.7213849136695 10^+1;
a2 = -2.3912078021337 10^-1;
a3 =  4.4567466443758 10^-1;
a4 = -1.3669787892875 10^-5;
a5 =  1.8005154685454 10^-5;
a7 =  0.0000000000000 10^+0;
a6 = -2.2572468977685 10^-5;
a8 =  2.2414131463519 10^-6;
a9 =  9.2920506836059 10^-8;
a10=  2.3086667701812 10^-6;
a11=  1.0169680301478 10^-8;

b1 =  6.7224241497957 10^+1;
b2 =  2.3578518375365 10^-1;
b3 = -6.0674935431172 10^-1;
b4 =  6.2113406400604 10^-6;
b5 = -1.6544594420210 10^-5;
b6 =  7.0065719687344 10^-6;
b7 =  0.0000000000000 10^+0;
b8 =  2.1889891887397 10^-6;
b9 =  1.7888081730558 10^-7;
b10=  2.2380519238055 10^-6;
b11= -1.0415953862357 10^-7;
:[font = input; preserveAspect]
xiF[x_, y_] := a1 x + a2 y + a3 + a4 x^2 + a5 x y + a6 y^2 +
      a8 x^3 + a9 x^2 y + a10 x y^2 + a11 y^3;
etaF[x_, y_]:= b1 y + b2 x + b3 + b4 y^2 + b5 x y + b6 x^2 +
      b8 y^3 + b9 x y^2 + b10 x^2 y + b11 x^3;
:[font = input; preserveAspect; startGroup]
n = Length[ xiL ]
:[font = output; output; inactive; preserveAspect; endGroup]
80
;[o]
80
:[font = input; preserveAspect]
xL = yL = Table[0, {n}];
:[font = input; preserveAspect]
solnL = Table[
FindRoot[{xiL[[i]] == xiF[x,y], etaL[[i]] == etaF[x,y]},
	{x, xiL[[i]]/67.21385}, {y,  etaL[[i]] / 67.22424}], {i, n}];
:[font = input; preserveAspect; endGroup]
xL = x /. solnL;
yL = y /. solnL;
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
turn xL, yL to colL, rowL
:[font = input; preserveAspect]
xC = 1.7536856856692 10^5;
yC = 1.7968494035345 10^5;
:[font = input; preserveAspect]
px = 25.28445;
py = 25.28445;
:[font = input; preserveAspect]
cnpix1 = 4982;
cnpix2 = 2833;
:[font = input; preserveAspect]
colL = (xC - 1000 xL)/px - cnpix1 + 1;
rowL = (yC + 1000 yL)/py - cnpix2 + 1;
:[font = input; preserveAspect; startGroup]
ListPlot[ Transpose[{colL, rowL}],
PlotRange->{{1,1059},{1,1059}}, 
AspectRatio->1, Frame->True];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00094518 0.00094518 -0.00094518 0.00094518 [
[(200)] .18809 0 0 2 Msboxa
[(400)] .37713 0 0 2 Msboxa
[(600)] .56616 0 0 2 Msboxa
[(800)] .7552 0 0 2 Msboxa
[(1000)] .94423 0 0 2 Msboxa
[(200)] -0.0125 .18809 1 0 Msboxa
[(400)] -0.0125 .37713 1 0 Msboxa
[(600)] -0.0125 .56616 1 0 Msboxa
[(800)] -0.0125 .7552 1 0 Msboxa
[(1000)] -0.0125 .94423 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.18809 0 m
.18809 .00625 L
s
P
[(200)] .18809 0 0 2 Mshowa
p
.002 w
.37713 0 m
.37713 .00625 L
s
P
[(400)] .37713 0 0 2 Mshowa
p
.002 w
.56616 0 m
.56616 .00625 L
s
P
[(600)] .56616 0 0 2 Mshowa
p
.002 w
.7552 0 m
.7552 .00625 L
s
P
[(800)] .7552 0 0 2 Mshowa
p
.002 w
.94423 0 m
.94423 .00625 L
s
P
[(1000)] .94423 0 0 2 Mshowa
p
.001 w
.03686 0 m
.03686 .00375 L
s
P
p
.001 w
.07467 0 m
.07467 .00375 L
s
P
p
.001 w
.11248 0 m
.11248 .00375 L
s
P
p
.001 w
.15028 0 m
.15028 .00375 L
s
P
p
.001 w
.2259 0 m
.2259 .00375 L
s
P
p
.001 w
.26371 0 m
.26371 .00375 L
s
P
p
.001 w
.30151 0 m
.30151 .00375 L
s
P
p
.001 w
.33932 0 m
.33932 .00375 L
s
P
p
.001 w
.41493 0 m
.41493 .00375 L
s
P
p
.001 w
.45274 0 m
.45274 .00375 L
s
P
p
.001 w
.49055 0 m
.49055 .00375 L
s
P
p
.001 w
.52836 0 m
.52836 .00375 L
s
P
p
.001 w
.60397 0 m
.60397 .00375 L
s
P
p
.001 w
.64178 0 m
.64178 .00375 L
s
P
p
.001 w
.67958 0 m
.67958 .00375 L
s
P
p
.001 w
.71739 0 m
.71739 .00375 L
s
P
p
.001 w
.79301 0 m
.79301 .00375 L
s
P
p
.001 w
.83081 0 m
.83081 .00375 L
s
P
p
.001 w
.86862 0 m
.86862 .00375 L
s
P
p
.001 w
.90643 0 m
.90643 .00375 L
s
P
p
.001 w
.98204 0 m
.98204 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .18809 m
.00625 .18809 L
s
P
[(200)] -0.0125 .18809 1 0 Mshowa
p
.002 w
0 .37713 m
.00625 .37713 L
s
P
[(400)] -0.0125 .37713 1 0 Mshowa
p
.002 w
0 .56616 m
.00625 .56616 L
s
P
[(600)] -0.0125 .56616 1 0 Mshowa
p
.002 w
0 .7552 m
.00625 .7552 L
s
P
[(800)] -0.0125 .7552 1 0 Mshowa
p
.002 w
0 .94423 m
.00625 .94423 L
s
P
[(1000)] -0.0125 .94423 1 0 Mshowa
p
.001 w
0 .03686 m
.00375 .03686 L
s
P
p
.001 w
0 .07467 m
.00375 .07467 L
s
P
p
.001 w
0 .11248 m
.00375 .11248 L
s
P
p
.001 w
0 .15028 m
.00375 .15028 L
s
P
p
.001 w
0 .2259 m
.00375 .2259 L
s
P
p
.001 w
0 .26371 m
.00375 .26371 L
s
P
p
.001 w
0 .30151 m
.00375 .30151 L
s
P
p
.001 w
0 .33932 m
.00375 .33932 L
s
P
p
.001 w
0 .41493 m
.00375 .41493 L
s
P
p
.001 w
0 .45274 m
.00375 .45274 L
s
P
p
.001 w
0 .49055 m
.00375 .49055 L
s
P
p
.001 w
0 .52836 m
.00375 .52836 L
s
P
p
.001 w
0 .60397 m
.00375 .60397 L
s
P
p
.001 w
0 .64178 m
.00375 .64178 L
s
P
p
.001 w
0 .67958 m
.00375 .67958 L
s
P
p
.001 w
0 .71739 m
.00375 .71739 L
s
P
p
.001 w
0 .79301 m
.00375 .79301 L
s
P
p
.001 w
0 .83081 m
.00375 .83081 L
s
P
p
.001 w
0 .86862 m
.00375 .86862 L
s
P
p
.001 w
0 .90643 m
.00375 .90643 L
s
P
p
.001 w
0 .98204 m
.00375 .98204 L
s
P
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.18809 .99375 m
.18809 1 L
s
P
p
.002 w
.37713 .99375 m
.37713 1 L
s
P
p
.002 w
.56616 .99375 m
.56616 1 L
s
P
p
.002 w
.7552 .99375 m
.7552 1 L
s
P
p
.002 w
.94423 .99375 m
.94423 1 L
s
P
p
.001 w
.03686 .99625 m
.03686 1 L
s
P
p
.001 w
.07467 .99625 m
.07467 1 L
s
P
p
.001 w
.11248 .99625 m
.11248 1 L
s
P
p
.001 w
.15028 .99625 m
.15028 1 L
s
P
p
.001 w
.2259 .99625 m
.2259 1 L
s
P
p
.001 w
.26371 .99625 m
.26371 1 L
s
P
p
.001 w
.30151 .99625 m
.30151 1 L
s
P
p
.001 w
.33932 .99625 m
.33932 1 L
s
P
p
.001 w
.41493 .99625 m
.41493 1 L
s
P
p
.001 w
.45274 .99625 m
.45274 1 L
s
P
p
.001 w
.49055 .99625 m
.49055 1 L
s
P
p
.001 w
.52836 .99625 m
.52836 1 L
s
P
p
.001 w
.60397 .99625 m
.60397 1 L
s
P
p
.001 w
.64178 .99625 m
.64178 1 L
s
P
p
.001 w
.67958 .99625 m
.67958 1 L
s
P
p
.001 w
.71739 .99625 m
.71739 1 L
s
P
p
.001 w
.79301 .99625 m
.79301 1 L
s
P
p
.001 w
.83081 .99625 m
.83081 1 L
s
P
p
.001 w
.86862 .99625 m
.86862 1 L
s
P
p
.001 w
.90643 .99625 m
.90643 1 L
s
P
p
.001 w
.98204 .99625 m
.98204 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .18809 m
1 .18809 L
s
P
p
.002 w
.99375 .37713 m
1 .37713 L
s
P
p
.002 w
.99375 .56616 m
1 .56616 L
s
P
p
.002 w
.99375 .7552 m
1 .7552 L
s
P
p
.002 w
.99375 .94423 m
1 .94423 L
s
P
p
.001 w
.99625 .03686 m
1 .03686 L
s
P
p
.001 w
.99625 .07467 m
1 .07467 L
s
P
p
.001 w
.99625 .11248 m
1 .11248 L
s
P
p
.001 w
.99625 .15028 m
1 .15028 L
s
P
p
.001 w
.99625 .2259 m
1 .2259 L
s
P
p
.001 w
.99625 .26371 m
1 .26371 L
s
P
p
.001 w
.99625 .30151 m
1 .30151 L
s
P
p
.001 w
.99625 .33932 m
1 .33932 L
s
P
p
.001 w
.99625 .41493 m
1 .41493 L
s
P
p
.001 w
.99625 .45274 m
1 .45274 L
s
P
p
.001 w
.99625 .49055 m
1 .49055 L
s
P
p
.001 w
.99625 .52836 m
1 .52836 L
s
P
p
.001 w
.99625 .60397 m
1 .60397 L
s
P
p
.001 w
.99625 .64178 m
1 .64178 L
s
P
p
.001 w
.99625 .67958 m
1 .67958 L
s
P
p
.001 w
.99625 .71739 m
1 .71739 L
s
P
p
.001 w
.99625 .79301 m
1 .79301 L
s
P
p
.001 w
.99625 .83081 m
1 .83081 L
s
P
p
.001 w
.99625 .86862 m
1 .86862 L
s
P
p
.001 w
.99625 .90643 m
1 .90643 L
s
P
p
.001 w
.99625 .98204 m
1 .98204 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
.008 w
.56379 .41856 Mdot
.56361 .41871 Mdot
.56343 .41886 Mdot
.56324 .41901 Mdot
.56306 .41916 Mdot
.55114 .42943 Mdot
.55098 .42958 Mdot
.55081 .42974 Mdot
.55064 .42989 Mdot
.55047 .43004 Mdot
.53963 .44053 Mdot
.53947 .44069 Mdot
.53932 .44084 Mdot
.53917 .441 Mdot
.53902 .44115 Mdot
.52924 .45186 Mdot
.52911 .45201 Mdot
.52897 .45217 Mdot
.52883 .45233 Mdot
.5287 .45249 Mdot
.51999 .4634 Mdot
.51987 .46356 Mdot
.51975 .46372 Mdot
.51963 .46389 Mdot
.51951 .46405 Mdot
.51188 .47516 Mdot
.51178 .47532 Mdot
.51167 .47549 Mdot
.51157 .47565 Mdot
.51146 .47582 Mdot
.50491 .48713 Mdot
.50482 .4873 Mdot
.50473 .48746 Mdot
.50464 .48763 Mdot
.50455 .4878 Mdot
.49907 .4993 Mdot
.499 .49947 Mdot
.49892 .49964 Mdot
.49885 .49981 Mdot
.49878 .49998 Mdot
.49437 .51167 Mdot
.49431 .51184 Mdot
.49425 .51202 Mdot
.4942 .51219 Mdot
.49414 .51236 Mdot
.4908 .52423 Mdot
.49076 .52441 Mdot
.49072 .52459 Mdot
.49067 .52476 Mdot
.49063 .52494 Mdot
.48836 .53699 Mdot
.48834 .53716 Mdot
.48831 .53734 Mdot
.48828 .53752 Mdot
.48826 .5377 Mdot
.48705 .54992 Mdot
.48704 .5501 Mdot
.48703 .55028 Mdot
.48702 .55046 Mdot
.48701 .55064 Mdot
.48687 .56303 Mdot
.48688 .56321 Mdot
.48688 .56339 Mdot
.48689 .56358 Mdot
.48689 .56376 Mdot
.48781 .57631 Mdot
.48783 .57649 Mdot
.48785 .57668 Mdot
.48787 .57686 Mdot
.48789 .57705 Mdot
.48986 .58975 Mdot
.4899 .58994 Mdot
.48993 .59013 Mdot
.48997 .59031 Mdot
.49001 .5905 Mdot
.49303 .60335 Mdot
.49308 .60354 Mdot
.49313 .60373 Mdot
.49318 .60392 Mdot
.49324 .60411 Mdot
P
% End of Graphics
MathPictureEnd

:[font = input; preserveAspect; startGroup]
ListPlot[ Transpose[{colL, rowL}],
PlotRange->{{1,1059}/4+450,{1,1059}/4+400}, 
AspectRatio->1, Frame->True];
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 282; endGroup; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.70227 0.00378072 -1.51323 0.00378072 [
[(500)] .18809 0 0 2 Msboxa
[(550)] .37713 0 0 2 Msboxa
[(600)] .56616 0 0 2 Msboxa
[(650)] .7552 0 0 2 Msboxa
[(700)] .94423 0 0 2 Msboxa
[(450)] -0.0125 .18809 1 0 Msboxa
[(500)] -0.0125 .37713 1 0 Msboxa
[(550)] -0.0125 .56616 1 0 Msboxa
[(600)] -0.0125 .7552 1 0 Msboxa
[(650)] -0.0125 .94423 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 1.001 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.18809 0 m
.18809 .00625 L
s
P
[(500)] .18809 0 0 2 Mshowa
p
.002 w
.37713 0 m
.37713 .00625 L
s
P
[(550)] .37713 0 0 2 Mshowa
p
.002 w
.56616 0 m
.56616 .00625 L
s
P
[(600)] .56616 0 0 2 Mshowa
p
.002 w
.7552 0 m
.7552 .00625 L
s
P
[(650)] .7552 0 0 2 Mshowa
p
.002 w
.94423 0 m
.94423 .00625 L
s
P
[(700)] .94423 0 0 2 Mshowa
p
.001 w
.03686 0 m
.03686 .00375 L
s
P
p
.001 w
.07467 0 m
.07467 .00375 L
s
P
p
.001 w
.11248 0 m
.11248 .00375 L
s
P
p
.001 w
.15028 0 m
.15028 .00375 L
s
P
p
.001 w
.2259 0 m
.2259 .00375 L
s
P
p
.001 w
.26371 0 m
.26371 .00375 L
s
P
p
.001 w
.30151 0 m
.30151 .00375 L
s
P
p
.001 w
.33932 0 m
.33932 .00375 L
s
P
p
.001 w
.41493 0 m
.41493 .00375 L
s
P
p
.001 w
.45274 0 m
.45274 .00375 L
s
P
p
.001 w
.49055 0 m
.49055 .00375 L
s
P
p
.001 w
.52836 0 m
.52836 .00375 L
s
P
p
.001 w
.60397 0 m
.60397 .00375 L
s
P
p
.001 w
.64178 0 m
.64178 .00375 L
s
P
p
.001 w
.67958 0 m
.67958 .00375 L
s
P
p
.001 w
.71739 0 m
.71739 .00375 L
s
P
p
.001 w
.79301 0 m
.79301 .00375 L
s
P
p
.001 w
.83081 0 m
.83081 .00375 L
s
P
p
.001 w
.86862 0 m
.86862 .00375 L
s
P
p
.001 w
.90643 0 m
.90643 .00375 L
s
P
p
.001 w
.98204 0 m
.98204 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .18809 m
.00625 .18809 L
s
P
[(450)] -0.0125 .18809 1 0 Mshowa
p
.002 w
0 .37713 m
.00625 .37713 L
s
P
[(500)] -0.0125 .37713 1 0 Mshowa
p
.002 w
0 .56616 m
.00625 .56616 L
s
P
[(550)] -0.0125 .56616 1 0 Mshowa
p
.002 w
0 .7552 m
.00625 .7552 L
s
P
[(600)] -0.0125 .7552 1 0 Mshowa
p
.002 w
0 .94423 m
.00625 .94423 L
s
P
[(650)] -0.0125 .94423 1 0 Mshowa
p
.001 w
0 .03686 m
.00375 .03686 L
s
P
p
.001 w
0 .07467 m
.00375 .07467 L
s
P
p
.001 w
0 .11248 m
.00375 .11248 L
s
P
p
.001 w
0 .15028 m
.00375 .15028 L
s
P
p
.001 w
0 .2259 m
.00375 .2259 L
s
P
p
.001 w
0 .26371 m
.00375 .26371 L
s
P
p
.001 w
0 .30151 m
.00375 .30151 L
s
P
p
.001 w
0 .33932 m
.00375 .33932 L
s
P
p
.001 w
0 .41493 m
.00375 .41493 L
s
P
p
.001 w
0 .45274 m
.00375 .45274 L
s
P
p
.001 w
0 .49055 m
.00375 .49055 L
s
P
p
.001 w
0 .52836 m
.00375 .52836 L
s
P
p
.001 w
0 .60397 m
.00375 .60397 L
s
P
p
.001 w
0 .64178 m
.00375 .64178 L
s
P
p
.001 w
0 .67958 m
.00375 .67958 L
s
P
p
.001 w
0 .71739 m
.00375 .71739 L
s
P
p
.001 w
0 .79301 m
.00375 .79301 L
s
P
p
.001 w
0 .83081 m
.00375 .83081 L
s
P
p
.001 w
0 .86862 m
.00375 .86862 L
s
P
p
.001 w
0 .90643 m
.00375 .90643 L
s
P
p
.001 w
0 .98204 m
.00375 .98204 L
s
P
p
.002 w
0 0 m
0 1 L
s
P
P
p
p
.002 w
.18809 .99375 m
.18809 1 L
s
P
p
.002 w
.37713 .99375 m
.37713 1 L
s
P
p
.002 w
.56616 .99375 m
.56616 1 L
s
P
p
.002 w
.7552 .99375 m
.7552 1 L
s
P
p
.002 w
.94423 .99375 m
.94423 1 L
s
P
p
.001 w
.03686 .99625 m
.03686 1 L
s
P
p
.001 w
.07467 .99625 m
.07467 1 L
s
P
p
.001 w
.11248 .99625 m
.11248 1 L
s
P
p
.001 w
.15028 .99625 m
.15028 1 L
s
P
p
.001 w
.2259 .99625 m
.2259 1 L
s
P
p
.001 w
.26371 .99625 m
.26371 1 L
s
P
p
.001 w
.30151 .99625 m
.30151 1 L
s
P
p
.001 w
.33932 .99625 m
.33932 1 L
s
P
p
.001 w
.41493 .99625 m
.41493 1 L
s
P
p
.001 w
.45274 .99625 m
.45274 1 L
s
P
p
.001 w
.49055 .99625 m
.49055 1 L
s
P
p
.001 w
.52836 .99625 m
.52836 1 L
s
P
p
.001 w
.60397 .99625 m
.60397 1 L
s
P
p
.001 w
.64178 .99625 m
.64178 1 L
s
P
p
.001 w
.67958 .99625 m
.67958 1 L
s
P
p
.001 w
.71739 .99625 m
.71739 1 L
s
P
p
.001 w
.79301 .99625 m
.79301 1 L
s
P
p
.001 w
.83081 .99625 m
.83081 1 L
s
P
p
.001 w
.86862 .99625 m
.86862 1 L
s
P
p
.001 w
.90643 .99625 m
.90643 1 L
s
P
p
.001 w
.98204 .99625 m
.98204 1 L
s
P
p
.002 w
0 1 m
1 1 L
s
P
p
.002 w
.99375 .18809 m
1 .18809 L
s
P
p
.002 w
.99375 .37713 m
1 .37713 L
s
P
p
.002 w
.99375 .56616 m
1 .56616 L
s
P
p
.002 w
.99375 .7552 m
1 .7552 L
s
P
p
.002 w
.99375 .94423 m
1 .94423 L
s
P
p
.001 w
.99625 .03686 m
1 .03686 L
s
P
p
.001 w
.99625 .07467 m
1 .07467 L
s
P
p
.001 w
.99625 .11248 m
1 .11248 L
s
P
p
.001 w
.99625 .15028 m
1 .15028 L
s
P
p
.001 w
.99625 .2259 m
1 .2259 L
s
P
p
.001 w
.99625 .26371 m
1 .26371 L
s
P
p
.001 w
.99625 .30151 m
1 .30151 L
s
P
p
.001 w
.99625 .33932 m
1 .33932 L
s
P
p
.001 w
.99625 .41493 m
1 .41493 L
s
P
p
.001 w
.99625 .45274 m
1 .45274 L
s
P
p
.001 w
.99625 .49055 m
1 .49055 L
s
P
p
.001 w
.99625 .52836 m
1 .52836 L
s
P
p
.001 w
.99625 .60397 m
1 .60397 L
s
P
p
.001 w
.99625 .64178 m
1 .64178 L
s
P
p
.001 w
.99625 .67958 m
1 .67958 L
s
P
p
.001 w
.99625 .71739 m
1 .71739 L
s
P
p
.001 w
.99625 .79301 m
1 .79301 L
s
P
p
.001 w
.99625 .83081 m
1 .83081 L
s
P
p
.001 w
.99625 .86862 m
1 .86862 L
s
P
p
.001 w
.99625 .90643 m
1 .90643 L
s
P
p
.001 w
.99625 .98204 m
1 .98204 L
s
P
p
.002 w
1 0 m
1 1 L
s
P
P
p
P
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
p
.008 w
.55669 .16478 Mdot
.55596 .16538 Mdot
.55522 .16598 Mdot
.55449 .16658 Mdot
.55376 .16718 Mdot
.50609 .20827 Mdot
.50542 .20888 Mdot
.50475 .20949 Mdot
.50408 .2101 Mdot
.50341 .21071 Mdot
.46002 .25267 Mdot
.45941 .25329 Mdot
.4588 .25392 Mdot
.45819 .25454 Mdot
.45759 .25516 Mdot
.41848 .29797 Mdot
.41793 .2986 Mdot
.41739 .29924 Mdot
.41685 .29988 Mdot
.4163 .30051 Mdot
.38148 .34415 Mdot
.381 .34479 Mdot
.38052 .34544 Mdot
.38004 .34609 Mdot
.37956 .34674 Mdot
.34904 .39118 Mdot
.34862 .39184 Mdot
.3482 .3925 Mdot
.34778 .39316 Mdot
.34737 .39382 Mdot
.32114 .43906 Mdot
.32078 .43973 Mdot
.32043 .4404 Mdot
.32007 .44107 Mdot
.31972 .44174 Mdot
.29779 .48775 Mdot
.29749 .48843 Mdot
.2972 .48911 Mdot
.29691 .48979 Mdot
.29662 .49048 Mdot
.27898 .53723 Mdot
.27875 .53792 Mdot
.27852 .53862 Mdot
.27829 .53931 Mdot
.27807 .54 Mdot
.26471 .58749 Mdot
.26454 .58819 Mdot
.26437 .58889 Mdot
.26421 .5896 Mdot
.26404 .5903 Mdot
.25496 .63849 Mdot
.25485 .63921 Mdot
.25475 .63992 Mdot
.25465 .64063 Mdot
.25455 .64135 Mdot
.24973 .69022 Mdot
.24968 .69095 Mdot
.24964 .69167 Mdot
.2496 .69239 Mdot
.24957 .69312 Mdot
.24899 .74266 Mdot
.24901 .74339 Mdot
.24904 .74413 Mdot
.24906 .74486 Mdot
.24908 .74559 Mdot
.25274 .79577 Mdot
.25283 .79652 Mdot
.25291 .79726 Mdot
.253 .798 Mdot
.25308 .79874 Mdot
.26096 .84955 Mdot
.2611 .8503 Mdot
.26125 .85105 Mdot
.2614 .8518 Mdot
.26155 .85255 Mdot
.27362 .90396 Mdot
.27383 .90472 Mdot
.27404 .90548 Mdot
.27425 .90624 Mdot
.27446 .907 Mdot
P
% End of Graphics
MathPictureEnd

:[font = subsubsection; inactive; preserveAspect; startGroup]
print out
:[font = input; preserveAspect]
dateStr[{y_,m_,d_,h_,mn_,s_}] := m<>"/"<>d<>" "<>h<>":"<>mn;
:[font = input; preserveAspect]
radecStr[{h_,mn_,s_}] := StringForm["`1` `2` `3`", h,mn,s];
:[font = input; preserveAspect; startGroup]
{ s[[1,2]], radecStr[ s[[1,2]] ]}
:[font = output; output; inactive; preserveAspect; endGroup]
{{"16", "05", "15.390969"}, StringForm["`1` `2` `3`", "16", "05", "15.390969"]}
;[o]
{{16, 05, 15.390969}, 16 05 15.390969}
:[font = input; preserveAspect; startGroup]
TableForm[ Transpose[{
	dateStr/@  Transpose[s][[1]],
	radecStr/@  Transpose[s][[2]],
	radecStr/@  Transpose[s][[3]],
	NumberForm[#,{5,3}, NumberPadding->{" ","0"}]& /@ colL,
	NumberForm[#,{5,3}, NumberPadding->{" ","0"}]& /@ rowL
}],
TableHeadings->{None, {"mo/dy hr:mn", "ra2000","dec2000", "column", "row"}},
TableSpacing->{0,2} ]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
TableForm[{{"02/22 14:00", StringForm["`1` `2` `3`", "16", "05", "15.390969"], 
    StringForm["`1` `2` `3`", "-06", "56", "37.96638"], 
    NumberForm[597.4945838821177957, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[443.8353642369684879, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/22 14:20", StringForm["`1` `2` `3`", "16", "05", "15.413029"], 
    StringForm["`1` `2` `3`", "-06", "56", "37.69621"], 
    NumberForm[597.3005108225428907, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[443.9934237111316442, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/22 14:40", StringForm["`1` `2` `3`", "16", "05", "15.435063"], 
    StringForm["`1` `2` `3`", "-06", "56", "37.42596"], 
    NumberForm[597.1066653353701792, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[444.1515313012613137, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/22 15:00", StringForm["`1` `2` `3`", "16", "05", "15.457070"], 
    StringForm["`1` `2` `3`", "-06", "56", "37.15564"], 
    NumberForm[596.913056211946798, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[444.3096811646670603, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/22 15:20", StringForm["`1` `2` `3`", "16", "05", "15.479051"], 
    StringForm["`1` `2` `3`", "-06", "56", "36.88523"], 
    NumberForm[596.7196746332862856, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[444.4678850283195108, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/23 14:00", StringForm["`1` `2` `3`", "16", "05", "16.911957"], 
    StringForm["`1` `2` `3`", "-06", "56", "18.31281"], 
    NumberForm[584.1106890312519972, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[455.3368197078267321, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/23 14:20", StringForm["`1` `2` `3`", "16", "05", "16.932119"], 
    StringForm["`1` `2` `3`", "-06", "56", "18.03698"], 
    NumberForm[583.9332295205640633, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[455.498286029724277, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/23 14:40", StringForm["`1` `2` `3`", "16", "05", "16.952256"], 
    StringForm["`1` `2` `3`", "-06", "56", "17.76108"], 
    NumberForm[583.7559888524406491, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[455.6597945494950859, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/23 15:00", StringForm["`1` `2` `3`", "16", "05", "16.972365"], 
    StringForm["`1` `2` `3`", "-06", "56", "17.48510"], 
    NumberForm[583.5789932897877898, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[455.8213512753844245, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/23 15:20", StringForm["`1` `2` `3`", "16", "05", "16.992449"], 
    StringForm["`1` `2` `3`", "-06", "56", "17.20905"], 
    NumberForm[583.4022165698673872, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[455.9829501993388601, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/24 14:00", StringForm["`1` `2` `3`", "16", "05", "18.296164"], 
    StringForm["`1` `2` `3`", "-06", "55", "58.25624"], 
    NumberForm[571.924093089162036, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[467.0809320266237676, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/24 14:20", StringForm["`1` `2` `3`", "16", "05", "18.314424"], 
    StringForm["`1` `2` `3`", "-06", "55", "57.97488"], 
    NumberForm[571.7632829803901413, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[467.2457293741169128, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/24 14:40", StringForm["`1` `2` `3`", "16", "05", "18.332659"], 
    StringForm["`1` `2` `3`", "-06", "55", "57.69344"], 
    NumberForm[571.6026916923879022, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[467.4105748100897338, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/24 15:00", StringForm["`1` `2` `3`", "16", "05", "18.350866"], 
    StringForm["`1` `2` `3`", "-06", "55", "57.41193"], 
    NumberForm[571.4423455441461055, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[467.5754625748952866, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/24 15:20", StringForm["`1` `2` `3`", "16", "05", "18.369048"], 
    StringForm["`1` `2` `3`", "-06", "55", "57.13034"], 
    NumberForm[571.2822182168474989, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[467.7403984283525438, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/25 14:00", StringForm["`1` `2` `3`", "16", "05", "19.543312"], 
    StringForm["`1` `2` `3`", "-06", "55", "37.80529"], 
    NumberForm[560.9372886240684428, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[479.0626751996469983, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/25 14:20", StringForm["`1` `2` `3`", "16", "05", "19.559668"], 
    StringForm["`1` `2` `3`", "-06", "55", "37.51851"], 
    NumberForm[560.7931462108642635, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[479.230739384856468, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/25 14:40", StringForm["`1` `2` `3`", "16", "05", "19.575997"], 
    StringForm["`1` `2` `3`", "-06", "55", "37.23166"], 
    NumberForm[560.649240180286148, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[479.3988458633501646, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/25 15:00", StringForm["`1` `2` `3`", "16", "05", "19.592299"], 
    StringForm["`1` `2` `3`", "-06", "55", "36.94474"], 
    NumberForm[560.5055705324301529, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[479.5669946352069932, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/25 15:20", StringForm["`1` `2` `3`", "16", "05", "19.608575"], 
    StringForm["`1` `2` `3`", "-06", "55", "36.65774"], 
    NumberForm[560.3621284756493952, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[479.7351915430511959, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/26 14:00", StringForm["`1` `2` `3`", "16", "05", "20.653196"], 
    StringForm["`1` `2` `3`", "-06", "55", "16.96886"], 
    NumberForm[551.1521309187466065, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[491.2768517738999656, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/26 14:20", StringForm["`1` `2` `3`", "16", "05", "20.667644"], 
    StringForm["`1` `2` `3`", "-06", "55", "16.67679"], 
    NumberForm[551.0246921008233158, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[491.4481068724648791, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/26 14:40", StringForm["`1` `2` `3`", "16", "05", "20.682066"], 
    StringForm["`1` `2` `3`", "-06", "55", "16.38465"], 
    NumberForm[550.8974809085692188, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[491.6194042279895482, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/26 15:00", StringForm["`1` `2` `3`", "16", "05", "20.696460"], 
    StringForm["`1` `2` `3`", "-06", "55", "16.09244"], 
    NumberForm[550.7705148697923718, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[491.7907439237110669, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/26 15:20", StringForm["`1` `2` `3`", "16", "05", "20.710829"], 
    StringForm["`1` `2` `3`", "-06", "55", "15.80016"], 
    NumberForm[550.6437676930229048, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[491.9621258349416863, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/27 14:00", StringForm["`1` `2` `3`", "16", "05", "21.625690"], 
    StringForm["`1` `2` `3`", "-06", "54", "55.75616"], 
    NumberForm[542.5697853830041284, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[503.718074899054729, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/27 14:20", StringForm["`1` `2` `3`", "16", "05", "21.638229"], 
    StringForm["`1` `2` `3`", "-06", "54", "55.45893"], 
    NumberForm[542.4590597904765099, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[503.8924448103878751, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/27 14:40", StringForm["`1` `2` `3`", "16", "05", "21.650742"], 
    StringForm["`1` `2` `3`", "-06", "54", "55.16164"], 
    NumberForm[542.3485618587581376, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[504.0668510990923328, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/27 15:00", StringForm["`1` `2` `3`", "16", "05", "21.663228"], 
    StringForm["`1` `2` `3`", "-06", "54", "54.86427"], 
    NumberForm[542.2383002957594757, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[504.2413055749946618, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/27 15:20", StringForm["`1` `2` `3`", "16", "05", "21.675688"], 
    StringForm["`1` `2` `3`", "-06", "54", "54.56683"], 
    NumberForm[542.1282663656974718, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[504.4158023124463628, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/28 14:00", StringForm["`1` `2` `3`", "16", "05", "22.460756"], 
    StringForm["`1` `2` `3`", "-06", "54", "34.17666"], 
    NumberForm[535.1906484418989556, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[516.3807973454370639, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/28 14:20", StringForm["`1` `2` `3`", "16", "05", "22.471386"], 
    StringForm["`1` `2` `3`", "-06", "54", "33.87441"], 
    NumberForm[535.0966369893020813, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[516.558199991276626, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/28 14:40", StringForm["`1` `2` `3`", "16", "05", "22.481991"], 
    StringForm["`1` `2` `3`", "-06", "54", "33.57209"], 
    NumberForm[535.0028444127091514, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[516.7356448606194943, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/28 15:00", StringForm["`1` `2` `3`", "16", "05", "22.492568"], 
    StringForm["`1` `2` `3`", "-06", "54", "33.26970"], 
    NumberForm[534.909297004393621, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[516.9131320785790493, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/28 15:20", StringForm["`1` `2` `3`", "16", "05", "22.503119"], 
    StringForm["`1` `2` `3`", "-06", "54", "32.96724"], 
    NumberForm[534.8159772363458799, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[517.0906615618249797, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/01 14:00", StringForm["`1` `2` `3`", "16", "05", "23.158448"], 
    StringForm["`1` `2` `3`", "-06", "54", "12.24007"], 
    NumberForm[529.0143123182296412, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[529.2593230873833559, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/01 14:20", StringForm["`1` `2` `3`", "16", "05", "23.167172"], 
    StringForm["`1` `2` `3`", "-06", "54", "11.93293"], 
    NumberForm[528.9369896186036426, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[529.4396820963431522, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/01 14:40", StringForm["`1` `2` `3`", "16", "05", "23.175869"], 
    StringForm["`1` `2` `3`", "-06", "54", "11.62572"], 
    NumberForm[528.8599033307616817, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[529.6200834152597918, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/01 15:00", StringForm["`1` `2` `3`", "16", "05", "23.184540"], 
    StringForm["`1` `2` `3`", "-06", "54", "11.31844"], 
    NumberForm[528.7830446906518462, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[529.8005270024433306, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/01 15:20", StringForm["`1` `2` `3`", "16", "05", "23.193184"], 
    StringForm["`1` `2` `3`", "-06", "54", "11.01110"], 
    NumberForm[528.7064224906799432, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[529.9810070155984645, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/02 14:00", StringForm["`1` `2` `3`", "16", "05", "23.718912"], 
    StringForm["`1` `2` `3`", "-06", "53", "49.95628"], 
    NumberForm[524.0395647526445777, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[542.3478426013215115, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/02 14:20", StringForm["`1` `2` `3`", "16", "05", "23.725731"], 
    StringForm["`1` `2` `3`", "-06", "53", "49.64438"], 
    NumberForm[523.9789229645758604, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[542.5310816333962776, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/02 14:40", StringForm["`1` `2` `3`", "16", "05", "23.732524"], 
    StringForm["`1` `2` `3`", "-06", "53", "49.33242"], 
    NumberForm[523.918508860087937, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[542.7143570519650633, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/02 15:00", StringForm["`1` `2` `3`", "16", "05", "23.739290"], 
    StringForm["`1` `2` `3`", "-06", "53", "49.02040"], 
    NumberForm[523.8583312035560522, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[542.8976688988126813, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/02 15:20", StringForm["`1` `2` `3`", "16", "05", "23.746030"], 
    StringForm["`1` `2` `3`", "-06", "53", "48.70831"], 
    NumberForm[523.7983812026661616, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[543.0810230162668448, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/03 14:00", StringForm["`1` `2` `3`", "16", "05", "24.142376"], 
    StringForm["`1` `2` `3`", "-06", "53", "27.33529"], 
    NumberForm[520.2644763349423411, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[555.6404744782451173, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/03 14:20", StringForm["`1` `2` `3`", "16", "05", "24.147294"], 
    StringForm["`1` `2` `3`", "-06", "53", "27.01878"], 
    NumberForm[520.2204813968436845, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[555.8265052483447444, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/03 14:40", StringForm["`1` `2` `3`", "16", "05", "24.152186"], 
    StringForm["`1` `2` `3`", "-06", "53", "26.70221"], 
    NumberForm[520.1767141503565361, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[556.0125724065516701, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/03 15:00", StringForm["`1` `2` `3`", "16", "05", "24.157052"], 
    StringForm["`1` `2` `3`", "-06", "53", "26.38558"], 
    NumberForm[520.1331745955930148, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[556.1986759528832391, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/03 15:20", StringForm["`1` `2` `3`", "16", "05", "24.161891"], 
    StringForm["`1` `2` `3`", "-06", "53", "26.06889"], 
    NumberForm[520.0898714970379864, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[556.3848159291353736, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/04 14:00", StringForm["`1` `2` `3`", "16", "05", "24.429145"], 
    StringForm["`1` `2` `3`", "-06", "53", "04.38723"], 
    NumberForm[517.6864442696990647, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[569.1312538839020403, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/04 14:20", StringForm["`1` `2` `3`", "16", "05", "24.432167"], 
    StringForm["`1` `2` `3`", "-06", "53", "04.06625"], 
    NumberForm[517.6590533419480749, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[569.319993897780918, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/04 14:40", StringForm["`1` `2` `3`", "16", "05", "24.435163"], 
    StringForm["`1` `2` `3`", "-06", "53", "03.74521"], 
    NumberForm[517.6318901140363842, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[569.5087703006738233, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/04 15:00", StringForm["`1` `2` `3`", "16", "05", "24.438132"], 
    StringForm["`1` `2` `3`", "-06", "53", "03.42411"], 
    NumberForm[517.6049633505570653, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[569.6975831343789429, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/04 15:20", StringForm["`1` `2` `3`", "16", "05", "24.441075"], 
    StringForm["`1` `2` `3`", "-06", "53", "03.10295"], 
    NumberForm[517.5782642871496582, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[569.8864323571131365, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/05 14:00", StringForm["`1` `2` `3`", "16", "05", "24.579589"], 
    StringForm["`1` `2` `3`", "-06", "52", "41.12227"], 
    NumberForm[516.3022971852358824, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[582.8141860472674009, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/05 14:20", StringForm["`1` `2` `3`", "16", "05", "24.580721"], 
    StringForm["`1` `2` `3`", "-06", "52", "40.79696"], 
    NumberForm[516.2914586767805605, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[583.0055527179742465, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/05 14:40", StringForm["`1` `2` `3`", "16", "05", "24.581827"], 
    StringForm["`1` `2` `3`", "-06", "52", "40.47159"], 
    NumberForm[516.2808478765764506, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[583.1969557779011783, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/05 15:00", StringForm["`1` `2` `3`", "16", "05", "24.582906"], 
    StringForm["`1` `2` `3`", "-06", "52", "40.14617"], 
    NumberForm[516.2704735775158156, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[583.3883893847915585, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/05 15:20", StringForm["`1` `2` `3`", "16", "05", "24.583959"], 
    StringForm["`1` `2` `3`", "-06", "52", "39.82068"], 
    NumberForm[516.2603269587558663, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[583.5798652649461913, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/06 14:00", StringForm["`1` `2` `3`", "16", "05", "24.594142"], 
    StringForm["`1` `2` `3`", "-06", "52", "17.55062"], 
    NumberForm[516.1083037907720365, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[596.6832463426283728, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/06 14:20", StringForm["`1` `2` `3`", "16", "05", "24.593389"], 
    StringForm["`1` `2` `3`", "-06", "52", "17.22112"], 
    NumberForm[516.1139748869778634, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[596.8771570747191808, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/06 14:40", StringForm["`1` `2` `3`", "16", "05", "24.592611"], 
    StringForm["`1` `2` `3`", "-06", "52", "16.89157"], 
    NumberForm[516.1198649635158926, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[597.071098269710107, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/06 15:00", StringForm["`1` `2` `3`", "16", "05", "24.591806"], 
    StringForm["`1` `2` `3`", "-06", "52", "16.56196"], 
    NumberForm[516.1259915217064029, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[597.2650758952105236, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/06 15:20", StringForm["`1` `2` `3`", "16", "05", "24.590975"], 
    StringForm["`1` `2` `3`", "-06", "52", "16.23230"], 
    NumberForm[516.1323458251625569, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[597.4590840253762862, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/07 14:00", StringForm["`1` `2` `3`", "16", "05", "24.473285"], 
    StringForm["`1` `2` `3`", "-06", "51", "53.68254"], 
    NumberForm[517.1003217985287388, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[610.7323751644648326, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/07 14:20", StringForm["`1` `2` `3`", "16", "05", "24.470655"], 
    StringForm["`1` `2` `3`", "-06", "51", "53.34900"], 
    NumberForm[517.1224334295091811, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[610.9287413035113255, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/07 14:40", StringForm["`1` `2` `3`", "16", "05", "24.468000"], 
    StringForm["`1` `2` `3`", "-06", "51", "53.01541"], 
    NumberForm[517.1447640494493778, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[611.1251379043036378, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/07 15:00", StringForm["`1` `2` `3`", "16", "05", "24.465318"], 
    StringForm["`1` `2` `3`", "-06", "51", "52.68176"], 
    NumberForm[517.1673311599012917, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[611.3215709344091802, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/07 15:20", StringForm["`1` `2` `3`", "16", "05", "24.462611"], 
    StringForm["`1` `2` `3`", "-06", "51", "52.34805"], 
    NumberForm[517.1901172313788777, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[611.5180403102587496, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/08 14:00", StringForm["`1` `2` `3`", "16", "05", "24.217550"], 
    StringForm["`1` `2` `3`", "-06", "51", "29.52831"], 
    NumberForm[519.2737626807123168, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[624.9554954676784713, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/08 14:20", StringForm["`1` `2` `3`", "16", "05", "24.213051"], 
    StringForm["`1` `2` `3`", "-06", "51", "29.19086"], 
    NumberForm[519.3122457291206895, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[625.1542400785975009, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/08 14:40", StringForm["`1` `2` `3`", "16", "05", "24.208526"], 
    StringForm["`1` `2` `3`", "-06", "51", "28.85337"], 
    NumberForm[519.3509565683328071, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[625.3530093071563098, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/08 15:00", StringForm["`1` `2` `3`", "16", "05", "24.203976"], 
    StringForm["`1` `2` `3`", "-06", "51", "28.51582"], 
    NumberForm[519.3898863772355776, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[625.5518148796441409, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/08 15:20", StringForm["`1` `2` `3`", "16", "05", "24.199399"], 
    StringForm["`1` `2` `3`", "-06", "51", "28.17822"], 
    NumberForm[519.4290527139448756, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[625.7506509954970519, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/09 14:00", StringForm["`1` `2` `3`", "16", "05", "23.827512"], 
    StringForm["`1` `2` `3`", "-06", "51", "05.09821"], 
    NumberForm[522.6236616323249926, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[639.3465249310546445, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/09 14:20", StringForm["`1` `2` `3`", "16", "05", "23.821152"], 
    StringForm["`1` `2` `3`", "-06", "51", "04.75701"], 
    NumberForm[522.6784470731195924, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[639.5475533787757556, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/09 14:40", StringForm["`1` `2` `3`", "16", "05", "23.814767"], 
    StringForm["`1` `2` `3`", "-06", "51", "04.41576"], 
    NumberForm[522.7334515205413661, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[639.7486122839398406, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/09 15:00", StringForm["`1` `2` `3`", "16", "05", "23.808355"], 
    StringForm["`1` `2` `3`", "-06", "51", "04.07446"], 
    NumberForm[522.7886925047683779, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[639.9497017299466601, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/09 15:20", StringForm["`1` `2` `3`", "16", "05", "23.801918"], 
    StringForm["`1` `2` `3`", "-06", "51", "03.73310"], 
    NumberForm[522.844152467734554, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[640.1508275173477229, {5, 3}, NumberPadding -> {" ", "0"}]}}, 
  TableHeadings -> {None, {"mo/dy hr:mn", "ra2000", "dec2000", "column", "row"}}, 
  TableSpacing -> {0, 2}]
;[o]
   mo/dy hr:mn  ra2000           dec2000          column    row
   02/22 14:00  16 05 15.390969  -06 56 37.96638   597.490   443.840
   02/22 14:20  16 05 15.413029  -06 56 37.69621   597.300   443.990
   02/22 14:40  16 05 15.435063  -06 56 37.42596   597.110   444.150
   02/22 15:00  16 05 15.457070  -06 56 37.15564   596.910   444.310
   02/22 15:20  16 05 15.479051  -06 56 36.88523   596.720   444.470
   02/23 14:00  16 05 16.911957  -06 56 18.31281   584.110   455.340
   02/23 14:20  16 05 16.932119  -06 56 18.03698   583.930   455.500
   02/23 14:40  16 05 16.952256  -06 56 17.76108   583.760   455.660
   02/23 15:00  16 05 16.972365  -06 56 17.48510   583.580   455.820
   02/23 15:20  16 05 16.992449  -06 56 17.20905   583.400   455.980
   02/24 14:00  16 05 18.296164  -06 55 58.25624   571.920   467.080
   02/24 14:20  16 05 18.314424  -06 55 57.97488   571.760   467.250
   02/24 14:40  16 05 18.332659  -06 55 57.69344   571.600   467.410
   02/24 15:00  16 05 18.350866  -06 55 57.41193   571.440   467.580
   02/24 15:20  16 05 18.369048  -06 55 57.13034   571.280   467.740
   02/25 14:00  16 05 19.543312  -06 55 37.80529   560.940   479.060
   02/25 14:20  16 05 19.559668  -06 55 37.51851   560.790   479.230
   02/25 14:40  16 05 19.575997  -06 55 37.23166   560.650   479.400
   02/25 15:00  16 05 19.592299  -06 55 36.94474   560.510   479.570
   02/25 15:20  16 05 19.608575  -06 55 36.65774   560.360   479.740
   02/26 14:00  16 05 20.653196  -06 55 16.96886   551.150   491.280
   02/26 14:20  16 05 20.667644  -06 55 16.67679   551.020   491.450
   02/26 14:40  16 05 20.682066  -06 55 16.38465   550.900   491.620
   02/26 15:00  16 05 20.696460  -06 55 16.09244   550.770   491.790
   02/26 15:20  16 05 20.710829  -06 55 15.80016   550.640   491.960
   02/27 14:00  16 05 21.625690  -06 54 55.75616   542.570   503.720
   02/27 14:20  16 05 21.638229  -06 54 55.45893   542.460   503.890
   02/27 14:40  16 05 21.650742  -06 54 55.16164   542.350   504.070
   02/27 15:00  16 05 21.663228  -06 54 54.86427   542.240   504.240
   02/27 15:20  16 05 21.675688  -06 54 54.56683   542.130   504.420
   02/28 14:00  16 05 22.460756  -06 54 34.17666   535.190   516.380
   02/28 14:20  16 05 22.471386  -06 54 33.87441   535.100   516.560
   02/28 14:40  16 05 22.481991  -06 54 33.57209   535.000   516.740
   02/28 15:00  16 05 22.492568  -06 54 33.26970   534.910   516.910
   02/28 15:20  16 05 22.503119  -06 54 32.96724   534.820   517.090
   03/01 14:00  16 05 23.158448  -06 54 12.24007   529.010   529.260
   03/01 14:20  16 05 23.167172  -06 54 11.93293   528.940   529.440
   03/01 14:40  16 05 23.175869  -06 54 11.62572   528.860   529.620
   03/01 15:00  16 05 23.184540  -06 54 11.31844   528.780   529.800
   03/01 15:20  16 05 23.193184  -06 54 11.01110   528.710   529.980
   03/02 14:00  16 05 23.718912  -06 53 49.95628   524.040   542.350
   03/02 14:20  16 05 23.725731  -06 53 49.64438   523.980   542.530
   03/02 14:40  16 05 23.732524  -06 53 49.33242   523.920   542.710
   03/02 15:00  16 05 23.739290  -06 53 49.02040   523.860   542.900
   03/02 15:20  16 05 23.746030  -06 53 48.70831   523.800   543.080
   03/03 14:00  16 05 24.142376  -06 53 27.33529   520.260   555.640
   03/03 14:20  16 05 24.147294  -06 53 27.01878   520.220   555.830
   03/03 14:40  16 05 24.152186  -06 53 26.70221   520.180   556.010
   03/03 15:00  16 05 24.157052  -06 53 26.38558   520.130   556.200
   03/03 15:20  16 05 24.161891  -06 53 26.06889   520.090   556.380
   03/04 14:00  16 05 24.429145  -06 53 04.38723   517.690   569.130
   03/04 14:20  16 05 24.432167  -06 53 04.06625   517.660   569.320
   03/04 14:40  16 05 24.435163  -06 53 03.74521   517.630   569.510
   03/04 15:00  16 05 24.438132  -06 53 03.42411   517.600   569.700
   03/04 15:20  16 05 24.441075  -06 53 03.10295   517.580   569.890
   03/05 14:00  16 05 24.579589  -06 52 41.12227   516.300   582.810
   03/05 14:20  16 05 24.580721  -06 52 40.79696   516.290   583.010
   03/05 14:40  16 05 24.581827  -06 52 40.47159   516.280   583.200
   03/05 15:00  16 05 24.582906  -06 52 40.14617   516.270   583.390
   03/05 15:20  16 05 24.583959  -06 52 39.82068   516.260   583.580
   03/06 14:00  16 05 24.594142  -06 52 17.55062   516.110   596.680
   03/06 14:20  16 05 24.593389  -06 52 17.22112   516.110   596.880
   03/06 14:40  16 05 24.592611  -06 52 16.89157   516.120   597.070
   03/06 15:00  16 05 24.591806  -06 52 16.56196   516.130   597.270
   03/06 15:20  16 05 24.590975  -06 52 16.23230   516.130   597.460
   03/07 14:00  16 05 24.473285  -06 51 53.68254   517.100   610.730
   03/07 14:20  16 05 24.470655  -06 51 53.34900   517.120   610.930
   03/07 14:40  16 05 24.468000  -06 51 53.01541   517.140   611.130
   03/07 15:00  16 05 24.465318  -06 51 52.68176   517.170   611.320
   03/07 15:20  16 05 24.462611  -06 51 52.34805   517.190   611.520
   03/08 14:00  16 05 24.217550  -06 51 29.52831   519.270   624.960
   03/08 14:20  16 05 24.213051  -06 51 29.19086   519.310   625.150
   03/08 14:40  16 05 24.208526  -06 51 28.85337   519.350   625.350
   03/08 15:00  16 05 24.203976  -06 51 28.51582   519.390   625.550
   03/08 15:20  16 05 24.199399  -06 51 28.17822   519.430   625.750
   03/09 14:00  16 05 23.827512  -06 51 05.09821   522.620   639.350
   03/09 14:20  16 05 23.821152  -06 51 04.75701   522.680   639.550
   03/09 14:40  16 05 23.814767  -06 51 04.41576   522.730   639.750
   03/09 15:00  16 05 23.808355  -06 51 04.07446   522.790   639.950
   03/09 15:20  16 05 23.801918  -06 51 03.73310   522.840   640.150
:[font = input; preserveAspect; startGroup]
TableForm[ Transpose[{
	dateStr/@  Transpose[s][[1]],
	radecStr/@  Transpose[s][[2]],
	radecStr/@  Transpose[s][[3]],
	NumberForm[#,{5,3}, NumberPadding->{" ","0"}]& /@ colL,
	NumberForm[#,{5,3}, NumberPadding->{" ","0"}]& /@ rowL
}][[ Union[ Range[16]*5, Range[16]*5-4 ] ]],
TableHeadings->{None, {"mo/dy hr:mn", "ra2000","dec2000", "column", "row"}},
TableSpacing->{0,2} ]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup; endGroup; endGroup; endGroup; endGroup]
TableForm[{{"02/22 14:00", StringForm["`1` `2` `3`", "16", "05", "15.390969"], 
    StringForm["`1` `2` `3`", "-06", "56", "37.96638"], 
    NumberForm[597.4945838821177957, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[443.8353642369684879, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/22 15:20", StringForm["`1` `2` `3`", "16", "05", "15.479051"], 
    StringForm["`1` `2` `3`", "-06", "56", "36.88523"], 
    NumberForm[596.7196746332862856, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[444.4678850283195108, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/23 14:00", StringForm["`1` `2` `3`", "16", "05", "16.911957"], 
    StringForm["`1` `2` `3`", "-06", "56", "18.31281"], 
    NumberForm[584.1106890312519972, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[455.3368197078267321, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/23 15:20", StringForm["`1` `2` `3`", "16", "05", "16.992449"], 
    StringForm["`1` `2` `3`", "-06", "56", "17.20905"], 
    NumberForm[583.4022165698673872, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[455.9829501993388601, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/24 14:00", StringForm["`1` `2` `3`", "16", "05", "18.296164"], 
    StringForm["`1` `2` `3`", "-06", "55", "58.25624"], 
    NumberForm[571.924093089162036, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[467.0809320266237676, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/24 15:20", StringForm["`1` `2` `3`", "16", "05", "18.369048"], 
    StringForm["`1` `2` `3`", "-06", "55", "57.13034"], 
    NumberForm[571.2822182168474989, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[467.7403984283525438, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/25 14:00", StringForm["`1` `2` `3`", "16", "05", "19.543312"], 
    StringForm["`1` `2` `3`", "-06", "55", "37.80529"], 
    NumberForm[560.9372886240684428, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[479.0626751996469983, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/25 15:20", StringForm["`1` `2` `3`", "16", "05", "19.608575"], 
    StringForm["`1` `2` `3`", "-06", "55", "36.65774"], 
    NumberForm[560.3621284756493952, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[479.7351915430511959, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/26 14:00", StringForm["`1` `2` `3`", "16", "05", "20.653196"], 
    StringForm["`1` `2` `3`", "-06", "55", "16.96886"], 
    NumberForm[551.1521309187466065, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[491.2768517738999656, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/26 15:20", StringForm["`1` `2` `3`", "16", "05", "20.710829"], 
    StringForm["`1` `2` `3`", "-06", "55", "15.80016"], 
    NumberForm[550.6437676930229048, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[491.9621258349416863, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/27 14:00", StringForm["`1` `2` `3`", "16", "05", "21.625690"], 
    StringForm["`1` `2` `3`", "-06", "54", "55.75616"], 
    NumberForm[542.5697853830041284, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[503.718074899054729, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/27 15:20", StringForm["`1` `2` `3`", "16", "05", "21.675688"], 
    StringForm["`1` `2` `3`", "-06", "54", "54.56683"], 
    NumberForm[542.1282663656974718, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[504.4158023124463628, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/28 14:00", StringForm["`1` `2` `3`", "16", "05", "22.460756"], 
    StringForm["`1` `2` `3`", "-06", "54", "34.17666"], 
    NumberForm[535.1906484418989556, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[516.3807973454370639, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"02/28 15:20", StringForm["`1` `2` `3`", "16", "05", "22.503119"], 
    StringForm["`1` `2` `3`", "-06", "54", "32.96724"], 
    NumberForm[534.8159772363458799, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[517.0906615618249797, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/01 14:00", StringForm["`1` `2` `3`", "16", "05", "23.158448"], 
    StringForm["`1` `2` `3`", "-06", "54", "12.24007"], 
    NumberForm[529.0143123182296412, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[529.2593230873833559, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/01 15:20", StringForm["`1` `2` `3`", "16", "05", "23.193184"], 
    StringForm["`1` `2` `3`", "-06", "54", "11.01110"], 
    NumberForm[528.7064224906799432, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[529.9810070155984645, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/02 14:00", StringForm["`1` `2` `3`", "16", "05", "23.718912"], 
    StringForm["`1` `2` `3`", "-06", "53", "49.95628"], 
    NumberForm[524.0395647526445777, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[542.3478426013215115, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/02 15:20", StringForm["`1` `2` `3`", "16", "05", "23.746030"], 
    StringForm["`1` `2` `3`", "-06", "53", "48.70831"], 
    NumberForm[523.7983812026661616, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[543.0810230162668448, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/03 14:00", StringForm["`1` `2` `3`", "16", "05", "24.142376"], 
    StringForm["`1` `2` `3`", "-06", "53", "27.33529"], 
    NumberForm[520.2644763349423411, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[555.6404744782451173, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/03 15:20", StringForm["`1` `2` `3`", "16", "05", "24.161891"], 
    StringForm["`1` `2` `3`", "-06", "53", "26.06889"], 
    NumberForm[520.0898714970379864, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[556.3848159291353736, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/04 14:00", StringForm["`1` `2` `3`", "16", "05", "24.429145"], 
    StringForm["`1` `2` `3`", "-06", "53", "04.38723"], 
    NumberForm[517.6864442696990647, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[569.1312538839020403, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/04 15:20", StringForm["`1` `2` `3`", "16", "05", "24.441075"], 
    StringForm["`1` `2` `3`", "-06", "53", "03.10295"], 
    NumberForm[517.5782642871496582, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[569.8864323571131365, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/05 14:00", StringForm["`1` `2` `3`", "16", "05", "24.579589"], 
    StringForm["`1` `2` `3`", "-06", "52", "41.12227"], 
    NumberForm[516.3022971852358824, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[582.8141860472674009, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/05 15:20", StringForm["`1` `2` `3`", "16", "05", "24.583959"], 
    StringForm["`1` `2` `3`", "-06", "52", "39.82068"], 
    NumberForm[516.2603269587558663, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[583.5798652649461913, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/06 14:00", StringForm["`1` `2` `3`", "16", "05", "24.594142"], 
    StringForm["`1` `2` `3`", "-06", "52", "17.55062"], 
    NumberForm[516.1083037907720365, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[596.6832463426283728, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/06 15:20", StringForm["`1` `2` `3`", "16", "05", "24.590975"], 
    StringForm["`1` `2` `3`", "-06", "52", "16.23230"], 
    NumberForm[516.1323458251625569, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[597.4590840253762862, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/07 14:00", StringForm["`1` `2` `3`", "16", "05", "24.473285"], 
    StringForm["`1` `2` `3`", "-06", "51", "53.68254"], 
    NumberForm[517.1003217985287388, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[610.7323751644648326, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/07 15:20", StringForm["`1` `2` `3`", "16", "05", "24.462611"], 
    StringForm["`1` `2` `3`", "-06", "51", "52.34805"], 
    NumberForm[517.1901172313788777, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[611.5180403102587496, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/08 14:00", StringForm["`1` `2` `3`", "16", "05", "24.217550"], 
    StringForm["`1` `2` `3`", "-06", "51", "29.52831"], 
    NumberForm[519.2737626807123168, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[624.9554954676784713, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/08 15:20", StringForm["`1` `2` `3`", "16", "05", "24.199399"], 
    StringForm["`1` `2` `3`", "-06", "51", "28.17822"], 
    NumberForm[519.4290527139448756, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[625.7506509954970519, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/09 14:00", StringForm["`1` `2` `3`", "16", "05", "23.827512"], 
    StringForm["`1` `2` `3`", "-06", "51", "05.09821"], 
    NumberForm[522.6236616323249926, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[639.3465249310546445, {5, 3}, NumberPadding -> {" ", "0"}]}, 
   {"03/09 15:20", StringForm["`1` `2` `3`", "16", "05", "23.801918"], 
    StringForm["`1` `2` `3`", "-06", "51", "03.73310"], 
    NumberForm[522.844152467734554, {5, 3}, NumberPadding -> {" ", "0"}], 
    NumberForm[640.1508275173477229, {5, 3}, NumberPadding -> {" ", "0"}]}}, 
  TableHeadings -> {None, {"mo/dy hr:mn", "ra2000", "dec2000", "column", "row"}}, 
  TableSpacing -> {0, 2}]
;[o]
   mo/dy hr:mn  ra2000           dec2000          column    row
   02/22 14:00  16 05 15.390969  -06 56 37.96638   597.490   443.840
   02/22 15:20  16 05 15.479051  -06 56 36.88523   596.720   444.470
   02/23 14:00  16 05 16.911957  -06 56 18.31281   584.110   455.340
   02/23 15:20  16 05 16.992449  -06 56 17.20905   583.400   455.980
   02/24 14:00  16 05 18.296164  -06 55 58.25624   571.920   467.080
   02/24 15:20  16 05 18.369048  -06 55 57.13034   571.280   467.740
   02/25 14:00  16 05 19.543312  -06 55 37.80529   560.940   479.060
   02/25 15:20  16 05 19.608575  -06 55 36.65774   560.360   479.740
   02/26 14:00  16 05 20.653196  -06 55 16.96886   551.150   491.280
   02/26 15:20  16 05 20.710829  -06 55 15.80016   550.640   491.960
   02/27 14:00  16 05 21.625690  -06 54 55.75616   542.570   503.720
   02/27 15:20  16 05 21.675688  -06 54 54.56683   542.130   504.420
   02/28 14:00  16 05 22.460756  -06 54 34.17666   535.190   516.380
   02/28 15:20  16 05 22.503119  -06 54 32.96724   534.820   517.090
   03/01 14:00  16 05 23.158448  -06 54 12.24007   529.010   529.260
   03/01 15:20  16 05 23.193184  -06 54 11.01110   528.710   529.980
   03/02 14:00  16 05 23.718912  -06 53 49.95628   524.040   542.350
   03/02 15:20  16 05 23.746030  -06 53 48.70831   523.800   543.080
   03/03 14:00  16 05 24.142376  -06 53 27.33529   520.260   555.640
   03/03 15:20  16 05 24.161891  -06 53 26.06889   520.090   556.380
   03/04 14:00  16 05 24.429145  -06 53 04.38723   517.690   569.130
   03/04 15:20  16 05 24.441075  -06 53 03.10295   517.580   569.890
   03/05 14:00  16 05 24.579589  -06 52 41.12227   516.300   582.810
   03/05 15:20  16 05 24.583959  -06 52 39.82068   516.260   583.580
   03/06 14:00  16 05 24.594142  -06 52 17.55062   516.110   596.680
   03/06 15:20  16 05 24.590975  -06 52 16.23230   516.130   597.460
   03/07 14:00  16 05 24.473285  -06 51 53.68254   517.100   610.730
   03/07 15:20  16 05 24.462611  -06 51 52.34805   517.190   611.520
   03/08 14:00  16 05 24.217550  -06 51 29.52831   519.270   624.960
   03/08 15:20  16 05 24.199399  -06 51 28.17822   519.430   625.750
   03/09 14:00  16 05 23.827512  -06 51 05.09821   522.620   639.350
   03/09 15:20  16 05 23.801918  -06 51 03.73310   522.840   640.150
^*)
