(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, whiteDot, M18, N3, L-5,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M18, N3, L-5,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M18, N3, R65535, L-5,  10, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M18, N3, L-5,  10, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M18, N3, B65535, L-5,  10, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M18, N3, w435, h442,  10, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; preserveAspect; startGroup]
Title
:[font = subtitle; inactive; preserveAspect]
Leslie Young

:[font = section; inactive; preserveAspect; startGroup]
Overview
:[font = text; inactive; preserveAspect; endGroup]
Find the mean refractivity as a function of V-R for the UH 88 inch telescope at MKO,
using their standard V filter and the 2048x2048 tektronics CCD.
:[font = section; inactive; initialization; preserveAspect; startGroup]
Initilize
:[font = input; initialization; preserveAspect; startGroup]
*)
$Path = Join[$Path, {First[$Path] <> $PathnameSeparator <> "jleGroup"}];
Get[ "jleGroup.Startup.m"]
(*
;[s]
2:0,1;73,0;100,-1;
2:1,11,9,Courier,0,10,0,0,0;1,12,9,Times,0,12,0,0,0;
:[font = print; inactive; initialization; preserveAspect; endGroup]
Context                                   File Name
------------------------------------------------------
jleGroup`brownAndZiegler`        :jleGroup:brownAndZiegler_2.3.m
jleGroup`colorTables`            :jleGroup:colorTables_2.1.m
jleGroup`fitsAide`               :jleGroup:fitsAide_6.0.1.m
jleGroup`fitsManagerMath`        :jleGroup:fitsManagerMath_2.5.2.m
jleGroup`frameFitting`           :jleGroup:frameFitting_1.0.m
jleGroup`grabBag`                :jleGroup:grabBag_2.9.2.m
jleGroup`imageCubeProc`          :jleGroup:imageCubeProc_1.1.4.m
jleGroup`imageModels`            :jleGroup:imageModels_1.0.1.m
jleGroup`imageProcessing`        :jleGroup:imageProcessing_4.4.1.m
jleGroup`leastSquares`           :jleGroup:leastSquares_4.4.4.m
jleGroup`mathLinkUtilities`      :jleGroup:mathLinkUtilities_1.0.m
jleGroup`occLightCurves`         :jleGroup:occLightCurves_2.13.0.m
jleGroup`plateReduction`         :jleGroup:plateReduction_2.3.1.m
jleGroup`remoteObserving`        :jleGroup:remoteObserving_2.2.m
jleGroup`shadowMap`              :jleGroup:shadowMap_3.0.m
jleGroup`star`                   :jleGroup:star_3.1.2.m
jleGroup`tableProcessing`        :jleGroup:tableProcessing_3.1.1.m
jleGroup`timeAndCoords`          :jleGroup:timeAndCoords_4.3.2.m

Computer, type, and operating system: $machineName, Power Macintosh, MacOS
Date of initialization: {1996, 2, 14, 10, 54, 19}
:[font = subsection; inactive; initialization; preserveAspect; startGroup]
force loadings
:[font = input; initialization; preserveAspect; endGroup]
*)
noshow::usage;
lsFit::usage;
ListAndCurvePlot::usage;
MultipleListPlot::usage;
(*
:[font = subsection; inactive; initialization; preserveAspect; startGroup]
Options
:[font = input; initialization; preserveAspect]
*)
SetOptions[ ListPlot, PlotJoined->True, PlotRange->All ];
(*
:[font = input; initialization; preserveAspect]
*)
SetOptions[ MultipleListPlot, 
 PlotJoined->True, DotShapes->{{GrayLevel[1],Point[#1]}&},
 LineStyles->{ {Thickness[0]} } ];

(*
:[font = input; initialization; preserveAspect; startGroup]
*)
$LineStyles = {{}}
(*
:[font = output; output; inactive; initialization; preserveAspect; fontLeading = 0; endGroup; endGroup]
{{}}
;[o]
{{}}
:[font = subsection; inactive; initialization; preserveAspect; startGroup]
Our Functions
:[font = input; initialization; preserveAspect; endGroup]
*)
norm[xL_] := xL / Max[xL];
(*
:[font = subsection; inactive; initialization; preserveAspect; startGroup]
Our files
:[font = input; initialization; preserveAspect; startGroup]
*)
FileType[ mr95D = "Macintosh HD:projects:mr95" ]
(*
:[font = output; output; inactive; initialization; preserveAspect; endGroup; endGroup; endGroup]
Directory
;[o]
Directory
:[font = section; inactive; preserveAspect; startGroup]
Read in or calculate lists: 
lamL, qFilterL, qChipL, refrL, extL, nPhotons[T]
:[font = input; preserveAspect]
(* v_filter has 12 lines of email info, then lines

   wavelength  transmission
   
   wavelength is in nm *)
:[font = input; preserveAspect; startGroup]
FileType[ fn = mr95D <> ":from_uh:vfilter" ]
:[font = output; output; inactive; preserveAspect; endGroup]
File
;[o]
File
:[font = input; preserveAspect]
fp = OpenRead[fn];
ReadList[ fp, String, 12];
temp = ReadList[ fp, {Number, Number}];
Close[fp];
:[font = input; preserveAspect]
{lamL, qFilterL} = Transpose[temp];
lamL = lamL / 1000;
:[font = input; preserveAspect]
(* The QE of the chip.
wavelengh      QE
  .4500      0.645 
  .5556      0.605
  .6500      0.812 
  
  Make a quadratic function joining these 3 measurements. *)

lam1 = .450; lam2 = .556; lam3 = .65 ;
qe1  = .645; qe2  = .605; qe3  = .812;
qChipL = qe1 (lamL-lam2)(lamL-lam3)/( (lam1-lam2)(lam1-lam3) ) +
         qe2 (lamL-lam1)(lamL-lam3)/( (lam2-lam1)(lam2-lam3) ) +
         qe3 (lamL-lam1)(lamL-lam2)/( (lam3-lam1)(lam3-lam2) );
:[font = input; preserveAspect]
(* refractivity, for MKO,
   derived in Macintosh HD:Projects:mr95:refract:refr.kgp,
   expressed in arcsec in the expression dz = R tanz *)
refrF[lam_] = (641/1013) * 0.206265 * 
        (272.08 + 1.3928 lam^-2 + .0078203 * lam^-4);
refrL = refrF[lamL];
refr1um = refrF[1.0];
:[font = input; preserveAspect]
(* extMagPerAirmassL = extinction, for MKO,
   derived in Macintosh HD:Projects:mr95:refract:ext.kgp,
   in magnitudes per airmass 
   
   extL is the transmission *)
   
extMagPerAirmassL = 0.12355 (lamL-0.5) + 0.025726 * (lamL^-0.8) +
9.4977 * 10^-3 * lamL^-4 * (refrL/refr1um)^2 * Exp[-4.194/7.996];

extL = 10^(-0.4 * extMagPerAirmassL);
:[font = input; dontPreserveAspect; endGroup]
(* number of photons per micron for a given temperture *)
c2 = 14384; (* h c / k in micron K *)
nPhotons[t_] := N[ lamL^-4 / (Exp[c2/(lamL t)] - 1)] ;
:[font = section; inactive; preserveAspect; startGroup]
Temperatue and color
:[font = input; preserveAspect]
(* Macintosh HD:Projects:mr95:refract:T(color).txt
   has one line of headings and then lines of
   
   spectral-type   V-R    Temperature
   
   from Zombeck, Handbook of space astronomy and astrophysics
 *)
:[font = input; preserveAspect; startGroup]
FileType[ fn = "Macintosh HD:Projects:mr95:refract:T(color).txt" ]
:[font = output; output; inactive; preserveAspect; endGroup]
File
;[o]
File
:[font = input; preserveAspect]
fp = OpenRead[fn];
Read[fp, String];
temp = ReadList[ fp, {Word, Number, Number},35];
Close[ fp ];
{specL, colorL, tL} = Transpose[temp];
:[font = input; preserveAspect; startGroup]
TableForm[Transpose[{specL, colorL, tL}]]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
TableForm[{{"O5-7", -0.15, 38000}, {"O8-9", -0.15, 35000}, 
   {"O9.5", -0.14, 31900}, {"B0", -0.13, 30000}, {"B0.5", -0.12, 27000}, 
   {"B1", -0.11, 24200}, {"B2", -0.1, 22100}, {"B3", -0.08, 18800}, 
   {"B5", -0.06, 16400}, {"B6", -0.06, 15400}, {"B7", -0.04, 14500}, 
   {"B8", -0.02, 13400}, {"B9", 0., 12400}, {"A0", 0.02, 10800}, 
   {"A2", 0.08, 9730}, {"A5", 0.16, 8620}, {"A7", 0.19, 8190}, 
   {"F0", 0.3, 7240}, {"F2", 0.35, 6930}, {"F5", 0.4, 6540}, 
   {"F8", 0.47, 6200}, {"G0", 0.5, 5920}, 
   {"G2", 0.5300000000000001, 5780}, {"G5", 0.5400000000000001, 5610}, 
   {"G8", 0.58, 5490}, {"K0", 0.6400000000000001, 5240}, 
   {"K2", 0.7400000000000001, 4780}, {"K5", 0.99, 4410}, 
   {"K7", 1.15, 4160}, {"M0", 1.28, 3920}, {"M1", 1.4, 3680}, 
   {"M2", 1.5, 3500}, {"M3", 1.6, 3360}, {"M4", 1.7, 3230}, 
   {"M5", 1.8, 3120}}]
;[o]
O5-7   -0.15   38000

O8-9   -0.15   35000

O9.5   -0.14   31900

B0     -0.13   30000

B0.5   -0.12   27000

B1     -0.11   24200

B2     -0.1    22100

B3     -0.08   18800

B5     -0.06   16400

B6     -0.06   15400

B7     -0.04   14500

B8     -0.02   13400

B9     0.      12400

A0     0.02    10800

A2     0.08    9730

A5     0.16    8620

A7     0.19    8190

F0     0.3     7240

F2     0.35    6930

F5     0.4     6540

F8     0.47    6200

G0     0.5     5920

G2     0.53    5780

G5     0.54    5610

G8     0.58    5490

K0     0.64    5240

K2     0.74    4780

K5     0.99    4410

K7     1.15    4160

M0     1.28    3920

M1     1.4     3680

M2     1.5     3500

M3     1.6     3360

M4     1.7     3230

M5     1.8     3120
:[font = section; inactive; preserveAspect; startGroup]
mean wavelengths,
mean refractivities
:[font = input; preserveAspect]
(* the mean x, weighted by weight.
   THIS ONLY WORKS IF x AND weight ARE TABULATED AT THE
   SAME WAVELENGTHS, AND AT A CONSTANT SPACING *)
   
mean[xL_, weight_] := Plus@@(xL*weight) / Plus@@(weight)
:[font = input; preserveAspect]
meanLamF[airmass_, t_] := mean[lamL, 
	qFilterL qChipL (extL^airmass) nPhotons[t] ]
meanRefrF[airmass_, t_] := mean[refrL, 
	qFilterL qChipL (extL^airmass) nPhotons[t] ]
:[font = input; preserveAspect; startGroup]
(* Some tests .... *)
{meanLamF[1.12, 38000], meanLamF[1.12, 3120] }
:[font = output; output; inactive; preserveAspect; endGroup]
{0.5374640969644493, 0.5469121955770089}
;[o]
{0.537464, 0.546912}
:[font = input; preserveAspect; startGroup]
refrF[{meanLamF[1.12, 38000], meanLamF[1.12, 3120] }]
:[font = output; output; inactive; preserveAspect; endGroup]
{36.15318231097654, 36.13080345439352}
;[o]
{36.1532, 36.1308}
:[font = input; preserveAspect; startGroup]
{meanRefrF[1.12, 38000], meanRefrF[1.12, 3120] }
:[font = output; output; inactive; preserveAspect; endGroup]
{36.15822129496033, 36.13536805812264}
;[o]
{36.1582, 36.1354}
:[font = input; preserveAspect; startGroup]
1000 (% - %%)
:[font = output; output; inactive; preserveAspect; endGroup]
{5.03898398378766, 4.564603729122041}
;[o]
{5.03898, 4.5646}
:[font = input; Cclosed; preserveAspect; startGroup]
(* Apply meanRefrF to each temperature (tL) at X=1.12 *)
meanRefr112L = meanRefrF[1.12, #]& /@ tL
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{36.15822129496033, 36.1580980774798, 36.15794383020905, 36.15783181133795, 
  36.15761905257469, 36.15736684199953, 36.157130185937, 36.15663580448886, 
  36.15613191788328, 36.15586865114208, 36.15559607306734, 
  36.15520572490901, 36.15478171362606, 36.15391474917841, 
  36.15315238989066, 36.15213425048257, 36.15165682276461, 
  36.15037936878974, 36.14987977109281, 36.14917882895329, 
  36.14849102866279, 36.14786200979176, 36.14752360149837, 
  36.14708909334444, 36.14676564269247, 36.14604294035405, 
  36.14451258233983, 36.1430502034298, 36.14191750109721, 
  36.14069858114164, 36.13932792391707, 36.13818369958994, 
  36.13721478233598, 36.13624570385441, 36.13536805812264}
;[o]
{36.1582, 36.1581, 36.1579, 36.1578, 36.1576, 36.1574, 36.1571, 36.1566, 
  36.1561, 36.1559, 36.1556, 36.1552, 36.1548, 36.1539, 36.1532, 36.1521, 
  36.1517, 36.1504, 36.1499, 36.1492, 36.1485, 36.1479, 36.1475, 36.1471, 
  36.1468, 36.146, 36.1445, 36.1431, 36.1419, 36.1407, 36.1393, 36.1382, 
  36.1372, 36.1362, 36.1354}
:[font = input; Cclosed; preserveAspect; startGroup]
(* Apply meanRefrF to each temperature (tL) at X=1.26 *)
meanRefr126L = meanRefrF[1.26, #]& /@ tL
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{36.15811374862586, 36.15799055772954, 36.15783634442716, 36.1577243507019, 
  36.15751164079398, 36.15725948997496, 36.1570228917808, 
  36.15652863676229, 36.15602488661837, 36.15576169418784, 
  36.1554891952114, 36.1550989641257, 36.15467508504391, 36.15380840706283, 
  36.15304631744527, 36.15202856388171, 36.15155132715737, 
  36.15027441565077, 36.14977504251156, 36.14907442715225, 
  36.14838696079624, 36.14775825881654, 36.14742002554596, 
  36.14698574676586, 36.14666247025176, 36.14594016744093, 
  36.14441070295523, 36.14294923795293, 36.14181728364131, 
  36.14059920757453, 36.13922954719535, 36.13808619359429, 
  36.13711804089264, 36.13614975188573, 36.13527284238487}
;[o]
{36.1581, 36.158, 36.1578, 36.1577, 36.1575, 36.1573, 36.157, 36.1565, 
  36.156, 36.1558, 36.1555, 36.1551, 36.1547, 36.1538, 36.153, 36.152, 
  36.1516, 36.1503, 36.1498, 36.1491, 36.1484, 36.1478, 36.1474, 36.147, 
  36.1467, 36.1459, 36.1444, 36.1429, 36.1418, 36.1406, 36.1392, 36.1381, 
  36.1371, 36.1361, 36.1353}
:[font = input; Cclosed; preserveAspect; startGroup]
1000(meanRefr126L-meanRefr112L)
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{-0.1075463344690775, -0.1075197502586889, -0.1074857818892383, 
  -0.107460636051826, -0.10741178071072, -0.1073520245711279, 
  -0.1072941562014762, -0.1071677265755966, -0.107031264917623, 
  -0.1069569542408999, -0.1068778559485395, -0.1067607833107331, 
  -0.1066285821522683, -0.1063421155791389, -0.1060724453836315, 
  -0.1056866008610768, -0.1054956072437108, -0.1049531389725189, 
  -0.1047285812489918, -0.1044018010389891, -0.1040678665447103, 
  -0.1037509752137566, -0.1035759524086188, -0.1033465785766907, 
  -0.1031724407098977, -0.1027729131166666, -0.1018793846014887, 
  -0.1009654768751034, -0.1002174559019409, -0.0993735671102058, 
  -0.09837672171642, -0.0975059956473956, -0.0967414433361569, 
  -0.0959519686816179, -0.0952157377724916}
;[o]
{-0.107546, -0.10752, -0.107486, -0.107461, -0.107412, -0.107352, 
  -0.107294, -0.107168, -0.107031, -0.106957, -0.106878, -0.106761, 
  -0.106629, -0.106342, -0.106072, -0.105687, -0.105496, -0.104953, 
  -0.104729, -0.104402, -0.104068, -0.103751, -0.103576, -0.103347, 
  -0.103172, -0.102773, -0.101879, -0.100965, -0.100217, -0.0993736, 
  -0.0983767, -0.097506, -0.0967414, -0.095952, -0.0952157}
:[font = input; Cclosed; preserveAspect; startGroup]
(* Apply meanLamF to each temperature (tL) at X=1.12 *)
meanLam112L = meanLamF[1.12, #]& /@ tL
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{0.5374640969644493, 0.5375144750205393, 0.5375775469147173, 
  0.5376233566221993, 0.5377103754313918, 0.5378135506322385, 
  0.5379103833359743, 0.5381127354215555, 0.5383190715419433, 
  0.5384269147028684, 0.5385386001512593, 0.538698590592394, 
  0.5388724460334215, 0.5392281455605517, 0.5395411768410065, 
  0.5399596016061797, 0.5401559560189361, 0.5406818026917636, 
  0.5408876385046271, 0.5411766029801701, 0.5414603476923264, 
  0.5417200147138878, 0.5418597820265953, 0.5420393097864254, 
  0.5421730024471563, 0.5424718763891474, 0.5431054769177073, 
  0.5437118498774951, 0.5441821419241528, 0.5446888378604861, 
  0.5452593659287408, 0.5457362600659801, 0.5461405317579625, 
  0.5465452798487464, 0.5469121955770089}
;[o]
{0.537464, 0.537514, 0.537578, 0.537623, 0.53771, 0.537814, 0.53791, 
  0.538113, 0.538319, 0.538427, 0.538539, 0.538699, 0.538872, 0.539228, 
  0.539541, 0.53996, 0.540156, 0.540682, 0.540888, 0.541177, 0.54146, 
  0.54172, 0.54186, 0.542039, 0.542173, 0.542472, 0.543105, 0.543712, 
  0.544182, 0.544689, 0.545259, 0.545736, 0.546141, 0.546545, 0.546912}
:[font = input; Cclosed; preserveAspect; startGroup]
(* Apply meanLamF to each temperature (tL) at X=1.26 *)
meanLam126L = meanLamF[1.26, #]& /@ tL
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{0.5375078074999719, 0.5375581798331348, 0.537621244280529, 
  0.5376670483843631, 0.5377540561011245, 0.5378572173970398, 
  0.5379540363155364, 0.5381563573273671, 0.5383626586517688, 
  0.5384704823930161, 0.5385821468458122, 0.5387421056549577, 
  0.5389159246614699, 0.5392715430232719, 0.5395844955889907, 
  0.5400028045924065, 0.5401991005504833, 0.5407247777655501, 
  0.5409305421468557, 0.5412194015204004, 0.5415030375629523, 
  0.5417626004023843, 0.5419023097694034, 0.5420817611836509, 
  0.5422153955929517, 0.5425141350053817, 0.5431474307218747, 
  0.5437534871383209, 0.5442235170688505, 0.5447299144730488, 
  0.5453000865343111, 0.5457766670840428, 0.5461806616272852, 
  0.5465851219305556, 0.5469517679290351}
;[o]
{0.537508, 0.537558, 0.537621, 0.537667, 0.537754, 0.537857, 0.537954, 
  0.538156, 0.538363, 0.53847, 0.538582, 0.538742, 0.538916, 0.539272, 
  0.539584, 0.540003, 0.540199, 0.540725, 0.540931, 0.541219, 0.541503, 
  0.541763, 0.541902, 0.542082, 0.542215, 0.542514, 0.543147, 0.543753, 
  0.544224, 0.54473, 0.5453, 0.545777, 0.546181, 0.546585, 0.546952}
:[font = input; Cclosed; preserveAspect; startGroup]
(* Plot them up *)
ListPlot[  Transpose[{colorL, meanLam126L}], 
           Frame->True, Axes->False,
           PlotLabel->"mean wavelength (micron) vs V-R"
           ];
ListPlot[  Transpose[{colorL, meanRefr126L}], 
           Frame->True, Axes->False,
           PlotLabel->"dz/tanz (arcsec) vs V-R"
           ];
ListPlot[  Transpose[{colorL, 1000*(meanRefr126L - meanRefrF[1.26, 6200])}], 
           Frame->True, 
           PlotLabel->"dz/tanz - dz/tanz(V-R=0.47) (in mas)  vs V-R"
           ];

ListPlot[  Transpose[{colorL, 1000*(meanRefr126L - meanRefrF[1.26, 6200])}], 
           Frame->True, 
           PlotLabel->"dz/tanz - dz/tanz(V-R=0.47) (in mas)  vs V-R",
           PlotRange->{{.3,.77},{-4,2}}
           ];

:[font = postscript; PICT; formatAsPICT; output; inactive; preserveAspect; pictureWidth = 435; pictureHeight = 268; startGroup; pictureID = 29224]

:[font = postscript; PICT; formatAsPICT; output; inactive; preserveAspect; pictureWidth = 435; pictureHeight = 268; pictureID = 3403]

:[font = postscript; PICT; formatAsPICT; output; inactive; preserveAspect; pictureLeft = 1; pictureWidth = 435; pictureHeight = 268; pictureID = 1949]

:[font = postscript; PICT; formatAsPICT; output; inactive; preserveAspect; pictureWidth = 435; pictureHeight = 268; endGroup; endGroup; pictureID = 24644]

:[font = input; Cclosed; preserveAspect; startGroup]
Fit[ Transpose[{colorL, meanRefr126L-36}], {1, x}, {x}]
:[font = output; output; inactive; preserveAspect; endGroup]
0.1548087714483227 - 0.01160688934972294*x
;[o]
0.154809 - 0.0116069 x
:[font = input; Cclosed; preserveAspect; startGroup]
Fit[ Transpose[{colorL, meanRefr112L-36}], {1, x}, {x}]
:[font = output; output; inactive; preserveAspect; endGroup]
0.1549154585377903 - 0.01161297816517496*x
;[o]
0.154915 - 0.011613 x
:[font = input; Cclosed; preserveAspect; startGroup]
Take[colorL,{18,27}]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
{0.3, 0.35, 0.4, 0.47, 0.5, 0.5300000000000001, 0.5400000000000001, 0.58, 
  0.6400000000000001, 0.7400000000000001}
;[o]
{0.3, 0.35, 0.4, 0.47, 0.5, 0.53, 0.54, 0.58, 0.64, 0.74}
:[font = input; Cclosed; preserveAspect; startGroup]
Fit[ Take[Transpose[{colorL, meanRefr126L-36}],{18,27}], {1, x}, {x}]
:[font = output; output; inactive; preserveAspect; fontLeading = 0; endGroup]
0.1544499704372792 - 0.01342801712587374*x
;[o]
0.15445 - 0.013428 x
:[font = input; preserveAspect]
meanRefr126M = 36.154809-0.0116069 * colorL;
:[font = input; Cclosed; preserveAspect; startGroup]
ListPlot[ Transpose[{colorL, 1000*(meanRefr126L-meanRefr126M)}], 
           Frame->True, 
           PlotLabel->"dz/tanz - (36.154809-0.0116069 * (V-R)) (in mas)  vs V-R"
           ];

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureWidth = 435; pictureHeight = 268; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0970696 0.4884 0.330436 0.174509 [
[(0)] .09707 0 0 2 Msboxa
[(0.5)] .34127 0 0 2 Msboxa
[(1)] .58547 0 0 2 Msboxa
[(1.5)] .82967 0 0 2 Msboxa
[(-1.5)] -0.0125 .06867 1 0 Msboxa
[(-1)] -0.0125 .15593 1 0 Msboxa
[(-0.5)] -0.0125 .24318 1 0 Msboxa
[(0)] -0.0125 .33044 1 0 Msboxa
[(0.5)] -0.0125 .41769 1 0 Msboxa
[(1)] -0.0125 .50495 1 0 Msboxa
[(1.5)] -0.0125 .5922 1 0 Msboxa
[(dz/tanz - \(36.154809-0.0116069 * \(V-R\)\) \(in mas\)  vs V-R)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.09707 0 m
.09707 .00625 L
s
P
[(0)] .09707 0 0 2 Mshowa
p
.002 w
.34127 0 m
.34127 .00625 L
s
P
[(0.5)] .34127 0 0 2 Mshowa
p
.002 w
.58547 0 m
.58547 .00625 L
s
P
[(1)] .58547 0 0 2 Mshowa
p
.002 w
.82967 0 m
.82967 .00625 L
s
P
[(1.5)] .82967 0 0 2 Mshowa
p
.001 w
.14591 0 m
.14591 .00375 L
s
P
p
.001 w
.19475 0 m
.19475 .00375 L
s
P
p
.001 w
.24359 0 m
.24359 .00375 L
s
P
p
.001 w
.29243 0 m
.29243 .00375 L
s
P
p
.001 w
.39011 0 m
.39011 .00375 L
s
P
p
.001 w
.43895 0 m
.43895 .00375 L
s
P
p
.001 w
.48779 0 m
.48779 .00375 L
s
P
p
.001 w
.53663 0 m
.53663 .00375 L
s
P
p
.001 w
.63431 0 m
.63431 .00375 L
s
P
p
.001 w
.68315 0 m
.68315 .00375 L
s
P
p
.001 w
.73199 0 m
.73199 .00375 L
s
P
p
.001 w
.78083 0 m
.78083 .00375 L
s
P
p
.001 w
.04823 0 m
.04823 .00375 L
s
P
p
.001 w
.87851 0 m
.87851 .00375 L
s
P
p
.001 w
.92735 0 m
.92735 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .06867 m
.00625 .06867 L
s
P
[(-1.5)] -0.0125 .06867 1 0 Mshowa
p
.002 w
0 .15593 m
.00625 .15593 L
s
P
[(-1)] -0.0125 .15593 1 0 Mshowa
p
.002 w
0 .24318 m
.00625 .24318 L
s
P
[(-0.5)] -0.0125 .24318 1 0 Mshowa
p
.002 w
0 .33044 m
.00625 .33044 L
s
P
[(0)] -0.0125 .33044 1 0 Mshowa
p
.002 w
0 .41769 m
.00625 .41769 L
s
P
[(0.5)] -0.0125 .41769 1 0 Mshowa
p
.002 w
0 .50495 m
.00625 .50495 L
s
P
[(1)] -0.0125 .50495 1 0 Mshowa
p
.002 w
0 .5922 m
.00625 .5922 L
s
P
[(1.5)] -0.0125 .5922 1 0 Mshowa
p
.001 w
0 .08612 m
.00375 .08612 L
s
P
p
.001 w
0 .10357 m
.00375 .10357 L
s
P
p
.001 w
0 .12102 m
.00375 .12102 L
s
P
p
.001 w
0 .13848 m
.00375 .13848 L
s
P
p
.001 w
0 .17338 m
.00375 .17338 L
s
P
p
.001 w
0 .19083 m
.00375 .19083 L
s
P
p
.001 w
0 .20828 m
.00375 .20828 L
s
P
p
.001 w
0 .22573 m
.00375 .22573 L
s
P
p
.001 w
0 .26063 m
.00375 .26063 L
s
P
p
.001 w
0 .27808 m
.00375 .27808 L
s
P
p
.001 w
0 .29553 m
.00375 .29553 L
s
P
p
.001 w
0 .31299 m
.00375 .31299 L
s
P
p
.001 w
0 .34789 m
.00375 .34789 L
s
P
p
.001 w
0 .36534 m
.00375 .36534 L
s
P
p
.001 w
0 .38279 m
.00375 .38279 L
s
P
p
.001 w
0 .40024 m
.00375 .40024 L
s
P
p
.001 w
0 .43514 m
.00375 .43514 L
s
P
p
.001 w
0 .45259 m
.00375 .45259 L
s
P
p
.001 w
0 .47004 m
.00375 .47004 L
s
P
p
.001 w
0 .48749 m
.00375 .48749 L
s
P
p
.001 w
0 .5224 m
.00375 .5224 L
s
P
p
.001 w
0 .53985 m
.00375 .53985 L
s
P
p
.001 w
0 .5573 m
.00375 .5573 L
s
P
p
.001 w
0 .57475 m
.00375 .57475 L
s
P
p
.001 w
0 .05122 m
.00375 .05122 L
s
P
p
.001 w
0 .03377 m
.00375 .03377 L
s
P
p
.001 w
0 .01632 m
.00375 .01632 L
s
P
p
.001 w
0 .60965 m
.00375 .60965 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.09707 .61178 m
.09707 .61803 L
s
P
p
.002 w
.34127 .61178 m
.34127 .61803 L
s
P
p
.002 w
.58547 .61178 m
.58547 .61803 L
s
P
p
.002 w
.82967 .61178 m
.82967 .61803 L
s
P
p
.001 w
.14591 .61428 m
.14591 .61803 L
s
P
p
.001 w
.19475 .61428 m
.19475 .61803 L
s
P
p
.001 w
.24359 .61428 m
.24359 .61803 L
s
P
p
.001 w
.29243 .61428 m
.29243 .61803 L
s
P
p
.001 w
.39011 .61428 m
.39011 .61803 L
s
P
p
.001 w
.43895 .61428 m
.43895 .61803 L
s
P
p
.001 w
.48779 .61428 m
.48779 .61803 L
s
P
p
.001 w
.53663 .61428 m
.53663 .61803 L
s
P
p
.001 w
.63431 .61428 m
.63431 .61803 L
s
P
p
.001 w
.68315 .61428 m
.68315 .61803 L
s
P
p
.001 w
.73199 .61428 m
.73199 .61803 L
s
P
p
.001 w
.78083 .61428 m
.78083 .61803 L
s
P
p
.001 w
.04823 .61428 m
.04823 .61803 L
s
P
p
.001 w
.87851 .61428 m
.87851 .61803 L
s
P
p
.001 w
.92735 .61428 m
.92735 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(dz/tanz - \(36.154809-0.0116069 * \(V-R\)\) \(in mas\)  vs V-R)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 .06867 m
1 .06867 L
s
P
p
.002 w
.99375 .15593 m
1 .15593 L
s
P
p
.002 w
.99375 .24318 m
1 .24318 L
s
P
p
.002 w
.99375 .33044 m
1 .33044 L
s
P
p
.002 w
.99375 .41769 m
1 .41769 L
s
P
p
.002 w
.99375 .50495 m
1 .50495 L
s
P
p
.002 w
.99375 .5922 m
1 .5922 L
s
P
p
.001 w
.99625 .08612 m
1 .08612 L
s
P
p
.001 w
.99625 .10357 m
1 .10357 L
s
P
p
.001 w
.99625 .12102 m
1 .12102 L
s
P
p
.001 w
.99625 .13848 m
1 .13848 L
s
P
p
.001 w
.99625 .17338 m
1 .17338 L
s
P
p
.001 w
.99625 .19083 m
1 .19083 L
s
P
p
.001 w
.99625 .20828 m
1 .20828 L
s
P
p
.001 w
.99625 .22573 m
1 .22573 L
s
P
p
.001 w
.99625 .26063 m
1 .26063 L
s
P
p
.001 w
.99625 .27808 m
1 .27808 L
s
P
p
.001 w
.99625 .29553 m
1 .29553 L
s
P
p
.001 w
.99625 .31299 m
1 .31299 L
s
P
p
.001 w
.99625 .34789 m
1 .34789 L
s
P
p
.001 w
.99625 .36534 m
1 .36534 L
s
P
p
.001 w
.99625 .38279 m
1 .38279 L
s
P
p
.001 w
.99625 .40024 m
1 .40024 L
s
P
p
.001 w
.99625 .43514 m
1 .43514 L
s
P
p
.001 w
.99625 .45259 m
1 .45259 L
s
P
p
.001 w
.99625 .47004 m
1 .47004 L
s
P
p
.001 w
.99625 .48749 m
1 .48749 L
s
P
p
.001 w
.99625 .5224 m
1 .5224 L
s
P
p
.001 w
.99625 .53985 m
1 .53985 L
s
P
p
.001 w
.99625 .5573 m
1 .5573 L
s
P
p
.001 w
.99625 .57475 m
1 .57475 L
s
P
p
.001 w
.99625 .05122 m
1 .05122 L
s
P
p
.001 w
.99625 .03377 m
1 .03377 L
s
P
p
.001 w
.99625 .01632 m
1 .01632 L
s
P
p
.001 w
.99625 .60965 m
1 .60965 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
p
.002 w
0 .33044 m
1 .33044 L
s
P
P
.004 w
.02381 .60332 m
.02381 .58182 L
.02869 .57516 L
.03358 .57588 L
.03846 .55901 L
.04335 .53526 L
.04823 .51423 L
.058 .46849 L
.06777 .42109 L
.06777 .37516 L
.07753 .36812 L
.0873 .34053 L
.09707 .30707 L
.10684 .19633 L
.13614 .18487 L
.17521 .16931 L
.18987 .14679 L
.24359 .14676 L
.26801 .16089 L
.29243 .1399 L
.32662 .16172 L
.34127 .11277 L
.35592 .11451 L
.36081 .05898 L
.38034 .08359 L
.40965 .07907 L
.45849 .01472 L
.58059 .26605 L
.65873 .3926 L
.72222 .44335 L
.78083 .44739 L
.82967 .45042 L
.87851 .48402 L
.92735 .51759 L
.97619 .56712 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = input; Cclosed; preserveAspect; startGroup]
ListPlot[ Transpose[{colorL, 
           1000*(meanRefr126L-(36.155058
                  - 0.0159471 colorL + 0.00302139 colorL^2))}], 
           Frame->True, 
           PlotLabel->"N - (36.155058 - 0.0159471 V-R + 0.00302139 V-R^2) (in mas)  vs V-R"
           ];

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureWidth = 435; pictureHeight = 268; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0970696 0.4884 0.28431 0.289308 [
[(0)] .09707 0 0 2 Msboxa
[(0.5)] .34127 0 0 2 Msboxa
[(1)] .58547 0 0 2 Msboxa
[(1.5)] .82967 0 0 2 Msboxa
[(-0.5)] -0.0125 .13966 1 0 Msboxa
[(0)] -0.0125 .28431 1 0 Msboxa
[(0.5)] -0.0125 .42896 1 0 Msboxa
[(1)] -0.0125 .57362 1 0 Msboxa
[(N - \(36.155058 - 0.0159471 V-R + 0.00302139 V-R^2\) \(in mas\)  vs V-R)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.09707 0 m
.09707 .00625 L
s
P
[(0)] .09707 0 0 2 Mshowa
p
.002 w
.34127 0 m
.34127 .00625 L
s
P
[(0.5)] .34127 0 0 2 Mshowa
p
.002 w
.58547 0 m
.58547 .00625 L
s
P
[(1)] .58547 0 0 2 Mshowa
p
.002 w
.82967 0 m
.82967 .00625 L
s
P
[(1.5)] .82967 0 0 2 Mshowa
p
.001 w
.14591 0 m
.14591 .00375 L
s
P
p
.001 w
.19475 0 m
.19475 .00375 L
s
P
p
.001 w
.24359 0 m
.24359 .00375 L
s
P
p
.001 w
.29243 0 m
.29243 .00375 L
s
P
p
.001 w
.39011 0 m
.39011 .00375 L
s
P
p
.001 w
.43895 0 m
.43895 .00375 L
s
P
p
.001 w
.48779 0 m
.48779 .00375 L
s
P
p
.001 w
.53663 0 m
.53663 .00375 L
s
P
p
.001 w
.63431 0 m
.63431 .00375 L
s
P
p
.001 w
.68315 0 m
.68315 .00375 L
s
P
p
.001 w
.73199 0 m
.73199 .00375 L
s
P
p
.001 w
.78083 0 m
.78083 .00375 L
s
P
p
.001 w
.04823 0 m
.04823 .00375 L
s
P
p
.001 w
.87851 0 m
.87851 .00375 L
s
P
p
.001 w
.92735 0 m
.92735 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .13966 m
.00625 .13966 L
s
P
[(-0.5)] -0.0125 .13966 1 0 Mshowa
p
.002 w
0 .28431 m
.00625 .28431 L
s
P
[(0)] -0.0125 .28431 1 0 Mshowa
p
.002 w
0 .42896 m
.00625 .42896 L
s
P
[(0.5)] -0.0125 .42896 1 0 Mshowa
p
.002 w
0 .57362 m
.00625 .57362 L
s
P
[(1)] -0.0125 .57362 1 0 Mshowa
p
.001 w
0 .02393 m
.00375 .02393 L
s
P
p
.001 w
0 .05286 m
.00375 .05286 L
s
P
p
.001 w
0 .08179 m
.00375 .08179 L
s
P
p
.001 w
0 .11072 m
.00375 .11072 L
s
P
p
.001 w
0 .16859 m
.00375 .16859 L
s
P
p
.001 w
0 .19752 m
.00375 .19752 L
s
P
p
.001 w
0 .22645 m
.00375 .22645 L
s
P
p
.001 w
0 .25538 m
.00375 .25538 L
s
P
p
.001 w
0 .31324 m
.00375 .31324 L
s
P
p
.001 w
0 .34217 m
.00375 .34217 L
s
P
p
.001 w
0 .3711 m
.00375 .3711 L
s
P
p
.001 w
0 .40003 m
.00375 .40003 L
s
P
p
.001 w
0 .45789 m
.00375 .45789 L
s
P
p
.001 w
0 .48683 m
.00375 .48683 L
s
P
p
.001 w
0 .51576 m
.00375 .51576 L
s
P
p
.001 w
0 .54469 m
.00375 .54469 L
s
P
p
.001 w
0 .60255 m
.00375 .60255 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.09707 .61178 m
.09707 .61803 L
s
P
p
.002 w
.34127 .61178 m
.34127 .61803 L
s
P
p
.002 w
.58547 .61178 m
.58547 .61803 L
s
P
p
.002 w
.82967 .61178 m
.82967 .61803 L
s
P
p
.001 w
.14591 .61428 m
.14591 .61803 L
s
P
p
.001 w
.19475 .61428 m
.19475 .61803 L
s
P
p
.001 w
.24359 .61428 m
.24359 .61803 L
s
P
p
.001 w
.29243 .61428 m
.29243 .61803 L
s
P
p
.001 w
.39011 .61428 m
.39011 .61803 L
s
P
p
.001 w
.43895 .61428 m
.43895 .61803 L
s
P
p
.001 w
.48779 .61428 m
.48779 .61803 L
s
P
p
.001 w
.53663 .61428 m
.53663 .61803 L
s
P
p
.001 w
.63431 .61428 m
.63431 .61803 L
s
P
p
.001 w
.68315 .61428 m
.68315 .61803 L
s
P
p
.001 w
.73199 .61428 m
.73199 .61803 L
s
P
p
.001 w
.78083 .61428 m
.78083 .61803 L
s
P
p
.001 w
.04823 .61428 m
.04823 .61803 L
s
P
p
.001 w
.87851 .61428 m
.87851 .61803 L
s
P
p
.001 w
.92735 .61428 m
.92735 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(N - \(36.155058 - 0.0159471 V-R + 0.00302139 V-R^2\) \(in mas\)  vs V-R)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 .13966 m
1 .13966 L
s
P
p
.002 w
.99375 .28431 m
1 .28431 L
s
P
p
.002 w
.99375 .42896 m
1 .42896 L
s
P
p
.002 w
.99375 .57362 m
1 .57362 L
s
P
p
.001 w
.99625 .02393 m
1 .02393 L
s
P
p
.001 w
.99625 .05286 m
1 .05286 L
s
P
p
.001 w
.99625 .08179 m
1 .08179 L
s
P
p
.001 w
.99625 .11072 m
1 .11072 L
s
P
p
.001 w
.99625 .16859 m
1 .16859 L
s
P
p
.001 w
.99625 .19752 m
1 .19752 L
s
P
p
.001 w
.99625 .22645 m
1 .22645 L
s
P
p
.001 w
.99625 .25538 m
1 .25538 L
s
P
p
.001 w
.99625 .31324 m
1 .31324 L
s
P
p
.001 w
.99625 .34217 m
1 .34217 L
s
P
p
.001 w
.99625 .3711 m
1 .3711 L
s
P
p
.001 w
.99625 .40003 m
1 .40003 L
s
P
p
.001 w
.99625 .45789 m
1 .45789 L
s
P
p
.001 w
.99625 .48683 m
1 .48683 L
s
P
p
.001 w
.99625 .51576 m
1 .51576 L
s
P
p
.001 w
.99625 .54469 m
1 .54469 L
s
P
p
.001 w
.99625 .60255 m
1 .60255 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
p
.002 w
0 .28431 m
1 .28431 L
s
P
P
.004 w
.02381 .45665 m
.02381 .42101 L
.02869 .42507 L
.03358 .44116 L
.03846 .42795 L
.04335 .40314 L
.04823 .38267 L
.058 .33509 L
.06777 .28407 L
.06777 .20793 L
.07753 .22311 L
.0873 .20354 L
.09707 .17353 L
.10684 .01472 L
.13614 .06581 L
.17521 .12367 L
.18987 .11483 L
.24359 .2058 L
.26801 .2636 L
.29243 .25881 L
.32662 .32964 L
.34127 .26072 L
.35592 .27427 L
.36081 .18541 L
.38034 .23727 L
.40965 .24113 L
.45849 .13938 L
.58059 .49192 L
.65873 .60332 L
.72222 .57456 L
.78083 .45083 L
.82967 .32791 L
.87851 .23821 L
.92735 .13098 L
.97619 .0327 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = input; Cclosed; preserveAspect; startGroup]
Fit[ Transpose[{colorL, meanRefr126L-36}], {1, x,x^2}, {x}]//Print
:[font = print; inactive; preserveAspect; endGroup]
                                     2
0.155058 - 0.0159471 x + 0.00302139 x
:[font = input; Cclosed; preserveAspect; startGroup]
ListPlot[ Transpose[{colorL, 1000*(meanRefr126L-(36.15445-0.013428*colorL))}], 
           Frame->True, 
           PlotLabel->"dz/tanz - (36.15445-0.013428 * (V-R)) (in mas)  vs V-R"
           ];

:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureWidth = 435; pictureHeight = 268; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0970696 0.4884 0.0556315 0.109686 [
[(0)] .09707 0 0 2 Msboxa
[(0.5)] .34127 0 0 2 Msboxa
[(1)] .58547 0 0 2 Msboxa
[(1.5)] .82967 0 0 2 Msboxa
[(0)] -0.0125 .05563 1 0 Msboxa
[(1)] -0.0125 .16532 1 0 Msboxa
[(2)] -0.0125 .275 1 0 Msboxa
[(3)] -0.0125 .38469 1 0 Msboxa
[(4)] -0.0125 .49437 1 0 Msboxa
[(5)] -0.0125 .60406 1 0 Msboxa
[(dz/tanz - \(36.15445-0.013428 * \(V-R\)\) \(in mas\)  vs V-R)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.09707 0 m
.09707 .00625 L
s
P
[(0)] .09707 0 0 2 Mshowa
p
.002 w
.34127 0 m
.34127 .00625 L
s
P
[(0.5)] .34127 0 0 2 Mshowa
p
.002 w
.58547 0 m
.58547 .00625 L
s
P
[(1)] .58547 0 0 2 Mshowa
p
.002 w
.82967 0 m
.82967 .00625 L
s
P
[(1.5)] .82967 0 0 2 Mshowa
p
.001 w
.14591 0 m
.14591 .00375 L
s
P
p
.001 w
.19475 0 m
.19475 .00375 L
s
P
p
.001 w
.24359 0 m
.24359 .00375 L
s
P
p
.001 w
.29243 0 m
.29243 .00375 L
s
P
p
.001 w
.39011 0 m
.39011 .00375 L
s
P
p
.001 w
.43895 0 m
.43895 .00375 L
s
P
p
.001 w
.48779 0 m
.48779 .00375 L
s
P
p
.001 w
.53663 0 m
.53663 .00375 L
s
P
p
.001 w
.63431 0 m
.63431 .00375 L
s
P
p
.001 w
.68315 0 m
.68315 .00375 L
s
P
p
.001 w
.73199 0 m
.73199 .00375 L
s
P
p
.001 w
.78083 0 m
.78083 .00375 L
s
P
p
.001 w
.04823 0 m
.04823 .00375 L
s
P
p
.001 w
.87851 0 m
.87851 .00375 L
s
P
p
.001 w
.92735 0 m
.92735 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05563 m
.00625 .05563 L
s
P
[(0)] -0.0125 .05563 1 0 Mshowa
p
.002 w
0 .16532 m
.00625 .16532 L
s
P
[(1)] -0.0125 .16532 1 0 Mshowa
p
.002 w
0 .275 m
.00625 .275 L
s
P
[(2)] -0.0125 .275 1 0 Mshowa
p
.002 w
0 .38469 m
.00625 .38469 L
s
P
[(3)] -0.0125 .38469 1 0 Mshowa
p
.002 w
0 .49437 m
.00625 .49437 L
s
P
[(4)] -0.0125 .49437 1 0 Mshowa
p
.002 w
0 .60406 m
.00625 .60406 L
s
P
[(5)] -0.0125 .60406 1 0 Mshowa
p
.001 w
0 .07757 m
.00375 .07757 L
s
P
p
.001 w
0 .09951 m
.00375 .09951 L
s
P
p
.001 w
0 .12144 m
.00375 .12144 L
s
P
p
.001 w
0 .14338 m
.00375 .14338 L
s
P
p
.001 w
0 .18725 m
.00375 .18725 L
s
P
p
.001 w
0 .20919 m
.00375 .20919 L
s
P
p
.001 w
0 .23113 m
.00375 .23113 L
s
P
p
.001 w
0 .25307 m
.00375 .25307 L
s
P
p
.001 w
0 .29694 m
.00375 .29694 L
s
P
p
.001 w
0 .31888 m
.00375 .31888 L
s
P
p
.001 w
0 .34081 m
.00375 .34081 L
s
P
p
.001 w
0 .36275 m
.00375 .36275 L
s
P
p
.001 w
0 .40663 m
.00375 .40663 L
s
P
p
.001 w
0 .42856 m
.00375 .42856 L
s
P
p
.001 w
0 .4505 m
.00375 .4505 L
s
P
p
.001 w
0 .47244 m
.00375 .47244 L
s
P
p
.001 w
0 .51631 m
.00375 .51631 L
s
P
p
.001 w
0 .53825 m
.00375 .53825 L
s
P
p
.001 w
0 .56019 m
.00375 .56019 L
s
P
p
.001 w
0 .58212 m
.00375 .58212 L
s
P
p
.001 w
0 .03369 m
.00375 .03369 L
s
P
p
.001 w
0 .01176 m
.00375 .01176 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.09707 .61178 m
.09707 .61803 L
s
P
p
.002 w
.34127 .61178 m
.34127 .61803 L
s
P
p
.002 w
.58547 .61178 m
.58547 .61803 L
s
P
p
.002 w
.82967 .61178 m
.82967 .61803 L
s
P
p
.001 w
.14591 .61428 m
.14591 .61803 L
s
P
p
.001 w
.19475 .61428 m
.19475 .61803 L
s
P
p
.001 w
.24359 .61428 m
.24359 .61803 L
s
P
p
.001 w
.29243 .61428 m
.29243 .61803 L
s
P
p
.001 w
.39011 .61428 m
.39011 .61803 L
s
P
p
.001 w
.43895 .61428 m
.43895 .61803 L
s
P
p
.001 w
.48779 .61428 m
.48779 .61803 L
s
P
p
.001 w
.53663 .61428 m
.53663 .61803 L
s
P
p
.001 w
.63431 .61428 m
.63431 .61803 L
s
P
p
.001 w
.68315 .61428 m
.68315 .61803 L
s
P
p
.001 w
.73199 .61428 m
.73199 .61803 L
s
P
p
.001 w
.78083 .61428 m
.78083 .61803 L
s
P
p
.001 w
.04823 .61428 m
.04823 .61803 L
s
P
p
.001 w
.87851 .61428 m
.87851 .61803 L
s
P
p
.001 w
.92735 .61428 m
.92735 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(dz/tanz - \(36.15445-0.013428 * \(V-R\)\) \(in mas\)  vs V-R)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 .05563 m
1 .05563 L
s
P
p
.002 w
.99375 .16532 m
1 .16532 L
s
P
p
.002 w
.99375 .275 m
1 .275 L
s
P
p
.002 w
.99375 .38469 m
1 .38469 L
s
P
p
.002 w
.99375 .49437 m
1 .49437 L
s
P
p
.002 w
.99375 .60406 m
1 .60406 L
s
P
p
.001 w
.99625 .07757 m
1 .07757 L
s
P
p
.001 w
.99625 .09951 m
1 .09951 L
s
P
p
.001 w
.99625 .12144 m
1 .12144 L
s
P
p
.001 w
.99625 .14338 m
1 .14338 L
s
P
p
.001 w
.99625 .18725 m
1 .18725 L
s
P
p
.001 w
.99625 .20919 m
1 .20919 L
s
P
p
.001 w
.99625 .23113 m
1 .23113 L
s
P
p
.001 w
.99625 .25307 m
1 .25307 L
s
P
p
.001 w
.99625 .29694 m
1 .29694 L
s
P
p
.001 w
.99625 .31888 m
1 .31888 L
s
P
p
.001 w
.99625 .34081 m
1 .34081 L
s
P
p
.001 w
.99625 .36275 m
1 .36275 L
s
P
p
.001 w
.99625 .40663 m
1 .40663 L
s
P
p
.001 w
.99625 .42856 m
1 .42856 L
s
P
p
.001 w
.99625 .4505 m
1 .4505 L
s
P
p
.001 w
.99625 .47244 m
1 .47244 L
s
P
p
.001 w
.99625 .51631 m
1 .51631 L
s
P
p
.001 w
.99625 .53825 m
1 .53825 L
s
P
p
.001 w
.99625 .56019 m
1 .56019 L
s
P
p
.001 w
.99625 .58212 m
1 .58212 L
s
P
p
.001 w
.99625 .03369 m
1 .03369 L
s
P
p
.001 w
.99625 .01176 m
1 .01176 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
.004 w
.02381 .23656 m
.02381 .22305 L
.02869 .22086 L
.03358 .22331 L
.03846 .21471 L
.04335 .20178 L
.04823 .19055 L
.058 .1658 L
.06777 .14 L
.06777 .11113 L
.07753 .1107 L
.0873 .09736 L
.09707 .08032 L
.10684 .01472 L
.13614 .0195 L
.17521 .02569 L
.18987 .01753 L
.24359 .03949 L
.26801 .05836 L
.29243 .05515 L
.32662 .08285 L
.34127 .05807 L
.35592 .06516 L
.36081 .03225 L
.38034 .05571 L
.40965 .06485 L
.45849 .04438 L
.58059 .25229 L
.65873 .36379 L
.72222 .42166 L
.78083 .44817 L
.82967 .47005 L
.87851 .51114 L
.92735 .55222 L
.97619 .60332 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd

:[font = input; Cclosed; preserveAspect; startGroup]
TableForm[ Transpose[{colorL, tL, meanLam126L, meanRefr126L} ] ]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
TableForm[{{-0.15, 38000, 0.5375078074999719, 36.15811374862586}, 
   {-0.15, 35000, 0.5375581798331348, 36.15799055772954}, 
   {-0.14, 31900, 0.537621244280529, 36.15783634442716}, 
   {-0.13, 30000, 0.5376670483843631, 36.1577243507019}, 
   {-0.12, 27000, 0.5377540561011245, 36.15751164079398}, 
   {-0.11, 24200, 0.5378572173970398, 36.15725948997496}, 
   {-0.1, 22100, 0.5379540363155364, 36.1570228917808}, 
   {-0.08, 18800, 0.5381563573273671, 36.15652863676229}, 
   {-0.06, 16400, 0.5383626586517688, 36.15602488661837}, 
   {-0.06, 15400, 0.5384704823930161, 36.15576169418784}, 
   {-0.04, 14500, 0.5385821468458122, 36.1554891952114}, 
   {-0.02, 13400, 0.5387421056549577, 36.1550989641257}, 
   {0., 12400, 0.5389159246614699, 36.15467508504391}, 
   {0.02, 10800, 0.5392715430232719, 36.15380840706283}, 
   {0.08, 9730, 0.5395844955889907, 36.15304631744527}, 
   {0.16, 8620, 0.5400028045924065, 36.15202856388171}, 
   {0.19, 8190, 0.5401991005504833, 36.15155132715737}, 
   {0.3, 7240, 0.5407247777655501, 36.15027441565077}, 
   {0.35, 6930, 0.5409305421468557, 36.14977504251156}, 
   {0.4, 6540, 0.5412194015204004, 36.14907442715225}, 
   {0.47, 6200, 0.5415030375629523, 36.14838696079624}, 
   {0.5, 5920, 0.5417626004023843, 36.14775825881654}, 
   {0.5300000000000001, 5780, 0.5419023097694034, 36.14742002554596}, 
   {0.5400000000000001, 5610, 0.5420817611836509, 36.14698574676586}, 
   {0.58, 5490, 0.5422153955929517, 36.14666247025176}, 
   {0.6400000000000001, 5240, 0.5425141350053817, 36.14594016744093}, 
   {0.7400000000000001, 4780, 0.5431474307218747, 36.14441070295523}, 
   {0.99, 4410, 0.5437534871383209, 36.14294923795293}, 
   {1.15, 4160, 0.5442235170688505, 36.14181728364131}, 
   {1.28, 3920, 0.5447299144730488, 36.14059920757453}, 
   {1.4, 3680, 0.5453000865343111, 36.13922954719535}, 
   {1.5, 3500, 0.5457766670840428, 36.13808619359429}, 
   {1.6, 3360, 0.5461806616272852, 36.13711804089264}, 
   {1.7, 3230, 0.5465851219305556, 36.13614975188573}, 
   {1.8, 3120, 0.5469517679290351, 36.13527284238487}}]
;[o]
-0.15   38000   0.537508   36.1581

-0.15   35000   0.537558   36.158

-0.14   31900   0.537621   36.1578

-0.13   30000   0.537667   36.1577

-0.12   27000   0.537754   36.1575

-0.11   24200   0.537857   36.1573

-0.1    22100   0.537954   36.157

-0.08   18800   0.538156   36.1565

-0.06   16400   0.538363   36.156

-0.06   15400   0.53847    36.1558

-0.04   14500   0.538582   36.1555

-0.02   13400   0.538742   36.1551

0.      12400   0.538916   36.1547

0.02    10800   0.539272   36.1538

0.08    9730    0.539584   36.153

0.16    8620    0.540003   36.152

0.19    8190    0.540199   36.1516

0.3     7240    0.540725   36.1503

0.35    6930    0.540931   36.1498

0.4     6540    0.541219   36.1491

0.47    6200    0.541503   36.1484

0.5     5920    0.541763   36.1478

0.53    5780    0.541902   36.1474

0.54    5610    0.542082   36.147

0.58    5490    0.542215   36.1467

0.64    5240    0.542514   36.1459

0.74    4780    0.543147   36.1444

0.99    4410    0.543753   36.1429

1.15    4160    0.544224   36.1418

1.28    3920    0.54473    36.1406

1.4     3680    0.5453     36.1392

1.5     3500    0.545777   36.1381

1.6     3360    0.546181   36.1371

1.7     3230    0.546585   36.1361

1.8     3120    0.546952   36.1353
:[font = section; inactive; preserveAspect; startGroup]
Pluto, Charon
:[font = input; preserveAspect; startGroup]
sunt = 5770;
Print[ "Sun's mean wavelength is ", meanLamF[1.26, sunt] ];
Print[ "Sun's mean refr is ", meanRefrF[1.26, sunt] ];

:[font = print; inactive; preserveAspect; endGroup]
Sun's mean wavelength is 0.541913
Sun's mean refr is 36.1474
:[font = input; preserveAspect]
(* Get the slope in the albedo from A(0.44)/A(0.55) *)

palb = 1 + (1-10^(-0.4(.868-.65))) * (lamL-.55)/(.55-.44);
calb = 1 + (1-10^(-0.4(.710-.65))) * (lamL-.55)/(.55-.44);
:[font = input; preserveAspect; startGroup]
mean[lamL, qFilterL qChipL (extL^1.26) nPhotons[sunt] ]
mean[lamL, qFilterL qChipL (extL^1.26) palb * nPhotons[sunt] ]
mean[lamL, qFilterL qChipL (extL^1.26) calb * nPhotons[sunt] ]
:[font = output; output; inactive; preserveAspect]
0.541912560588246
;[o]
0.541913
:[font = output; output; inactive; preserveAspect]
0.5431155504932072
;[o]
0.543116
:[font = output; output; inactive; preserveAspect; endGroup]
0.5422647328076735
;[o]
0.542265
:[font = input; preserveAspect; startGroup]
r = {mean[refrL, qFilterL qChipL (extL^1.26) nPhotons[sunt] ],
mean[refrL, qFilterL qChipL (extL^1.26) palb * nPhotons[sunt] ],
mean[refrL, qFilterL qChipL (extL^1.26) calb * nPhotons[sunt] ] }
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup]
{36.14739521308072, 36.14449305221541, 36.14654561290632}
;[o]
{36.1474, 36.1445, 36.1465}
^*)
