#include <stdio.h>

main(int argc, char *argv[])
{
  char *incoo_fn, *inmag_fn, *outmag_fn;
  FILE *incoo, *inmag, *outmag;
  char s1[100], *s2, olds[100], im[40], coo[40];
  float x, y, x2, y2, xshift, yshift, pcmag, psmag, csmag, mag;
  int id, lid, i, id2;

  if (argc != 3 && argc != 4)
    return;
   
  inmag = fopen(argv[1], "r");
  outmag = fopen(argv[2], "w");
  if (inmag==NULL) {
    printf("adjmag: can't open %s for reading\n", argv[1]);
    return;
  }
  outmag = fopen(argv[2], "w");
  if (inmag==NULL) {
    printf("adjmag: can't open %s for writing\n", argv[2]);
    return;
  }

  if (argc == 4)
  	pcmag = atof(argv[3]);
  else
  	pcmag = 17.2591-15.3735;
  psmag = 2.5*log10(1+pow(10,0.4*pcmag)) /* mag(Pluto) - mas(pluto+charon) */
  csmag = 2.5*log10(1+pow(10,-0.4*pcmag))

   
  /* First, read all the comment lines. End with the 1st dataline in s1 */
  while ( (fgets(s1, 99, inmag) !=  NULL) && (s1[0] == '#') )
    fprintf(outmag, "%s", s1);

  /* get the coo file */
  if ( sscanf(s1, "%23s%f%f%d%23s%d", im, &x, &y, &id, coo, &lid) == 6) 
    incoo = fopen(coo, "r");
  if (incoo == NULL)
    return;

  /* If s1 has characters, adjust the ids, print the next 3 lines,
     and read the next id line */
  while ( sscanf(s1, "%23s%f%f%d%23s%d", im, &x, &y, &id, coo, &lid) == 6) {
    fscanf(incoo, "%f%f%d", &x2, &y2, &id2);
    fprintf(outmag, "%-23s%-10.3f%-10.3f%-5d%-23s%-5d   \\\n", 
	    im, x, y, id2, coo, id2);

    /* if id2 > 9000, then it's Pluto */
    if (id2 > 9000) {
      fgets(olds, 99, inmag);
      sscanf(olds+25, "%f%f", &xshift, &yshift);
      fprintf(outmag, olds);
      for (i = 1; i < 3; i++) {
	fgets(s1, 99, inmag);
	fprintf(outmag, s1 );
      }
      fgets(s1, 99, inmag);
      sscanf(s1+42, "%f", &mag);
      fprintf(outmag, "%-.47s%-7.3f%s", s1, mag+psmag, s1+49);
    }
    else if (id2 > 8000) {
      fgets(s1, 99, inmag);
      fprintf(outmag, "   %-11.3f%-11.3f%s", x+xshift, y+yshift, olds+25);
      for (i = 1; i < 3; i++) {
	fgets(s1, 99, inmag);
	fprintf(outmag, s1 );
      }
      fgets(s1, 99, inmag);
      sscanf(s1+42, "%f", &mag);
      fprintf(outmag, "%-.47s%-7.3f%s", s1, mag+csmag, s1+49);
    }
    else {
      for (i = 0; i < 4; i++) {
	fgets(s1, 99, inmag);
	fprintf(outmag, s1 );
      }
    }

    if (fgets(s1, 99, inmag)==NULL)
      s1[0]='\0';
  }

  
}
