; Return a_b, the bolometric hemispheric albedo

function a_b, sslat_deg, lat_deg, lon_deg

    dir = '~/reference/maps/Triton/Stansberry1992/'
    d = fltarr(360,180)
    case sslat_deg of
        -45 : begin
            fn = 'alb3b.sslat135.fits'
            d[*,0:134] = readfits(dir+fn, /sil)
        end

        -40 : begin
            fn = 'alb3b.sslat140.fits'
            d[*,0:129] = readfits(dir+fn, /sil)
        end

        else: begin
            print, 'Sub solar latitude ', sslat_deg, ' deg no allowed'
        end
    endcase

    lat_deg = arrgen(-179.5, 179.5, 1.) # replicate(1,180)
    lat_deg = replicate(1,360) # arrgen(-89.5, 89.5, 1.)

    return, d

end
