function bandarea, wl, sp, cont, band, plot=plot

    icont = where( (wl ge cont[0] and wl le cont[1]) or $
                   (wl ge cont[2] and wl le cont[3]), ncont )
    iband = where(  wl ge band[0] and wl le band[1], nband)
    res = linfit(wl[icont], sp[icont])

    spn = 1- sp[iband] / poly(wl[iband], res)  ; 1 - normalized
    dwl = (wl[iband+1] - wl[iband-1])/2.

    area = total(spn * dwl)

    if keyword_set(plot) then begin
        plot, wl, sp
        oplot, wl[iband], sp[iband], ps=3, col='0000ff'xl
        oplot, wl[icont], poly(wl[icont],res), col='ff0000'xl
        oplot, wl[icont], sp[icont], ps=3, col='ff0000'xl
    endif

    return, area

end
