function banddepth, wl, sp, cont, band, plot=plot

    icont = where( (wl ge cont[0] and wl le cont[1]) or $
                   (wl ge cont[2] and wl le cont[3]), ncont )
    iband = where(  wl ge band[0] and wl le band[1], nband)
    acont = mean(sp[icont])
    aband = mean(sp[iband])

    depth = 1- (aband / acont)

    if keyword_set(plot) then begin
        plot, wl, sp
        oplot, wl[iband], sp[iband], ps=3, col='0000ff'xl
        oplot, wl[iband], replicate(aband,nband), col='0000ff'xl
        oplot, wl[icont], sp[icont], ps=3, col='ff0000'xl
        oplot, wl[icont], replicate(acont,ncont), col='ff0000'xl
    endif

    return, depth

end
