;+
; NAME:
;  calc_areas
; PURPOSE:
;  calculate the area from a spectrum
; CALLING SEQUENCE
;  area = calc_areas, name, wl, sp
; INPUTS
;  name
;   one of
;   names=["CH4_0.89","CH4_1.65","CH4_1.73","CH4_shift","CO2_sum","CO_2.35","H2O_ratio","N2_2.15"]
;  wl - array of wavelengths, micron
;  sp - array of reflectance
; OUTPUTS
;  area 
;-
function calc_areas, name, wl, sp, plot=plot, gy04=gy04

    case name of
        "CH4_0.89": begin
            cont = [0.860,0.878,0.909,0.930]
            band = [0.878, 0.909]
            area = bandarea(wl, sp, cont, band, plot=plot)
        end
 
        "CH4_1.15": begin
            cont = [1.070, 1.100, 1.210, 1.230]
            band = [1.100, 1.210]
            area = bandarea(wl, sp, cont, band, plot=plot)
        end

        "CH4_1.33": begin
            cont = [1.300, 1.310, 1.342 - 1.348]
            band = [1.310, 1.342]
            area = bandarea(wl, sp, cont, band, plot=plot)
        end

        "CH4_1.65": begin
            cont = [1.605, 1.620, 1.685, 1.699]
            band = [1.620, 1.685]
            area = bandarea(wl, sp, cont, band, plot=plot)
        end
        
        "CH4_1.73": begin
            cont = [1.686,1.698,1.735, 1.745]
            band = [1.698,1.735]
            area = bandarea(wl, sp, cont, band, plot=plot)
        end

        "CH4_2.20": begin
            cont = [2.170, 2.180, 2.225, 2.235]
            band = [2.180, 2.225]
            area = bandarea(wl, sp, cont, band, plot=plot)
        end

        "H2O_ratio": begin
            cont = [1.25, 1.27, 1.73, 1.75]
            band = [1.505, 1.57]
            if keyword_set(gy04) then begin
                cont = [1.430,1.450,1.683,1.710]
                band = [1.500,1.570]
            endif
            area = banddepth(wl, sp, cont, band, plot=plot)
        end
        
        else: area = 0.
    endcase

    return, area

end
