;pro do_dist

    mapalb = rdmap_triton_stans92(-50)
    mapinsol = rdmap_insol(-50, maplat, maplon)
    deg = !pi/180

    arrlon = maplon[*,0]
    arrlat = reform(maplat[0,*])

    if (0) then begin
                                ; what is the projected area for pole
                                ; to -33 deg?
        for limlat = -90,-25 do begin
            map = (maplat lt limlat)
            mapfrac = map_da(map,lat=-50,lon=arrlon[0], frac=frac, /north)
            print, limlat, 'deg ', round(frac[0]*100), '%'
        endfor

;     -60deg           19%
;     -59deg           20%
;     -58deg           22%
;     -57deg           23%
;...
;     -45deg           38%
;     -44deg           40%
;..
;     -35deg           51%
;     -34deg           53%
;     -33deg           54%
;     -32deg           55%
;     -31deg           57%
;     -30deg           58%
;     -29deg           59%
;     -28deg           60%
;     -27deg           62%
    endif

    if (0) then begin
                                ; high-lat denuding
        ilat = (-58.5 + 89.5)
        liminsol = mean(mapinsol[*,ilat])
        print, liminsol;       173.41064
        map = (mapinsol gt liminsol)
        mapfrac = map_da(map,lat=-50,lon=arrlon, frac=frac, /north)
        print, max(frac)/min(frac) ;  1.06486
    endif

    if (1) then begin
                                ; mid-lat denuding
        ilat = (-44.5 + 89.5)
        liminsol = mean(mapinsol[*,ilat])
        print, liminsol ; 119.52933
        map = (mapinsol gt liminsol)
        mapfrac = map_da(map,lat=-50,lon=arrlon, frac=frac, /north)
        print, max(frac)/min(frac) ;  1.05118
    endif
    
    if (0) then begin
                                ; low-lat denuding
        ilat = (-33 + 89.5)
        liminsol = mean(mapinsol[*,ilat])
        print, liminsol ; 91
        map = (mapinsol gt liminsol)
        mapfrac = map_da(map,lat=-50,lon=arrlon, frac=frac, /north)
        print, max(frac)/min(frac) ;  1.05118
    endif
    
    
    ; unit 1 - CO + H2O ('denuded')
    
    ; unit 2 - H2O
    ; 


    plot, lon_deg, f1, yr=[0,1], xs=1
    

end
