; 2008 04 01
; plot gy04 map vs. N2 area

rd_n2areas, year, et, slon, area, area_err

minlat = -31.

unitcombos = [ $
               [ 0, 0, 0, 0, 0, 0, 1] , $ ; just fringe
               [ 1, 0, 1, 0, 0, 1, 0] , $ ; 
               [ 0, 0, 1, 1, 0, 1, 0] , $ ; SPC
               [ 1, 0, 1, 1, 0, 1, 0] , $ ; SPC + unmapped
               [ 0, 0, 1, 0, 0, 1, 0] , $ ; SPC no unit 3
               [ 0, 0, 1, 1, 0, 1, 1] , $ ; SPC + fringe
               [ 0, 0, 1, 1, 1, 1, 1] , $ ; SPC + fringe + transition
               [ 1, 0, 1, 1, 0, 1, 1] ]   ; SPC + fringe + unmapped

ncombos = n_elements(unitcombos)/7

;for icombo = 0, ncombos-1 do begin
for icombo = 3,3 do begin

    slat = -50.
    minlat0=50
    unit = unitcombos[*,icombo]

    m = rdmap_geol(minlat, unit, lat_deg, lon_deg, minlat0=minlat0)
    
    da = map_da(m, lat=slat,lon=slon, frac=frac,/north)
    
    fullarea = total(area*frac)/total(frac^2)
    
    arg = {slat:slat, slon:slon, unit:unit, minlat0=minlat0}
    paraminit = [-31., fullarea]
    param = paraminit
    
    geol_func, arg, param, area_mod
    weights = 1/area_err^2.
    area_mod = curvefitlay(arg, area, weights, param, perr, $
                           func='geol_func', /noderiv, chisq=chisq_dof)
    perr_ext = perr * sqrt(chisq_dof)
    
    lon361 = findgen(361)
    m = rdmap_geol(param[0], unit, lat_deg, lon_deg)
    area_mod361 = map_frac(m,lat=slat,lon=lon361, /north) * param[1]
    
    window, xs=750, ys=420
    loadct,0
    titlestr = 'Geologic Units' 
    fn = "geolarea"
    for i=0,6 do begin
        if unit[i] eq 1 then begin
            titlestr += string(i,fo='(I2)')
            fn += string(i,fo='(I1)')
        end
    endfor
    plot, slon, area, xr=[0,360], xs=3, ps=4, yr=[0,0.006], $
      title=titlestr, $
      xtitl = 'Sub-observer longitude', $
      ytitl = 'N2 band area'
    oploterr, slon, area, area_err, ps=4
;oplot, slon, area_mod, ps=1
    oplot, lon361, area_mod361
    tv, rebin(float(m),180,90)*255, 90,60,/dev
    plots, [0,180,180,0,0]+90,[0,0,90,90,0]+60, /dev
    form = '("Latitude cutoff = ", F6.2, "+/-", F6.2)'
    xyouts, 200, 0.0017, string(param[0], perr_ext[0], form=form)
    form = '("Area for 100% N2 = ", F6.4, "+/-", F6.4)'
    xyouts, 200, 0.0015, string(param[1], perr_ext[1], form=form)
    form = '("Chi-sq per degree of freedom = ", F5.2)
    xyouts, 200, 0.0013, string(chisq_dof, form=form)
    
    wrgif, fn
;    fntif = '../figs/'+fn+'.tif'
;    tv2tiff, fntif, /cor
;    spawn,'tiffutil -cat '+fntif+' -out '+fntif

    map_ice = m
    fnsav = '../maps/'+fn+'.sav'
    save, map_ice, file=fnsav

endfor

end

