; 2008 04 01
; plot gy04 map vs. N2 area

rd_n2areas, year, et, slon, area, area_err
weights = 1/area_err^2.

unitcombos = [ $
               [ 1, 1, 1, 1, 1, 1, 1] , $ ; all
               [ 0, 1, 1, 1, 1, 1, 1] , $ ; all mapped
               [ 0, 0, 1, 1, 0, 1, 0] , $ ; SPC
;               [ 0, 0, 1, 0, 0, 1, 0] , $ ; SPC no unit 3 - did not converge
               [ 0, 0, 1, 1, 0, 1, 1] ]   ; SPC + fringe

ncombos = n_elements(unitcombos)/7

for icombo = 2, ncombos-1 do begin
;for icombo = 0,0 do begin

    slat = -50.
    unit = unitcombos[*,icombo]
    print, icombo
    print, unit

    geolmap = rdmap_geol(-90., unit, lat_deg, lon_deg)

    abmap = rdmap_triton_stans92(slat, lat_deg, lon_deg)
    eabsmap = rdmap_insol( slat, lat_deg, lon_deg)

;    scutoffarr = arrgen(55,85,1)
   scutoffarr = arrgen(75,95,1)
    chiarr = 0*scutoffarr
    for i=0,n_elements(scutoffarr)-1 do begin
        scutoff = scutoffarr[i]
        m = (eabsmap lt scutoff) and geolmap
        da = map_da(m, lat=slat,lon=slon, frac=frac,/north)
        fullarea = total(area*frac*weights)/total(frac^2*weights)
        area_mod = frac * fullarea
        chisq_dof = total(weights * (area_mod-area)^2)/(n_elements(area)-2.)
        chiarr[i] = chisq_dof
        print, scutoff, chisq_dof
    endfor
    chimin = min(chiarr,imin)
    scutoff = scutoffarr[imin]
    m = (eabsmap lt scutoff) and geolmap
    da = map_da(m, lat=slat,lon=slon, frac=frac,/north)
    fullarea = total(area*frac*weights)/total(frac^2*weights)


    arg = {slat:slat, slon:slon, geolmap:geolmap, eabsmap:eabsmap }
    paraminit = [scutoff, fullarea]
    param = paraminit
    scutoffgeol_func, arg, param, area_mod
    fac = total(area_mod*area*weights)/total(area_mod^2 * weights)
    fullarea = fullarea * fac
    area_mod = area_mod * fac
    chisq_dof = total(weights * (area_mod-area)^2)/(n_elements(area)-2.)

    area_mod = curvefitlay(arg, area, weights, param, perr, $
                           func='scutoffgeol_func', /noderiv, chisq=chisq_dof)
    perr_ext = perr * sqrt(chisq_dof)
    
    lon361 = findgen(361)
    m = (eabsmap lt param[0]) and geolmap
    area_mod361 = map_frac(m,lat=slat,lon=lon361, /north) * param[1]
    
    window, xs=750, ys=420
    loadct,0
    titlestr = 'Geologic Units' 
    fn = "geolinsolarea"
    for i=0,6 do begin
        if unit[i] eq 1 then begin
            titlestr += string(i,fo='(I2)')
            fn += string(i,fo='(I1)')
        end
    endfor
    plot, slon, area, xr=[0,360], xs=3, ps=4, yr=[0,0.006], $
      title=titlestr, $
      xtitl = 'Sub-observer longitude', $
      ytitl = 'N2 band area'
    oploterr, slon, area, area_err, ps=4
;oplot, slon, area_mod, ps=1
    oplot, lon361, area_mod361
    tv, rebin(float(m),180,90)*255, 90,60,/dev
    plots, [0,180,180,0,0]+90,[0,0,90,90,0]+60, /dev
    form = '("Latitude cutoff = ", F6.2, "+/-", F6.2)'
    xyouts, 200, 0.0017, string(param[0], perr_ext[0], form=form)
    form = '("Area for 100% N2 = ", F6.4, "+/-", F6.4)'
    xyouts, 200, 0.0015, string(param[1], perr_ext[1], form=form)
    form = '("Chi-sq per degree of freedom = ", F8.2)
    xyouts, 200, 0.0013, string(chisq_dof, form=form)
 
    wrgif, fn

    map_ice = m
    fnsav = '../maps/'+fn+'.sav'
    save, map_ice, file=fnsav

;    fn = '../figs/'+fn+'.tif'
;    tv2tiff, fn, /cor
;    spawn,'tiffutil -cat '+fn+' -out '+fn
endfor

end

