;====================================
; PLOTS FOR THE ICES 2008 MEETING
;====================================

deg = !pi/180.
theta = findgen(361)
cost = cos(theta/deg)
sint = sin(theta/deg)
dir = '../figs/'
device, true_color = 24
window, 2, xs = 450, ys = 500
!p.color = 0
!p.background = !d.N_COLORS - 1L
naifinit, ker='../spice/kernels.tm'

names=names(colors,titles)

geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)


;=====================================================
;=====================================================
;
; START JUST MESSING-AROUND PART
;
;=====================================================
;=====================================================

if (0) then begin
    print, '------------------------'
    print, 'First attempt at CH4'
    
    names=names(colors,titles)
    in = 3 ; ch4_1.65
    name = names[in]
    rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
    lat_deg = replicate(-50, n_elements(lat_deg))
    s = sort(lon_deg)
    lon_deg = lon_deg[s]
    area = area[s]
    area_err = area_err[s]
    nterms = 1
    fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
      lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
      lonmin, lonmin0, lonmin1, ratiomin, ratiominerr
    fourierfunc,theta,a,model

    maxlon_l = 115
    maxlat_l = -35
    minlat_l = -43
    maxlon_u = -45
    maxlat_u = -20
    minlat_u = -20
    map_lat = mkmap_sinelat(maxlon_u, maxlat_u, minlat_u, maxlon_l, maxlat_l, minlat_l)

    restore, '../maps/geolarea2356.sav' ; gives map_ice

    map = map_lat

;    map = map_ice
;    ilat = where (map_lat)
;    map[ilat] = 1
;    i6 = where(geomap[*,*,6])
;    map[i6] = 0

    image = lonarr(360,180)
    imap = where(map,nmap)
    if nmap gt 0 then image[imap] = colors[in]
    mapset_image, image=image

    da = map_da(map, lat=lat_deg,lon=lon_deg, frac=frac,/north)
    print, 'frac mean', mean(frac), '  frac ratio = ', max(frac)/min(frac)
stop
    plot, lon_deg, frac, yr=[0,1]
    oplot, lon_deg, (area/a[0]) * mean(frac), ps=4

endif

if (0) then begin
    print, '------------------------'
    print, 'First attempt at H2O'
    
    names=names(colors,titles)
    in = [7] ; H2O
    name = names[in]
    rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
    lat_deg = replicate(-50, n_elements(lat_deg))
    s = sort(lon_deg)
    lon_deg = lon_deg[s]
    area = area[s]
    area_err = area_err[s]
    fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
      lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
      lonmin, lonmin0, lonmin1, ratiomin, ratiominerr
    fourierfunc,theta,a,model

    maxlon = 115
    maxlat = -35
    minlat = -43
;    maxlat = -40
;    minlat = -40
    map = mkmap_sinelat(maxlon, maxlat, minlat)
    image = lonarr(360,180)
    imap = where(map,nmap)
    if nmap gt 0 then image[imap] = '0000ff'xl
    mapset_image, image=image

    da = map_da(map, lat=lat_deg,lon=lon_deg, frac=frac,/north)
    print, 'frac mean', mean(frac), '  frac ratio = ', max(frac)/min(frac)
;    plot, lon_deg, frac, yr=[0,1]
;    oplot, lon_deg, (area/a[0]) * 0.45, ps=4

endif


if (0) then begin
    map_geot = rdmap_triton_mcewen90colorized()

    MAP_SET, /AZIMUTHAL, /ISOTROPIC, -90, $
      /HORIZON, TITLE = 'Geologic Units', limit = [-90,0,60,360]
    
    pmap_geot = MAP_IMAGE(map_geot,Startx,Starty, COMPRESS=1, $  
                          LATMIN= -89.5, LONMIN=0, $  
                          LATMAX= 89.5, LONMAX=359) 
    tv, truecolorconv(pmap_geot), Startx,Starty, /true
    
    map_grid, latdel = 30, londel = 30, /lab, color = 16*12

    dir = '../figs/'
    fn_root='ices08_'+geol
    fn_tiff = dir + fn_root + '.tif'
    fn_gif = dir + fn_root + '.gif'
    tv2tiff, fn_tiff, /tr, /corner
    spawn,'tiffutil -cat '+fn_tiff+' -out '+fn_gif
    spawn, 'rm ' + fn_tiff
end

if (0) then begin

;    loadct, 12

    map_stans = byte(rdmap_triton_stans92(-50) * 255 )

    MAP_SET, /AZIMUTHAL, /ISOTROPIC, -90, $
      /HORIZON, TITLE = 'Albedo Map', limit = [-90,0,60,360]
    
    pmap_stans = MAP_IMAGE(map_stans,Startx,Starty, COMPRESS=1, $  
                          LATMIN= -89.5, LONMIN=0, $  
                          LATMAX= 89.5, LONMAX=359) 
    tv, truecolorconv(pmap_stans * '010101'xl), Startx,Starty, /true
    
    map_grid, latdel = 30, londel = 30, /lab, color = 16*12

    tv2tiff, '../figs/ices08_a.tiff', /tr

end

if (0) then begin
    names=["N2_2.15",  "CO_2.35", $
           "CH4_0.89", "CH4_1.65","CH4_1.73","CH4_shift",$
           "CO2_sum","H2O_ratio"]
    titles=["!3N!D2!N (2.15 !4l!3m)",  "!3CO (2.35 !4l!3m)", $
           "!3CH!D4!N (0.89 !4l!3m)", "!3CH!D4!N (1.65 !4l!3m)","!3CH!D!N4 (1.73!4l!3m)",$
            "!3CH!D4!N state",$
           "!3CO!D2!N (2 !4l!3m)","H2O_ratio"]
    colors=['00af00'xl,'00df00'xl, $
            'ffaf00'xl,  'ff8000'xl, 'ff0000'xl, $
            '808000'xl, $
            '0045ff'xl, '0000ff'xl]
    nnames = n_elements(names)
    
    arc_hw = 30.

;    for i = 0, nnames-1 do begin
    for iname = 7,7 do begin
        name = names[iname]

        rd_areas,name, year, et, lon_deg, lat_deg, area, area_err

        a = [0,0,0, 0, 0]
;        a = [0,0,0]
        w = 1/(area_err)^(2.)
        r = curvefit(lon_deg, area, w, a, sigma, func='fourierfunc', chisq=chisq)
        fourierfunc,theta,a,model
        ratio = model/a[0]
        ratmax = max(ratio,imax)
        ihigh = where(ratio[0:359] gt (1 + (ratmax-1)*cos(arc_hw*deg)),nhigh)
        thigh = ((theta[ihigh] - theta[imax] + 180 ) mod 360) - 180 + theta[imax]
        shigh = sort(thigh)
        thigh = thigh[shigh]
        ratmin = min(ratio,imin)
        ilow = where(ratio[0:359] lt (1 - (1-ratmin)*cos(arc_hw*deg)),nhigh)
        tlow = ((theta[ilow] - theta[imin] + 180 ) mod 360) - 180 + theta[imin]
        slow = sort(tlow)
        tlow = tlow[slow]

        color = colors[iname]
        if name eq 'CH4_shift' then begin
            title = titles[iname]+' SHIFT (0=PURE, 1=SOLUTION)'
        endif else begin
            title = titles[iname] + ' AREA / '+strtrim(string(a[0],for='(F7.4)'),2)+' !4l!3m'
        endelse
        MAP_SET, /AZIMUTHAL, /ISOTROPIC, -90, $
          TITLE = title, limit = [-90,0,65,360], /noborder, chars=1.5
        map_grid, latdel = 90, londel=90, color = 0, glines=0, thick=2
        map_grid, latdel = 18, londel=30, color = 0, glines=0, /label, $
          chars=1.2, $
          lats=findgen(9)*18 - 90, $
          latnames = ['','0.2','0.4','0.6','0.8','1.0','1.2','1.4','1.6'], $
          latlab = 45
        if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
 
        plotsym, 0, 1, /fill, color=color
        plots, lon_deg, (area/pscale) * 90 - 90, ps=8, color=color
        n = n_elements(area)
        for i = 0, n-1 do begin
            low = area[i] - area_err[i]
            if low lt 0 then low = 0
            high = area[i] + area_err[i]
            if area[i] gt 0 then begin
                plots, [1,1]*lon_deg[i],  (([low,high])/pscale) * 90 - 90, $
                  color=color, thick=2
            endif 
        endfor
        s = sort(lon_deg)
        plots, theta, (model/pscale) * 90 - 90, color=color, thick=2

        plots, thigh, replicate(1.7*90 - 90,nhigh), thick=3, color=color
        xyouts, theta[imax], 1.8*90-90, '!3More ', chars=1.5, $
          orient=atan(tan((-theta[imax])*deg))/deg, ali=0.5, color=color
        plots, tlow, replicate(1.7*90 - 90,nlow), thick=3, color=color, line=2
      
        dir = '../figs/'
        fn_root='ices08_'+name
        fn_tiff = dir + fn_root + '.tif'
        fn_gif = dir + fn_root + '.gif'
        tv2tiff, fn_tiff, /tr
        spawn,'tiffutil -cat '+fn_tiff+' -out '+fn_gif
        spawn, 'rm ' + fn_tiff
    endfor

end

if (0) then begin
    print, '---------------------------------------------'
    print, 'Check my sine fits vs. Will'
    names = names()
    nnames = n_elements(names)
    will = ['N2         30    0.79  0.04',$
            'CO        ~90    0.70  0.07',$
            'CH4 0.89  305    0.38  0.06',$
            'CH4 1.65  305    0.15  0.01',$
            'CH4 1.73  305    0.20  0.02',$
            'CO2       ---    0.02  0.02',$
            'H2O       ~90    0.11  0.02']
    inarr = [0,1,2,3,4,6,7] 
    nii = n_elements(iinarr)
    for iin = 0, 6 do begin
        in = inarr[iin]
        name = names[in]
        rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
        for nterms = 1,2 do begin
            fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
              lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
              lonmin, lonmin0, lonmin1, ratiomin, ratiominerr
            print, name, lonmax, (ratiomax/ratiomin)-1, $
              (ratiomax/ratiomin) * $
              sqrt((ratiomaxerr/ratiomax)^2 + (ratiominerr/ratiomin)^2), $
              lonmax0,lonmax1,$
              sigma[1:2*nterms]/a[0],$
              form='(A-10, F5.1, 2F6.2, 2F6.1,4F6.2)'
        endfor
        print, will[iin] 
        print, ''
    endfor
; Check my sine fits vs. Will
; N2_2.15    30.0  0.79  0.03   0.0  59.0  0.01  0.01
; N2_2.15    27.0  0.78  0.04   0.0  54.0  0.01  0.01  0.01  0.01
; N2         30    0.79  0.04
; 
; CO_2.35    58.0  0.70  0.05  28.0  87.0  0.02  0.02
; CO_2.35    31.0  0.76  0.08   6.0  63.0  0.02  0.02  0.02  0.02
; CO        ~90    0.70  0.07
; 
; CH4_0.89  281.0  0.38  0.04 252.0 311.0  0.02  0.02
; CH4_0.89  294.0  0.40  0.07 251.0 328.0  0.03  0.03  0.02  0.03
; CH4 0.89  305    0.38  0.06
; 
; CH4_1.65  317.0  0.15  0.00 287.0 346.0  0.00  0.00
; CH4_1.65  312.0  0.15  0.01 286.0 338.0  0.00  0.00  0.00  0.00
; CH4 1.65  305    0.15  0.01
; 
; CH4_1.73  320.0  0.20  0.01 290.0 349.0  0.01  0.01
; CH4_1.73  325.0  0.20  0.02 290.0 358.0  0.01  0.01  0.01  0.01
; CH4 1.73  305    0.20  0.02
; 
; CO2_sum   242.0  0.02  0.02 212.0 271.0  0.01  0.01
; CO2_sum   268.0  0.05  0.03 252.0 284.0  0.01  0.01  0.01  0.01
; CO2       ---    0.02  0.02
; 
; H2O_ratio 115.0  0.12  0.02  86.0 145.0  0.01  0.01
; H2O_ratio 162.0  0.19  0.03 144.0 180.0  0.01  0.01  0.01  0.01
; H2O       ~90    0.11  0.02

end

if (0) then begin
    print, '---------------------------------------------'
    print, 'Check that the nights in N2_2.15 is the superset of all nights measured'
    names=["CH4_0.89","CH4_1.65","CH4_1.73","CH4_shift","CO2_sum","CO_2.35","H2O_ratio","N2_2.15"]
    nnames = n_elements(names)
    for in = 0, nnames-1 do begin
        name = names[in]
        rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
        if in eq 0 then yearall = year else yearall = [yearall,year]
        print, name, n_elements(year)
    endfor
    yearuniq = yearall[UNIQ(yearall, SORT(yearall))]
    print, yearuniq eq year
endif


end
