; 2008 04 01
; plot gy04 map vs. N2 area

rd_n2areas, year, et, slon, area, area_err

scutoff = 70.

slat = -50.

eabsmap = rdmap_insol( slat, lat_deg, lon_deg)
m = float(rdmap_scutoff(scutoff, slat, lat_deg, lon_deg))

da = map_da(m, lat=slat,lon=slon, frac=frac,/north)

fullarea = total(area*frac)/total(frac^2)

weights = 1/area_err^2.
arg = {slat:slat, slon:slon, eabsmap:eabsmap, $
      weight:weights, zobs:area, m:m, fullarea:fullarea, frac:frac}

scutoffarr = arrgen(50,100,5)
chisqarr = fltarr(n_elements(scutoffarr))

dof = (n_elements(slon)-2)

for i = 0, n_elements(scutoffarr)-1 do begin

    paraminit = [ scutoffarr[i] ]
    param = paraminit
    
    scutoff1_func, arg, param, area_mod
    
    chisqarr[i] = total( (area_mod - area)^2 * weights) / dof
endfor

chimin = min(chisqarr, imin)
scutoff = scutoffarr[imin]

paraminit = [ scutoff ]
param = paraminit

area_mod = curvefitlay(arg, area, weights, param, perr, $
                       func='scutoff1_func', /noderiv, chisq=chisq_dof, $
                       derivdelta = [.1])
perr_ext = perr * sqrt(chisq_dof)

scutoff1_func, arg, param, area_mod

lon361 = findgen(361)
m = arg.m
fullarea = arg.fullarea
area_mod361 = map_frac(m, lat=slat,lon=lon361, /north) * fullarea

;plot, slon, area_mod, ps=1
;oplot, slon, area, ps=4
;oploterr, slon, area, area_err, ps=4
;print, arg.frac
retall
stop

arg = {slat:slat, slon:slon, eabsmap:eabsmap}
paraminit = [70., fullarea]
param = paraminit

scutoff_func, arg, param, area_mod

area_mod = curvefitlay(arg, area, weights, param, perr, $
                       func='scutoff_func', /noderiv, chisq=chisq_dof)
perr_ext = perr * sqrt(chisq_dof)

lon361 = findgen(361)
m = rdmap_scutoff(param[0], slat, lat_deg, lon_deg)
area_mod361 = map_frac(m, lat=slat,lon=lon361, /north) * param[1]

window, xs=750, ys=420
loadct,0
titlestr = 'Insolation Cutoff'
fn = 'insoarea'
plot, slon, area, xr=[0,360], xs=3, ps=4, yr=[0,0.006], $
  title=titlestr, $
  xtitl = 'Sub-observer longitude', $
  ytitl = 'N2 band area'
oploterr, slon, area, area_err, ps=4
;oplot, slon, area_mod, ps=1
oplot, lon361, area_mod361
tv, rebin(float(m),180,90)*255, 90,60,/dev
plots, [0,180,180,0,0]+90,[0,0,90,90,0]+60, /dev
form = '("Insolation cutoff = ", F4.1, "+/-", F3.1)'
xyouts, 200, 0.0017, string(param[0], perr_ext[0], form=form)
form = '("Area for 100% N2 = ", F6.4)'
xyouts, 200, 0.0015, string(fullarea, form=form)
form = '("Chi-sq per degree of freedom = ", F5.2)
xyouts, 200, 0.0013, string(chisq_dof, form=form)

fn = '../figs/'+fn+'.tif'
tv2tiff, fn, /cor
spawn,'tiffutil -cat '+fn+' -out '+fn

end

