geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)

; 5 very bright, slightly reddish, main SPC
; 2 "dark" patchs (slightly darker & redder than 5) in PSC
; 6 bright fringe on margin of SPC. Bright and blue.
; 1 relatively dark & reddish N equitorial
; 4 transition between 1 and 6
; 3 bright, reddish (reddish material superimposed on bright fringe?)
window,2,xs=2*360+30,ys=2*180+30+30
device, decom=0
color = [0*16, 14*16, 11*16, 8*16, 7*16, 13*16, 5*16, 0] 

loadct,12
tvlct, r, g, b, /get
r[color[5]] = 220 & g[color[5]] = 200 & b[color[5]] = 200
r[color[2]] = 125 & g[color[2]] = 105 & b[color[2]] = 105
r[color[6]] = 200 & g[color[6]] = 220 & b[color[6]] = 255
r[color[3]] = 255 & g[color[3]] = 220 & b[color[3]] = 220
r[color[1]] = 155 & g[color[1]] = 95 & b[color[1]] = 95
r[color[4]] = 178 & g[color[4]] = 158 & b[color[4]] = 175
tvlct, r, g, b


m = bytarr(360,180)
for i=0,6 do m = m + color[i] * geomap[*,*,i]
tv, rebin(shift(m,180,0),2*360,2*180,/sam), 15, 15
for lat=-90,90,30 do  plots, [0,360]*2+15,(lat+[90,90])*2+15, /dev
for lon=30,330,30 do  plots, [lon,lon]*2+15,([0,180])*2+15, /dev
;polyfill, [0,360,360,0]*2+15, ([61,61,90,90]+90)*2+15, color=0, /dev
for lon=30,330,30 do $
  xyouts, lon*2+15, 2, string(lon-180,fo='(I4)'), /dev, al=0.5,co=3*16
for lat=-90,90,30 do $
  xyouts, 0, (lat+90)*2+15, string(lat,fo='(I4)'), /dev, al=0.5,co=3*16
xyouts, 10, 410, 'South Polar Cap', /dev, co=255
xyouts, 10, 400, '5: Main SPC. V. bright, reddish.', col=color[5], /dev
xyouts, 10, 390, '2: Darker patches in SPC', col=color[2], /dev

xyouts, 210, 410, 'Fringe', /dev, co=255
xyouts, 210, 400, '6: Bright, blue fringe on margin of SPC', col=color[6], /dev
xyouts, 210, 390, '3: Bright reddish material, ', $
  col=color[3], /dev
xyouts, 210, 380, '   perhaps superimposed on fringe?', $
  col=color[3], /dev

xyouts, 470, 410, 'Equatorial', /dev, color=255
xyouts, 470, 400, '1: Relatively dark and reddish N. equatorial', $
  col=color[1], /dev
xyouts, 470, 390, '4: Transition between 1 and 6', $
  col=color[4], /dev

tv2tiff, '../figs/mapgeol.tif', /cor, /true

end

