rd_resampled, wl_res, sp_res, badsp_res, lon_res, datestr_res, /lonsort, /fix
nres = n_elements(lon_res)
lonbin_resampled, wl_res, sp_res, badsp_res, lon_res, sp_oct, esp_oct, wsp_oct, lon_oct

name = 'CH4_1.65'
rd_areas,name, year, et, lon_tab, lat_tab, area_tab, area_err_tab, datestr_tab
ntab = n_elements(lon_tab)

unit_init, arg, param, data, weight
wl_fit = arg.wl
sp_fit = transpose(reform(data,arg.nwl,arg.nlon))
lon_fit = arg.lon
nfit = n_elements(lon_fit)

area_oct = fltarr(8)
area_res = fltarr(nres)
area_fit = fltarr(nfit)

for i = 0, 7 do area_oct[i] = calc_areas('CH4_1.65', wl_res, sp_oct[i,*])
for ires = 0, nres-1 do begin
    area_res[ires] = calc_areas('CH4_1.65', wl_res, reform(sp_res[ires,*]) )
endfor
for ifit = 0, nfit-1 do begin
    area_fit[ifit] = calc_areas('CH4_1.65', wl_fit, reform(sp_fit[ifit,*]) )
endfor
for itab = 0, ntab-1 do begin
    ires = where(datestr_tab[itab] eq datestr_res, nmatch)
    if nmatch gt 0 then begin
        ires = ires[0]

        wl = wl_res
        sp = reform(sp_res[ires,*])
        area = calc_areas('CH4_1.65', wl, sp)
;        area_res[ires] = area

        print, lon_tab[itab], ' '+datestr_tab[itab], area_tab[itab] 
        print, lon_res[ires], ' '+datestr_res[ires], area
        print,''
          
    endif

endfor

plot, lon_tab, area_tab, ps=4
oplot, lon_res, area_res, ps=1
;oplot, lon_oct, area_oct, ps=10
oplot, lon_fit, area_fit, ps=10



end
