
rd_resampled, wl, sp, badsp, lon_deg, datestr, /lonsort, /fix
;atv, sp

nwl = 1601
nsp = n_elements(datestr)
    
lonbin_resampled, wl, sp, badsp, lon_deg, msp, esp, wsp, mlon_deg

mmsp = total(msp, 1)/8

nbad = total(badsp, 1)
igd = where(nbad lt 20, ngd)
igd0 = split_contig(igd, igdlen, nsplit)

for isplit = 0, 2 do begin
    i0 = igd[igd0[isplit]]
    i1 = igd[igd0[isplit]] + igdlen[isplit] - 1

    window, isplit, xs=1400, ys=800
    !p.multi = [0,2,4]
    !p.background = !d.n_colors-1
    !p.color = 0
    !p.charsize = 1.5
    iarr = [7,0,6,1,5,2,4,3]
    for ii=0, 7 do begin
        i = iarr[ii]
        plot, wl[i0:i1], mmsp[i0:i1], title = string(i*45) + ' to ' + string( (i+1)*45), $
          yr=[0.4,1.4], /ys, xs = 3
        oplot,  wl[i0:i1], mmsp[i0:i1], col='a0a0a0'xl, thic=2
        oplot,  wl[i0:i1], msp[i,i0:i1]
        
        axis, /yax, yr=[-4,1] * 0.2 / 5.
        oplot, wl[[i0,i1]], [1,1]*1.2
        oplot, wl[i0:i1], (msp[i,i0:i1] - mmsp[i0:i1])*5 + 1.2
        for iwl=i0,i1 do begin
            e = msp[i,iwl] + [-1,1] * esp[i,iwl]
            oplot, wl[iwl]+[0,0],  (e - mmsp[iwl])*5 + 1.2
        endfor
        
        fn = 'plotresampled_'+strtrim(string(isplit),2)
    endfor
    wrgif,fn
        
endfor

end
