; 2008 04 01
; plot gy04 map vs. N2 area

rd_n2areas, year, et, slon, area, area_err

scutoff = 70.

slat = -50.

eabsmap = rdmap_insol( sslat, lat_deg, lon_deg)
m = rdmap_scutoff(scutoff, slat, lat_deg, lon_deg)

da = map_da(m, lat=slat,lon=slon, frac=frac,/north)

fullarea = total(area*frac)/total(frac^2)



arg = {slat:slat, slon:slon, eabsmap:eabsmap}
paraminit = [70., fullarea]
param = paraminit;

scutoff_func, arg, param, area_mod

weights = 1/area_err^2.
area_mod = curvefit(arg, area, weights, param, perr, $
                    func='scutoff_func', /noderiv)

lon361 = findgen(361)
area_mod361 = map_frac(rdmap_scutoff(param[0], slat, lat_deg, lon_deg),$
                       lat=slat,lon=lon361, /north) * param[1]

plot, slon, area, xr=[0,360], xs=3, ps=4, yr=[0,0.006]
oploterr, slon, area, area_err, ps=4
oplot, slon, area_mod, ps=1
oplot, lon361, area_mod361

end

