deg = !pi/180.
physconstants

; Read in the insolation map
; map_insol is the 
slat = -50.
map_insol = rdmap_insol(slat, lat_deg, lon_deg)

; Omega -  area in steradian
map_domega = cos(lat_deg * deg) * (deg^2)

;--------------------------
; 
;  /                         /
;  | sigma eps T^4 d_omega = | insol d_omega
; /ice                      /ice
;
; so  define
;
;            /                   
; area_ice = | d_omega 
;           /ice                 
;
;
;                 /
;  integ_insol = | insol d_omega
;                /ice
;
;
; sigma * eps * T^4 * area_ice = integ_insol

;--------------------------------
; first, what if coverage is everywhere?
;--------------------------------

map_ice = 0*map_insol + 1.

integ_insol = total(map_insol * map_ice * map_domega)

area_ice = total(map_ice * map_domega)

eps = 1.0
sigma = !phys.sigma

t = (integ_insol/(area_ice*eps*sigma))^0.25
 ; 33 K

eps = 0.5
t = (integ_insol/(area_ice*eps*sigma))^0.25
print, t ; 39
t = 38.
eps = integ_insol / (area_ice * sigma * t^4.)
print, eps ; 0.57

; so even in a best-case, we need a low-emissivity N2

;--------------------------------
; Now one of the summer-only N2 maps
;--------------------------------

delvarx, map_ice
restore, '../maps/geolarea25.sav'
integ_insol = total(map_insol * map_ice * map_domega)
area_ice = total(map_ice * map_domega)
eps = 1.0
t = (integ_insol/(area_ice*eps*sigma))^0.25
print, t ; 33.6
eps = .5
t = (integ_insol/(area_ice*eps*sigma))^0.25
print, t ; 40.0
t = 38.
eps = integ_insol / (area_ice * sigma * t^4.)
print, eps ; 0.62

;--------------------------------
; and a winter-only map
;--------------------------------

delvarx, map_ice
restore, '../maps/geolarea025.sav'
integ_insol = total(map_insol * map_ice * map_domega)
area_ice = total(map_ice * map_domega)
eps = 1.0
t = (integ_insol/(area_ice*eps*sigma))^0.25
print, t ; 25.96
eps = .5
t = (integ_insol/(area_ice*eps*sigma))^0.25
print, t ; 30.88
t = 38.
eps = integ_insol / (area_ice * sigma * t^4.)
print, eps ; 0.22

;=================
; we can look at the balance locally and ask
; for a given emissivity 
; what is the insolation at the point
; for which sublimation equals condensation

;--------------------------
; LOCALLY
; 
;   sigma eps T^4  = insol  : for lcal balance
; 
;

t = 38.
eps = arrgen(0.2,1.0,0.2)

insol = sigma * eps * t^4

;    0.20   23.65
;    0.40   47.29
;    0.60   70.94
;    0.80   94.59
;    1.00  118.24

; so, 70 erg/cm^2/s as a sublimation/condensation cutoff
; corresponds to an emissivity of 0.6.
;
; Can we get 0.6 emisivity with a N2-covered night side
; and "invisible" N2?

;--------------------------------
; winter-only map with invisible N2
;--------------------------------

delvarx, map_ice
restore, '../maps/geolarea025.sav'
map_ice_plus = map_ice
map_ice_plus[*,50:60] = 1
integ_insol = total(map_insol * map_ice_plus * map_domega)
area_ice = total(map_ice_plus * map_domega)
t = 38.
eps = integ_insol / (area_ice * sigma * t^4.)
print, eps ; 0.3
print, 'lat', ' eps'
for lat=-40,-90,-1 do begin
    map_ice_plus[*,lat+90:90-30] = 1
    integ_insol = total(map_insol * map_ice_plus * map_domega)
    area_ice = total(map_ice_plus * map_domega)
    t = 38.
    eps = integ_insol / (area_ice * sigma * t^4.)
    print, lat, eps                  ; 0.3
end
;      -40      0.30321434
;     -50      0.383
;    -60      0.46
;    -70      0.52

;--------------------------------
; winter-only map, 2 different emissivities
;--------------------------------
;--------------------------
; 
;  /                            /
;  |   sigma eps1 T^4 d_omega + |    sigma eps2 T^4 d_omega =
; /ice1                        /ice2
;
;
;    /                     /                 /
;    |     insol d_omega + | insol d_omega = |       insol d_omega
;    /ice1                 /ice2             /ice1+2
;
; so  define
;
;             /                   
; area_ice1 = |    d_omega 
;            /ice1                 
;
;             /                   
; area_ice2 = |    d_omega 
;            /ice2                 
;
;
;                 /
;  integ_insol = |       insol d_omega
;                /ice1+2
;
;
; sigma * T^4 * (eps1 * area_ice1 + eps2 * area_ice2) = integ_insol

delvarx, map_ice
restore, '../maps/geolarea025.sav'
map_1 = map_ice
area_1 = total(map_1 * map_domega)
eps1 = 0.4
print, 'lat eps_2'
for lat=-30,-90,-1 do begin
    map_2 = map_ice*0
    map_2[*,lat+90:60] = 1
    map_12 = map_1 + map_2
    integ_insol = total(map_insol * map_12 * map_domega)
    area_2 = total(map_2 * map_domega)
    t = 38.
    eps2 = (integ_insol - sigma* (t^4) * eps1 * area_1)/ (area_2 * sigma * t^4.)
    print, lat, eps2
end


end
