pro fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
  lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
  lonmin, lonmin0, lonmin1, ratiomin, ratiominerr 

  deg = !pi/180
  arc_hw = 30.

  a = replicate(0., 1+2*nterms)
  w = 1/(area_err)^(2.)
  r = curvefit(lon_deg, area, w, a, sigma, func='fourierfunc', chisq=chisq)
  sigma = sigma * sqrt(chisq)
  theta = findgen(361)
  fourierfunc,theta,a,model
  ratio = model/a[0]

  ratmax = max(ratio,imax)
  ihigh = where(ratio[0:359] gt (1 + (ratmax-1)*cos(arc_hw*deg)),nhigh)
  thigh = ((theta[ihigh] - theta[imax] + 180 ) mod 360) - 180 + theta[imax]
  shigh = sort(thigh)
  thigh = thigh[shigh]
  ratiomax = ratmax
  lonmax = theta(imax)
  lonmax0 = thigh[0]
  lonmax1 = thigh[nhigh-1]
  modelmaxvar = 0.
  for i = 1, nterms do begin
      modelmaxvar = modelmaxvar + (sigma[2*i-1]*cos(i*lonmax*deg))^2 
      modelmaxvar = modelmaxvar + (sigma[2*i  ]*sin(i*lonmax*deg))^2 
  endfor
  modelmaxerr = sqrt(modelmaxvar)
  ratiomaxerr = modelmaxerr/a[0]

  ratmin = min(ratio,imin)
  ilow = where(ratio[0:359] lt (1 - (1-ratmin)*cos(arc_hw*deg)),nlow)
  tlow = ((theta[ilow] - theta[imin] + 180 ) mod 360) - 180 + theta[imin]
  slow = sort(tlow)
  tlow = tlow[slow]
  ratiomin = ratmin
  lonmin = theta(imin)
  lonmin0 = tlow[0]
  lonmin1 = tlow[nlow-1]
  ratiominvar = sigma[0]^2
  for i = 1, nterms-1 do begin
      ratiominvar = ratiominvar + (sigma[2*i-1]*cos(i*lonmin*deg))^2 
      ratiominvar = ratiominvar + (sigma[2*i  ]*sin(i*lonmin*deg))^2 
  endfor
  ratiominerr = sqrt(ratiominvar)/a[0]
  
end
