pro geol_func, arg, param, z, deriv

    slat = arg.slat
    slon = arg.slon
    unit = arg.unit
    minlat0 = arg.minlat0
    minlat = param[0]
    fullarea = param[1]
    
    m = rdmap_geol(minlat, unit, lat_deg, lon_deg, minlat0=minlat0)
    da = map_da(m, lat=slat,lon=slon, frac=frac,/north)
    
    z = fullarea * frac

    if n_params() ge 4 then begin
        n = n_elements(frac)
        deriv = dblarr(n,n_elements(param))
        lati = floor(minlat) + 90
        for i = 0, n-1 do begin
            deriv[i,0] = -total(da[*,lati,i] * m[*,lati]) * fullarea
        endfor
        deriv[*,1] = frac
    endif

end
