; NAME:
;  latcutoff
; PURPOSE: (one line)
;  Read the Grundy Young 2004 N2 map of Triton
; CALLING SEQUENCE:
;  map_geol = rdmap_geol(minlat, units, lat_deg, lon_deg)
; INPUTS:
;  sslat_deg - the subsolar latitude in degrees
; OUTPUTS:
;  map - 
;   360 by 180.  Pixels are 1-deg wide.
;   Pixel 0,0 runs from latitude -90 to -89 and East longitude 0 to 1.
;  lat_deg - the latitude in degrees (360 x 180 array)
;  lon_deg - the East longitude in degrees (360 x 180 )
; COMMON BLOCKS:
;  None
; RESTRICTIONS:
;  ONLY WORKS FOR MAPS WITH 
;  LAT_deg[*,0] = -89.5 (pixel spans [-90 to -89])
;  LAT_deg[*,1] = -88.5 (pixel spans [-89 to -88]), etc.
; MODIFICATION HISTORY:
;  Written 2007 June 26, by Leslie Young, SwRI
;-

function latcutoff, m, lat_deg, minlt

    ; hilatmap : high latitudes (eg not near south pol)
    ;   value = 1 if latitude > -31, 0 otherwise
    floorlat = floor(minlat)
    hilatmap = lat_deg gt floorlat

    ; m_out : Grundy & Young 2004 N2 map - SPC and lat > -31
    m_out = m and hilatmap

    ; take care of the fractional part
    dlat = 1-(minlat - floorlat)
    i = floorlat + 90  
    m_out = float(m_out)
    m_out[*,i] = m_out[*,i] * dlat

    return, m

end
