

pro lonbin_resampled, wl, sp, badsp, lon_deg, msp, esp, wsp, mlon_deg

nwl = n_elements(wl)
nsp = n_elements(datestr)

mlon_deg = findgen(8)*45 + 45./2
    
msp = fltarr(8,nwl)  ; mean spectrum
esp = fltarr(8,nwl)  ; error spectrum
wsp = fltarr(8,nwl)  ; weight spectrum
for i = 0, 7 do begin
    ilon = where(lon_deg ge i*45. and lon_deg lt (i+1)*45.)
    ;print, ilon
    for iwl = 0, nwl-1 do begin
        s = sp[ilon, iwl]
        b = badsp[ilon, iwl]
        igd = where(b ne 1, ngd)
        if ngd gt 1 then begin
            msp[i,iwl] = mean(s[igd])
            esp[i,iwl] = stddev(s[igd]) / sqrt(ngd)
            wsp[i,iwl] = 1/(esp[i,iwl])^2.
        endif
    endfor
endfor


end
