;pro majcycle

if (0) then begin    
t = arrgen(2007-640.*2, 2090, 1/20.)
phi = triton_subsollat(t)           

t1= shift(t,1)
p1 = shift(phi,1)

cross = where(p1 * phi lt 0 and (p1-phi)/(t1-t) lt 0 )
plot, t, phi
oplot, t[cross[[5,9]]], phi[cross[[5,9]]], ps=4
;print,  t[cross[[5,9]]]
;      1391.90      2046.95

t = arrgen(1391, 1392., 1/100.)
phi = triton_subsollat(t)
t1= shift(t,1)
p1 = shift(phi,1)
cross = where(p1 * phi lt 0 and (p1-phi)/(t1-t) lt 0 )
plot, t, phi
oplot, t[cross[[1]]], phi[cross[[1]]], ps=4
t0 = t[cross[1]]
; 1391.87


t = arrgen(2046, 2047, 1/100.)
phi = triton_subsollat(t)
t1= shift(t,1)
p1 = shift(phi,1)
cross = where(p1 * phi lt 0 and (p1-phi)/(t1-t) lt 0 )
plot, t, phi
oplot, t[cross[[1]]], phi[cross[[1]]], ps=4
t1 = t[cross[1]]
;2046.91
end

nt = 10000L
t = findgen(nt) * (2046.91 - 1391.87)/nt +  1391.87
latss = triton_subsollat(t)
nlat = 180L
lat = (findgen(nlat) - 89.5) * !dpi/180.d
muarr = fltarr(nlat, nt)
for it = 0, nt-1 do muarr[*,it] = insolfac(latss[it], lat)

mkhdr,h, muarr
sxaddpar, h, 'COMMENT', 'Diurnal average of cos(solar illumination angle) for Triton,'
sxaddpar, h, 'COMMENT', 'or the ratio of diurnal insolation to normal insolation'
sxaddpar, h, 'COMMENT', 'Subsolar latitudes were calculated with the functional form '
sxaddpar, h, 'COMMENT', 'of Trafton (1984) and the updated coefficients of Forget et al. (2000).
sxaddpar, h, 'COMMENT', 'Created 2007 June 27, Leslie Young, SwRI'
sxaddpar, h, 'COMMENT', 'using projects/tritonspex/ms-5yr/triton-bond-alb/majcyc.pro'
sxaddpar, h, 'TIMESTRT', 1391.87, 'Start time (year)'
sxaddpar, h, 'TIMEEND',  2046.91, 'End time (year)'
sxaddpar, h, 'LATSTRT',  -89.5, 'Starting latitude (deg)'
sxaddpar, h, 'LATEND',  89.5, 'Ending latitude (deg)'
writefits, 'triton_solfac.fits', muarr, h

;IDL>   alpha1 = 2.185376 * !pi/180.
;IDL>   beta1 = 0.523169 * !pi/180.
;IDL> print, 2.*!pi/alpha1
;      164.731
;IDL> print, 2.*!pi/(alpha1 + beta1)
;      132.913
;IDL> print, 2.*!pi/(alpha1 - beta1)
;      216.580
;IDL> print, 2.*!pi/( beta1)        
;      688.114


end
