; maps are all 360 x 180, with edge of the 0,0 pixel
; at 0 East longitude, -90 latitude

; geomap : 7 planes of geologic units
;   0 = unmapped, 1-6 = units 1-6
;   value = 0 if not in unit, 1 if in unit
; spcmap : south polar cap (units 2+3+5)
;   value = 0 if not in units, 1 if in units
; spc2map : south polar cap plus 
;   value = 0 if not in units, 1 if in units
; hilatmap : high latitudes (eg not near south pol)
;   value = 1 if latitude > -31, 0 otherwise
; lolatmap: high latitudes (eg not near N pole)
;   this is for messing around with foomap,
;   value = 1 if latitude < S
; gy04map : Grundy & Young 2004 N2 map - SPC and lat > -31

; ab : hemispheric bolometric albedo
; mu : diurnally averaged cos(solar illumination angle)
; eabs : energy absorbed (insolation 
;pro map_gy04

    physconstants  ; set up !phys.sigma, etc
    deg = !dpi/180.d
    
    window,0, xs=360,ys=180

    ; read in the geologic map
    geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)
    latmap = lat_deg * deg
    lonmap = lon_deg * deg
    spcmap = geomap[*,*,5] + geomap[*,*,2] + geomap[*,*,3]
    spc2map = geomap[*,*,5] + geomap[*,*,2] + geomap[*,*,3] + geomap[*,*,6]
    hilatmap = lat_deg gt -31
    lowlatmap = lat_deg gt 40.57
    gy04map = spcmap and hilatmap
    foomap = (spc2map and hilatmap ) or lowlatmap
;    foomap = geomap[*,*,6]
    
    
    abmap = rdmap_triton_stans92(-45)

    sslat = -49.43 * deg
    mumap = insolfac(sslat, lat_deg * deg)
    eabsmap = mumap * (1. - abmap) * 1.373e6/(30.08^2.)

    cut = 40. ; percentile of "heating" below which N2 ice is stable
    icut = round( ((100-38.5)/100) * n_elements(eabsmap) )
    sort_eabsmap = sort(eabsmap)
    eabscut = eabsmap[ sort_eabsmap[ icut ] ]
;    eabscut = 152.68 / 2.
    ; checkit
    indxloweabs = where(eabsmap le eabscut, nloweabs, $
                        comp = indxhieabs, ncomp =  nhieabs)
    loweabsmap = eabsmap le eabscut

    areamap = cos(latmap) * deg^2.

    loweabsfrac = total(loweabsmap * areamap)/total(areamap)
    gy04frac = total(gy04map * areamap)/total(areamap)
    foofrac = total(foomap * areamap)/total(areamap)

    loweabs_eavg = total(loweabsmap * eabsmap * areamap) / total( loweabsmap * areamap)
    loweabs_eps = loweabs_eavg / (!phys.sigma * (38.5d)^4)

    gy04_eavg = total(gy04map * eabsmap * areamap) / total( gy04map * areamap)
    gy04_eps = gy04_eavg / (!phys.sigma * (38.5d)^4)
    
    foo_eavg = total(foomap * eabsmap * areamap) / total( foomap * areamap)
    foo_eps = foo_eavg / (!phys.sigma * (38.5d)^4)

    print, 'eps', loweabs_eps, gy04_eps, foo_eps
    
;    eabsplotmax = max(loweabsmap * eabsmap * areamap)
    eabsplotmax = 100. *deg^2
    xshift=0

    wset,0
    tv, shift(loweabsmap * eabsmap * areamap ,xshift,0) * 255/eabsplotmax 
    wset,2
    tvscl, shift(loweabsmap * areamap ,xshift,0) 
    
    wset,1
    tv, shift(gy04map * eabsmap * areamap ,xshift,0) * 255/eabsplotmax < 255
    wset,3
    tvscl, shift(gy04map * areamap ,xshift,0)
    
    wset,4
    tv, shift(foomap * eabsmap * areamap ,xshift,0) * 255/eabsplotmax < 255
    wset,5
    tvscl, shift(foomap * areamap ,xshift,0)
    

end

