pro mapset_image, title=title, image=image, pimage=pimage, wsize=wsize, center0=center0

    win, wsize=wsize

    MAP_SET, /AZIMUTHAL, /ISOTROPIC, -90, $
      TITLE = title, limit = [-90,0,60,360], chars=1.29, /nob, clip=0

    pimage = MAP_IMAGE(image,Startx,Starty, COMPRESS=1, $  
                          LATMIN= -89.5, LONMIN=0, $  
                          LATMAX= 89.5, LONMAX=360) 
    nul = where(pimage eq 0, nnul)
    if nnul ne 0 then pimage[nul] = 'ffffff'xl
    tv, truecolorconv(pimage), Startx,Starty, /true

    deg = !pi/180.
    theta = findgen(361)
;    for i=0,270,90 do plots, [i,i], [-90,60], thick=2
;    plots, theta, 0*theta, thick=2
;    map_grid, latdel = 90, londel=90, color = 0, glines=0, thick=2
    map_grid, latdel = 30, londel=30, color = 0, glines=0, /label, $
      chars=1.2, $
      latlab = 45
    

    if wsize eq 'medium' or wsize eq 'large' then begin
        th = findgen(31)-15
        polyfill,[th,reverse(th)], $
          [replicate(53,31),replicate(73,31)],col='ffffff'xl,/nocl
        polyfill,[th,reverse(th)]+180, $
          [replicate(50,31),replicate(73,31)],col='ffffff'xl,/nocl
        polyfill,[th,reverse(th)]-90, $
          [replicate(50,31),replicate(73,31)],col='ffffff'xl,/nocl
        polyfill,[th,reverse(th)]+90, $
          [replicate(50,31),replicate(73,31)],col='ffffff'xl,/nocl
    endif else begin
        th = findgen(31)-15
        polyfill,[th,reverse(th)], $
          [replicate(50,31),replicate(65,31)],col='ffffff'xl,/nocl
        polyfill,[th,reverse(th)]+180, $
          [replicate(50,31),replicate(73,31)],col='ffffff'xl,/nocl
        polyfill,[th,reverse(th)]-90, $
          [replicate(50,31),replicate(73,31)],col='ffffff'xl,/nocl
        polyfill,[th,reverse(th)]+90, $
          [replicate(50,31),replicate(73,31)],col='ffffff'xl,/nocl
    endelse
    xyouts, 0, 52, 'Neptune Facing', chars=1.2, ali=0.5
    xyouts, 90, 55, 'Leading', chars=1.2, ali=0.5, orient = 90
    xyouts, 180, 55, 'Anti-Neptune', chars=1.2, ali=0.5
    xyouts, 270, 55, 'Trailing', chars=1.2, ali=0.5, orient = 90

    
    
end
