pro mapset_map, title=title, map=map, pimage=pimage,alt=alt

    MAP_SET, /AZIMUTHAL, /ISOTROPIC, -90, $
      TITLE = title, limit = [-90,0,60,360], chars=1.29, /nob
    
    pimage = MAP_IMAGE(byte(map*255),Startx,Starty, COMPRESS=1, $  
                          LATMIN= -89.5, LONMIN=0, $  
                          LATMAX= 89.5, LONMAX=359) * '010101'xl
    nul = where(pimage eq 0, nnul)
    if nnul ne 0 then pimage[nul] = 'ffffff'xl
    tv, truecolorconv(pimage), Startx,Starty, /true

    deg = !pi/180.
    theta = findgen(361)
;    for i=0,270,90 do plots, [i,i], [-90,60], thick=2
;    plots, theta, 0*theta, thick=2
;    map_grid, latdel = 90, londel=90, color = 0, glines=0, thick=2
    map_grid, latdel = 30, londel=30, color = 0, glines=0, /label, $
      chars=1.2, $
      latlab = 45
    

    xyouts, 0, 55, 'Neptune Facing', chars=1.2, ali=0.5
    xyouts, 90, 50, 'Leading', chars=1.2, ali=0.5, orient = 90
    xyouts, 180, 50, 'Anti-Neptune', chars=1.2, ali=0.5
    xyouts, 270, 55, 'Trailing', chars=1.2, ali=0.5, orient = 90

    
    
end
