pro mapset_polar, title=title, wsize=wsize

    win, wsize=wsize
    print, 'wsize = ', wsize


    MAP_SET, /AZIMUTHAL, /ISOTROPIC, -90, $
      TITLE = title, limit = [-90,0,70,360], /noborder, chars=1.3

    deg = !pi/180.
    theta = findgen(361)
    for i=0,270,90 do plots, [i,i], [-90,60], thick=2
    plots, theta, 0*theta, thick=2
;    map_grid, latdel = 90, londel=90, color = 0, glines=0, thick=2
    map_grid, latdel = 18, londel=30, color = 0, glines=0, /label, $
      chars=1.2, $
      lats=findgen(9)*18 - 90, $
      latnames = ['','0.2','0.4','0.6','0.8','1.0','1.2','1.4','1.6'], $
      latlab = 45

    xyouts, 0, 65, 'Neptune Facing', chars=1.2, ali=0.5
    xyouts, 90, 70, 'Leading', chars=1.2, ali=0.5, orient = 90
    xyouts, 180, 70, 'Anti-Neptune', chars=1.2, ali=0.5
    xyouts, 270, 65, 'Trailing', chars=1.2, ali=0.5, orient = 90
    
end
