pro oplot_arc_by_name, name, wsize=wsize

    if not keyword_set(wsize) then wsize = 'medium'

    deg = !pi/180.
    theta = findgen(361)
    
    names=names(colors,titles)

    iname = where(names eq name, nmatch)
    if nmatch eq 0 then return
    iname = iname[0]
    color = colors[iname]
    
    rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
    nterms = 1
    fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
      lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
      lonmin, lonmin0, lonmin1, ratiomin, ratiominerr

    ; plot the positive side
    xlabel = lonmax
    doplot = 1
    case name of 
        'N2_2.15': begin
            thick = 14          ; *** thickness 8 for 20% peak-to-peak
            arclat = 70
            ylabel = 80
            label = '!340% more N!D2!N'
            doplot = 1
        end
        'CO_2.35': begin
            thick = 14          ; *** thickness 8 for 20% peak-to-peak
            arclat = 60
            xlabel = 68
            ylabel = 67
            label = '!335% more CO'
            doplot = 1
        end

        'CH4_0.89': begin
            thick = 8
            arclat = 57
            xlabel = -80
            ylabel = 40
            label = '!319% more deep CH!D4!N'
        end
        'CH4_1.65': begin
            thick = 4
            arclat = 61
            xlabel = -30
            ylabel = 67
            label = '!37% more CH!D4!N'
        end
        'CH4_1.73': begin
            thick = 4
            arclat = 52
            xlabel = -30
            ylabel = 37
            label = '!310% more CH!D4!N'
        end

        'CO2_sum': begin
            thick = 2
            arclat = 55
            xlabel = 45
            ylabel = 68
            label = '!3Uniform CO!D2!N'
            lonmax0 = 0
            lonmax1 = 361
            doplot = 1
        end
        'H2O_ratio': begin
            thick = 2
            arclat = 63
            xlabel = 130
            ylabel = 72
            label = '!36% more H!D2!NO'
            doplot = 1
        end
        else: doplot = 0

    endcase

    if doplot then begin
        thetaarc = arrgen(lonmax0, lonmax1)
        plots, thetaarc, 0*thetaarc+arclat, color=color, thick=thick
        xyouts, xlabel, ylabel, label, chars=1.5, $
          orient=atan(tan(-xlabel*deg))/deg, ali=0.5, color=color
    endif

    xlabel = lonmin
    doplot = 1
    case name of 
        'N2_2.15': begin
            thick = 14
            arclat = 70
            xlabel = -130
            ylabel = 85
            label = '!340% less N!D2!N'
            doplot = 1
        end
        'CO_2.35': begin
            thick = 14          ; *** thickness 8 for 20% peak-to-peak
            arclat = 60
            xlabel = -150
            ylabel = 50
            label = '!335% less CO'
            doplot = 1
        end

        'CH4_0.89': begin
            thick = 8
            arclat = 57
            xlabel = 90
            ylabel = 40
            label = '!319% less deep CH!D4!N'
        end
        'CH4_1.65': begin
            thick = 4
            arclat = 61
            xlabel = 130
            ylabel = 72
            label = '!37% less CH!D4!N'
        end
        'CH4_1.73': begin
            thick = 4
            arclat = 52
            xlabel = 150
            ylabel = 45
            label = '!310%less CH!D4!N'
        end

        'CH4_shift': begin
            thick = 2
            arclat = 50
            xlabel = -120
            ylabel = 45
            label = '!3some pure CH!D4!N'
        end

        'CO2_sum': begin
            doplot = 0
        end
        'H2O_ratio': begin
            thick = 2
            arclat = 60
            xlabel = -45
            ylabel = 72
            label = '!36% less H!D2!NO'
            doplot = 1
        end
        else: doplot = 0
    endcase
    if doplot then begin
        thetaarc = arrgen(lonmin0, lonmin1)
        plots, thetaarc, 0*thetaarc+arclat, color=color, thick=thick, line=2
        xyouts, xlabel, ylabel, label, chars=1.5, $
          orient=atan(tan(-xlabel*deg))/deg, ali=0.5, color=color
    end

end
