pro oplot_data_by_name, name

    deg = !pi/180.
    theta = findgen(361)
    
    names=names(colors,titles)

    iname = where(names eq name, nmatch)
    if nmatch eq 0 then return
    iname = iname[0]
    color = colors[iname]
    
    rd_areas,name, year, et, lon_deg, lat_deg, area, area_err

    ; fit it to get a[0], the mean 
    a = [0,0,0]
    w = 1/(area_err)^(2.)
    r = curvefit(lon_deg, area, w, a, sigma, func='fourierfunc', chisq=chisq)
;    fourierfunc,theta,a,model
;    ratio = model/a[0]

    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    
    plotsym, 0, 1, /fill, color=color
    pos = where(area gt 0)
    plots, lon_deg[pos], (area[pos]/pscale) * 90 - 90, ps=8, color=color
    n = n_elements(area)
    for i = 0, n-1 do begin
        low = area[i] - area_err[i]
        if low lt 0 then low = 0
        high = area[i] + area_err[i]
        if area[i] gt 0 then begin
            plots, [1,1]*lon_deg[i],  (([low,high])/pscale) * 90 - 90, $
              color=color, thick=2
        endif 
    endfor
    s = sort(lon_deg)
;    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2

end
