; Make five plots
; triton_v2_small - trimap1 small
; mcewen_small - McEwen geol. map (small)
; mcewen_annot_small - McEwen annotated (small)

; mcewen_all_n2_map
; mcewen_all_n2_frac
; mcewen_new_n2_map
; mcewen_new_n2_frac


pro plot_ices08_mcewen_n2

;====================================
; PLOTS FOR THE ICES 2008 MEETING
;====================================

deg = !pi/180.
theta = findgen(361)
cost = cos(theta/deg)
sint = sin(theta/deg)
dir = '../figs/'
device, true_color = 24
window, 2, xs = 450, ys = 500
!p.color = 0
!p.background = !d.N_COLORS - 1L
naifinit, ker='../spice/kernels.tm'

names=names(colors,titles)

geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)

if (1) then begin

    minlat = -33.34
    unit = [0,0,1,0,0,1,0]

    slat = -50.
;    m = rdmap_geol(minlat, unit, lat_deg, lon_deg)
    iname = 0
    name = names[iname]
;    rd_areas,name, year, et, slon, slat, area, area_err
;    da = map_da(m, lat=slat,lon=slon, frac=frac,/north)
;    frac361 = map_frac(m,lat=replicate(-50,361),lon=theta, /north)
;    image = byte(m) * colors[0]
;    mapset_image, ti='Unit 2 & 5, -33.34 deg cutoff', image=image, wsi='small'
;    writegif,'mcewen_all_n2_map'
;    mapset_polar, title=titles[iname], wsize='medium'
;    oplot_data_by_name, names[iname]
;    oplot_arc_by_name, names[iname]
;    plots, theta, frac361/mean(frac361) * 90 - 90, color=colors[0], thick=2
;    writegif, 'mcewen_all_n2_frac'

    scutoff = 70.
    eabsmap = rdmap_insol( slat, lat_deg, lon_deg)
    m = float(rdmap_scutoff(scutoff, slat, lat_deg, lon_deg))
    
    da = map_da(m, lat=slat,lon=slon, frac=frac,/north)
    frac361 = map_frac(m,lat=replicate(-50,361),lon=theta, /north)
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, names[iname]
    oplot_arc_by_name, names[iname]
    plots, theta, frac361/mean(frac361) * 90 - 90, color=colors[0], thick=2

    
endif

if (0) then begin
    print, '------------------------'
    print, 'triton_v2_small'

    map_v2 = rdmap_trimap1(lat_deg, lon_deg)
    mapset_image, image=map_v2, ws='small', titl='Triton Voyager 2'
    writegif, 'triton_v2_small'
    
    oplot_arc_by_name, 'N2_2.15'
    writegif, 'triton_v2-n2-arc_small'

endif

if (0) then begin

    map_geot = rdmap_triton_mcewen90colorized()
    mapset_image, image=map_geot, ws='small', titl='Geologic Units'
    writegif, 'mcewen_small'
    oplot_arc_by_name, 'N2_2.15'
    writegif, 'mcewen-n2-arc_small'

    map_geot = rdmap_triton_mcewen90colorized()
    mapset_image, image=map_geot, ws='small', titl='Geologic Units'
    lon=30
    xyouts, lon, -45, '!3CAP (5&2)', color='0000ff'xl, al=0.5, chars=1.2, orient= -lon
    lon = 0
    xyouts, lon, 2, '!3FRINGE (6)', color='0000ff'xl, al=0.5, chars=1.2, orient=-lon
    lon = -30
    xyouts, lon, 15, '!3EQ. BAND (1)', color='0000ff'xl, al=0.5, chars=1.2, orient=-lon
    lon = -30
    xyouts, lon, 15, '!3EQ. BAND (1)', color='00d7ff'xl, al=0.5, chars=1.2, orient=-lon
    lon = -60
    xyouts, lon, -25, '!3GAP (3)', color='0000ff'xl, al=0.5, chars=1.2, orient=-lon
    lon = -90
    xyouts, lon, -15, '!3FRINGE/BAND (4)', color='0000ff'xl, al=0.5, chars=1.2, orient=-lon
    writegif, 'mcewen_annot_small'

endif

if (0) then begin
    print, '------------------------'
    print, 'ices08_N2_2.15_data'
    
    iname = 0
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, names[iname]
    oplot_arc_by_name, names[iname]
    writegif, 'n2_data_arc'
    
endif



if (0) then begin
    print, '------------------------'
    print, 'first cartoon - picture as of McEwen 1990'

    geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)
    nxnyn,geomap, nx,ny,n
    map_geot = rdmap_triton_mcewen90colorized()
    map_comp = map_geot

;    mapset_image, title='McEwen Units', image=map_geot, pimage=pmap_geot

    ; get the boundary of the SPC
    map5 = geomap(*,*,5) + geomap[*,*,2]
    maxlat5 = fltarr(360)
    for i=0,359 do begin
        latstrip = map5[i,*]
        unit5 = where(latstrip eq 1, nunit)
        if nunit gt 0 then maxlat5[i] = lat_deg[i,unit5[nunit-1]]
    endfor

    ; Fill unit 5 in with N2 and CH4
    unit5 = where(map5 eq 1, nunit5)
    map_comp[unit5] = colors[0]
    map_comp[unit5] = '008000'xl
;    for i=0,359,8 do begin
;        for j = 0 + (i mod 2), 179,8 do begin
;            if (geomap[i,j,5] eq 1) or (geomap[i,j,2] eq 1) then begin
;                map_comp[i:i+1,j:j+1] = colors[2]
;           endif
;        endfor
;    endfor
 
    ; unit 6 -- just N2
    map6 = geomap[*,*,6]
;    map6 = geomap[*,*,6] + geomap[*,*,4]
    unit6 = where(map6 eq 1, nunit6)
    map_comp[unit6] = colors[0]

    ; unit 1 unknowmn
    map1 = geomap[*,*,1]
    unit1 = where(map1 eq 1, nunit1)
    map_comp[unit1] = '010101'xl * 128
    
    ; unit 4 is unknown/new N2
    map4 = geomap[*,*,4]
    unit4 = where(map4 eq 1, nunit4)
    map_comp[unit4] = '80af80'xl

    mapset_image, title='McEwen Units', image=map_comp, wsize='small'

    xyouts, 0, -30, '!3Old N!D2!N & CH!D4!N', color='0000ff'xl, al=0.5, chars=1.2
    xyouts, -165, -5, '!3New N!D2!N', color='0000ff'xl, al=0.5, chars=1.2, orient=-15
    xyouts, 155, 15, '!3???', color='0000ff'xl, al=0.5, chars=1.2, orient=180-155

endif


end
