pro plot_ices08_methane

;====================================
; PLOTS FOR THE ICES 2008 MEETING
;====================================

deg = !pi/180.
theta = findgen(361)
cost = cos(theta/deg)
sint = sin(theta/deg)
dir = '../figs/'
device, true_color = 24
window, 2, xs = 450, ys = 500
!p.color = 0
!p.background = !d.N_COLORS - 1L
naifinit, ker='../spice/kernels.tm'

names=names(colors,titles)

geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)

if (1) then begin

    name = 'CH4_0.89'
    iname = where(names eq name)
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, name
    oplot_arc_by_name, name
    oplot_sin_by_name, name
    wrgif, 'ices08_ch4_089-data-sin-arc'
    
    name = 'CH4_1.65'
    iname = where(names eq name)
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, name
    oplot_arc_by_name, name
    oplot_sin_by_name, name
    wrgif, 'ices08_ch4_165-data-sin-arc'

    name = 'CH4_1.73'
    iname = where(names eq name)
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, name
    oplot_arc_by_name, name
    oplot_sin_by_name, name
    wrgif, 'ices08_ch4_173-data-sin-arc'
    
    name = 'CH4_shift'
    iname = where(names eq name)
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, name
    oplot_arc_by_name, name
    oplot_sin_by_name, name
    wrgif, 'ices08_ch4_shift-data-sin-arc'
    
    mapset_polar, title='CH!D4', wsize='medium'
    oplot_data_by_name, 'CH4_1.65'
    oplot_arc_by_name, 'CH4_0.89'
    oplot_arc_by_name, 'CH4_1.65'
    oplot_arc_by_name, 'CH4_1.73'
    oplot_arc_by_name, 'CH4_shift'
    wrgif, 'ices08_methane-data-arc'
    
    mapset_polar, title='CH!D4', wsize='small'
    oplot_data_by_name, 'CH4_1.65'
    oplot_arc_by_name, 'CH4_0.89'
    oplot_arc_by_name, 'CH4_1.65'
    oplot_arc_by_name, 'CH4_1.73'
    oplot_arc_by_name, 'CH4_shift'
    wrgif, 'ices08_methane-data-arc-small'
    
end
if (0) then begin
    print, '---------------------------------------------'
    print, 'Methane plot'
    names=names(colors,titles)
    inarr = [2,3,4,5] ; CO2, H2O
    nii = n_elements(inarr)
    nterms = 1
    aarr = fltarr(1+2*nterms, nii)
    lonmaxarr = fltarr(3,nii)
    lonminarr = fltarr(3,nii)
    ratmaxarr = fltarr(nii)
    ratminarr = fltarr(nii)
    for iin = 0, nii-1 do begin
        in = inarr[iin]
        name = names[in]
        rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
        fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
          lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
          lonmin, lonmin0, lonmin1, ratiomin, ratiominerr
        aarr[*,iin] = a
        ratmaxarr[iin] = ratiomax
        lonmaxarr[*,iin] = [lonmax0,lonmax,lonmax1]
        ratminarr[iin] = ratiomin
        lonminarr[*,iin] = [lonmin0,lonmin,lonmin1]
    endfor

    mapset_polar, title='METHANE'
    
    ; first the CH4 bands
    iin = 0
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 8 ; *** thickness 8 for 20% peak-to-peak
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+57, color=color, thick=thick
    ;midarc=lonmaxarr[1,iin]
    midarc = -120
    xyouts, midarc, 65, '!3More CH!D4!N (0.9 !4l!3m)', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+57, color=color, thick=thick, line=2
    ;midarc=lonminarr[1,iin]
    midarc = 70
    xyouts, midarc, 67, '!3Less CH!D4!N ((0.9 !4l!3m)', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=.7, color=color
    
    ; strong band 
    iin = 1
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 4 ; *** thickness 8 for 20% peak-to-peak
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+61, color=color, thick=thick
    ;midarc=lonmaxarr[1,iin]
    midarc = -30
    xyouts, midarc, 65, '!3More CH!D4!N (1.65 !4l!3m)', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+61, color=color, thick=thick, line=2
    ;midarc=lonminarr[1,iin]
    midarc = 150
    xyouts, midarc, 70, '!3Less CH!D4!N (1.65 !4l!3m)', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color

    ; 1.732
    iin = 2
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 4 ; *** thickness 8 for 20% peak-to-peak
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+52, color=color, thick=thick
    ;midarc=lonmaxarr[1,iin]
    midarc = -30
    xyouts, midarc, 37, '!3More CH!D4!N (1.73 !4l!3)', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+52, color=color, thick=thick, line=2
    ;midarc=lonminarr[1,iin]
    midarc = 150
    xyouts, midarc, 45, '!3Less CH!D4!N (1.73 !4l!3)', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color

    ; the CH4 bands
    iin = 3
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 2 ; *** thickness 2 for hint of pure
;    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
;    plots, thetaarc, 0*thetaarc+50, color=color, thick=thick
;    midarc=lonmaxarr[1,iin]
;    xyouts, midarc, 40, '!3CH!D4!N in N!D2!N', chars=1.5, $
;          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+50, color=color, thick=thick
;    midarc=lonminarr[1,iin]
    midarc=-120
    xyouts, midarc, 45, '!3Pure CH!D4!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    
    writegif, 'methane'

endif


end
