; make ices08_N2_2.15.gif

pro plot_ices08_n2_215

;====================================
; PLOTS FOR THE ICES 2008 MEETING
;====================================

deg = !pi/180.
theta = findgen(361)
cost = cos(theta/deg)
sint = sin(theta/deg)
dir = '../figs/'
device, true_color = 24
window, 2, xs = 450, ys = 500
!p.color = 0
!p.background = !d.N_COLORS - 1L
naifinit, ker='../spice/kernels.tm'

names=names(colors,titles)
nnames = n_elements(names)

geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)

if (1) then begin

    nnames = n_elements(names)
    
    arc_hw = 30.

;    for i = 0, nnames-1 do begin
    for iname = 0,0 do begin
        name = names[iname]

        rd_areas,name, year, et, lon_deg, lat_deg, area, area_err

        a = [0,0,0, 0, 0]
;        a = [0,0,0]
        w = 1/(area_err)^(2.)
        r = curvefit(lon_deg, area, w, a, sigma, func='fourierfunc', chisq=chisq)
        fourierfunc,theta,a,model
        ratio = model/a[0]
        ratmax = max(ratio,imax)
        ihigh = where(ratio[0:359] gt (1 + (ratmax-1)*cos(arc_hw*deg)),nhigh)
        thigh = ((theta[ihigh] - theta[imax] + 180 ) mod 360) - 180 + theta[imax]
        shigh = sort(thigh)
        thigh = thigh[shigh]
        ratmin = min(ratio,imin)
        ilow = where(ratio[0:359] lt (1 - (1-ratmin)*cos(arc_hw*deg)),nlow)
        tlow = ((theta[ilow] - theta[imin] + 180 ) mod 360) - 180 + theta[imin]
        slow = sort(tlow)
        tlow = tlow[slow]

        color = colors[iname]
        if name eq 'CH4_shift' then begin
            title = titles[iname]+' SHIFT (0=PURE, 1=SOLUTION)'
        endif else begin
            title = titles[iname] + ' AREA / '+strtrim(string(a[0],for='(F7.4)'),2)+' !4l!3m'
        endelse
        MAP_SET, /AZIMUTHAL, /ISOTROPIC, -90, $
          TITLE = title, limit = [-90,0,65,360], /noborder, chars=1.5
        map_grid, latdel = 90, londel=90, color = 0, glines=0, thick=2
        map_grid, latdel = 18, londel=30, color = 0, glines=0, /label, $
          chars=1.2, $
          lats=findgen(9)*18 - 90, $
          latnames = ['','0.2','0.4','0.6','0.8','1.0','1.2','1.4','1.6'], $
          latlab = 45
        if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
 
        plotsym, 0, 1, /fill, color=color
        plots, lon_deg, (area/pscale) * 90 - 90, ps=8, color=color
        n = n_elements(area)
        for i = 0, n-1 do begin
            low = area[i] - area_err[i]
            if low lt 0 then low = 0
            high = area[i] + area_err[i]
            if area[i] gt 0 then begin
                plots, [1,1]*lon_deg[i],  (([low,high])/pscale) * 90 - 90, $
                  color=color, thick=2
            endif 
        endfor
        s = sort(lon_deg)
        plots, theta, (model/pscale) * 90 - 90, color=color, thick=2

        plots, thigh, replicate(1.7*90 - 90,nhigh), thick=3, color=color
        xyouts, theta[imax], 1.8*90-90, '!3More ', chars=1.5, $
          orient=atan(tan((-theta[imax])*deg))/deg, ali=0.5, color=color
        plots, tlow, replicate(1.7*90 - 90,nlow), thick=3, color=color, line=2
      
        writegif, 'name'
    
;        dir = '../figs/'
;        fn_root='ices08_'+name
;        fn_tiff = dir + fn_root + '.tif'
;        fn_gif = dir + fn_root + '.gif'
;        tv2tiff, fn_tiff, /tr
;        spawn,'tiffutil -cat '+fn_tiff+' -out '+fn_gif
;        spawn, 'rm ' + fn_tiff
    endfor
endif

if (0) then begin
    print, '---------------------------------------------'
    print, 'N2 CO plot'

    inarr = [0,1,5] ; CO2, H2O
    nii = n_elements(inarr)
    nterms = 1
    aarr = fltarr(1+2*nterms, nii)
    lonmaxarr = fltarr(3,nii)
    lonminarr = fltarr(3,nii)
    ratmaxarr = fltarr(nii)
    ratminarr = fltarr(nii)
    for iin = 0, nii-1 do begin
        in = inarr[iin]
        name = names[in]
        rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
        fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
          lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
          lonmin, lonmin0, lonmin1, ratiomin, ratiominerr
        aarr[*,iin] = a
        ratmaxarr[iin] = ratiomax
        lonmaxarr[*,iin] = [lonmax0,lonmax,lonmax1]
        ratminarr[iin] = ratiomin
        lonminarr[*,iin] = [lonmin0,lonmin,lonmin1]
    endfor

    mapset_polar, title='!3N!D2!N AND CO', wsize='medium'
    
    ; N2
    iin = 0
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 14 ; *** thickness 8 for 20% peak-to-peak
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+70, color=color, thick=thick
    midarc=lonmaxarr[1,iin]
    ;midarc = -60
    xyouts, midarc, 80, '!3More N!D2!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+70, color=color, thick=thick, line=2
    midarc=lonminarr[1,iin]
    ;midarc = 120
    xyouts, midarc, 82, '!3Less N!D2!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    
    ; strong band #2
    iin = 1
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 14 ; *** thickness 8 for 20% peak-to-peak
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+60, color=color, thick=thick
    midarc=lonmaxarr[1,iin]
    midarc = 68
    xyouts, midarc, 67, '!3More CO', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+60, color=color, thick=thick, line=2
    midarc=lonminarr[1,iin]
    midarc = -105
    xyouts, midarc, 75, '!3Less CO', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color


    ; first the CH4 bands
    iin = 2
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 2 ; *** thickness 2 for hint of pure
;    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
;    midarc=lonmaxarr[1,iin]
;    plots, thetaarc, 0*thetaarc+50, color=color, thick=thick
;    xyouts, midarc, 40, '!3CH!D4!N in N!D2!N', chars=1.5, $
;          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color

    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+50, color=color, thick=thick
;    midarc=lonminarr[1,iin]
    midarc=-120
    xyouts, midarc, 45, '!3Pure CH!D4!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    
    writegif, 'n2co'

endif


end
