pro plot_ices08_n2co

;====================================
; PLOTS FOR THE ICES 2008 MEETING
;====================================

deg = !pi/180.
theta = findgen(361)
cost = cos(theta/deg)
sint = sin(theta/deg)
dir = '../figs/'
device, true_color = 24
window, 2, xs = 450, ys = 500
!p.color = 0
!p.background = !d.N_COLORS - 1L
naifinit, ker='../spice/kernels.tm'

names=names(colors,titles)

geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)

if (1) then begin

    name = 'N2_2.15'
    iname = where(names eq name)
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, name
    oplot_arc_by_name, name
    oplot_sin_by_name, name
    wrgif, 'ices08_n2-data-sin-arc'
    
    name = 'CO_2.35'
    iname = where(names eq name)
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, name
    oplot_arc_by_name, name
    oplot_sin_by_name, name
    wrgif, 'ices08_co2-data-sin-arc'
    
    mapset_polar, title='N2 & CO', wsize='medium'
    oplot_data_by_name, 'N2_2.15'
    oplot_arc_by_name, 'N2_2.15'
    oplot_arc_by_name, 'CO_2.35'
    wrgif, 'ices08_n2+co-data-arc'
    
    mapset_polar, title='N2 & CO', wsize='small'
    oplot_data_by_name, 'N2_2.15'
    oplot_arc_by_name, 'N2_2.15'
    oplot_arc_by_name, 'CO_2.35'
    wrgif, 'ices08_n2+co-data-arc-small'
    
end

if (0) then begin
    print, '---------------------------------------------'
    print, 'N2 CO plot'

    inarr = [0,1,5] ; CO2, H2O
    nii = n_elements(inarr)
    nterms = 1
    aarr = fltarr(1+2*nterms, nii)
    lonmaxarr = fltarr(3,nii)
    lonminarr = fltarr(3,nii)
    ratmaxarr = fltarr(nii)
    ratminarr = fltarr(nii)
    for iin = 0, nii-1 do begin
        in = inarr[iin]
        name = names[in]
        rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
        fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
          lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
          lonmin, lonmin0, lonmin1, ratiomin, ratiominerr
        aarr[*,iin] = a
        ratmaxarr[iin] = ratiomax
        lonmaxarr[*,iin] = [lonmax0,lonmax,lonmax1]
        ratminarr[iin] = ratiomin
        lonminarr[*,iin] = [lonmin0,lonmin,lonmin1]
    endfor

    mapset_polar, title='!3N!D2!N AND CO', wsize='medium'
    
    ; N2
    iin = 0
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 14 ; *** thickness 8 for 20% peak-to-peak
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+70, color=color, thick=thick
    midarc=lonmaxarr[1,iin]
    ;midarc = -60
    xyouts, midarc, 80, '!3More N!D2!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+70, color=color, thick=thick, line=2
    midarc=lonminarr[1,iin]
    ;midarc = 120
    xyouts, midarc, 82, '!3Less N!D2!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    
    ; strong band #2
    iin = 1
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 14 ; *** thickness 8 for 20% peak-to-peak
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+60, color=color, thick=thick
    midarc=lonmaxarr[1,iin]
    midarc = 68
    xyouts, midarc, 67, '!3More CO', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+60, color=color, thick=thick, line=2
    midarc=lonminarr[1,iin]
    midarc = -105
    xyouts, midarc, 75, '!3Less CO', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color


    ; first the CH4 bands
    iin = 2
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 2 ; *** thickness 2 for hint of pure
;    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
;    midarc=lonmaxarr[1,iin]
;    plots, thetaarc, 0*thetaarc+50, color=color, thick=thick
;    xyouts, midarc, 40, '!3CH!D4!N in N!D2!N', chars=1.5, $
;          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color

    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+50, color=color, thick=thick
;    midarc=lonminarr[1,iin]
    midarc=-120
    xyouts, midarc, 45, '!3Pure CH!D4!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    
    writegif, 'n2co'

endif


if (0) then begin
    print, '---------------------------------------------'
    print, 'N2 CO plot'

    inarr = [0,1,5] ; N2, CO, shift
    nii = n_elements(inarr)
    nterms = 1
    aarr = fltarr(1+2*nterms, nii)
    lonmaxarr = fltarr(3,nii)
    lonminarr = fltarr(3,nii)
    ratmaxarr = fltarr(nii)
    ratminarr = fltarr(nii)
    for iin = 0, nii-1 do begin
        in = inarr[iin]
        name = names[in]
        rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
        fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
          lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
          lonmin, lonmin0, lonmin1, ratiomin, ratiominerr
        aarr[*,iin] = a
        ratmaxarr[iin] = ratiomax
        lonmaxarr[*,iin] = [lonmax0,lonmax,lonmax1]
        ratminarr[iin] = ratiomin
        lonminarr[*,iin] = [lonmin0,lonmin,lonmin1]
    endfor

    mapset_polar, title='!3N!D2!N AND CO', wsize='medium'
    
    ; N2
    iin = 0
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 14 ; *** thickness 8 for 20% peak-to-peak
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+70, color=color, thick=thick
    midarc=lonmaxarr[1,iin]
    ;midarc = -60
    xyouts, midarc, 80, '!3More N!D2!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+70, color=color, thick=thick, line=2
    midarc=lonminarr[1,iin]
    ;midarc = 120
    xyouts, midarc, 82, '!3Less N!D2!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    
    ; strong band #2
    iin = 1
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 14 ; *** thickness 8 for 20% peak-to-peak
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+60, color=color, thick=thick
    midarc=lonmaxarr[1,iin]
    midarc = 68
    xyouts, midarc, 67, '!3More CO', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+60, color=color, thick=thick, line=2
    midarc=lonminarr[1,iin]
    midarc = -105
    xyouts, midarc, 75, '!3Less CO', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color


    ; first the CH4 bands
    iin = 2
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thick = 2 ; *** thickness 2 for hint of pure
;    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
;    midarc=lonmaxarr[1,iin]
;    plots, thetaarc, 0*thetaarc+50, color=color, thick=thick
;    xyouts, midarc, 40, '!3CH!D4!N in N!D2!N', chars=1.5, $
;          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color

    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+50, color=color, thick=thick
;    midarc=lonminarr[1,iin]
    midarc=-120
    xyouts, midarc, 45, '!3Pure CH!D4!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    
;    writegif, 'n2co_n2areas'

endif


end
