; write the following files
; 
; h2o-data-sin-arc
; co2-data-sin-arc
; nonvolatile-data-arc
; nonvolatile-data-arc-small
; 

pro plot_ices08_nonvolatiles

;====================================
; PLOTS FOR THE ICES 2008 MEETING
;====================================

deg = !pi/180.
theta = findgen(361)
cost = cos(theta/deg)
sint = sin(theta/deg)
dir = '../figs/'
device, true_color = 24
window, 2, xs = 450, ys = 500
!p.color = 0
!p.background = !d.N_COLORS - 1L
naifinit, ker='../spice/kernels.tm'

names=names(colors,titles)

geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)

if (1) then begin

    name = 'H2O_ratio'
    iname = where(names eq name)
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, name
    oplot_arc_by_name, name
    oplot_sin_by_name, name
    wrgif, 'ices08_h2o-data-sin-arc'
    
    name = 'CO2_sum'
    iname = where(names eq name)
    mapset_polar, title=titles[iname], wsize='medium'
    oplot_data_by_name, name
    oplot_arc_by_name, name
    oplot_sin_by_name, name
    wrgif, 'ices08_co2-data-sin-arc'
    
    mapset_polar, title='NON-VOLATILES', wsize='medium'
    oplot_data_by_name, 'H2O_ratio'
    oplot_arc_by_name, 'H2O_ratio'
    oplot_arc_by_name, 'CO2_sum'
    wrgif, 'ices08_nonvolatile-data-arc'
    
    mapset_polar, title='NON-VOLATILES', wsize='small'
    oplot_data_by_name, 'H2O_ratio'
    oplot_arc_by_name, 'H2O_ratio'
    oplot_arc_by_name, 'CO2_sum'
    wrgif, 'ices08_nonvolatile-data-arc-small'
    

    
end

;------old
if (0) then begin
    print, '---------------------------------------------'
    print, 'Bedrock plot'
    names=names(colors,titles)
    inarr = [6,7] ; CO2, H2O
    nii = n_elements(inarr)
    nterms = 1
    aarr = fltarr(1+2*nterms, nii)
    lonmaxarr = fltarr(3,nii)
    lonminarr = fltarr(3,nii)
    ratmaxarr = fltarr(nii)
    ratminarr = fltarr(nii)
    for iin = 0, nii-1 do begin
        in = inarr[iin]
        name = names[in]
        rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
        fit_areas, lon_deg, area, area_err, nterms, a, sigma, ratio, $
          lonmax, lonmax0, lonmax1, ratiomax, ratiomaxerr, $
          lonmin, lonmin0, lonmin1, ratiomin, ratiominerr
        aarr[*,iin] = a
        ratmaxarr[iin] = ratiomax
        lonmaxarr[*,iin] = [lonmax0,lonmax,lonmax1]
        ratminarr[iin] = ratiomin
        lonminarr[*,iin] = [lonmin0,lonmin,lonmin1]
    endfor

    mapset_polar, title='NON-VOLATILES'
    
    ; first the CO2
    iin = 0
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    plots, theta, 0*theta+60, color=color, thick=1
    midarc=45
    xyouts, midarc, 1.8*90-90, '!3Uniform CO!D2!N', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color

    iin = 1
    in = inarr[iin]
    name = names[in]
    color = colors[in]
    a = aarr[*,iin]
    fourierfunc,theta,a,model
    if name eq 'CH4_shift' then pscale = 1 else pscale = a[0]
    plots, theta, (model/pscale) * 90 - 90, color=color, thick=2
    thetaarc = arrgen(lonmaxarr[0,iin], lonmaxarr[2,iin])
    plots, thetaarc, 0*thetaarc+60, color=color, thick=2
    midarc=lonmaxarr[1,iin]
    xyouts, midarc, 1.8*90-90, '!3More H!D2!NO', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    thetaarc = arrgen(lonminarr[0,iin], lonminarr[2,iin])
    plots, thetaarc, 0*thetaarc+60, color=color, thick=2, line=2
    midarc=lonminarr[1,iin]
    xyouts, midarc, 1.8*90-90, '!3Less H!D2!NO', chars=1.5, $
          orient=atan(tan(-midarc*deg))/deg, ali=0.5, color=color
    
    writegif, 'nonvolatiles'

endif


end
