; First slide - showing Triton and our lats and long

pro plot_ices08_triton_slon

;====================================
; PLOTS FOR THE ICES 2008 MEETING
;====================================

deg = !pi/180.
theta = findgen(361)
cost = cos(theta/deg)
sint = sin(theta/deg)
dir = '../figs/'
device, true_color = 24
window, 2, xs = 450, ys = 500
!p.color = 0
!p.background = !d.N_COLORS - 1L
naifinit, ker='../spice/kernels.tm'

names=names(colors,titles)

geomap = rdmap_triton_mcewen90(lat_deg, lon_deg)

if (1) then begin
    
    map_v2 = rdmap_trimap1(lat_deg, lon_deg)

    mapset_image, image=map_v2, ws='large', titl='Triton & Sub-observer latitude/longitudes'

    name='N2_2.15'
    rd_areas,name, year, et, lon_deg, lat_deg, area, area_err
    yr_cols = ['0000ff'xl, '0000a0'xl, '0080ff'xl,'00d7ff'xl,'00ff00'xl, $
              'ff0000'xl, '800080'xl, 'ff00ff'xl]
    
    plotsym, 0, 1, /fill
    for i = 0,7 do begin
        c = yr_cols[i]
        gd = where(floor(year) eq 2000+i,ngd)
        plots, lon_deg[gd], lat_deg[gd], col=c, ps=8
        yrstr = string(2000+i, ngd,for='(I4," : ",I2," nights")')
        xyouts, i*150+50-150*4*(i/4),25 - (i/4)*15,yrstr, col=c, chars=1.3, /dev
    endfor

    writegif, 'triton_slon'

end

end
