lon = (findgen(360)+0.5) 
nlon = n_elements(lon)
rlon = reverse(lon)
deg = !pi/180.
!p.charsize=1.2

color1 = '008cff'xl ; color of unit 1 = H2O + CO2
color2 = '0000ff'xl ; color of unit 2 = pure H2O
color3 = '00af00'xl ; color of detectable N2 with CH4
color6 = 'ff0000'xl ; color of stealth N2

;-------------
; minimum CO2+H2O
a1 = replicate(21,360)
plot, [0,360], [0,100], /xs, /ys, /nod, tit='Minimum H2O+CO2 (Unit 1)',$
  xtit='Longitude', ytit='% Projected area'
polyfill,[lon,rlon], [replicate(0,360),reverse(a1)], $
  color=color1
xyouts, 100, mean(a1)/2, 'Unit 1 (H2O+CO2)', co=0


; minimum H2O
a1_2 = 26.5 + (1+cos( (lon-115.)*deg)) * (29.5-26.5)/2
a1 = 26.5 + 0*lon
a2 = a1_2 - a1
a0 = 0*lon
plot, [0,360], [0,100], /xs, /ys, /nod, tit='Minimum Pure H2O'
polyfill,[lon,rlon], [a0,reverse(a1)], color=color1
polyfill,[lon,rlon], [a1,reverse(a1+a2)], color=color2
;stop

; minimum detectable N2
a3 = 10 + (1+cos( (lon-30.)*deg)) * (18.-10)/2
an = replicate(100,nlon)
plot, [0,360], [0,100], /xs, /ys, /nod, tit='Minimum detectable N2'
polyfill,[lon,rlon], [an-a3,reverse(an)], color=color3
;stop

; minimum detectable stealth N2
a3_6 = 38 + (1+cos( (lon-320)*deg)) * (46-38)/2.
a3 = 24 + (1+cos( (lon-30.)*deg)) * (42 - 24)/2.
a6 = a3_6 - a3
an = replicate(100,nlon)
plot, [0,360], [0,100], /xs, /ys, /nod, tit='Minimum stealth N2+CH4'
polyfill,[lon,rlon], [an-a3,reverse(an)], color=color3
polyfill,[lon,rlon], [an-a3-a6,reverse(an-a3)], color=color6
;stop


; maximum CO2+H2O
a3_6 = 38 + (1+cos( (lon-320)*deg)) * (46-38)/2.
a3 = 10 + (1+cos( (lon-30.)*deg)) * (18.-10)/2
a6 = a3_6 - a3
a1_2 = 59+ (1+cos( (lon-115)*deg)) * (59-53)/2.
a1 = replicate(53.,nlon)
a2 = a1_2 - a1
plot, [0,360], [0,100], /xs, /ys, /nod, tit='Maximum H2O+CO2'
polyfill,[lon,rlon], [a0,reverse(a1)], color=color1
polyfill,[lon,rlon], [a1,reverse(a1+a2)], color=color2
polyfill,[lon,rlon], [an-a3,reverse(an)], color=color3
polyfill,[lon,rlon], [an-a3-a6,reverse(an-a3)], color=color6
stop

; maximum pure H2O
a3_6 = 38 + (1+cos( (lon-320)*deg)) * (46-38)/2.
a3 = 10 + (1+cos( (lon-30.)*deg)) * (18.-10)/2
a6 = a3_6 - a3
a1_2 = 59+ (1+cos( (lon-115)*deg)) * (59-53)/2.
a1 = replicate(21.,nlon)
a2 = a1_2 - a1
plot, [0,360], [0,100], /xs, /ys, /nod, tit='Maximum pure H2O'
polyfill,[lon,rlon], [a0,reverse(a1)], color=color1
polyfill,[lon,rlon], [a1,reverse(a1+a2)], color=color2
polyfill,[lon,rlon], [an-a3,reverse(an)], color=color3
polyfill,[lon,rlon], [an-a3-a6,reverse(an-a3)], color=color6
;stop

; maximum detectable N2
a1_2 = 26.5 + (1+cos( (lon-115.)*deg)) * (29.5-26.5)/2
a1 = 26.5 + 0*lon
a2 = a1_2 - a1
a3_6 = 61 + (1+cos( (lon-320)*deg)) * (73-61)/2.
a3 = 38 + (1+cos( (lon-30)*deg)) * (68-38)/2.
a6 = a3_6 - a3
plot, [0,360], [0,100], /xs, /ys, /nod, tit='Maximum detectable N2'
polyfill,[lon,rlon], [a0,reverse(a1)], color=color1
polyfill,[lon,rlon], [a1,reverse(a1+a2)], color=color2
polyfill,[lon,rlon], [an-a3,reverse(an)], color=color3
polyfill,[lon,rlon], [an-a3-a6,reverse(an-a3)], color=color6
;stop


; maximum stealth N2
a1_2 = 26.5 + (1+cos( (lon-115.)*deg)) * (29.5-26.5)/2
a1 = 26.5 + 0*lon
a2 = a1_2 - a1
a3_6 = 61 + (1+cos( (lon-320)*deg)) * (73-61)/2.
a3 = 10 + (1+cos( (lon-30.)*deg)) * (18.-10)/2
a6 = a3_6 - a3
plot, [0,360], [0,100], /xs, /ys, /nod, tit='Maximum stealth N2'
polyfill,[lon,rlon], [a0,reverse(a1)], color=color1
polyfill,[lon,rlon], [a1,reverse(a1+a2)], color=color2
polyfill,[lon,rlon], [an-a3,reverse(an)], color=color3
polyfill,[lon,rlon], [an-a3-a6,reverse(an-a3)], color=color6
;stop


end
