;+
; NAME:
;  rd_aread
; PURPOSE:
;  Read in the measured widths from Will's and my program
; CALLING SEQUENCE
;  rd_areas, mol, year, et, lon, area, area_err
; INPUTS
;  name
;  one of
;  names=["CH4_0.89","CH4_1.65","CH4_1.73","CH4_shift","CO2_sum","CO_2.35","H2O_ratio","N2_2.15"]
; OUTPUTS
;  year float
;  et ephemeris time (s since J2000)
;  lon East longitude
;  area 
;  area_error
;-
pro rd_areas, name, year, et, lon_deg, lat_deg, area, area_err, datestr

    dir = '~/projects/tritonspex/ms-5yr/tables/20080430widths/'
    fn = dir + 'data.triton_'+name+'.ascii'
    if not isfile(fn) then begin
        print, 'rd_areas: ', fn, ' does not exist'
    endif

    readcol, fn, datestr, lon_deg, area, area_err, $
      format = 'A,F,F,F', /skip, /silent

    ut = '20'+strmid(datestr,0,2) + ' ' + strmid(datestr,2,2) + ' ' +$
      strmid(datestr,4,2) + ' 10:00'

    et = utc2et(ut)
    year = et2utcy(et)

    lat_deg = subsearth_latdeg_of_y(year)

end

