pro rd_n2areas, year, et, lon, area, area_err

    dir = '~/projects/tritonspex/ms-5yr/tables/20080326widths/'
    fn = dir + 'data.triton_N2'
    if not isfile(fn) then begin
        print, 'rd_n2areas: ', fn, ' does not exist'
    endif

    readcol, fn, datestr, lon, area, area_err, $
      format = 'A,F,F,F', /skip

    ut = '20'+strmid(datestr,0,2) + ' ' + strmid(datestr,2,2) + ' ' +$
      strmid(datestr,4,2) + ' 10:00'
    
    et = utc2et(ut)
    year = et2utcy(et)

end

