pro rd_resampled, wl, sp, badsp, lon_deg, datestr, lonsort = lonsort, fix=fix

    dir = '../../From-Grundy/20080709_resampled/resampled/'
    
    fns = file_search(dir+'resampled.*.fits', count = nspec)

    nwl = 1601
    wl = fltarr(nwl)
    sp = fltarr(nspec,nwl)
    lon_deg = fltarr(nspec)
    datestr = strarr(nspec)

    deg = !pi/180.
    for i = 0, nspec-1 do begin
        fn = fns[i]
        d = readfits(fn, /silent)
        sp[i,*] = d[1,*]
        datestr[i] = strmid(fn, strlen(dir)+strlen('resampled.'),6)
    endfor
    wl = d[0,*]

    ; get longitudes
    name = 'CH4_1.65'
    rd_areas,name, year, et, lon_tab, lat_tab, area_tab, area_err_tab, datestr_tab
    for  i = 0, nspec-1 do begin
        itab = where(datestr_tab eq datestr[i], nmatch)
        if nmatch gt 0 then begin
            itab = itab[0]
            lon_deg[i] = lon_tab[itab]
        endif else begin
            ut = '20'+strmid(datestr[i],0,2) + ' ' + strmid(datestr[i],2,2) + ' ' +$
              strmid(datestr[i],4,2) + ' 10:27'
            et = utc2et(ut)
            tet = utc2et('20'+strmid(datestr[i],0,2) + ' 08 15 10:27') ; et of transit that year
            et = et - (et-tet)*0.0027
            
            p = naif_phys(801, et)
            lon_deg[i] = p.subobslon/deg
        endelse
    end

    if keyword_set(lonsort) then begin
        s = sort(lon_deg)
        lon_deg = lon_deg[s]
        datestr = datestr[s]
        sp = sp[s,*]
    endif

    nsp = n_elements(datestr)
    badsp = bytarr(nsp,nwl)

    if keyword_set(fix) then begin
        
        print, 'fix'

        ; weed out the bad spectra
        baddates = ['010706', '010708', '010703', '070628']
        ; WHY IS 070628 so noisy?
        gd = where(ismember(datestr, baddates) ne 1, ngd)
        sp = sp[gd, *]
        badsp = badsp[gd, *]
        lon_deg = lon_deg[gd]
        datestr=datestr[gd]
        nsp = n_elements(datestr)

        ; weed out long wavelengths (poor wavelength calibration)
        badwl = bytarr(nwl)
        maxwl = 2.3  ; ******** set to longest sky line
        ibd = where(wl gt maxwl, nbd)
        ibdlong = ibd
        badwl[ibd] = 1 or badwl[ibd]

        ; weed out short wavelengths (spurious slopes?)
        badwl = bytarr(nwl)
        minwl = 0.9  
        ibd = where(wl lt minwl, nbd)
        ibdlong = ibd
        badwl[ibd] = 1 or badwl[ibd]

        badwl[550:610] = 1 or badwl[550:610]

        ; weed out where there are more than 3 negative numbers
        nneg = total(sp lt 0, 1)
        ibd = where(nneg gt 3, nbd)
        ibdlow = ibd
        if nbd gt 0 then begin
            ibd0 = split_contig(ibd, ibdlen, nsplit)
            for isplit = 0, nsplit-1 do begin
                istart = (ibd[ibd0[isplit]]-1) > 0
                iend = (ibd[ibd0[isplit]] + ibdlen[isplit]) < (nwl-1)
                badwl[istart:iend] = 1 or badwl[istart:iend]
            endfor
        endif
        ibd = where(badwl ne 0)
        sp[*,ibd] = 0
        
        ; weed out low or high numbers
        msp = median(sp, dim=1)
        for i = 0, nsp-1 do begin
            s = sp[i, *]
            ibd = where(abs(s - msp) gt 0.5 or s lt 0. or s gt 1.5, nbd)
            if nbd gt 0 then begin
                badsp[i,ibd] = 1 or badsp[i,ibd]
                sp[i,ibd] = msp[ibd]
            endif
        endfor

        ; weed out where there are more than 3 bad spectra
        nbad = total(badsp, 1)
        ibd = where(nbad gt 20, nbd)
        ibdbad = ibd
        if nbd gt 0 then begin
            ibd0 = split_contig(ibd, ibdlen, nsplit)
            for isplit = 0, nsplit-1 do begin
                istart = (ibd[ibd0[isplit]]-1) > 0
                iend = (ibd[ibd0[isplit]] + ibdlen[isplit]) < (nwl-1)
                badwl[istart:iend] = 1 or badwl[istart:iend]
            endfor
        endif
        ibd = where(badwl ne 0)
        sp[*,ibd] = 0
        badsp[*,ibd] = 1


    endif

end
